/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.backend.model.Dispute;
import org.drools.scenariosimulation.backend.model.NotEmptyConstructor;
import org.drools.scenariosimulation.backend.model.Person;
import org.drools.scenariosimulation.backend.model.SubPerson;
import org.drools.scenariosimulation.backend.runner.RuleScenarioRunnerHelperTest;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.ValueWrapper;
import org.drools.scenariosimulation.backend.util.ScenarioBeanUtil;
import org.drools.scenariosimulation.backend.util.ScenarioBeanWrapper;
import org.drools.scenariosimulation.backend.util.model.EnumTest;
import org.junit.Assert;
import org.junit.Test;

public class ScenarioBeanUtilTest {
    private static String FIRST_NAME = "firstNameToSet";
    private static int AGE = 10;
    private static ClassLoader classLoader = ScenarioBeanUtilTest.class.getClassLoader();

    @Test
    public void fillBeanTest() {
        HashMap<List<String>, Object> paramsToSet = new HashMap<List<String>, Object>();
        paramsToSet.put(Arrays.asList("creator", "firstName"), FIRST_NAME);
        paramsToSet.put(Arrays.asList("creator", "age"), AGE);
        Object result = ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.errorEmptyMessage(), (String)Dispute.class.getCanonicalName(), paramsToSet, (ClassLoader)classLoader);
        Assert.assertTrue((boolean)(result instanceof Dispute));
        Dispute dispute = (Dispute)result;
        Assert.assertEquals((Object)dispute.getCreator().getFirstName(), (Object)FIRST_NAME);
        Assert.assertEquals((long)dispute.getCreator().getAge(), (long)AGE);
    }

    @Test
    public void fillBeanTestWithInitialInstanceTest() {
        Dispute dispute = new Dispute();
        HashMap<List<String>, Object> paramsToSet = new HashMap<List<String>, Object>();
        paramsToSet.put(Arrays.asList("creator", "firstName"), FIRST_NAME);
        paramsToSet.put(Arrays.asList("creator", "age"), AGE);
        Object result = ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.of((Object)dispute), (String)Dispute.class.getCanonicalName(), paramsToSet, (ClassLoader)classLoader);
        Assert.assertTrue((boolean)(result instanceof Dispute));
        Assert.assertSame((Object)dispute, (Object)result);
        Assert.assertEquals((Object)dispute.getCreator().getFirstName(), (Object)FIRST_NAME);
        Assert.assertEquals((long)dispute.getCreator().getAge(), (long)AGE);
    }

    @Test(expected=ScenarioException.class)
    public void fillBeanLoadClassTest() {
        ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.errorEmptyMessage(), (String)"FakeCanonicalName", new HashMap(), (ClassLoader)classLoader);
    }

    @Test(expected=ScenarioException.class)
    public void fillBeanFailNotEmptyConstructorTest() {
        HashMap<List<String>, Object> paramsToSet = new HashMap<List<String>, Object>();
        paramsToSet.put(Collections.singletonList("name"), null);
        ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.errorEmptyMessage(), (String)NotEmptyConstructor.class.getCanonicalName(), paramsToSet, (ClassLoader)classLoader);
    }

    @Test(expected=ScenarioException.class)
    public void fillBeanFailTest() {
        HashMap<List<String>, Object> paramsToSet = new HashMap<List<String>, Object>();
        paramsToSet.put(Collections.singletonList("fakeField"), null);
        ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.errorEmptyMessage(), (String)Dispute.class.getCanonicalName(), paramsToSet, (ClassLoader)classLoader);
    }

    @Test(expected=ScenarioException.class)
    public void fillBeanFailNullClassTest() {
        HashMap<List<String>, Object> paramsToSet = new HashMap<List<String>, Object>();
        paramsToSet.put(Collections.singletonList("fakeField"), null);
        ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.errorEmptyMessage(), null, paramsToSet, (ClassLoader)classLoader);
    }

    @Test(expected=ScenarioException.class)
    public void fillBeanFailWrongTypeTest() {
        HashMap paramsToSet = new HashMap();
        paramsToSet.put(Collections.singletonList("description"), new ArrayList());
        ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.errorEmptyMessage(), (String)Dispute.class.getCanonicalName(), paramsToSet, (ClassLoader)classLoader);
    }

    @Test
    public void fillBeanEmptyValueTest() {
        HashMap paramsToSet = new HashMap();
        paramsToSet.put(Collections.emptyList(), null);
        Assert.assertNull((Object)ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.of(null), (String)String.class.getCanonicalName(), paramsToSet, (ClassLoader)classLoader));
    }

    @Test
    public void navigateToObjectTest() {
        Dispute dispute = new Dispute();
        Person creator = new Person();
        creator.setFirstName(FIRST_NAME);
        dispute.setCreator(creator);
        List<String> pathToProperty = Arrays.asList("creator", "firstName");
        ScenarioBeanWrapper scenarioBeanWrapper = ScenarioBeanUtil.navigateToObject((Object)dispute, pathToProperty, (boolean)true);
        Object targetObject = scenarioBeanWrapper.getBean();
        Assert.assertEquals((Object)targetObject, (Object)FIRST_NAME);
        Assert.assertNull((Object)ScenarioBeanUtil.navigateToObject(null, Collections.emptyList()).getBean());
    }

    @Test
    public void navigateToObjectFakeFieldTest() {
        Dispute dispute = new Dispute();
        List<String> pathToProperty = Collections.singletonList("fakeField");
        String message = "Impossible to find field with name 'fakeField' in class " + Dispute.class.getCanonicalName();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.navigateToObject((Object)dispute, (List)pathToProperty, (boolean)true)).isInstanceOf(ScenarioException.class)).hasMessage(message);
    }

    @Test
    public void navigateToObjectNoStepCreationTest() {
        Dispute dispute = new Dispute();
        List<String> pathToProperty = Arrays.asList("creator", "firstName");
        String message = "Impossible to reach field firstName because a step is not instantiated";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.navigateToObject((Object)dispute, (List)pathToProperty, (boolean)false)).isInstanceOf(ScenarioException.class)).hasMessage(message);
    }

    @Test
    public void convertValueTest() {
        Assert.assertEquals((Object)"Test", (Object)ScenarioBeanUtil.convertValue((String)String.class.getCanonicalName(), (Object)"Test", (ClassLoader)classLoader));
        Assert.assertEquals((Object)false, (Object)ScenarioBeanUtil.convertValue((String)Boolean.TYPE.getCanonicalName(), (Object)"false", (ClassLoader)classLoader));
        Assert.assertEquals((Object)true, (Object)ScenarioBeanUtil.convertValue((String)Boolean.class.getCanonicalName(), (Object)"true", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1, (Object)ScenarioBeanUtil.convertValue((String)Integer.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1, (Object)ScenarioBeanUtil.convertValue((String)Integer.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1L, (Object)ScenarioBeanUtil.convertValue((String)Long.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1L, (Object)ScenarioBeanUtil.convertValue((String)Long.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1.0d", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1.0d", (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1.0f", (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1.0f", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1.0D", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1.0D", (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1.0F", (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1.0F", (ClassLoader)classLoader));
        Assert.assertEquals((Object)Character.valueOf('a'), (Object)ScenarioBeanUtil.convertValue((String)Character.TYPE.getCanonicalName(), (Object)"a", (ClassLoader)classLoader));
        Assert.assertEquals((Object)Character.valueOf('a'), (Object)ScenarioBeanUtil.convertValue((String)Character.class.getCanonicalName(), (Object)"a", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1, (Object)ScenarioBeanUtil.convertValue((String)Short.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1, (Object)ScenarioBeanUtil.convertValue((String)Short.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)"0".getBytes()[0], (Object)ScenarioBeanUtil.convertValue((String)Byte.TYPE.getCanonicalName(), (Object)Byte.toString("0".getBytes()[0]), (ClassLoader)classLoader));
        Assert.assertEquals((Object)"0".getBytes()[0], (Object)ScenarioBeanUtil.convertValue((String)Byte.class.getCanonicalName(), (Object)Byte.toString("0".getBytes()[0]), (ClassLoader)classLoader));
        Assert.assertEquals((Object)LocalDate.of(2018, 5, 20), (Object)ScenarioBeanUtil.convertValue((String)LocalDate.class.getCanonicalName(), (Object)"2018-05-20", (ClassLoader)classLoader));
        Assert.assertEquals((Object)((Object)EnumTest.FIRST), (Object)ScenarioBeanUtil.convertValue((String)EnumTest.class.getCanonicalName(), (Object)"FIRST", (ClassLoader)classLoader));
        Assert.assertNull((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), null, (ClassLoader)classLoader));
    }

    @Test
    public void revertValueTest() {
        Assert.assertEquals((Object)"Test", (Object)ScenarioBeanUtil.revertValue((Object)"Test"));
        Assert.assertEquals((Object)"false", (Object)ScenarioBeanUtil.revertValue((Object)false));
        Assert.assertEquals((Object)"true", (Object)ScenarioBeanUtil.revertValue((Object)Boolean.TRUE));
        Assert.assertEquals((Object)"1", (Object)ScenarioBeanUtil.revertValue((Object)1));
        Assert.assertEquals((Object)"1", (Object)ScenarioBeanUtil.revertValue((Object)1L));
        Assert.assertEquals((Object)"1.0d", (Object)ScenarioBeanUtil.revertValue((Object)1.0));
        Assert.assertEquals((Object)"NaN", (Object)ScenarioBeanUtil.revertValue((Object)Double.NaN));
        Assert.assertEquals((Object)"Infinity", (Object)ScenarioBeanUtil.revertValue((Object)Double.POSITIVE_INFINITY));
        Assert.assertEquals((Object)"-Infinity", (Object)ScenarioBeanUtil.revertValue((Object)Double.NEGATIVE_INFINITY));
        Assert.assertEquals((Object)"1.0f", (Object)ScenarioBeanUtil.revertValue((Object)Float.valueOf(1.0f)));
        Assert.assertEquals((Object)"a", (Object)ScenarioBeanUtil.revertValue((Object)Character.valueOf('a')));
        Assert.assertEquals((Object)"1", (Object)ScenarioBeanUtil.revertValue((Object)1));
        Assert.assertEquals((Object)String.valueOf("0".getBytes()[0]), (Object)ScenarioBeanUtil.revertValue((Object)"0".getBytes()[0]));
        Assert.assertEquals((Object)"null", (Object)ScenarioBeanUtil.revertValue(null));
        Assert.assertEquals((Object)"2018-10-20", (Object)ScenarioBeanUtil.revertValue((Object)LocalDate.of(2018, 10, 20)));
        Assert.assertEquals((Object)"FIRST", (Object)ScenarioBeanUtil.revertValue((Object)((Object)EnumTest.FIRST)));
    }

    @Test
    public void convertAndRevertValue() {
        Assert.assertEquals((Object)"Test", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)String.class.getCanonicalName(), (Object)"Test", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"false", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Boolean.TYPE.getCanonicalName(), (Object)"false", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"true", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Boolean.class.getCanonicalName(), (Object)"true", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Integer.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Integer.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Long.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Long.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0d", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0d", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"NaN", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"NaN", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"NaN", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"NaN", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"Infinity", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"Infinity", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"Infinity", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"Infinity", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"-Infinity", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"-Infinity", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"-Infinity", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"-Infinity", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0f", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0f", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0d", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0d", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0f", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0f", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0d", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1.0d", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0d", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1.0d", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0f", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1.0f", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0f", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1.0f", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0d", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1.0D", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0d", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1.0D", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0f", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1.0F", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0f", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1.0F", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"a", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Character.TYPE.getCanonicalName(), (Object)"a", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"a", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Character.class.getCanonicalName(), (Object)"a", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Short.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Short.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)Byte.toString("0".getBytes()[0]), (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Byte.TYPE.getCanonicalName(), (Object)Byte.toString("0".getBytes()[0]), (ClassLoader)classLoader)));
        Assert.assertEquals((Object)Byte.toString("0".getBytes()[0]), (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Byte.class.getCanonicalName(), (Object)Byte.toString("0".getBytes()[0]), (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"2018-05-20", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)LocalDate.class.getCanonicalName(), (Object)"2018-05-20", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"FIRST", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)EnumTest.class.getCanonicalName(), (Object)"FIRST", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"null", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), null, (ClassLoader)classLoader)));
    }

    @Test
    public void revertAndConvertValueTest() {
        Assert.assertEquals((Object)"Test", (Object)ScenarioBeanUtil.convertValue((String)String.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)"Test"), (ClassLoader)classLoader));
        Assert.assertEquals((Object)false, (Object)ScenarioBeanUtil.convertValue((String)Boolean.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)false), (ClassLoader)classLoader));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ScenarioBeanUtil.convertValue((String)Boolean.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)Boolean.TRUE), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1, (Object)ScenarioBeanUtil.convertValue((String)Integer.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1, (Object)ScenarioBeanUtil.convertValue((String)Integer.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1L, (Object)ScenarioBeanUtil.convertValue((String)Long.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1L), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1L, (Object)ScenarioBeanUtil.convertValue((String)Long.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1L), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)Float.valueOf(1.0f)), (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)Float.valueOf(1.0f)), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)Float.valueOf(1.0f)), (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)Float.valueOf(1.0f)), (ClassLoader)classLoader));
        Assert.assertEquals((Object)Character.valueOf('a'), (Object)ScenarioBeanUtil.convertValue((String)Character.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)Character.valueOf('a')), (ClassLoader)classLoader));
        Assert.assertEquals((Object)Character.valueOf('a'), (Object)ScenarioBeanUtil.convertValue((String)Character.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)Character.valueOf('a')), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1, (Object)ScenarioBeanUtil.convertValue((String)Short.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1, (Object)ScenarioBeanUtil.convertValue((String)Short.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader));
        Assert.assertEquals((Object)"0".getBytes()[0], (Object)ScenarioBeanUtil.convertValue((String)Byte.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)"0".getBytes()[0]), (ClassLoader)classLoader));
        Assert.assertEquals((Object)"0".getBytes()[0], (Object)ScenarioBeanUtil.convertValue((String)Byte.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)"0".getBytes()[0]), (ClassLoader)classLoader));
        Assert.assertEquals((Object)LocalDate.of(2018, 10, 20), (Object)ScenarioBeanUtil.convertValue((String)LocalDate.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)LocalDate.of(2018, 10, 20)), (ClassLoader)classLoader));
        Assert.assertEquals((Object)((Object)EnumTest.FIRST), (Object)ScenarioBeanUtil.convertValue((String)EnumTest.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)((Object)EnumTest.FIRST)), (ClassLoader)classLoader));
        Assert.assertNull((Object)ScenarioBeanUtil.convertValue((String)String.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue(null), (ClassLoader)classLoader));
    }

    @Test
    public void convertValueFailLoadClassTest() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.convertValue((String)"my.NotExistingClass", (Object)"Test", (ClassLoader)classLoader)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Impossible to load ");
    }

    @Test
    public void convertValueFailUnsupportedTest() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.convertValue((String)RuleScenarioRunnerHelperTest.class.getCanonicalName(), (Object)"Test", (ClassLoader)classLoader)).isInstanceOf(IllegalArgumentException.class)).hasMessageEndingWith("Please use an MVEL expression to use it.");
    }

    @Test
    public void convertValueFailPrimitiveNullTest() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.convertValue((String)"int", null, (ClassLoader)classLoader)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(" is not a String or an instance of");
    }

    @Test
    public void convertValueFailNotStringOrTypeTest() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.convertValue((String)RuleScenarioRunnerHelperTest.class.getCanonicalName(), (Object)1, (ClassLoader)classLoader)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Object 1 is not a String or an instance of");
    }

    @Test
    public void convertValueFailParsing() {
        String integerCanonicalName = Integer.class.getCanonicalName();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.convertValue((String)integerCanonicalName, (Object)"wrongValue", (ClassLoader)classLoader)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Impossible to parse 'wrongValue' as " + integerCanonicalName);
    }

    @Test
    public void convertValueEnumWrongValue() {
        String enumTestCanonicalName = EnumTest.class.getCanonicalName();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.convertValue((String)EnumTest.class.getCanonicalName(), (Object)"FIRS", (ClassLoader)classLoader)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Impossible to parse 'FIRS' as " + enumTestCanonicalName);
    }

    @Test
    public void loadClassTest() {
        Assert.assertEquals(String.class, (Object)ScenarioBeanUtil.loadClass((String)String.class.getCanonicalName(), (ClassLoader)classLoader));
        Assert.assertEquals(Integer.TYPE, (Object)ScenarioBeanUtil.loadClass((String)Integer.TYPE.getCanonicalName(), (ClassLoader)classLoader));
        Assert.assertEquals(RuleScenarioRunnerHelperTest.class, (Object)ScenarioBeanUtil.loadClass((String)RuleScenarioRunnerHelperTest.class.getCanonicalName(), (ClassLoader)classLoader));
        Assert.assertEquals(EnumTest.class, (Object)ScenarioBeanUtil.loadClass((String)EnumTest.class.getCanonicalName(), (ClassLoader)classLoader));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.loadClass(null, (ClassLoader)classLoader)).isInstanceOf(ScenarioException.class)).hasMessage("Impossible to load class null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.loadClass((String)"NotExistingClass", (ClassLoader)classLoader)).isInstanceOf(ScenarioException.class)).hasMessage("Impossible to load class NotExistingClass");
    }

    @Test
    public void getFieldTest() {
        Assert.assertNotNull((Object)ScenarioBeanUtil.getField(Person.class, (String)"firstName"));
        Assert.assertNotNull((Object)ScenarioBeanUtil.getField(SubPerson.class, (String)"firstName"));
        Assert.assertNotNull((Object)ScenarioBeanUtil.getField(SubPerson.class, (String)"additionalField"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.getField(Person.class, (String)"notExistingField")).isInstanceOf(ScenarioException.class)).hasMessageStartingWith("Impossible to find field with name ");
    }
}

