/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import com.fasterxml.jackson.databind.node.TextNode;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.backend.expression.AbstractExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.BaseExpressionEvaluator;
import org.drools.scenariosimulation.backend.model.ListMapClass;
import org.junit.Assert;
import org.junit.Test;

public class BaseExpressionEvaluatorTest {
    private static final ClassLoader classLoader = BaseExpressionEvaluatorTest.class.getClassLoader();
    private static final AbstractExpressionEvaluator expressionEvaluator = new BaseExpressionEvaluator(classLoader);

    @Test
    public void evaluateLiteralExpression() {
        String raw = "";
        Assert.assertEquals((Object)raw, (Object)expressionEvaluator.evaluateLiteralExpression(raw, Object.class.getCanonicalName(), Collections.emptyList()));
        raw = "SimpleString";
        Assert.assertEquals((Object)raw, (Object)expressionEvaluator.evaluateLiteralExpression(raw, String.class.getCanonicalName(), Collections.emptyList()));
        raw = "= SimpleString";
        Assert.assertEquals((Object)"SimpleString", (Object)expressionEvaluator.evaluateLiteralExpression(raw, String.class.getCanonicalName(), Collections.emptyList()));
        Assert.assertNull((Object)expressionEvaluator.evaluateLiteralExpression(null, String.class.getCanonicalName(), Collections.emptyList()));
    }

    @Test
    public void createObjectTest() {
        Assert.assertNotNull((Object)expressionEvaluator.createObject(String.class.getCanonicalName(), Collections.emptyList()));
        Assert.assertTrue((boolean)(expressionEvaluator.createObject(Map.class.getCanonicalName(), Arrays.asList(String.class.getCanonicalName(), String.class.getCanonicalName())) instanceof Map));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> expressionEvaluator.createObject("com.invalid.class.Name", Collections.emptyList())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Impossible to instantiate com.invalid.class.Name");
    }

    @Test
    public void verifyNullTest() {
        Assert.assertTrue((boolean)expressionEvaluator.verifyResult("[]", null, null));
        Assert.assertFalse((boolean)expressionEvaluator.verifyResult("[{\"value\" : \"result\"}]", null, null));
    }

    @Test
    public void nullResultTest() {
        Assert.assertFalse((boolean)expressionEvaluator.evaluateUnaryExpression("> 1", null, null));
        Assert.assertTrue((boolean)expressionEvaluator.evaluateUnaryExpression("", null, null));
        Assert.assertTrue((boolean)expressionEvaluator.evaluateUnaryExpression(null, null, null));
        Assert.assertTrue((boolean)expressionEvaluator.evaluateUnaryExpression("{}", null, Map.class));
        Assert.assertTrue((boolean)expressionEvaluator.evaluateUnaryExpression("[]", null, List.class));
        String mapOfListJson = "{\"key1\" : [{\"value\" : \"value1\"}, {\"value\" : \"value2\"}]}";
        HashMap mapOfListToCheck = new HashMap();
        Assert.assertFalse((boolean)expressionEvaluator.evaluateUnaryExpression(mapOfListJson, mapOfListToCheck, Map.class));
    }

    @Test
    public void mapOfSimpleTypeTest() {
        String givenWorkbenchMapString = "{ \"Home\": { \"value\": \"123 Any Street\" } }";
        ArrayList<String> genericClasses = new ArrayList<String>();
        genericClasses.add(String.class.getCanonicalName());
        genericClasses.add(String.class.getCanonicalName());
        Map parsedWorkbench = (Map)expressionEvaluator.convertResult(givenWorkbenchMapString, Map.class.getCanonicalName(), genericClasses);
        Assert.assertEquals((long)1L, (long)parsedWorkbench.size());
        Assert.assertNotNull(parsedWorkbench.get("Home"));
        Assert.assertEquals((Object)"123 Any Street", parsedWorkbench.get("Home"));
        String givenWorkbenchMapInteger = "{ \"Home\": { \"value\": \"100\" } }";
        genericClasses.clear();
        genericClasses.add(String.class.getCanonicalName());
        genericClasses.add(Integer.class.getCanonicalName());
        Map parsedIntegerFromMap = (Map)expressionEvaluator.convertResult(givenWorkbenchMapInteger, Map.class.getCanonicalName(), genericClasses);
        Assert.assertEquals((long)1L, (long)parsedIntegerFromMap.size());
        Assert.assertNotNull(parsedIntegerFromMap.get("Home"));
        Assert.assertEquals((long)100L, (long)((Integer)parsedIntegerFromMap.get("Home")).intValue());
        String expectWorkbenchMapInteger = "{ \"Home\": { \"value\": \"> 100\" } }";
        genericClasses.clear();
        genericClasses.add(String.class.getCanonicalName());
        genericClasses.add(Integer.class.getCanonicalName());
        HashMap<String, Integer> resultToTest = new HashMap<String, Integer>();
        resultToTest.put("Home", 120);
        Assert.assertTrue((boolean)expressionEvaluator.verifyResult(expectWorkbenchMapInteger, resultToTest, null));
        resultToTest.put("Home", 20);
        Assert.assertFalse((boolean)expressionEvaluator.verifyResult(expectWorkbenchMapInteger, resultToTest, null));
        String mapOfStringJson = "{\"key1\" : {\"value\" : \"value1\"}, \"key2\" : {\"value\" : \"value2\"}}";
        HashMap<String, String> mapStringStringToCheck = new HashMap<String, String>();
        mapStringStringToCheck.put("key1", "value1");
        Assert.assertFalse((boolean)expressionEvaluator.evaluateUnaryExpression(mapOfStringJson, mapStringStringToCheck, Map.class));
        mapStringStringToCheck.put("key2", "value2");
        Assert.assertTrue((boolean)expressionEvaluator.evaluateUnaryExpression(mapOfStringJson, mapStringStringToCheck, Map.class));
        String mapOfStringJson1 = "{\"key1\" : {\"value\" : \"\"}}";
        HashMap<String, String> mapStringStringToCheck1 = new HashMap<String, String>();
        Assert.assertTrue((boolean)expressionEvaluator.evaluateUnaryExpression(mapOfStringJson1, mapStringStringToCheck1, Map.class));
        mapStringStringToCheck1.put("key1", "value1");
        Assert.assertTrue((boolean)expressionEvaluator.evaluateUnaryExpression(mapOfStringJson1, mapStringStringToCheck1, Map.class));
    }

    @Test
    public void mapOfComplexTypeTest() {
        String mapJsonString = "{\"first\": {\"name\": \"John\"}}";
        Map parsedMap = (Map)expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), Collections.singletonList(ListMapClass.class.getCanonicalName()));
        Assert.assertEquals((long)1L, (long)parsedMap.size());
        Assert.assertEquals((Object)"John", (Object)((ListMapClass)parsedMap.get("first")).getName());
        mapJsonString = "{\"first\": {\"siblings\": [{\"name\" : \"John\"}]}}";
        parsedMap = (Map)expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), Collections.singletonList(ListMapClass.class.getCanonicalName()));
        Assert.assertEquals((long)1L, (long)parsedMap.size());
        Assert.assertEquals((Object)"John", (Object)((ListMapClass)parsedMap.get("first")).getSiblings().get(0).getName());
        mapJsonString = "{\"first\": {\"phones\": {\"number\" : \"1\"}}}";
        parsedMap = (Map)expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), Collections.singletonList(ListMapClass.class.getCanonicalName()));
        Assert.assertEquals((long)1L, (long)parsedMap.size());
        Assert.assertEquals((Object)1, (Object)((ListMapClass)parsedMap.get("first")).getPhones().get("number"));
        mapJsonString = "{\"first\": {\"phones\": {\"number\" : \"> 1\"}}}";
        HashMap<String, ListMapClass> toCheck = new HashMap<String, ListMapClass>();
        ListMapClass element = new ListMapClass();
        HashMap<String, Integer> phones = new HashMap<String, Integer>();
        phones.put("number", 10);
        element.setPhones(phones);
        toCheck.put("first", element);
        Assert.assertTrue((boolean)expressionEvaluator.verifyResult(mapJsonString, toCheck, null));
        phones.put("number", -1);
        Assert.assertFalse((boolean)expressionEvaluator.verifyResult(mapJsonString, toCheck, null));
    }

    @Test
    public void listOfComplexTypeTest() {
        String listJsonString = "[{\"name\": \"John\"}, {\"name\": \"John\", \"names\" : [{\"value\": \"Anna\"}, {\"value\": \"Mario\"}]}]";
        List parsedValue = (List)expressionEvaluator.convertResult(listJsonString, List.class.getCanonicalName(), Collections.singletonList(ListMapClass.class.getCanonicalName()));
        Assert.assertEquals((long)2L, (long)parsedValue.size());
        Assert.assertEquals((long)2L, (long)((ListMapClass)parsedValue.get(1)).getNames().size());
        Assert.assertTrue((boolean)((ListMapClass)parsedValue.get(1)).getNames().contains("Anna"));
        Assert.assertTrue((boolean)expressionEvaluator.verifyResult(listJsonString, (Object)parsedValue, null));
        ((ListMapClass)parsedValue.get(1)).setNames(new ArrayList<String>());
        Assert.assertFalse((boolean)expressionEvaluator.verifyResult(listJsonString, (Object)parsedValue, null));
    }

    @Test
    public void listOfSimpleTypeTest() {
        String listJsonString = "[{\"value\" : \"10\"}, {\"value\" : \"12\"}]";
        List result = (List)expressionEvaluator.convertResult(listJsonString, List.class.getCanonicalName(), Collections.singletonList(Integer.class.getCanonicalName()));
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)result.contains(10));
        listJsonString = "[{\"value\" : \"> 10\"}]";
        List<Integer> toCheck = Collections.singletonList(13);
        Assert.assertTrue((boolean)expressionEvaluator.verifyResult(listJsonString, toCheck, null));
        listJsonString = "[{\"value\" : \"> 100\"}]";
        Assert.assertFalse((boolean)expressionEvaluator.verifyResult(listJsonString, toCheck, null));
        listJsonString = "[{\"value\" : \"\"}]";
        Assert.assertTrue((boolean)expressionEvaluator.verifyResult(listJsonString, toCheck, null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void expressionListVerifyResultTest() {
        String expressionCollectionJsonString = new TextNode("10").toString();
        List<BigDecimal> contextValue = Collections.singletonList(BigDecimal.valueOf(10L));
        Assert.assertTrue((boolean)expressionEvaluator.verifyResult(expressionCollectionJsonString, contextValue, List.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void expressionMapVerifyResultTest() {
        String expressionCollectionJsonString = new TextNode("{key_a : 1}").toString();
        Map<String, BigDecimal> contextValue = Collections.singletonMap("key_a", BigDecimal.valueOf(1L));
        Assert.assertTrue((boolean)expressionEvaluator.verifyResult(expressionCollectionJsonString, contextValue, Map.class));
    }
}

