/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorFactory;
import org.drools.scenariosimulation.backend.runner.AbstractRunnerHelper;
import org.drools.scenariosimulation.backend.runner.AbstractScenarioRunner;
import org.drools.scenariosimulation.backend.runner.ScenarioRunnerProvider;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerDTO;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runner.notification.RunNotifier;
import org.kie.api.runtime.KieContainer;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AbstractScenarioRunnerTest {
    private static final int SCENARIO_DATA = 5;
    @Mock
    protected KieContainer kieContainerMock;
    protected AbstractScenarioRunner abstractScenarioRunnerLocal;
    protected Settings settingsLocal;
    private ScenarioRunnerDTO scenarioRunnerDTOLocal;

    @Before
    public void setup() {
        this.settingsLocal = new Settings();
        this.scenarioRunnerDTOLocal = this.getScenarioRunnerDTO();
        this.abstractScenarioRunnerLocal = (AbstractScenarioRunner)Mockito.spy((Object)new AbstractScenarioRunner(this.kieContainerMock, this.scenarioRunnerDTOLocal, ExpressionEvaluatorFactory.create((ClassLoader)this.getClass().getClassLoader(), (ScenarioSimulationModel.Type)ScenarioSimulationModel.Type.RULE)){

            protected AbstractRunnerHelper newRunnerHelper() {
                return null;
            }
        });
    }

    @Test
    public void getDescriptionForSimulationByClassNameAndSimulation() {
        Description retrieved = AbstractScenarioRunner.getDescriptionForSimulation(Optional.empty(), (List)this.scenarioRunnerDTOLocal.getScenarioWithIndices());
        this.commonVerifyDescriptionForSimulation(retrieved, AbstractScenarioRunner.class.getCanonicalName());
        retrieved = AbstractScenarioRunner.getDescriptionForSimulation(Optional.of(String.class.getCanonicalName()), (List)this.scenarioRunnerDTOLocal.getScenarioWithIndices());
        this.commonVerifyDescriptionForSimulation(retrieved, String.class.getCanonicalName());
    }

    @Test
    public void getDescriptionForScenario() {
        Scenario scenario = (Scenario)((ScenarioWithIndex)this.scenarioRunnerDTOLocal.getScenarioWithIndices().get(2)).getScesimData();
        Description retrieved = AbstractScenarioRunner.getDescriptionForScenario(Optional.empty(), (int)1, (Scenario)scenario);
        this.commonVerifyDescriptionForScenario(retrieved, 1, scenario.getDescription(), AbstractScenarioRunner.class.getCanonicalName());
        retrieved = AbstractScenarioRunner.getDescriptionForScenario(Optional.of(String.class.getCanonicalName()), (int)1, (Scenario)scenario);
        this.commonVerifyDescriptionForScenario(retrieved, 1, scenario.getDescription(), String.class.getCanonicalName());
    }

    @Test
    public void getSpecificRunnerProvider() {
        for (ScenarioSimulationModel.Type value : ScenarioSimulationModel.Type.values()) {
            ScenarioRunnerProvider retrieved = AbstractScenarioRunner.getSpecificRunnerProvider((ScenarioSimulationModel.Type)value);
            Assert.assertNotNull((Object)retrieved);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void getSpecificRunnerProviderNullType() {
        this.settingsLocal.setType(null);
        AbstractScenarioRunner.getSpecificRunnerProvider(null);
    }

    @Test
    public void testRun() {
        Assert.assertNull((Object)this.abstractScenarioRunnerLocal.simulationRunMetadataBuilder);
        this.abstractScenarioRunnerLocal.run(new RunNotifier());
        Assert.assertNotNull((Object)this.abstractScenarioRunnerLocal.simulationRunMetadataBuilder);
    }

    private void commonVerifyDescriptionForSimulation(Description retrieved, String className) {
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)"Test Scenarios (Preview) tests", (Object)retrieved.getDisplayName());
        Assert.assertEquals((long)5L, (long)retrieved.getChildren().size());
        Assert.assertNull((Object)retrieved.getTestClass());
        Assert.assertEquals((Object)"Test Scenarios (Preview) tests", (Object)retrieved.getClassName());
        IntStream.range(0, 5).forEach(index -> {
            Description description = (Description)retrieved.getChildren().get(index);
            this.commonVerifyDescriptionForScenario(description, index + 1, ((Scenario)((ScenarioWithIndex)this.scenarioRunnerDTOLocal.getScenarioWithIndices().get(index)).getScesimData()).getDescription(), className);
        });
    }

    private void commonVerifyDescriptionForScenario(Description description, int index, String scenarioDescription, String className) {
        String expected = String.format("#%1$d: %2$s(%3$s)", index, scenarioDescription, className);
        Assert.assertEquals((Object)expected, (Object)description.getDisplayName());
    }

    private ScenarioRunnerDTO getScenarioRunnerDTO() {
        Simulation simulation = new Simulation();
        IntStream.range(0, 5).forEach(index -> {
            Scenario scenario = (Scenario)simulation.addData();
            scenario.setDescription("INDEX-" + index);
        });
        ScenarioSimulationModel model = new ScenarioSimulationModel();
        model.setSimulation(simulation);
        return new ScenarioRunnerDTO(model, "");
    }
}

