/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.drools.mvel.MVELSafeHelper;
import org.drools.scenariosimulation.backend.expression.BaseExpressionOperator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluator;
import org.drools.scenariosimulation.backend.util.JsonUtils;
import org.drools.scenariosimulation.backend.util.ScenarioBeanUtil;
import org.kie.soup.project.datamodel.commons.util.MVELEvaluator;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;

public class MVELExpressionEvaluator
implements ExpressionEvaluator {
    private final ParserConfiguration config;
    private final MVELEvaluator evaluator = MVELSafeHelper.getEvaluator();
    private final ClassLoader classLoader;

    public MVELExpressionEvaluator(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.config = new ParserConfiguration();
        this.config.setClassLoader(classLoader);
    }

    @Override
    public boolean evaluateUnaryExpression(String rawExpression, Object resultValue, Class<?> resultClass) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("actualValue", resultValue);
        Object expressionResult = this.compileAndExecute(rawExpression, params);
        if (!(expressionResult instanceof Boolean)) {
            return BaseExpressionOperator.compareValues(expressionResult, resultValue);
        }
        return (Boolean)expressionResult;
    }

    @Override
    public Object evaluateLiteralExpression(String rawExpression, String className, List<String> genericClasses) {
        Object expressionResult = this.compileAndExecute(rawExpression, new HashMap<String, Object>());
        Class requiredClass = ScenarioBeanUtil.loadClass(className, this.classLoader);
        if (expressionResult != null && !requiredClass.isAssignableFrom(expressionResult.getClass())) {
            throw new IllegalArgumentException("Cannot assign a '" + expressionResult.getClass().getCanonicalName() + "' to '" + requiredClass.getCanonicalName() + "'");
        }
        return expressionResult;
    }

    @Override
    public String fromObjectToExpression(Object value) {
        throw new UnsupportedOperationException("The condition has not been satisfied");
    }

    protected Object compileAndExecute(String rawExpression, Map<String, Object> params) {
        ParserContext ctx = new ParserContext(this.config);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Class<?> type = entry.getValue() != null ? entry.getValue().getClass() : null;
            ctx.addVariable(entry.getKey(), type);
        }
        String expression = this.cleanExpression(rawExpression);
        Serializable compiledExpression = MVEL.compileExpression((String)expression, (ParserContext)ctx);
        return this.evaluator.executeExpression((Object)compiledExpression, params);
    }

    protected String cleanExpression(String rawExpression) {
        JsonNode jsonNode;
        if (rawExpression != null && rawExpression.trim().startsWith("#")) {
            return rawExpression.replaceFirst("#", "");
        }
        Optional<JsonNode> optionalJSONNode = JsonUtils.convertFromStringToJSONNode(rawExpression);
        if (optionalJSONNode.isPresent() && (jsonNode = optionalJSONNode.get()).isTextual() && jsonNode.asText() != null && jsonNode.asText().trim().startsWith("#")) {
            String expression = jsonNode.asText();
            return expression.replaceFirst("#", "");
        }
        throw new IllegalArgumentException("Malformed MVEL expression'" + rawExpression + "'");
    }
}

