/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.fluent;

import java.util.Collections;
import java.util.function.Function;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.backend.fluent.ConditionFilter;
import org.drools.scenariosimulation.backend.fluent.FactCheckerHandle;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.drools.scenariosimulation.backend.runner.model.ValueWrapper;
import org.junit.Assert;
import org.junit.Test;

public class ConditionFilterTest {
    @Test
    public void acceptTest() {
        Function<Object, ValueWrapper> alwaysMatchFunction = ValueWrapper::of;
        FactMappingValue factMappingValue = new FactMappingValue(FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION, (Object)"Test");
        ScenarioResult scenarioResult = new ScenarioResult(factMappingValue);
        ConditionFilter conditionFilter = new ConditionFilter(Collections.singletonList(new FactCheckerHandle(String.class, alwaysMatchFunction, scenarioResult)));
        Assert.assertFalse((boolean)conditionFilter.accept((Object)1));
        Assert.assertTrue((boolean)conditionFilter.accept((Object)"String"));
        Function<Object, ValueWrapper> alwaysNotMatchFunction = object -> ValueWrapper.errorWithValidValue(null, null);
        ConditionFilter conditionFilterFail = new ConditionFilter(Collections.singletonList(new FactCheckerHandle(String.class, alwaysNotMatchFunction, scenarioResult)));
        Assert.assertFalse((boolean)conditionFilterFail.accept((Object)"String"));
    }
}

