/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DOMParserUtil {
    private DOMParserUtil() {
    }

    public static String cleanupNodes(String fullXml, String containerNodeName, String nodeToRemoveName) throws Exception {
        Document document = DOMParserUtil.getDocument(fullXml);
        DOMParserUtil.cleanupNodes(document, containerNodeName, nodeToRemoveName);
        return DOMParserUtil.getString(document);
    }

    public static void cleanupNodes(Document document, String containerNodeName, String nodeToRemoveName) {
        NodeList nodeList = document.getElementsByTagName(containerNodeName);
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                NodeList childNodes = node.getChildNodes();
                if (childNodes == null) continue;
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    Node childNode = childNodes.item(j);
                    if (!Objects.equals(childNode.getNodeName(), nodeToRemoveName)) continue;
                    node.removeChild(childNode);
                }
            }
        }
    }

    public static void replaceNodeText(Document document, String containerNodeName, String nodeName, String toReplace, String replacement) {
        DOMParserUtil.asStream(document.getElementsByTagName(containerNodeName)).forEach(containerNode -> DOMParserUtil.asStream(containerNode.getChildNodes()).filter(childNode -> Objects.equals(nodeName, childNode.getNodeName()) && Objects.equals(toReplace, childNode.getTextContent())).forEach(childNode -> childNode.setTextContent(replacement)));
    }

    public static String replaceNodeName(Document document, String containerNodeName, String childNodeNameToReplace, String childNodeNameReplacement) throws TransformerException {
        NodeList containerNodes = document.getElementsByTagName(containerNodeName);
        if (containerNodes != null) {
            for (int i = 0; i < containerNodes.getLength(); ++i) {
                Node containerNode = containerNodes.item(i);
                NodeList childNodes = containerNode.getChildNodes();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    Node childNode = childNodes.item(j);
                    if (!Objects.equals(childNode.getNodeName(), childNodeNameToReplace)) continue;
                    document.renameNode(childNode, null, childNodeNameReplacement);
                }
            }
        }
        return DOMParserUtil.getString(document);
    }

    public static String getAttributeValue(Node containerNode, String attributeName) {
        return containerNode.getAttributes() != null && containerNode.getAttributes().getNamedItem(attributeName) != null ? containerNode.getAttributes().getNamedItem(attributeName).getNodeValue() : null;
    }

    public static Map<Node, String> getAttributeValues(Document document, String containerNodeName, String attributeName) {
        return DOMParserUtil.asStream(document.getElementsByTagName(containerNodeName)).filter(containerNode -> containerNode.getAttributes() != null && containerNode.getAttributes().getNamedItem(attributeName) != null).collect(Collectors.toMap(containerNode -> containerNode, containerNode -> containerNode.getAttributes().getNamedItem(attributeName).getNodeValue()));
    }

    public static Map<Node, String> getAttributeValues(Document document, String attributeName) {
        HashMap<Node, String> toReturn = new HashMap<Node, String>();
        DOMParserUtil.asStream(document.getChildNodes()).forEach(childNode -> DOMParserUtil.populateAttributeValuesMap(childNode, attributeName, toReturn));
        return toReturn;
    }

    public static void setAttributeValue(Document document, String containerNodeName, String attributeName, String attributeValue) {
        DOMParserUtil.asStream(document.getElementsByTagName(containerNodeName)).map(Node::getAttributes).map(attributes -> attributes.getNamedItem(attributeName)).filter(Objects::nonNull).forEach(attributeNode -> attributeNode.setNodeValue(attributeValue));
    }

    public static Map<Node, Node> createNodes(Document document, String containerNodeName, String childNodeName, String nodeContent) {
        return DOMParserUtil.asStream(document.getElementsByTagName(containerNodeName)).collect(Collectors.toMap(containerNode -> containerNode, containerNode -> {
            Element childNode = document.createElement(childNodeName);
            containerNode.appendChild(childNode);
            if (nodeContent != null) {
                childNode.setTextContent(nodeContent);
            }
            return childNode;
        }));
    }

    public static Map<Node, Node> createNestedNodes(Document document, String mainContainerNodeName, String containerNodeName, String childNodeName, String nodeContent) {
        HashMap<Node, Node> toReturn = new HashMap<Node, Node>();
        DOMParserUtil.asStream(document.getElementsByTagName(mainContainerNodeName)).map(Node::getChildNodes).forEach(containerNodeList -> DOMParserUtil.asStream(containerNodeList).filter(containerNode -> Objects.equals(containerNodeName, containerNode.getNodeName())).forEach(containerNode -> {
            Element childNode = document.createElement(childNodeName);
            containerNode.appendChild(childNode);
            if (nodeContent != null) {
                childNode.setTextContent(nodeContent);
            }
            toReturn.put((Node)containerNode, childNode);
        }));
        return toReturn;
    }

    public static Node createNodeAndAppend(Node containerNode, String nodeToCreateName, String nodeContent) {
        return DOMParserUtil.createNodeAtPosition(containerNode, nodeToCreateName, nodeContent, null);
    }

    public static Node createNodeAtPosition(Node containerNode, String nodeToCreateName, String nodeContent, Integer position) {
        Element toReturn = containerNode.getOwnerDocument().createElement(nodeToCreateName);
        if (nodeContent != null) {
            toReturn.setTextContent(nodeContent);
        }
        if (containerNode.hasChildNodes() && position != null && position < containerNode.getChildNodes().getLength()) {
            Node positionNode = containerNode.getChildNodes().item(position);
            containerNode.insertBefore(toReturn, positionNode);
        } else {
            containerNode.appendChild(toReturn);
        }
        return toReturn;
    }

    public static Map<Node, List<Node>> getChildrenNodesMap(String fullXml, String containerNodeName, String childNodeName) throws Exception {
        Document document = DOMParserUtil.getDocument(fullXml);
        return DOMParserUtil.getChildrenNodesMap(document, containerNodeName, childNodeName);
    }

    public static Map<Node, List<Node>> getChildrenNodesMap(Document document, String containerNodeName, String childNodeName) {
        return DOMParserUtil.asStream(document.getElementsByTagName(containerNodeName)).collect(Collectors.toMap(containerNode -> containerNode, containerNode -> DOMParserUtil.asStream(containerNode.getChildNodes()).filter(childNode -> Objects.equals(childNode.getNodeName(), childNodeName)).collect(Collectors.toList())));
    }

    public static Map<Node, List<Node>> getChildrenNodesMap(Node node, String containerNodeName, String childNodeName) {
        return DOMParserUtil.asStream(node.getChildNodes()).filter(containerNode -> Objects.equals(containerNode.getNodeName(), containerNodeName)).collect(Collectors.toMap(containerNode -> containerNode, containerNode -> DOMParserUtil.asStream(containerNode.getChildNodes()).filter(childNode -> Objects.equals(childNode.getNodeName(), childNodeName)).collect(Collectors.toList())));
    }

    public static List<Node> getChildrenNodesList(Node node, String childNodeName) {
        return DOMParserUtil.asStream(node.getChildNodes()).filter(childNode -> Objects.equals(childNode.getNodeName(), childNodeName)).collect(Collectors.toList());
    }

    public static Map<Node, List<Node>> getNestedChildrenNodesMap(Document document, String mainContainerNodeName, String containerNodeName, String childNodeName) {
        HashMap<Node, List<Node>> toReturn = new HashMap<Node, List<Node>>();
        DOMParserUtil.asStream(document.getElementsByTagName(mainContainerNodeName)).map(mainContainerNode -> DOMParserUtil.getChildrenNodesMap(mainContainerNode, containerNodeName, childNodeName)).forEach(toReturn::putAll);
        return toReturn;
    }

    public static List<Node> getNestedChildrenNodesList(Document document, String grandParentNodeName, String parentNodeName, String childNodeName) {
        return DOMParserUtil.asStream(document.getElementsByTagName(childNodeName)).filter(childNode -> {
            Node parentNode = childNode.getParentNode();
            Node grandParentNode = parentNode.getParentNode();
            return Objects.equals(parentNodeName, parentNode.getNodeName()) && Objects.equals(grandParentNodeName, grandParentNode.getNodeName());
        }).collect(Collectors.toList());
    }

    public static List<Node> getNestedChildrenNodesList(Node node, String containerName, String childNodeName) {
        return DOMParserUtil.asStream(node.getOwnerDocument().getElementsByTagName(childNodeName)).filter(childNode -> Objects.equals(containerName, childNode.getParentNode().getNodeName()) && Objects.equals(node, childNode.getParentNode().getParentNode())).collect(Collectors.toList());
    }

    public static Document getDocument(String xml) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder dBuilder = factory.newDocumentBuilder();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes());){
            Document document = dBuilder.parse(inputStream);
            return document;
        }
    }

    public static String getString(Document toRead) throws TransformerException {
        DOMSource domSource = new DOMSource(toRead);
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        transformer.transform(domSource, sr);
        return sw.toString();
    }

    protected static void populateAttributeValuesMap(Node node, String attributeName, Map<Node, String> toPopulate) {
        Node attributeNode;
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && (attributeNode = attributes.getNamedItem(attributeName)) != null) {
            toPopulate.put(node, attributeNode.getNodeValue());
        }
        DOMParserUtil.asStream(node.getChildNodes()).forEach(childNode -> DOMParserUtil.populateAttributeValuesMap(childNode, attributeName, toPopulate));
    }

    protected static Stream<Node> asStream(NodeList nodeList) {
        if (nodeList == null) {
            return new ArrayList().stream();
        }
        AtomicInteger n = new AtomicInteger(0);
        return Stream.generate(() -> nodeList.item(n.getAndIncrement())).limit(nodeList.getLength());
    }
}

