/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import com.github.javaparser.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.drools.scenariosimulation.backend.util.DOMParserUtil;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class DOMParserUtilTest {
    private static final String MAIN_NODE = "Main";
    private static final String MAIN_ATTRIBUTE_NAME = "mainattribute";
    private static final String ATTRIBUTE_VALUE = "default";
    private static final String TEST_NODE = "testnode";
    private static final String TEST_NODE_CONTENT = "testnodecontent";
    private static final String TEST_NODE_TOREMOVE_1 = "toremove1";
    private static final String TEST_NODE_TOREMOVE_2 = "toremove2";
    private static final String CHILD_NODE = "child";
    private static final String CHILD_ATTRIBUTE_NAME = "childattribute";
    private static final String OTHER_NODE = "othernode";
    private static final String OTHER_NODE_CONTENT_1 = "othernodecontent1";
    private static final String OTHER_NODE_CONTENT_2 = "othernodecontent2";
    private static final String NOT_EXISTING = "NOT_EXISTING";
    private static final String NESTING_NODE = "nesting";
    private static final String NESTED_NODE = "nested";
    private static final String XML = "<Main mainattribute =\"default\"><testnode>testnodecontent</testnode><child childattribute =\"default\"><testnode>toremove1</testnode><othernode>othernodecontent1</othernode><nesting><nested/></nesting></child><child childattribute =\"default\"><testnode>toremove2</testnode><othernode>othernodecontent2</othernode><nesting><nested/></nesting></child></Main>";

    @Test
    public void cleanupNodesString() throws Exception {
        String retrieved = DOMParserUtil.cleanupNodes((String)XML, (String)CHILD_NODE, (String)TEST_NODE);
        Utils.assertNotNull((Object)retrieved);
        Map childrenNodes = DOMParserUtil.getChildrenNodesMap((String)retrieved, (String)MAIN_NODE, (String)TEST_NODE);
        Utils.assertNotNull((Object)childrenNodes);
        Assert.assertEquals((long)1L, (long)childrenNodes.size());
        Node keyNode = (Node)childrenNodes.keySet().iterator().next();
        Assert.assertEquals((Object)MAIN_NODE, (Object)keyNode.getNodeName());
        List valueNodes = (List)childrenNodes.get(keyNode);
        Assert.assertTrue((valueNodes != null && valueNodes.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)TEST_NODE, (Object)((Node)valueNodes.get(0)).getNodeName());
        childrenNodes = DOMParserUtil.getChildrenNodesMap((String)retrieved, (String)CHILD_NODE, (String)OTHER_NODE);
        Assert.assertEquals((long)2L, (long)childrenNodes.size());
        childrenNodes.forEach((childKeyNode, childValueNodes) -> {
            Utils.assertNotNull((Object)childKeyNode);
            Assert.assertEquals((Object)CHILD_NODE, (Object)childKeyNode.getNodeName());
            Assert.assertTrue((childValueNodes != null && childValueNodes.size() == 1 ? 1 : 0) != 0);
            Assert.assertEquals((Object)OTHER_NODE, (Object)((Node)childValueNodes.get(0)).getNodeName());
        });
        childrenNodes = DOMParserUtil.getChildrenNodesMap((String)retrieved, (String)CHILD_NODE, (String)TEST_NODE);
        childrenNodes.forEach((childKeyNode, childValueNodes) -> {
            Utils.assertNotNull((Object)childKeyNode);
            Assert.assertEquals((Object)CHILD_NODE, (Object)childKeyNode.getNodeName());
            Assert.assertTrue((childValueNodes != null && childValueNodes.isEmpty() ? 1 : 0) != 0);
        });
    }

    @Test
    public void cleanupNodesDocument() throws Exception {
        Document document = DOMParserUtil.getDocument((String)XML);
        DOMParserUtil.cleanupNodes((Document)document, (String)CHILD_NODE, (String)TEST_NODE);
        Utils.assertNotNull((Object)document);
        Map childrenNodes = DOMParserUtil.getChildrenNodesMap((Document)document, (String)MAIN_NODE, (String)TEST_NODE);
        Utils.assertNotNull((Object)childrenNodes);
        Assert.assertEquals((long)1L, (long)childrenNodes.size());
        Node keyNode = (Node)childrenNodes.keySet().iterator().next();
        Assert.assertEquals((Object)MAIN_NODE, (Object)keyNode.getNodeName());
        List valueNodes = (List)childrenNodes.get(keyNode);
        Assert.assertTrue((valueNodes != null && valueNodes.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)TEST_NODE, (Object)((Node)valueNodes.get(0)).getNodeName());
        childrenNodes = DOMParserUtil.getChildrenNodesMap((Document)document, (String)CHILD_NODE, (String)OTHER_NODE);
        Assert.assertEquals((long)2L, (long)childrenNodes.size());
        childrenNodes.forEach((childKeyNode, childValueNodes) -> {
            Utils.assertNotNull((Object)childKeyNode);
            Assert.assertEquals((Object)CHILD_NODE, (Object)childKeyNode.getNodeName());
            Assert.assertTrue((childValueNodes != null && childValueNodes.size() == 1 ? 1 : 0) != 0);
            Assert.assertEquals((Object)OTHER_NODE, (Object)((Node)childValueNodes.get(0)).getNodeName());
        });
        childrenNodes = DOMParserUtil.getChildrenNodesMap((Document)document, (String)CHILD_NODE, (String)TEST_NODE);
        childrenNodes.forEach((childKeyNode, childValueNodes) -> {
            Utils.assertNotNull((Object)childKeyNode);
            Assert.assertEquals((Object)CHILD_NODE, (Object)childKeyNode.getNodeName());
            Assert.assertTrue((childValueNodes != null && childValueNodes.isEmpty() ? 1 : 0) != 0);
        });
    }

    @Test
    public void replaceNodeText() throws Exception {
        String replacement = "replacement";
        Document document = DOMParserUtil.getDocument((String)XML);
        DOMParserUtil.replaceNodeText((Document)document, (String)MAIN_NODE, (String)TEST_NODE, (String)TEST_NODE_CONTENT, (String)"replacement");
        Map retrieved = DOMParserUtil.getChildrenNodesMap((Document)document, (String)MAIN_NODE, (String)TEST_NODE);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)1L, (long)retrieved.size());
        List testNodes = (List)retrieved.values().iterator().next();
        Utils.assertNotNull((Object)testNodes);
        Assert.assertEquals((long)1L, (long)testNodes.size());
        Assert.assertEquals((Object)"replacement", (Object)((Node)testNodes.get(0)).getTextContent());
    }

    @Test
    public void replaceNodeName() throws Exception {
        String replacement = "replacement";
        Document document = DOMParserUtil.getDocument((String)XML);
        DOMParserUtil.replaceNodeName((Document)document, (String)MAIN_NODE, (String)TEST_NODE, (String)"replacement");
        Map retrieved = DOMParserUtil.getChildrenNodesMap((Document)document, (String)MAIN_NODE, (String)"replacement");
        Utils.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)1L, (long)retrieved.size());
        List testNodes = (List)retrieved.values().iterator().next();
        Utils.assertNotNull((Object)testNodes);
        Assert.assertEquals((long)1L, (long)testNodes.size());
        Assert.assertEquals((Object)"replacement", (Object)((Node)testNodes.get(0)).getNodeName());
    }

    @Test
    public void getAttributeValuesByNode() throws Exception {
        Document document = DOMParserUtil.getDocument((String)XML);
        Map retrieved = DOMParserUtil.getAttributeValues((Document)document, (String)MAIN_NODE, (String)MAIN_ATTRIBUTE_NAME);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)1L, (long)retrieved.size());
        Assert.assertEquals((Object)ATTRIBUTE_VALUE, (Object)retrieved.values().toArray()[0]);
        retrieved = DOMParserUtil.getAttributeValues((Document)document, (String)MAIN_NODE, (String)NOT_EXISTING);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)retrieved.isEmpty());
        retrieved = DOMParserUtil.getAttributeValues((Document)document, (String)CHILD_NODE, (String)CHILD_ATTRIBUTE_NAME);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)2L, (long)retrieved.size());
        retrieved.values().forEach(attributeValue -> Assert.assertEquals((Object)ATTRIBUTE_VALUE, (Object)attributeValue));
        retrieved = DOMParserUtil.getAttributeValues((Document)document, (String)CHILD_NODE, (String)NOT_EXISTING);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)retrieved.isEmpty());
    }

    @Test
    public void getAllAttributeValues() throws Exception {
        Document document = DOMParserUtil.getDocument((String)XML);
        Map retrieved = DOMParserUtil.getAttributeValues((Document)document, (String)MAIN_ATTRIBUTE_NAME);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)1L, (long)retrieved.size());
        Assert.assertEquals((Object)ATTRIBUTE_VALUE, (Object)retrieved.values().toArray()[0]);
        retrieved = DOMParserUtil.getAttributeValues((Document)document, (String)CHILD_ATTRIBUTE_NAME);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)2L, (long)retrieved.size());
        retrieved.values().forEach(attributeValue -> Assert.assertEquals((Object)ATTRIBUTE_VALUE, (Object)attributeValue));
    }

    @Test
    public void setAttributeValue() throws Exception {
        String newValue = "NEW_VALUE";
        Document document = DOMParserUtil.getDocument((String)XML);
        DOMParserUtil.setAttributeValue((Document)document, (String)MAIN_NODE, (String)MAIN_ATTRIBUTE_NAME, (String)"NEW_VALUE");
        Map retrieved = DOMParserUtil.getAttributeValues((Document)document, (String)MAIN_NODE, (String)MAIN_ATTRIBUTE_NAME);
        Assert.assertEquals((Object)retrieved.values().toArray()[0], (Object)"NEW_VALUE");
        DOMParserUtil.setAttributeValue((Document)document, (String)MAIN_NODE, (String)NOT_EXISTING, (String)"NEW_VALUE");
        retrieved = DOMParserUtil.getAttributeValues((Document)document, (String)MAIN_NODE, (String)NOT_EXISTING);
        Assert.assertTrue((boolean)retrieved.isEmpty());
        DOMParserUtil.setAttributeValue((Document)document, (String)CHILD_NODE, (String)CHILD_ATTRIBUTE_NAME, (String)"NEW_VALUE");
        retrieved = DOMParserUtil.getAttributeValues((Document)document, (String)CHILD_NODE, (String)CHILD_ATTRIBUTE_NAME);
        Assert.assertEquals((long)2L, (long)retrieved.size());
        retrieved.values().forEach(attributeValue -> Assert.assertEquals((Object)"NEW_VALUE", (Object)attributeValue));
    }

    @Test
    public void createNodes() throws Exception {
        String newNodeName = "NEW_NODE_NAME";
        String newNodeValue = "NEW_NODE_VALUE";
        Document document = DOMParserUtil.getDocument((String)XML);
        Map retrieved = DOMParserUtil.createNodes((Document)document, (String)MAIN_NODE, (String)"NEW_NODE_NAME", (String)"NEW_NODE_VALUE");
        Assert.assertEquals((long)1L, (long)retrieved.size());
        Node created = (Node)retrieved.values().toArray()[0];
        Utils.assertNotNull((Object)created);
        Assert.assertEquals((Object)"NEW_NODE_NAME", (Object)created.getNodeName());
        Assert.assertEquals((Object)"NEW_NODE_VALUE", (Object)created.getTextContent());
        retrieved = DOMParserUtil.createNodes((Document)document, (String)MAIN_NODE, (String)"NEW_NODE_NAME", null);
        Assert.assertEquals((long)1L, (long)retrieved.size());
        created = (Node)retrieved.values().toArray()[0];
        Utils.assertNotNull((Object)created);
        Assert.assertEquals((Object)"NEW_NODE_NAME", (Object)created.getNodeName());
        Assert.assertTrue((boolean)created.getTextContent().isEmpty());
        retrieved = DOMParserUtil.createNodes((Document)document, (String)CHILD_NODE, (String)"NEW_NODE_NAME", (String)"NEW_NODE_VALUE");
        Assert.assertEquals((long)2L, (long)retrieved.size());
        retrieved.forEach((key, createdNode) -> {
            Utils.assertNotNull((Object)createdNode);
            Assert.assertEquals((Object)"NEW_NODE_NAME", (Object)createdNode.getNodeName());
            Assert.assertEquals((Object)"NEW_NODE_VALUE", (Object)createdNode.getTextContent());
        });
        retrieved = DOMParserUtil.createNodes((Document)document, (String)CHILD_NODE, (String)"NEW_NODE_NAME", null);
        Assert.assertEquals((long)2L, (long)retrieved.size());
        retrieved.forEach((key, createdNode) -> {
            Utils.assertNotNull((Object)createdNode);
            Assert.assertEquals((Object)"NEW_NODE_NAME", (Object)createdNode.getNodeName());
            Assert.assertTrue((boolean)createdNode.getTextContent().isEmpty());
        });
    }

    @Test
    public void createNestedNodes() throws Exception {
        String newNodeName = "NEW_NODE_NAME";
        String newNodeValue = "NEW_NODE_VALUE";
        Document document = DOMParserUtil.getDocument((String)XML);
        Map retrieved = DOMParserUtil.createNestedNodes((Document)document, (String)MAIN_NODE, (String)TEST_NODE, (String)"NEW_NODE_NAME", (String)"NEW_NODE_VALUE");
        Assert.assertEquals((long)1L, (long)retrieved.size());
        Node created = (Node)retrieved.values().toArray()[0];
        Utils.assertNotNull((Object)created);
        Assert.assertEquals((Object)"NEW_NODE_NAME", (Object)created.getNodeName());
        Assert.assertEquals((Object)"NEW_NODE_VALUE", (Object)created.getTextContent());
        retrieved = DOMParserUtil.createNestedNodes((Document)document, (String)MAIN_NODE, (String)TEST_NODE, (String)"NEW_NODE_NAME", null);
        Assert.assertEquals((long)1L, (long)retrieved.size());
        created = (Node)retrieved.values().toArray()[0];
        Utils.assertNotNull((Object)created);
        Assert.assertEquals((Object)"NEW_NODE_NAME", (Object)created.getNodeName());
        Assert.assertTrue((boolean)created.getTextContent().isEmpty());
        retrieved = DOMParserUtil.createNestedNodes((Document)document, (String)MAIN_NODE, (String)CHILD_NODE, (String)"NEW_NODE_NAME", (String)"NEW_NODE_VALUE");
        Assert.assertEquals((long)2L, (long)retrieved.size());
        retrieved.forEach((key, createdNode) -> {
            Utils.assertNotNull((Object)createdNode);
            Assert.assertEquals((Object)"NEW_NODE_NAME", (Object)createdNode.getNodeName());
            Assert.assertEquals((Object)"NEW_NODE_VALUE", (Object)createdNode.getTextContent());
        });
        retrieved = DOMParserUtil.createNestedNodes((Document)document, (String)MAIN_NODE, (String)CHILD_NODE, (String)"NEW_NODE_NAME", null);
        Assert.assertEquals((long)2L, (long)retrieved.size());
        retrieved.forEach((key, createdNode) -> {
            Utils.assertNotNull((Object)createdNode);
            Assert.assertEquals((Object)"NEW_NODE_NAME", (Object)createdNode.getNodeName());
            Assert.assertTrue((boolean)createdNode.getTextContent().isEmpty());
        });
    }

    @Test
    public void createNodeAtPosition() throws Exception {
        String newNodeName = "NEW_NODE_NAME_0";
        String newNodeValue = "NEW_NODE_VALUE_=";
        Document document = DOMParserUtil.getDocument((String)XML);
        Map testNodesMap = DOMParserUtil.getChildrenNodesMap((Document)document, (String)MAIN_NODE, (String)TEST_NODE);
        Assert.assertEquals((long)1L, (long)testNodesMap.size());
        Node mainNode = (Node)testNodesMap.keySet().iterator().next();
        Node retrieved = DOMParserUtil.createNodeAtPosition((Node)mainNode, (String)newNodeName, (String)newNodeValue, null);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)newNodeName, (Object)retrieved.getNodeName());
        Assert.assertEquals((Object)newNodeValue, (Object)retrieved.getTextContent());
        Assert.assertEquals((Object)retrieved, (Object)mainNode.getChildNodes().item(mainNode.getChildNodes().getLength() - 1));
        newNodeName = "NEW_NODE_NAME_1";
        newNodeValue = "NEW_NODE_VALUE_1";
        retrieved = DOMParserUtil.createNodeAtPosition((Node)mainNode, (String)newNodeName, (String)newNodeValue, (Integer)0);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)newNodeName, (Object)retrieved.getNodeName());
        Assert.assertEquals((Object)newNodeValue, (Object)retrieved.getTextContent());
        Assert.assertEquals((Object)retrieved, (Object)mainNode.getChildNodes().item(0));
        newNodeName = "NEW_NODE_NAME_2";
        newNodeValue = "NEW_NODE_VALUE_2";
        retrieved = DOMParserUtil.createNodeAtPosition((Node)mainNode, (String)newNodeName, (String)newNodeValue, (Integer)2);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)newNodeName, (Object)retrieved.getNodeName());
        Assert.assertEquals((Object)newNodeValue, (Object)retrieved.getTextContent());
        Assert.assertEquals((Object)retrieved, (Object)mainNode.getChildNodes().item(2));
    }

    @Test
    public void createNodeAndAppend() throws Exception {
        String newNodeName0 = "NEW_NODE_NAME_0";
        String newNodeValue0 = "NEW_NODE_VALUE_=";
        Document document = DOMParserUtil.getDocument((String)XML);
        Map testNodesMap = DOMParserUtil.getChildrenNodesMap((Document)document, (String)MAIN_NODE, (String)TEST_NODE);
        Assert.assertEquals((long)1L, (long)testNodesMap.size());
        Node mainNode = (Node)testNodesMap.keySet().iterator().next();
        int startingChildNodes = mainNode.getChildNodes().getLength();
        Node retrieved = DOMParserUtil.createNodeAndAppend((Node)mainNode, (String)newNodeName0, (String)newNodeValue0);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)newNodeName0, (Object)retrieved.getNodeName());
        Assert.assertEquals((Object)newNodeValue0, (Object)retrieved.getTextContent());
        Assert.assertEquals((Object)retrieved, (Object)mainNode.getChildNodes().item(mainNode.getChildNodes().getLength() - 1));
        Assert.assertEquals((long)(startingChildNodes + 1), (long)mainNode.getChildNodes().getLength());
        String newNodeName1 = "NEW_NODE_NAME_1";
        String newNodeValue1 = "NEW_NODE_VALUE_1";
        retrieved = DOMParserUtil.createNodeAndAppend((Node)mainNode, (String)newNodeName1, (String)newNodeValue1);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)newNodeName1, (Object)retrieved.getNodeName());
        Assert.assertEquals((Object)newNodeValue1, (Object)retrieved.getTextContent());
        Assert.assertEquals((Object)retrieved, (Object)mainNode.getChildNodes().item(mainNode.getChildNodes().getLength() - 1));
        Assert.assertEquals((long)(startingChildNodes + 2), (long)mainNode.getChildNodes().getLength());
        String newNodeName2 = "NEW_NODE_NAME_2";
        String newNodeValue2 = "NEW_NODE_VALUE_2";
        retrieved = DOMParserUtil.createNodeAndAppend((Node)mainNode, (String)newNodeName2, (String)newNodeValue2);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)newNodeName2, (Object)retrieved.getNodeName());
        Assert.assertEquals((Object)newNodeValue2, (Object)retrieved.getTextContent());
        Assert.assertEquals((Object)retrieved, (Object)mainNode.getChildNodes().item(mainNode.getChildNodes().getLength() - 1));
        Assert.assertEquals((long)(startingChildNodes + 3), (long)mainNode.getChildNodes().getLength());
        Assert.assertEquals((Object)newNodeName0, (Object)mainNode.getChildNodes().item(startingChildNodes).getNodeName());
        Assert.assertEquals((Object)newNodeValue0, (Object)mainNode.getChildNodes().item(startingChildNodes).getTextContent());
        Assert.assertEquals((Object)newNodeName1, (Object)mainNode.getChildNodes().item(startingChildNodes + 1).getNodeName());
        Assert.assertEquals((Object)newNodeValue1, (Object)mainNode.getChildNodes().item(startingChildNodes + 1).getTextContent());
        Assert.assertEquals((Object)newNodeName2, (Object)mainNode.getChildNodes().item(startingChildNodes + 2).getNodeName());
        Assert.assertEquals((Object)newNodeValue2, (Object)mainNode.getChildNodes().item(startingChildNodes + 2).getTextContent());
    }

    @Test
    public void getChildrenNodesFromDocument() throws Exception {
        Document document = DOMParserUtil.getDocument((String)XML);
        Map retrieved = DOMParserUtil.getChildrenNodesMap((Document)document, (String)MAIN_NODE, (String)TEST_NODE);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)1L, (long)retrieved.size());
        Node keyNode = (Node)retrieved.keySet().iterator().next();
        Utils.assertNotNull((Object)keyNode);
        Assert.assertEquals((Object)MAIN_NODE, (Object)keyNode.getNodeName());
        List valueNodes = (List)retrieved.get(keyNode);
        Assert.assertTrue((valueNodes != null && valueNodes.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)TEST_NODE, (Object)((Node)valueNodes.get(0)).getNodeName());
        retrieved = DOMParserUtil.getChildrenNodesMap((Document)document, (String)MAIN_NODE, (String)NOT_EXISTING);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)1L, (long)retrieved.size());
        Assert.assertTrue((boolean)((List)retrieved.values().iterator().next()).isEmpty());
        retrieved = DOMParserUtil.getChildrenNodesMap((Document)document, (String)MAIN_NODE, (String)CHILD_NODE);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)1L, (long)retrieved.size());
        keyNode = (Node)retrieved.keySet().iterator().next();
        Utils.assertNotNull((Object)keyNode);
        Assert.assertEquals((Object)MAIN_NODE, (Object)keyNode.getNodeName());
        valueNodes = (List)retrieved.get(keyNode);
        Assert.assertTrue((valueNodes != null && valueNodes.size() == 2 ? 1 : 0) != 0);
        valueNodes.forEach(childNode -> Assert.assertEquals((Object)CHILD_NODE, (Object)childNode.getNodeName()));
        List<String> nodeToTest = Arrays.asList(TEST_NODE, OTHER_NODE);
        for (String childNodeName : nodeToTest) {
            retrieved = DOMParserUtil.getChildrenNodesMap((String)XML, (String)CHILD_NODE, (String)childNodeName);
            Utils.assertNotNull((Object)retrieved);
            Assert.assertEquals((long)2L, (long)retrieved.size());
            retrieved.forEach((childKeyNode, childValueNodes) -> {
                Utils.assertNotNull((Object)childKeyNode);
                Assert.assertEquals((Object)CHILD_NODE, (Object)childKeyNode.getNodeName());
                Assert.assertTrue((childValueNodes != null && childValueNodes.size() == 1 ? 1 : 0) != 0);
                Assert.assertEquals((Object)childNodeName, (Object)((Node)childValueNodes.get(0)).getNodeName());
            });
        }
    }

    @Test
    public void getChildrenNodesFromNode() throws Exception {
        Document document = DOMParserUtil.getDocument((String)XML);
        Map retrieved = DOMParserUtil.getChildrenNodesMap((Document)document, (String)MAIN_NODE, (String)CHILD_NODE);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)1L, (long)retrieved.size());
        Node mainNode = (Node)retrieved.keySet().toArray()[0];
        Assert.assertEquals((Object)MAIN_NODE, (Object)mainNode.getNodeName());
        List nodes = (List)retrieved.get(mainNode);
        nodes.forEach(childNode -> Assert.assertEquals((Object)CHILD_NODE, (Object)childNode.getNodeName()));
        retrieved = DOMParserUtil.getChildrenNodesMap((Node)((Node)nodes.get(0)), (String)NESTING_NODE, (String)NESTED_NODE);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)1L, (long)retrieved.size());
        Node childNode2 = (Node)retrieved.keySet().toArray()[0];
        Assert.assertEquals((Object)NESTING_NODE, (Object)childNode2.getNodeName());
        nodes = (List)retrieved.get(childNode2);
        Utils.assertNotNull((Object)nodes);
        Assert.assertEquals((long)1L, (long)nodes.size());
        Assert.assertEquals((Object)NESTED_NODE, (Object)((Node)nodes.get(0)).getNodeName());
    }

    @Test
    public void getNestedChildrenNodesMap() throws Exception {
        Document document = DOMParserUtil.getDocument((String)XML);
        Map retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)MAIN_NODE, (String)CHILD_NODE, (String)TEST_NODE);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)2L, (long)retrieved.size());
        retrieved.forEach((childNode, testNodes) -> {
            Assert.assertEquals((Object)CHILD_NODE, (Object)childNode.getNodeName());
            Assert.assertEquals((long)1L, (long)testNodes.size());
            Assert.assertEquals((Object)TEST_NODE, (Object)((Node)testNodes.get(0)).getNodeName());
        });
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)CHILD_NODE, (String)NESTING_NODE, (String)NESTED_NODE);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)2L, (long)retrieved.size());
        retrieved.forEach((nestingNode, nestedNodes) -> {
            Assert.assertEquals((Object)NESTING_NODE, (Object)nestingNode.getNodeName());
            Assert.assertEquals((long)1L, (long)nestedNodes.size());
            Assert.assertEquals((Object)NESTED_NODE, (Object)((Node)nestedNodes.get(0)).getNodeName());
        });
    }

    @Test
    public void getNestedChildrenNodesList() throws Exception {
        Document document = DOMParserUtil.getDocument((String)XML);
        List retrieved = DOMParserUtil.getNestedChildrenNodesList((Document)document, (String)MAIN_NODE, (String)CHILD_NODE, (String)TEST_NODE);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)2L, (long)retrieved.size());
        retrieved.forEach(testNode -> Assert.assertEquals((Object)TEST_NODE, (Object)testNode.getNodeName()));
        retrieved = DOMParserUtil.getNestedChildrenNodesList((Document)document, (String)CHILD_NODE, (String)NESTING_NODE, (String)NESTED_NODE);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)2L, (long)retrieved.size());
        retrieved.forEach(nestedNode -> Assert.assertEquals((Object)NESTED_NODE, (Object)nestedNode.getNodeName()));
    }

    @Test
    public void getDocument() throws Exception {
        Document retrieved = DOMParserUtil.getDocument((String)XML);
        Utils.assertNotNull((Object)retrieved);
    }

    @Test(expected=SAXParseException.class)
    public void getDocument_XXE_Vulnerability() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE foo [ <!ENTITY xxe SYSTEM \"file:///\"> ]>\n<stocklevel><ProductID>&xxe;</ProductID></stocklevel>";
        Document retrieved = DOMParserUtil.getDocument((String)xml);
        Transformer transformer = DOMParserUtil.createTransformer();
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        transformer.transform(new DOMSource(retrieved), sr);
    }

    @Test
    public void getString() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document document = builder.newDocument();
        document.appendChild(document.createElement("CREATED"));
        String retrieved = DOMParserUtil.getString((Document)document);
        Utils.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)retrieved.contains("CREATED"));
    }

    @Test(expected=TransformerException.class)
    public void createTransformer_XXE_Vulnerability() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE foo [ <!ENTITY xxe SYSTEM \"file:///\"> ]>\n<stocklevel><ProductID>&xxe;</ProductID></stocklevel>";
        StreamSource source = new StreamSource(new ByteArrayInputStream(xml.getBytes()));
        Transformer transformer = DOMParserUtil.createTransformer();
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        transformer.transform(source, sr);
    }

    @Test
    public void asStream() throws Exception {
        Document document = DOMParserUtil.getDocument((String)XML);
        NodeList mainNodeList = document.getElementsByTagName(MAIN_NODE);
        this.commonCheckNodeStream(mainNodeList);
        NodeList childNodesList = mainNodeList.item(0).getChildNodes();
        this.commonCheckNodeStream(childNodesList);
        NodeList innerNodesList = childNodesList.item(0).getChildNodes();
        this.commonCheckNodeStream(innerNodesList);
    }

    private void commonCheckNodeStream(NodeList src) {
        Assert.assertEquals((long)src.getLength(), (long)DOMParserUtil.asStream((NodeList)src).count());
        AtomicInteger counter = new AtomicInteger();
        Stream nodeStream = DOMParserUtil.asStream((NodeList)src);
        nodeStream.forEach(node -> Assert.assertEquals((Object)src.item(counter.getAndIncrement()), (Object)node));
    }
}

