/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.backend.model.Dispute;
import org.drools.scenariosimulation.backend.model.NotEmptyConstructor;
import org.drools.scenariosimulation.backend.model.Person;
import org.drools.scenariosimulation.backend.model.SubPerson;
import org.drools.scenariosimulation.backend.runner.RuleScenarioRunnerHelperTest;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.ValueWrapper;
import org.drools.scenariosimulation.backend.util.ScenarioBeanUtil;
import org.drools.scenariosimulation.backend.util.ScenarioBeanWrapper;
import org.drools.scenariosimulation.backend.util.model.EnumTest;
import org.junit.Assert;
import org.junit.Test;

public class ScenarioBeanUtilTest {
    private static String FIRST_NAME = "firstNameToSet";
    private static int AGE = 10;
    private static ClassLoader classLoader = ScenarioBeanUtilTest.class.getClassLoader();

    @Test
    public void fillBeanTest() {
        HashMap<List<String>, Object> paramsToSet = new HashMap<List<String>, Object>();
        paramsToSet.put(Arrays.asList("creator", "firstName"), FIRST_NAME);
        paramsToSet.put(Arrays.asList("creator", "age"), AGE);
        Object result = ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.errorEmptyMessage(), (String)Dispute.class.getCanonicalName(), paramsToSet, (ClassLoader)classLoader);
        Assert.assertTrue((boolean)(result instanceof Dispute));
        Dispute dispute = (Dispute)result;
        Assert.assertEquals((Object)dispute.getCreator().getFirstName(), (Object)FIRST_NAME);
        Assert.assertEquals((long)dispute.getCreator().getAge(), (long)AGE);
    }

    @Test
    public void fillBeanTestWithInitialInstanceTest() {
        Dispute dispute = new Dispute();
        HashMap<List<String>, Object> paramsToSet = new HashMap<List<String>, Object>();
        paramsToSet.put(Arrays.asList("creator", "firstName"), FIRST_NAME);
        paramsToSet.put(Arrays.asList("creator", "age"), AGE);
        Object result = ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.of((Object)dispute), (String)Dispute.class.getCanonicalName(), paramsToSet, (ClassLoader)classLoader);
        Assert.assertTrue((boolean)(result instanceof Dispute));
        Assert.assertSame((Object)dispute, (Object)result);
        Assert.assertEquals((Object)dispute.getCreator().getFirstName(), (Object)FIRST_NAME);
        Assert.assertEquals((long)dispute.getCreator().getAge(), (long)AGE);
    }

    @Test(expected=ScenarioException.class)
    public void fillBeanLoadClassTest() {
        ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.errorEmptyMessage(), (String)"FakeCanonicalName", new HashMap(), (ClassLoader)classLoader);
    }

    @Test(expected=ScenarioException.class)
    public void fillBeanFailNotEmptyConstructorTest() {
        HashMap<List<String>, Object> paramsToSet = new HashMap<List<String>, Object>();
        paramsToSet.put(Collections.singletonList("name"), null);
        ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.errorEmptyMessage(), (String)NotEmptyConstructor.class.getCanonicalName(), paramsToSet, (ClassLoader)classLoader);
    }

    @Test(expected=ScenarioException.class)
    public void fillBeanFailTest() {
        HashMap<List<String>, Object> paramsToSet = new HashMap<List<String>, Object>();
        paramsToSet.put(Collections.singletonList("fakeField"), null);
        ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.errorEmptyMessage(), (String)Dispute.class.getCanonicalName(), paramsToSet, (ClassLoader)classLoader);
    }

    @Test(expected=ScenarioException.class)
    public void fillBeanFailNullClassTest() {
        HashMap<List<String>, Object> paramsToSet = new HashMap<List<String>, Object>();
        paramsToSet.put(Collections.singletonList("fakeField"), null);
        ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.errorEmptyMessage(), null, paramsToSet, (ClassLoader)classLoader);
    }

    @Test(expected=ScenarioException.class)
    public void fillBeanFailWrongTypeTest() {
        HashMap paramsToSet = new HashMap();
        paramsToSet.put(Collections.singletonList("description"), new ArrayList());
        ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.errorEmptyMessage(), (String)Dispute.class.getCanonicalName(), paramsToSet, (ClassLoader)classLoader);
    }

    @Test
    public void fillBeanEmptyValueTest() {
        HashMap paramsToSet = new HashMap();
        paramsToSet.put(Collections.emptyList(), null);
        Assert.assertNull((Object)ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.of(null), (String)String.class.getCanonicalName(), paramsToSet, (ClassLoader)classLoader));
    }

    @Test
    public void navigateToObjectTest() {
        Dispute dispute = new Dispute();
        Person creator = new Person();
        creator.setFirstName(FIRST_NAME);
        dispute.setCreator(creator);
        List<String> pathToProperty = Arrays.asList("creator", "firstName");
        ScenarioBeanWrapper scenarioBeanWrapper = ScenarioBeanUtil.navigateToObject((Object)dispute, pathToProperty, (boolean)true);
        Object targetObject = scenarioBeanWrapper.getBean();
        Assert.assertEquals((Object)targetObject, (Object)FIRST_NAME);
        Assert.assertNull((Object)ScenarioBeanUtil.navigateToObject(null, Collections.emptyList()).getBean());
    }

    @Test
    public void navigateToObjectFakeFieldTest() {
        Dispute dispute = new Dispute();
        List<String> pathToProperty = Collections.singletonList("fakeField");
        String message = "Impossible to find field with name 'fakeField' in class " + Dispute.class.getCanonicalName();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.navigateToObject((Object)dispute, (List)pathToProperty, (boolean)true)).isInstanceOf(ScenarioException.class)).hasMessage(message);
    }

    @Test
    public void navigateToObjectNoStepCreationTest() {
        Dispute dispute = new Dispute();
        List<String> pathToProperty = Arrays.asList("creator", "firstName");
        String message = "Impossible to reach field firstName because a step is not instantiated";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.navigateToObject((Object)dispute, (List)pathToProperty, (boolean)false)).isInstanceOf(ScenarioException.class)).hasMessage(message);
    }

    @Test
    public void convertValueTest() {
        Assert.assertEquals((Object)"Test", (Object)ScenarioBeanUtil.convertValue((String)String.class.getCanonicalName(), (Object)"Test", (ClassLoader)classLoader));
        Assert.assertEquals((Object)BigDecimal.valueOf(13.33), (Object)ScenarioBeanUtil.convertValue((String)BigDecimal.class.getCanonicalName(), (Object)"13.33", (ClassLoader)classLoader));
        Assert.assertEquals((Object)BigDecimal.valueOf(13L), (Object)ScenarioBeanUtil.convertValue((String)BigDecimal.class.getCanonicalName(), (Object)"13", (ClassLoader)classLoader));
        Assert.assertEquals((Object)BigDecimal.valueOf(1232113.33), (Object)ScenarioBeanUtil.convertValue((String)BigDecimal.class.getCanonicalName(), (Object)"1,232,113.33", (ClassLoader)classLoader));
        Assert.assertEquals((Object)BigDecimal.valueOf(1232113.33), (Object)ScenarioBeanUtil.convertValue((String)BigDecimal.class.getCanonicalName(), (Object)"1232113.33", (ClassLoader)classLoader));
        Assert.assertEquals((Object)BigInteger.valueOf(13L), (Object)ScenarioBeanUtil.convertValue((String)BigInteger.class.getCanonicalName(), (Object)"13.33", (ClassLoader)classLoader));
        Assert.assertEquals((Object)BigInteger.valueOf(13L), (Object)ScenarioBeanUtil.convertValue((String)BigInteger.class.getCanonicalName(), (Object)"13", (ClassLoader)classLoader));
        Assert.assertEquals((Object)BigInteger.valueOf(1232113L), (Object)ScenarioBeanUtil.convertValue((String)BigInteger.class.getCanonicalName(), (Object)"1,232,113.33", (ClassLoader)classLoader));
        Assert.assertEquals((Object)BigInteger.valueOf(1232113L), (Object)ScenarioBeanUtil.convertValue((String)BigInteger.class.getCanonicalName(), (Object)"1232113", (ClassLoader)classLoader));
        Assert.assertEquals((Object)false, (Object)ScenarioBeanUtil.convertValue((String)Boolean.TYPE.getCanonicalName(), (Object)"false", (ClassLoader)classLoader));
        Assert.assertEquals((Object)true, (Object)ScenarioBeanUtil.convertValue((String)Boolean.class.getCanonicalName(), (Object)"true", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1, (Object)ScenarioBeanUtil.convertValue((String)Integer.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1, (Object)ScenarioBeanUtil.convertValue((String)Integer.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1L, (Object)ScenarioBeanUtil.convertValue((String)Long.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1L, (Object)ScenarioBeanUtil.convertValue((String)Long.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1.0d", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1.0d", (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1.0f", (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1.0f", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1.0D", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1.0D", (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1.0F", (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1.0F", (ClassLoader)classLoader));
        Assert.assertEquals((Object)Character.valueOf('a'), (Object)ScenarioBeanUtil.convertValue((String)Character.TYPE.getCanonicalName(), (Object)"a", (ClassLoader)classLoader));
        Assert.assertEquals((Object)Character.valueOf('a'), (Object)ScenarioBeanUtil.convertValue((String)Character.class.getCanonicalName(), (Object)"a", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1, (Object)ScenarioBeanUtil.convertValue((String)Short.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1, (Object)ScenarioBeanUtil.convertValue((String)Short.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)"0".getBytes()[0], (Object)ScenarioBeanUtil.convertValue((String)Byte.TYPE.getCanonicalName(), (Object)Byte.toString("0".getBytes()[0]), (ClassLoader)classLoader));
        Assert.assertEquals((Object)"0".getBytes()[0], (Object)ScenarioBeanUtil.convertValue((String)Byte.class.getCanonicalName(), (Object)Byte.toString("0".getBytes()[0]), (ClassLoader)classLoader));
        Assert.assertEquals((Object)LocalDate.of(2018, 5, 20), (Object)ScenarioBeanUtil.convertValue((String)LocalDate.class.getCanonicalName(), (Object)"2018-05-20", (ClassLoader)classLoader));
        Assert.assertEquals((Object)LocalDateTime.of(2017, 2, 18, 10, 30), (Object)ScenarioBeanUtil.convertValue((String)LocalDateTime.class.getCanonicalName(), (Object)"2017-02-18T10:30", (ClassLoader)classLoader));
        Assert.assertEquals((Object)LocalDateTime.of(1982, 4, 4, 0, 20, 0), (Object)ScenarioBeanUtil.convertValue((String)LocalDateTime.class.getCanonicalName(), (Object)"1982-04-04T00:20", (ClassLoader)classLoader));
        Assert.assertEquals((Object)LocalDateTime.of(1982, 10, 13, 2, 9, 0, 999999999), (Object)ScenarioBeanUtil.convertValue((String)LocalDateTime.class.getCanonicalName(), (Object)"1982-10-13T02:09:00.999999999", (ClassLoader)classLoader));
        Assert.assertEquals((Object)LocalTime.of(1, 9, 0), (Object)ScenarioBeanUtil.convertValue((String)LocalTime.class.getCanonicalName(), (Object)"01:09:00", (ClassLoader)classLoader));
        Assert.assertEquals((Object)LocalTime.of(4, 59, 7, 9999999), (Object)ScenarioBeanUtil.convertValue((String)LocalTime.class.getCanonicalName(), (Object)"04:59:07.009999999", (ClassLoader)classLoader));
        Assert.assertEquals((Object)LocalTime.of(23, 45), (Object)ScenarioBeanUtil.convertValue((String)LocalTime.class.getCanonicalName(), (Object)"23:45", (ClassLoader)classLoader));
        Assert.assertEquals((Object)LocalTime.of(1, 9, 0), (Object)ScenarioBeanUtil.convertValue((String)LocalTime.class.getCanonicalName(), (Object)"01:09:00", (ClassLoader)classLoader));
        Assert.assertEquals((Object)LocalTime.of(4, 59, 7, 9999999), (Object)ScenarioBeanUtil.convertValue((String)LocalTime.class.getCanonicalName(), (Object)"04:59:07.009999999", (ClassLoader)classLoader));
        Assert.assertEquals((Object)((Object)EnumTest.FIRST), (Object)ScenarioBeanUtil.convertValue((String)EnumTest.class.getCanonicalName(), (Object)"FIRST", (ClassLoader)classLoader));
        Assert.assertNull((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), null, (ClassLoader)classLoader));
    }

    @Test
    public void revertValueTest() {
        Assert.assertEquals((Object)"Test", (Object)ScenarioBeanUtil.revertValue((Object)"Test"));
        Assert.assertEquals((Object)"10000.83", (Object)ScenarioBeanUtil.revertValue((Object)BigDecimal.valueOf(10000.83)));
        Assert.assertEquals((Object)"10000", (Object)ScenarioBeanUtil.revertValue((Object)BigDecimal.valueOf(10000L)));
        Assert.assertEquals((Object)"10000", (Object)ScenarioBeanUtil.revertValue((Object)BigInteger.valueOf(10000L)));
        Assert.assertEquals((Object)"false", (Object)ScenarioBeanUtil.revertValue((Object)Boolean.FALSE));
        Assert.assertEquals((Object)"true", (Object)ScenarioBeanUtil.revertValue((Object)Boolean.TRUE));
        Assert.assertEquals((Object)"false", (Object)ScenarioBeanUtil.revertValue((Object)false));
        Assert.assertEquals((Object)"true", (Object)ScenarioBeanUtil.revertValue((Object)true));
        Assert.assertEquals((Object)"1", (Object)ScenarioBeanUtil.revertValue((Object)1));
        Assert.assertEquals((Object)"1", (Object)ScenarioBeanUtil.revertValue((Object)new Integer(1)));
        Assert.assertEquals((Object)"1", (Object)ScenarioBeanUtil.revertValue((Object)1L));
        Assert.assertEquals((Object)"1", (Object)ScenarioBeanUtil.revertValue((Object)new Long(1L)));
        Assert.assertEquals((Object)"1.1d", (Object)ScenarioBeanUtil.revertValue((Object)1.1));
        Assert.assertEquals((Object)"1.1d", (Object)ScenarioBeanUtil.revertValue((Object)new Double(1.1)));
        Assert.assertEquals((Object)"NaN", (Object)ScenarioBeanUtil.revertValue((Object)Double.NaN));
        Assert.assertEquals((Object)"Infinity", (Object)ScenarioBeanUtil.revertValue((Object)Double.POSITIVE_INFINITY));
        Assert.assertEquals((Object)"-Infinity", (Object)ScenarioBeanUtil.revertValue((Object)Double.NEGATIVE_INFINITY));
        Assert.assertEquals((Object)"1.1f", (Object)ScenarioBeanUtil.revertValue((Object)Float.valueOf(1.1f)));
        Assert.assertEquals((Object)"1.1f", (Object)ScenarioBeanUtil.revertValue((Object)new Float(1.1)));
        Assert.assertEquals((Object)"a", (Object)ScenarioBeanUtil.revertValue((Object)Character.valueOf('a')));
        Assert.assertEquals((Object)"a", (Object)ScenarioBeanUtil.revertValue((Object)new Character('a')));
        Assert.assertEquals((Object)"1", (Object)ScenarioBeanUtil.revertValue((Object)1));
        Assert.assertEquals((Object)String.valueOf("0".getBytes()[0]), (Object)ScenarioBeanUtil.revertValue((Object)"0".getBytes()[0]));
        Assert.assertEquals((Object)String.valueOf("0".getBytes()[0]), (Object)ScenarioBeanUtil.revertValue((Object)new Byte("0".getBytes()[0])));
        Assert.assertEquals((Object)"null", (Object)ScenarioBeanUtil.revertValue(null));
        Assert.assertEquals((Object)"2018-10-20", (Object)ScenarioBeanUtil.revertValue((Object)LocalDate.of(2018, 10, 20)));
        Assert.assertEquals((Object)"2018-10-20T02:13:00", (Object)ScenarioBeanUtil.revertValue((Object)LocalDateTime.of(2018, 10, 20, 2, 13)));
        Assert.assertEquals((Object)"2018-10-20T02:13:03", (Object)ScenarioBeanUtil.revertValue((Object)LocalDateTime.of(2018, 10, 20, 2, 13, 3)));
        Assert.assertEquals((Object)"2018-10-20T02:13:03.000009999", (Object)ScenarioBeanUtil.revertValue((Object)LocalDateTime.of(2018, 10, 20, 2, 13, 3, 9999)));
        Assert.assertEquals((Object)"02:13:00", (Object)ScenarioBeanUtil.revertValue((Object)LocalTime.of(2, 13)));
        Assert.assertEquals((Object)"02:13:03", (Object)ScenarioBeanUtil.revertValue((Object)LocalTime.of(2, 13, 3)));
        Assert.assertEquals((Object)"02:13:03.000009999", (Object)ScenarioBeanUtil.revertValue((Object)LocalTime.of(2, 13, 3, 9999)));
        Assert.assertEquals((Object)"FIRST", (Object)ScenarioBeanUtil.revertValue((Object)((Object)EnumTest.FIRST)));
    }

    @Test
    public void convertAndRevertValue() {
        Assert.assertEquals((Object)"Test", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)String.class.getCanonicalName(), (Object)"Test", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"false", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Boolean.TYPE.getCanonicalName(), (Object)"false", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"true", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Boolean.class.getCanonicalName(), (Object)"true", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1000", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)BigDecimal.class.getCanonicalName(), (Object)"1000", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1000.23", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)BigDecimal.class.getCanonicalName(), (Object)"1000.23", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1000.23", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)BigDecimal.class.getCanonicalName(), (Object)"1,000.23", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1000", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)BigInteger.class.getCanonicalName(), (Object)"1000", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1000", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)BigInteger.class.getCanonicalName(), (Object)"1000.23", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1000", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)BigInteger.class.getCanonicalName(), (Object)"1,000.23", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Integer.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Integer.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Long.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Long.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0d", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0d", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"NaN", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"NaN", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"NaN", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"NaN", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"Infinity", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"Infinity", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"Infinity", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"Infinity", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"-Infinity", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"-Infinity", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"-Infinity", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"-Infinity", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0f", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0f", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0d", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0d", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0f", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0f", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0d", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1.0d", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0d", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1.0d", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0f", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1.0f", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0f", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1.0f", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0d", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1.0D", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0d", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1.0D", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0f", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1.0F", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1.0f", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1.0F", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"a", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Character.TYPE.getCanonicalName(), (Object)"a", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"a", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Character.class.getCanonicalName(), (Object)"a", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Short.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"1", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Short.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)Byte.toString("0".getBytes()[0]), (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Byte.TYPE.getCanonicalName(), (Object)Byte.toString("0".getBytes()[0]), (ClassLoader)classLoader)));
        Assert.assertEquals((Object)Byte.toString("0".getBytes()[0]), (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Byte.class.getCanonicalName(), (Object)Byte.toString("0".getBytes()[0]), (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"2018-05-20", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)LocalDate.class.getCanonicalName(), (Object)"2018-05-20", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"2018-05-20T03:04:00", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)LocalDateTime.class.getCanonicalName(), (Object)"2018-05-20T03:04", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"2018-05-20T03:04:01", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)LocalDateTime.class.getCanonicalName(), (Object)"2018-05-20T03:04:01", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"2018-05-20T03:04:01.000009999", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)LocalDateTime.class.getCanonicalName(), (Object)"2018-05-20T03:04:01.000009999", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"03:04:00", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)LocalTime.class.getCanonicalName(), (Object)"03:04", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"03:04:01", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)LocalTime.class.getCanonicalName(), (Object)"03:04:01", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"03:04:01.000009999", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)LocalTime.class.getCanonicalName(), (Object)"03:04:01.000009999", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"FIRST", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)EnumTest.class.getCanonicalName(), (Object)"FIRST", (ClassLoader)classLoader)));
        Assert.assertEquals((Object)"null", (Object)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), null, (ClassLoader)classLoader)));
    }

    @Test
    public void revertAndConvertValueTest() {
        Assert.assertEquals((Object)"Test", (Object)ScenarioBeanUtil.convertValue((String)String.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)"Test"), (ClassLoader)classLoader));
        Assert.assertEquals((Object)false, (Object)ScenarioBeanUtil.convertValue((String)Boolean.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)false), (ClassLoader)classLoader));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ScenarioBeanUtil.convertValue((String)Boolean.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)Boolean.TRUE), (ClassLoader)classLoader));
        Assert.assertEquals((Object)BigInteger.valueOf(1000L), (Object)ScenarioBeanUtil.convertValue((String)BigInteger.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)BigInteger.valueOf(1000L)), (ClassLoader)classLoader));
        Assert.assertEquals((Object)BigDecimal.valueOf(1000L), (Object)ScenarioBeanUtil.convertValue((String)BigDecimal.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)BigDecimal.valueOf(1000L)), (ClassLoader)classLoader));
        Assert.assertEquals((Object)BigDecimal.valueOf(1000.13), (Object)ScenarioBeanUtil.convertValue((String)BigDecimal.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)BigDecimal.valueOf(1000.13)), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1, (Object)ScenarioBeanUtil.convertValue((String)Integer.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1, (Object)ScenarioBeanUtil.convertValue((String)Integer.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1L, (Object)ScenarioBeanUtil.convertValue((String)Long.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1L), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1L, (Object)ScenarioBeanUtil.convertValue((String)Long.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1L), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)Float.valueOf(1.0f)), (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)Float.valueOf(1.0f)), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)Float.valueOf(1.0f)), (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)Float.valueOf(1.0f)), (ClassLoader)classLoader));
        Assert.assertEquals((Object)Character.valueOf('a'), (Object)ScenarioBeanUtil.convertValue((String)Character.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)Character.valueOf('a')), (ClassLoader)classLoader));
        Assert.assertEquals((Object)Character.valueOf('a'), (Object)ScenarioBeanUtil.convertValue((String)Character.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)Character.valueOf('a')), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1, (Object)ScenarioBeanUtil.convertValue((String)Short.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader));
        Assert.assertEquals((Object)1, (Object)ScenarioBeanUtil.convertValue((String)Short.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader));
        Assert.assertEquals((Object)"0".getBytes()[0], (Object)ScenarioBeanUtil.convertValue((String)Byte.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)"0".getBytes()[0]), (ClassLoader)classLoader));
        Assert.assertEquals((Object)"0".getBytes()[0], (Object)ScenarioBeanUtil.convertValue((String)Byte.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)"0".getBytes()[0]), (ClassLoader)classLoader));
        Assert.assertEquals((Object)LocalDate.of(2018, 10, 20), (Object)ScenarioBeanUtil.convertValue((String)LocalDate.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)LocalDate.of(2018, 10, 20)), (ClassLoader)classLoader));
        Assert.assertEquals((Object)LocalDateTime.of(2018, 10, 20, 2, 3), (Object)ScenarioBeanUtil.convertValue((String)LocalDateTime.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)LocalDateTime.of(2018, 10, 20, 2, 3)), (ClassLoader)classLoader));
        Assert.assertEquals((Object)LocalDateTime.of(2018, 10, 20, 2, 3, 1), (Object)ScenarioBeanUtil.convertValue((String)LocalDateTime.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)LocalDateTime.of(2018, 10, 20, 2, 3, 1)), (ClassLoader)classLoader));
        Assert.assertEquals((Object)LocalDateTime.of(2018, 10, 20, 2, 3, 1, 9999), (Object)ScenarioBeanUtil.convertValue((String)LocalDateTime.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)LocalDateTime.of(2018, 10, 20, 2, 3, 1, 9999)), (ClassLoader)classLoader));
        Assert.assertEquals((Object)LocalTime.of(2, 3), (Object)ScenarioBeanUtil.convertValue((String)LocalTime.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)LocalTime.of(2, 3)), (ClassLoader)classLoader));
        Assert.assertEquals((Object)LocalTime.of(2, 3, 1), (Object)ScenarioBeanUtil.convertValue((String)LocalTime.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)LocalTime.of(2, 3, 1)), (ClassLoader)classLoader));
        Assert.assertEquals((Object)LocalTime.of(2, 3, 1, 9999), (Object)ScenarioBeanUtil.convertValue((String)LocalTime.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)LocalTime.of(2, 3, 1, 9999)), (ClassLoader)classLoader));
        Assert.assertEquals((Object)((Object)EnumTest.FIRST), (Object)ScenarioBeanUtil.convertValue((String)EnumTest.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)((Object)EnumTest.FIRST)), (ClassLoader)classLoader));
        Assert.assertNull((Object)ScenarioBeanUtil.convertValue((String)String.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue(null), (ClassLoader)classLoader));
    }

    @Test
    public void convertValueFailLoadClassTest() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.convertValue((String)"my.NotExistingClass", (Object)"Test", (ClassLoader)classLoader)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Impossible to load ");
    }

    @Test
    public void convertValueFailUnsupportedTest() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.convertValue((String)RuleScenarioRunnerHelperTest.class.getCanonicalName(), (Object)"Test", (ClassLoader)classLoader)).isInstanceOf(IllegalArgumentException.class)).hasMessageEndingWith("Please use an MVEL expression to use it.");
    }

    @Test
    public void convertValueFailPrimitiveNullTest() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.convertValue((String)"int", null, (ClassLoader)classLoader)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(" is not a String or an instance of");
    }

    @Test
    public void convertValueFailNotStringOrTypeTest() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.convertValue((String)RuleScenarioRunnerHelperTest.class.getCanonicalName(), (Object)1, (ClassLoader)classLoader)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Object 1 is not a String or an instance of");
    }

    @Test
    public void convertValueFailParsing() {
        String integerCanonicalName = Integer.class.getCanonicalName();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.convertValue((String)integerCanonicalName, (Object)"wrongValue", (ClassLoader)classLoader)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Impossible to parse 'wrongValue' as " + integerCanonicalName);
    }

    @Test
    public void convertValueEnumWrongValue() {
        String enumTestCanonicalName = EnumTest.class.getCanonicalName();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.convertValue((String)EnumTest.class.getCanonicalName(), (Object)"FIRS", (ClassLoader)classLoader)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Impossible to parse 'FIRS' as " + enumTestCanonicalName);
    }

    @Test
    public void loadClassTest() {
        Assert.assertEquals(String.class, (Object)ScenarioBeanUtil.loadClass((String)String.class.getCanonicalName(), (ClassLoader)classLoader));
        Assert.assertEquals(Integer.TYPE, (Object)ScenarioBeanUtil.loadClass((String)Integer.TYPE.getCanonicalName(), (ClassLoader)classLoader));
        Assert.assertEquals(RuleScenarioRunnerHelperTest.class, (Object)ScenarioBeanUtil.loadClass((String)RuleScenarioRunnerHelperTest.class.getCanonicalName(), (ClassLoader)classLoader));
        Assert.assertEquals(EnumTest.class, (Object)ScenarioBeanUtil.loadClass((String)EnumTest.class.getCanonicalName(), (ClassLoader)classLoader));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.loadClass(null, (ClassLoader)classLoader)).isInstanceOf(ScenarioException.class)).hasMessage("Impossible to load class null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.loadClass((String)"NotExistingClass", (ClassLoader)classLoader)).isInstanceOf(ScenarioException.class)).hasMessage("Impossible to load class NotExistingClass");
    }

    @Test
    public void getFieldTest() {
        Assertions.assertThat((Object)ScenarioBeanUtil.getField(Person.class, (String)"firstName")).isNotNull();
        Assertions.assertThat((Object)ScenarioBeanUtil.getField(SubPerson.class, (String)"firstName")).isNotNull();
        Assertions.assertThat((Object)ScenarioBeanUtil.getField(SubPerson.class, (String)"additionalField")).isNotNull();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.getField(Person.class, (String)"notExistingField")).isInstanceOf(ScenarioException.class)).hasMessageStartingWith("Impossible to find field with name ");
    }
}

