/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import java.util.Arrays;
import java.util.Collections;
import org.drools.scenariosimulation.backend.util.ScenarioSimulationServerMessages;
import org.junit.Assert;
import org.junit.Test;

public class ScenarioSimulationServerMessagesTest {
    @Test
    public void getFactWithWrongValueExceptionMessage() {
        String factName = "Fact.name";
        String testResult = ScenarioSimulationServerMessages.getFactWithWrongValueExceptionMessage((String)factName, null, null);
        Assert.assertEquals((Object)"Failed in \"Fact.name\": The expected value is \"null\" but the actual one is \"null\"", (Object)testResult);
        testResult = ScenarioSimulationServerMessages.getFactWithWrongValueExceptionMessage((String)factName, (Object)1, null);
        Assert.assertEquals((Object)"Failed in \"Fact.name\": The expected value is \"1\" but the actual one is \"null\"", (Object)testResult);
        testResult = ScenarioSimulationServerMessages.getFactWithWrongValueExceptionMessage((String)factName, null, (Object)"value");
        Assert.assertEquals((Object)"Failed in \"Fact.name\": The expected value is \"null\" but the actual one is \"value\"", (Object)testResult);
    }

    @Test
    public void getGenericScenarioExceptionMessage() {
        Assert.assertEquals((Object)"Failure reason: An exception message", (Object)ScenarioSimulationServerMessages.getGenericScenarioExceptionMessage((String)"An exception message"));
    }

    @Test
    public void getCollectionFactExceptionMessage() {
        String factName = "Fact.name";
        String wrongValue = "value";
        String testResult = ScenarioSimulationServerMessages.getCollectionFactExceptionMessage((String)factName, Collections.emptyList(), (Object)wrongValue);
        Assert.assertEquals((Object)"Failed in \"Fact.name\": Impossible to find elements in the collection to satisfy the conditions.", (Object)testResult);
        testResult = ScenarioSimulationServerMessages.getCollectionFactExceptionMessage((String)factName, Arrays.asList("Item #2"), (Object)wrongValue);
        Assert.assertEquals((Object)"Failed in \"Fact.name\": Value \"value\" is wrong in \"Item #2\"", (Object)testResult);
        testResult = ScenarioSimulationServerMessages.getCollectionFactExceptionMessage((String)factName, Arrays.asList("Item #2"), null);
        Assert.assertEquals((Object)"Failed in \"Fact.name\": Wrong in \"Item #2\"", (Object)testResult);
    }

    @Test
    public void getIndexedScenarioMessage() {
        String failureMessage = "Failure message";
        String scenarioDescription = "First Case";
        String fileName = "ScesimTest";
        String testResult = ScenarioSimulationServerMessages.getIndexedScenarioMessage((String)failureMessage, (int)1, (String)scenarioDescription, (String)fileName);
        Assert.assertEquals((Object)"#1 First Case: Failure message (ScesimTest)", (Object)testResult);
        testResult = ScenarioSimulationServerMessages.getIndexedScenarioMessage((String)failureMessage, (int)1, (String)scenarioDescription, null);
        Assert.assertEquals((Object)"#1 First Case: Failure message", (Object)testResult);
        testResult = ScenarioSimulationServerMessages.getIndexedScenarioMessage((String)failureMessage, (int)1, (String)"", (String)fileName);
        Assert.assertEquals((Object)"#1: Failure message (ScesimTest)", (Object)testResult);
        testResult = ScenarioSimulationServerMessages.getIndexedScenarioMessage((String)failureMessage, (int)1, null, (String)fileName);
        Assert.assertEquals((Object)"#1: Failure message (ScesimTest)", (Object)testResult);
    }
}

