/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.fluent;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.core.command.runtime.rule.AgendaGroupSetFocusCommand;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.InsertElementsCommand;
import org.drools.core.fluent.impl.Batch;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.backend.fluent.AddCoverageListenerCommand;
import org.drools.scenariosimulation.backend.fluent.RuleStatelessScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.fluent.ValidateFactCommand;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.StatelessKieSession;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class RuleStatelessScenarioExecutableBuilderTest {
    @Mock
    private KieContainer kieContainerMock;
    @Mock
    private StatelessKieSession statelessKieSessionMock;
    @Mock
    private KieBase kieBaseMock;

    @Test
    public void testBuilder() {
        Mockito.when((Object)this.kieContainerMock.newStatelessKieSession(ArgumentMatchers.anyString())).thenReturn((Object)this.statelessKieSessionMock);
        Mockito.when((Object)this.statelessKieSessionMock.getKieBase()).thenReturn((Object)this.kieBaseMock);
        Mockito.when((Object)this.kieBaseMock.getKiePackages()).thenReturn(Collections.emptyList());
        String sessionName = "sessionName";
        RuleStatelessScenarioExecutableBuilder builder = new RuleStatelessScenarioExecutableBuilder(this.kieContainerMock, sessionName);
        Map result = builder.run();
        ((KieContainer)Mockito.verify((Object)this.kieContainerMock, (VerificationMode)Mockito.times((int)1))).newStatelessKieSession((String)ArgumentMatchers.eq((Object)sessionName));
        Assertions.assertThat((boolean)result.containsKey("COVERAGE_LISTENER")).isTrue();
        Assertions.assertThat((boolean)result.containsKey("RULES_AVAILABLE")).isTrue();
    }

    @Test
    public void generateCommands() {
        FactMappingValue emptyFMV = new FactMappingValue(FactIdentifier.EMPTY, ExpressionIdentifier.DESCRIPTION, null);
        RuleStatelessScenarioExecutableBuilder builder = new RuleStatelessScenarioExecutableBuilder(null, null);
        Command batchCommand = builder.generateCommands(null);
        Assertions.assertThat((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, AddCoverageListenerCommand.class)).isTrue();
        Assertions.assertThat((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, FireAllRulesCommand.class)).isTrue();
        Assertions.assertThat((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, AgendaGroupSetFocusCommand.class)).isFalse();
        Assertions.assertThat((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, InsertElementsCommand.class)).isFalse();
        Assertions.assertThat((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, ValidateFactCommand.class)).isFalse();
        builder.setActiveAgendaGroup("test");
        batchCommand = builder.generateCommands(null);
        Assertions.assertThat((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, AddCoverageListenerCommand.class)).isTrue();
        Assertions.assertThat((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, FireAllRulesCommand.class)).isTrue();
        Assertions.assertThat((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, AgendaGroupSetFocusCommand.class)).isTrue();
        Assertions.assertThat((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, InsertElementsCommand.class)).isFalse();
        Assertions.assertThat((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, ValidateFactCommand.class)).isFalse();
        builder.insert(new Object());
        batchCommand = builder.generateCommands(null);
        Assertions.assertThat((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, AddCoverageListenerCommand.class)).isTrue();
        Assertions.assertThat((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, FireAllRulesCommand.class)).isTrue();
        Assertions.assertThat((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, AgendaGroupSetFocusCommand.class)).isTrue();
        Assertions.assertThat((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, InsertElementsCommand.class)).isTrue();
        Assertions.assertThat((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, ValidateFactCommand.class)).isFalse();
        builder.addInternalCondition(String.class, obj -> null, new ScenarioResult(emptyFMV, null));
        batchCommand = builder.generateCommands(null);
        Assertions.assertThat((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, AddCoverageListenerCommand.class)).isTrue();
        Assertions.assertThat((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, FireAllRulesCommand.class)).isTrue();
        Assertions.assertThat((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, AgendaGroupSetFocusCommand.class)).isTrue();
        Assertions.assertThat((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, InsertElementsCommand.class)).isTrue();
        Assertions.assertThat((boolean)this.verifyCommand((Command<ExecutionResults>)batchCommand, ValidateFactCommand.class)).isTrue();
    }

    private boolean verifyCommand(Command<ExecutionResults> batchCommand, Class<?> classToFind) {
        if (!(batchCommand instanceof Batch)) {
            Assertions.fail((String)"Unexpected execution path");
        }
        List commands = ((Batch)batchCommand).getCommands();
        return commands.stream().anyMatch(classToFind::isInstance);
    }
}

