/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.backend.util.DOMParserUtil;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class DOMParserUtilTest {
    private static final String MAIN_NODE = "Main";
    private static final String MAIN_ATTRIBUTE_NAME = "mainattribute";
    private static final String ATTRIBUTE_VALUE = "default";
    private static final String TEST_NODE = "testnode";
    private static final String TEST_NODE_CONTENT = "testnodecontent";
    private static final String TEST_NODE_TOREMOVE_1 = "toremove1";
    private static final String TEST_NODE_TOREMOVE_2 = "toremove2";
    private static final String CHILD_NODE = "child";
    private static final String CHILD_ATTRIBUTE_NAME = "childattribute";
    private static final String OTHER_NODE = "othernode";
    private static final String OTHER_NODE_CONTENT_1 = "othernodecontent1";
    private static final String OTHER_NODE_CONTENT_2 = "othernodecontent2";
    private static final String NOT_EXISTING = "NOT_EXISTING";
    private static final String NESTING_NODE = "nesting";
    private static final String NESTED_NODE = "nested";
    private static final String XML = "<Main mainattribute =\"default\"><testnode>testnodecontent</testnode><child childattribute =\"default\"><testnode>toremove1</testnode><othernode>othernodecontent1</othernode><nesting><nested/></nesting></child><child childattribute =\"default\"><testnode>toremove2</testnode><othernode>othernodecontent2</othernode><nesting><nested/></nesting></child></Main>";

    @Test
    public void cleanupNodesString() throws Exception {
        String retrieved = DOMParserUtil.cleanupNodes((String)XML, (String)CHILD_NODE, (String)TEST_NODE);
        Assertions.assertThat((String)retrieved).isNotNull();
        Map childrenNodes = DOMParserUtil.getChildrenNodesMap((String)retrieved, (String)MAIN_NODE, (String)TEST_NODE);
        Assertions.assertThat((Map)childrenNodes).isNotNull();
        Assertions.assertThat((int)childrenNodes.size()).isEqualTo(1);
        Node keyNode = (Node)childrenNodes.keySet().iterator().next();
        Assertions.assertThat((String)keyNode.getNodeName()).isEqualTo(MAIN_NODE);
        List valueNodes = (List)childrenNodes.get(keyNode);
        Assertions.assertThat((valueNodes != null && valueNodes.size() == 1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((String)((Node)valueNodes.get(0)).getNodeName()).isEqualTo(TEST_NODE);
        childrenNodes = DOMParserUtil.getChildrenNodesMap((String)retrieved, (String)CHILD_NODE, (String)OTHER_NODE);
        Assertions.assertThat((int)childrenNodes.size()).isEqualTo(2);
        childrenNodes.forEach((childKeyNode, childValueNodes) -> {
            Assertions.assertThat((Object)childKeyNode).isNotNull();
            Assertions.assertThat((String)childKeyNode.getNodeName()).isEqualTo(CHILD_NODE);
            Assertions.assertThat((childValueNodes != null && childValueNodes.size() == 1 ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((String)((Node)childValueNodes.get(0)).getNodeName()).isEqualTo(OTHER_NODE);
        });
        childrenNodes = DOMParserUtil.getChildrenNodesMap((String)retrieved, (String)CHILD_NODE, (String)TEST_NODE);
        childrenNodes.forEach((childKeyNode, childValueNodes) -> {
            Assertions.assertThat((Object)childKeyNode).isNotNull();
            Assertions.assertThat((String)childKeyNode.getNodeName()).isEqualTo(CHILD_NODE);
            Assertions.assertThat((childValueNodes != null && childValueNodes.isEmpty() ? 1 : 0) != 0).isTrue();
        });
    }

    @Test
    public void cleanupNodesDocument() throws Exception {
        Document document = DOMParserUtil.getDocument((String)XML);
        DOMParserUtil.cleanupNodes((Document)document, (String)CHILD_NODE, (String)TEST_NODE);
        Assertions.assertThat((Object)document).isNotNull();
        Map childrenNodes = DOMParserUtil.getChildrenNodesMap((Document)document, (String)MAIN_NODE, (String)TEST_NODE);
        Assertions.assertThat((Map)childrenNodes).isNotNull();
        Assertions.assertThat((int)childrenNodes.size()).isEqualTo(1);
        Node keyNode = (Node)childrenNodes.keySet().iterator().next();
        Assertions.assertThat((String)keyNode.getNodeName()).isEqualTo(MAIN_NODE);
        List valueNodes = (List)childrenNodes.get(keyNode);
        Assertions.assertThat((valueNodes != null && valueNodes.size() == 1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((String)((Node)valueNodes.get(0)).getNodeName()).isEqualTo(TEST_NODE);
        childrenNodes = DOMParserUtil.getChildrenNodesMap((Document)document, (String)CHILD_NODE, (String)OTHER_NODE);
        Assertions.assertThat((int)childrenNodes.size()).isEqualTo(2);
        childrenNodes.forEach((childKeyNode, childValueNodes) -> {
            Assertions.assertThat((Object)childKeyNode).isNotNull();
            Assertions.assertThat((String)childKeyNode.getNodeName()).isEqualTo(CHILD_NODE);
            Assertions.assertThat((childValueNodes != null && childValueNodes.size() == 1 ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((String)((Node)childValueNodes.get(0)).getNodeName()).isEqualTo(OTHER_NODE);
        });
        childrenNodes = DOMParserUtil.getChildrenNodesMap((Document)document, (String)CHILD_NODE, (String)TEST_NODE);
        childrenNodes.forEach((childKeyNode, childValueNodes) -> {
            Assertions.assertThat((Object)childKeyNode).isNotNull();
            Assertions.assertThat((String)childKeyNode.getNodeName()).isEqualTo(CHILD_NODE);
            Assertions.assertThat((childValueNodes != null && childValueNodes.isEmpty() ? 1 : 0) != 0).isTrue();
        });
    }

    @Test
    public void replaceNodeText() throws Exception {
        String replacement = "replacement";
        Document document = DOMParserUtil.getDocument((String)XML);
        DOMParserUtil.replaceNodeText((Document)document, (String)MAIN_NODE, (String)TEST_NODE, (String)TEST_NODE_CONTENT, (String)"replacement");
        Map retrieved = DOMParserUtil.getChildrenNodesMap((Document)document, (String)MAIN_NODE, (String)TEST_NODE);
        Assertions.assertThat((Map)retrieved).isNotNull();
        Assertions.assertThat((int)retrieved.size()).isEqualTo(1);
        List testNodes = (List)retrieved.values().iterator().next();
        Assertions.assertThat((List)testNodes).isNotNull();
        Assertions.assertThat((int)testNodes.size()).isEqualTo(1);
        Assertions.assertThat((String)((Node)testNodes.get(0)).getTextContent()).isEqualTo("replacement");
    }

    @Test
    public void replaceNodeName() throws Exception {
        String replacement = "replacement";
        Document document = DOMParserUtil.getDocument((String)XML);
        DOMParserUtil.replaceNodeName((Document)document, (String)MAIN_NODE, (String)TEST_NODE, (String)"replacement");
        Map retrieved = DOMParserUtil.getChildrenNodesMap((Document)document, (String)MAIN_NODE, (String)"replacement");
        Assertions.assertThat((Map)retrieved).isNotNull();
        Assertions.assertThat((int)retrieved.size()).isEqualTo(1);
        List testNodes = (List)retrieved.values().iterator().next();
        Assertions.assertThat((List)testNodes).isNotNull();
        Assertions.assertThat((int)testNodes.size()).isEqualTo(1);
        Assertions.assertThat((String)((Node)testNodes.get(0)).getNodeName()).isEqualTo("replacement");
    }

    @Test
    public void getAttributeValuesByNode() throws Exception {
        Document document = DOMParserUtil.getDocument((String)XML);
        Map retrieved = DOMParserUtil.getAttributeValues((Document)document, (String)MAIN_NODE, (String)MAIN_ATTRIBUTE_NAME);
        Assertions.assertThat((Map)retrieved).isNotNull();
        Assertions.assertThat((int)retrieved.size()).isEqualTo(1);
        Assertions.assertThat((Object)retrieved.values().toArray()[0]).isEqualTo((Object)ATTRIBUTE_VALUE);
        retrieved = DOMParserUtil.getAttributeValues((Document)document, (String)MAIN_NODE, (String)NOT_EXISTING);
        Assertions.assertThat((Map)retrieved).isNotNull();
        Assertions.assertThat((boolean)retrieved.isEmpty()).isTrue();
        retrieved = DOMParserUtil.getAttributeValues((Document)document, (String)CHILD_NODE, (String)CHILD_ATTRIBUTE_NAME);
        Assertions.assertThat((Map)retrieved).isNotNull();
        Assertions.assertThat((int)retrieved.size()).isEqualTo(2);
        retrieved.values().forEach(attributeValue -> Assertions.assertThat((String)attributeValue).isEqualTo(ATTRIBUTE_VALUE));
        retrieved = DOMParserUtil.getAttributeValues((Document)document, (String)CHILD_NODE, (String)NOT_EXISTING);
        Assertions.assertThat((Map)retrieved).isNotNull();
        Assertions.assertThat((boolean)retrieved.isEmpty()).isTrue();
    }

    @Test
    public void getAllAttributeValues() throws Exception {
        Document document = DOMParserUtil.getDocument((String)XML);
        Map retrieved = DOMParserUtil.getAttributeValues((Document)document, (String)MAIN_ATTRIBUTE_NAME);
        Assertions.assertThat((Map)retrieved).isNotNull();
        Assertions.assertThat((int)retrieved.size()).isEqualTo(1);
        Assertions.assertThat((Object)retrieved.values().toArray()[0]).isEqualTo((Object)ATTRIBUTE_VALUE);
        retrieved = DOMParserUtil.getAttributeValues((Document)document, (String)CHILD_ATTRIBUTE_NAME);
        Assertions.assertThat((Map)retrieved).isNotNull();
        Assertions.assertThat((int)retrieved.size()).isEqualTo(2);
        retrieved.values().forEach(attributeValue -> Assertions.assertThat((String)attributeValue).isEqualTo(ATTRIBUTE_VALUE));
    }

    @Test
    public void setAttributeValue() throws Exception {
        String newValue = "NEW_VALUE";
        Document document = DOMParserUtil.getDocument((String)XML);
        DOMParserUtil.setAttributeValue((Document)document, (String)MAIN_NODE, (String)MAIN_ATTRIBUTE_NAME, (String)"NEW_VALUE");
        Map retrieved = DOMParserUtil.getAttributeValues((Document)document, (String)MAIN_NODE, (String)MAIN_ATTRIBUTE_NAME);
        Assertions.assertThat((String)"NEW_VALUE").isEqualTo(retrieved.values().toArray()[0]);
        DOMParserUtil.setAttributeValue((Document)document, (String)MAIN_NODE, (String)NOT_EXISTING, (String)"NEW_VALUE");
        retrieved = DOMParserUtil.getAttributeValues((Document)document, (String)MAIN_NODE, (String)NOT_EXISTING);
        Assertions.assertThat((boolean)retrieved.isEmpty()).isTrue();
        DOMParserUtil.setAttributeValue((Document)document, (String)CHILD_NODE, (String)CHILD_ATTRIBUTE_NAME, (String)"NEW_VALUE");
        retrieved = DOMParserUtil.getAttributeValues((Document)document, (String)CHILD_NODE, (String)CHILD_ATTRIBUTE_NAME);
        Assertions.assertThat((int)retrieved.size()).isEqualTo(2);
        retrieved.values().forEach(attributeValue -> Assertions.assertThat((String)attributeValue).isEqualTo("NEW_VALUE"));
    }

    @Test
    public void createNodes() throws Exception {
        String newNodeName = "NEW_NODE_NAME";
        String newNodeValue = "NEW_NODE_VALUE";
        Document document = DOMParserUtil.getDocument((String)XML);
        Map retrieved = DOMParserUtil.createNodes((Document)document, (String)MAIN_NODE, (String)"NEW_NODE_NAME", (String)"NEW_NODE_VALUE");
        Assertions.assertThat((int)retrieved.size()).isEqualTo(1);
        Node created = (Node)retrieved.values().toArray()[0];
        Assertions.assertThat((Object)created).isNotNull();
        Assertions.assertThat((String)created.getNodeName()).isEqualTo("NEW_NODE_NAME");
        Assertions.assertThat((String)created.getTextContent()).isEqualTo("NEW_NODE_VALUE");
        retrieved = DOMParserUtil.createNodes((Document)document, (String)MAIN_NODE, (String)"NEW_NODE_NAME", null);
        Assertions.assertThat((int)retrieved.size()).isEqualTo(1);
        created = (Node)retrieved.values().toArray()[0];
        Assertions.assertThat((Object)created).isNotNull();
        Assertions.assertThat((String)created.getNodeName()).isEqualTo("NEW_NODE_NAME");
        Assertions.assertThat((boolean)created.getTextContent().isEmpty()).isTrue();
        retrieved = DOMParserUtil.createNodes((Document)document, (String)CHILD_NODE, (String)"NEW_NODE_NAME", (String)"NEW_NODE_VALUE");
        Assertions.assertThat((int)retrieved.size()).isEqualTo(2);
        retrieved.forEach((key, createdNode) -> {
            Assertions.assertThat((Object)createdNode).isNotNull();
            Assertions.assertThat((String)createdNode.getNodeName()).isEqualTo("NEW_NODE_NAME");
            Assertions.assertThat((String)createdNode.getTextContent()).isEqualTo("NEW_NODE_VALUE");
        });
        retrieved = DOMParserUtil.createNodes((Document)document, (String)CHILD_NODE, (String)"NEW_NODE_NAME", null);
        Assertions.assertThat((int)retrieved.size()).isEqualTo(2);
        retrieved.forEach((key, createdNode) -> {
            Assertions.assertThat((Object)createdNode).isNotNull();
            Assertions.assertThat((String)createdNode.getNodeName()).isEqualTo("NEW_NODE_NAME");
            Assertions.assertThat((String)createdNode.getTextContent()).isEmpty();
        });
    }

    @Test
    public void createNestedNodes() throws Exception {
        String newNodeName = "NEW_NODE_NAME";
        String newNodeValue = "NEW_NODE_VALUE";
        Document document = DOMParserUtil.getDocument((String)XML);
        Map retrieved = DOMParserUtil.createNestedNodes((Document)document, (String)MAIN_NODE, (String)TEST_NODE, (String)"NEW_NODE_NAME", (String)"NEW_NODE_VALUE");
        Assertions.assertThat((int)retrieved.size()).isEqualTo(1);
        Node created = (Node)retrieved.values().toArray()[0];
        Assertions.assertThat((Object)created).isNotNull();
        Assertions.assertThat((String)created.getNodeName()).isEqualTo("NEW_NODE_NAME");
        Assertions.assertThat((String)created.getTextContent()).isEqualTo("NEW_NODE_VALUE");
        retrieved = DOMParserUtil.createNestedNodes((Document)document, (String)MAIN_NODE, (String)TEST_NODE, (String)"NEW_NODE_NAME", null);
        Assertions.assertThat((int)retrieved.size()).isEqualTo(1);
        created = (Node)retrieved.values().toArray()[0];
        Assertions.assertThat((Object)created).isNotNull();
        Assertions.assertThat((String)created.getNodeName()).isEqualTo("NEW_NODE_NAME");
        Assertions.assertThat((boolean)created.getTextContent().isEmpty()).isTrue();
        retrieved = DOMParserUtil.createNestedNodes((Document)document, (String)MAIN_NODE, (String)CHILD_NODE, (String)"NEW_NODE_NAME", (String)"NEW_NODE_VALUE");
        Assertions.assertThat((int)retrieved.size()).isEqualTo(2);
        retrieved.forEach((key, createdNode) -> {
            Assertions.assertThat((Object)createdNode).isNotNull();
            Assertions.assertThat((String)createdNode.getNodeName()).isEqualTo("NEW_NODE_NAME");
            Assertions.assertThat((String)createdNode.getTextContent()).isEqualTo("NEW_NODE_VALUE");
        });
        retrieved = DOMParserUtil.createNestedNodes((Document)document, (String)MAIN_NODE, (String)CHILD_NODE, (String)"NEW_NODE_NAME", null);
        Assertions.assertThat((int)retrieved.size()).isEqualTo(2);
        retrieved.forEach((key, createdNode) -> {
            Assertions.assertThat((Object)createdNode).isNotNull();
            Assertions.assertThat((String)createdNode.getNodeName()).isEqualTo("NEW_NODE_NAME");
            Assertions.assertThat((String)createdNode.getTextContent()).isEmpty();
        });
    }

    @Test
    public void createNodeAtPosition() throws Exception {
        String newNodeName = "NEW_NODE_NAME_0";
        String newNodeValue = "NEW_NODE_VALUE_=";
        Document document = DOMParserUtil.getDocument((String)XML);
        Map testNodesMap = DOMParserUtil.getChildrenNodesMap((Document)document, (String)MAIN_NODE, (String)TEST_NODE);
        Assertions.assertThat((int)testNodesMap.size()).isEqualTo(1);
        Node mainNode = (Node)testNodesMap.keySet().iterator().next();
        Node retrieved = DOMParserUtil.createNodeAtPosition((Node)mainNode, (String)newNodeName, (String)newNodeValue, null);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((String)retrieved.getNodeName()).isEqualTo(newNodeName);
        Assertions.assertThat((String)retrieved.getTextContent()).isEqualTo(newNodeValue);
        Assertions.assertThat((Object)mainNode.getChildNodes().item(mainNode.getChildNodes().getLength() - 1)).isEqualTo((Object)retrieved);
        newNodeName = "NEW_NODE_NAME_1";
        newNodeValue = "NEW_NODE_VALUE_1";
        retrieved = DOMParserUtil.createNodeAtPosition((Node)mainNode, (String)newNodeName, (String)newNodeValue, (Integer)0);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((String)retrieved.getNodeName()).isEqualTo(newNodeName);
        Assertions.assertThat((String)retrieved.getTextContent()).isEqualTo(newNodeValue);
        Assertions.assertThat((Object)mainNode.getChildNodes().item(0)).isEqualTo((Object)retrieved);
        newNodeName = "NEW_NODE_NAME_2";
        newNodeValue = "NEW_NODE_VALUE_2";
        retrieved = DOMParserUtil.createNodeAtPosition((Node)mainNode, (String)newNodeName, (String)newNodeValue, (Integer)2);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((String)retrieved.getNodeName()).isEqualTo(newNodeName);
        Assertions.assertThat((String)retrieved.getTextContent()).isEqualTo(newNodeValue);
        Assertions.assertThat((Object)mainNode.getChildNodes().item(2)).isEqualTo((Object)retrieved);
    }

    @Test
    public void createNodeAndAppend() throws Exception {
        String newNodeName0 = "NEW_NODE_NAME_0";
        String newNodeValue0 = "NEW_NODE_VALUE_=";
        Document document = DOMParserUtil.getDocument((String)XML);
        Map testNodesMap = DOMParserUtil.getChildrenNodesMap((Document)document, (String)MAIN_NODE, (String)TEST_NODE);
        Assertions.assertThat((int)testNodesMap.size()).isEqualTo(1);
        Node mainNode = (Node)testNodesMap.keySet().iterator().next();
        int startingChildNodes = mainNode.getChildNodes().getLength();
        Node retrieved = DOMParserUtil.createNodeAndAppend((Node)mainNode, (String)newNodeName0, (String)newNodeValue0);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((String)retrieved.getNodeName()).isEqualTo(newNodeName0);
        Assertions.assertThat((String)retrieved.getTextContent()).isEqualTo(newNodeValue0);
        Assertions.assertThat((Object)mainNode.getChildNodes().item(mainNode.getChildNodes().getLength() - 1)).isEqualTo((Object)retrieved);
        Assertions.assertThat((int)mainNode.getChildNodes().getLength()).isEqualTo(startingChildNodes + 1);
        String newNodeName1 = "NEW_NODE_NAME_1";
        String newNodeValue1 = "NEW_NODE_VALUE_1";
        retrieved = DOMParserUtil.createNodeAndAppend((Node)mainNode, (String)newNodeName1, (String)newNodeValue1);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((String)retrieved.getNodeName()).isEqualTo(newNodeName1);
        Assertions.assertThat((String)retrieved.getTextContent()).isEqualTo(newNodeValue1);
        Assertions.assertThat((Object)mainNode.getChildNodes().item(mainNode.getChildNodes().getLength() - 1)).isEqualTo((Object)retrieved);
        Assertions.assertThat((int)mainNode.getChildNodes().getLength()).isEqualTo(startingChildNodes + 2);
        String newNodeName2 = "NEW_NODE_NAME_2";
        String newNodeValue2 = "NEW_NODE_VALUE_2";
        retrieved = DOMParserUtil.createNodeAndAppend((Node)mainNode, (String)newNodeName2, (String)newNodeValue2);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((String)retrieved.getNodeName()).isEqualTo(newNodeName2);
        Assertions.assertThat((String)retrieved.getTextContent()).isEqualTo(newNodeValue2);
        Assertions.assertThat((Object)mainNode.getChildNodes().item(mainNode.getChildNodes().getLength() - 1)).isEqualTo((Object)retrieved);
        Assertions.assertThat((int)mainNode.getChildNodes().getLength()).isEqualTo(startingChildNodes + 3);
        Assertions.assertThat((String)mainNode.getChildNodes().item(startingChildNodes).getNodeName()).isEqualTo(newNodeName0);
        Assertions.assertThat((String)mainNode.getChildNodes().item(startingChildNodes).getTextContent()).isEqualTo(newNodeValue0);
        Assertions.assertThat((String)mainNode.getChildNodes().item(startingChildNodes + 1).getNodeName()).isEqualTo(newNodeName1);
        Assertions.assertThat((String)mainNode.getChildNodes().item(startingChildNodes + 1).getTextContent()).isEqualTo(newNodeValue1);
        Assertions.assertThat((String)mainNode.getChildNodes().item(startingChildNodes + 2).getNodeName()).isEqualTo(newNodeName2);
        Assertions.assertThat((String)mainNode.getChildNodes().item(startingChildNodes + 2).getTextContent()).isEqualTo(newNodeValue2);
    }

    @Test
    public void getChildrenNodesFromDocument() throws Exception {
        Document document = DOMParserUtil.getDocument((String)XML);
        Map retrieved = DOMParserUtil.getChildrenNodesMap((Document)document, (String)MAIN_NODE, (String)TEST_NODE);
        Assertions.assertThat((Map)retrieved).isNotNull();
        Assertions.assertThat((int)retrieved.size()).isEqualTo(1);
        Node keyNode = (Node)retrieved.keySet().iterator().next();
        Assertions.assertThat((Object)keyNode).isNotNull();
        Assertions.assertThat((String)keyNode.getNodeName()).isEqualTo(MAIN_NODE);
        List valueNodes = (List)retrieved.get(keyNode);
        Assertions.assertThat((valueNodes != null && valueNodes.size() == 1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((String)((Node)valueNodes.get(0)).getNodeName()).isEqualTo(TEST_NODE);
        retrieved = DOMParserUtil.getChildrenNodesMap((Document)document, (String)MAIN_NODE, (String)NOT_EXISTING);
        Assertions.assertThat((Map)retrieved).isNotNull();
        Assertions.assertThat((int)retrieved.size()).isEqualTo(1);
        Assertions.assertThat((boolean)((List)retrieved.values().iterator().next()).isEmpty()).isTrue();
        retrieved = DOMParserUtil.getChildrenNodesMap((Document)document, (String)MAIN_NODE, (String)CHILD_NODE);
        Assertions.assertThat((Map)retrieved).isNotNull();
        Assertions.assertThat((int)retrieved.size()).isEqualTo(1);
        keyNode = (Node)retrieved.keySet().iterator().next();
        Assertions.assertThat((Object)keyNode).isNotNull();
        Assertions.assertThat((String)keyNode.getNodeName()).isEqualTo(MAIN_NODE);
        valueNodes = (List)retrieved.get(keyNode);
        Assertions.assertThat((valueNodes != null && valueNodes.size() == 2 ? 1 : 0) != 0).isTrue();
        valueNodes.forEach(childNode -> Assertions.assertThat((String)childNode.getNodeName()).isEqualTo(CHILD_NODE));
        List<String> nodeToTest = Arrays.asList(TEST_NODE, OTHER_NODE);
        for (String childNodeName : nodeToTest) {
            retrieved = DOMParserUtil.getChildrenNodesMap((String)XML, (String)CHILD_NODE, (String)childNodeName);
            Assertions.assertThat((Map)retrieved).isNotNull();
            Assertions.assertThat((int)retrieved.size()).isEqualTo(2);
            retrieved.forEach((childKeyNode, childValueNodes) -> {
                Assertions.assertThat((Object)childKeyNode).isNotNull();
                Assertions.assertThat((String)childKeyNode.getNodeName()).isEqualTo(CHILD_NODE);
                Assertions.assertThat((childValueNodes != null && childValueNodes.size() == 1 ? 1 : 0) != 0).isTrue();
                Assertions.assertThat((String)((Node)childValueNodes.get(0)).getNodeName()).isEqualTo(childNodeName);
            });
        }
    }

    @Test
    public void getChildrenNodesFromNode() throws Exception {
        Document document = DOMParserUtil.getDocument((String)XML);
        Map retrieved = DOMParserUtil.getChildrenNodesMap((Document)document, (String)MAIN_NODE, (String)CHILD_NODE);
        Assertions.assertThat((Map)retrieved).isNotNull();
        Assertions.assertThat((int)retrieved.size()).isEqualTo(1);
        Node mainNode = (Node)retrieved.keySet().toArray()[0];
        Assertions.assertThat((String)mainNode.getNodeName()).isEqualTo(MAIN_NODE);
        List nodes = (List)retrieved.get(mainNode);
        nodes.forEach(childNode -> Assertions.assertThat((String)childNode.getNodeName()).isEqualTo(CHILD_NODE));
        retrieved = DOMParserUtil.getChildrenNodesMap((Node)((Node)nodes.get(0)), (String)NESTING_NODE, (String)NESTED_NODE);
        Assertions.assertThat((Map)retrieved).isNotNull();
        Assertions.assertThat((int)retrieved.size()).isEqualTo(1);
        Node childNode2 = (Node)retrieved.keySet().toArray()[0];
        Assertions.assertThat((String)childNode2.getNodeName()).isEqualTo(NESTING_NODE);
        nodes = (List)retrieved.get(childNode2);
        Assertions.assertThat((List)nodes).isNotNull();
        Assertions.assertThat((int)nodes.size()).isEqualTo(1);
        Assertions.assertThat((String)((Node)nodes.get(0)).getNodeName()).isEqualTo(NESTED_NODE);
    }

    @Test
    public void getNestedChildrenNodesMap() throws Exception {
        Document document = DOMParserUtil.getDocument((String)XML);
        Map retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)MAIN_NODE, (String)CHILD_NODE, (String)TEST_NODE);
        Assertions.assertThat((Map)retrieved).isNotNull();
        Assertions.assertThat((int)retrieved.size()).isEqualTo(2);
        retrieved.forEach((childNode, testNodes) -> {
            Assertions.assertThat((String)childNode.getNodeName()).isEqualTo(CHILD_NODE);
            Assertions.assertThat((int)testNodes.size()).isEqualTo(1);
            Assertions.assertThat((String)((Node)testNodes.get(0)).getNodeName()).isEqualTo(TEST_NODE);
        });
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)CHILD_NODE, (String)NESTING_NODE, (String)NESTED_NODE);
        Assertions.assertThat((Map)retrieved).isNotNull();
        Assertions.assertThat((int)retrieved.size()).isEqualTo(2);
        retrieved.forEach((nestingNode, nestedNodes) -> {
            Assertions.assertThat((String)nestingNode.getNodeName()).isEqualTo(NESTING_NODE);
            Assertions.assertThat((int)nestedNodes.size()).isEqualTo(1);
            Assertions.assertThat((String)((Node)nestedNodes.get(0)).getNodeName()).isEqualTo(NESTED_NODE);
        });
    }

    @Test
    public void getNestedChildrenNodesList() throws Exception {
        Document document = DOMParserUtil.getDocument((String)XML);
        List retrieved = DOMParserUtil.getNestedChildrenNodesList((Document)document, (String)MAIN_NODE, (String)CHILD_NODE, (String)TEST_NODE);
        Assertions.assertThat((List)retrieved).isNotNull();
        Assertions.assertThat((int)retrieved.size()).isEqualTo(2);
        retrieved.forEach(testNode -> Assertions.assertThat((String)testNode.getNodeName()).isEqualTo(TEST_NODE));
        retrieved = DOMParserUtil.getNestedChildrenNodesList((Document)document, (String)CHILD_NODE, (String)NESTING_NODE, (String)NESTED_NODE);
        Assertions.assertThat((List)retrieved).isNotNull();
        Assertions.assertThat((int)retrieved.size()).isEqualTo(2);
        retrieved.forEach(nestedNode -> Assertions.assertThat((String)nestedNode.getNodeName()).isEqualTo(NESTED_NODE));
    }

    @Test
    public void getDocument() throws Exception {
        Document retrieved = DOMParserUtil.getDocument((String)XML);
        Assertions.assertThat((Object)retrieved).isNotNull();
    }

    @Test(expected=SAXParseException.class)
    public void getDocument_XXE_Vulnerability() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE foo [ <!ENTITY xxe SYSTEM \"file:///\"> ]>\n<stocklevel><ProductID>&xxe;</ProductID></stocklevel>";
        Document retrieved = DOMParserUtil.getDocument((String)xml);
        Transformer transformer = DOMParserUtil.createTransformer();
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        transformer.transform(new DOMSource(retrieved), sr);
    }

    @Test
    public void getString() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document document = builder.newDocument();
        document.appendChild(document.createElement("CREATED"));
        String retrieved = DOMParserUtil.getString((Document)document);
        Assertions.assertThat((String)retrieved).isNotNull();
        Assertions.assertThat((boolean)retrieved.contains("CREATED")).isTrue();
    }

    @Test(expected=TransformerException.class)
    public void createTransformer_XXE_Vulnerability() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE foo [ <!ENTITY xxe SYSTEM \"file:///\"> ]>\n<stocklevel><ProductID>&xxe;</ProductID></stocklevel>";
        StreamSource source = new StreamSource(new ByteArrayInputStream(xml.getBytes()));
        Transformer transformer = DOMParserUtil.createTransformer();
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        transformer.transform(source, sr);
    }

    @Test
    public void asStream() throws Exception {
        Document document = DOMParserUtil.getDocument((String)XML);
        NodeList mainNodeList = document.getElementsByTagName(MAIN_NODE);
        this.commonCheckNodeStream(mainNodeList);
        NodeList childNodesList = mainNodeList.item(0).getChildNodes();
        this.commonCheckNodeStream(childNodesList);
        NodeList innerNodesList = childNodesList.item(0).getChildNodes();
        this.commonCheckNodeStream(innerNodesList);
    }

    private void commonCheckNodeStream(NodeList src) {
        Assertions.assertThat((long)DOMParserUtil.asStream((NodeList)src).count()).isEqualTo((long)src.getLength());
        AtomicInteger counter = new AtomicInteger();
        Stream nodeStream = DOMParserUtil.asStream((NodeList)src);
        nodeStream.forEach(node -> Assertions.assertThat((Object)node).isEqualTo((Object)src.item(counter.getAndIncrement())));
    }
}

