/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.backend.util.ResourceHelper;
import org.junit.Test;

public class ResourceHelperTest {
    @Test
    public void getClassPathElementsTest() {
        List<String> classPathElements = Arrays.asList(ResourceHelper.getClassPathElements());
        List notJar = classPathElements.stream().filter(elem -> !elem.contains(".jar")).collect(Collectors.toList());
        Assertions.assertThat((boolean)notJar.stream().anyMatch(elem -> elem.contains("test-classes"))).isTrue();
    }

    @Test
    public void getResourcesByExtensionTest() {
        Stream txtResources = ResourceHelper.getResourcesByExtension((String)"txt");
        List resources = txtResources.collect(Collectors.toList());
        Assertions.assertThat((int)resources.size()).isEqualTo(1);
        Assertions.assertThat((boolean)resources.stream().anyMatch(elem -> elem.endsWith("testFile.txt"))).isTrue();
    }

    @Test
    public void getResourcesFromDirectoryTest() {
        List<String> classPathElements = Arrays.asList(ResourceHelper.getClassPathElements());
        Optional<String> testFolder = classPathElements.stream().filter(elem -> elem.contains("test-classes")).findFirst();
        Assertions.assertThat((boolean)testFolder.isPresent()).isTrue();
        File dir = new File(testFolder.get());
        List filesFound = ResourceHelper.getResourcesFromDirectory((File)dir, (Pattern)Pattern.compile(".*testFile.txt")).collect(Collectors.toList());
        Assertions.assertThat((int)filesFound.size()).isEqualTo(1);
        Assertions.assertThat((long)ResourceHelper.getResourcesFromDirectory(null, null).count()).isEqualTo(0L);
        Assertions.assertThat((long)ResourceHelper.getResourcesFromDirectory((File)dir, (Pattern)Pattern.compile("noMatch")).count()).isEqualTo(0L);
    }

    @Test
    public void internalGetResourcesTest() {
        List<String> classPathElements = Arrays.asList(ResourceHelper.getClassPathElements());
        Optional<String> testFolder = classPathElements.stream().filter(elem -> elem.contains("test-classes")).findFirst();
        Assertions.assertThat((boolean)testFolder.isPresent()).isTrue();
        File dir = new File(testFolder.get());
        List filesFound = ResourceHelper.internalGetResources((String)testFolder.get(), (Pattern)Pattern.compile(".*\\.txt$")).collect(Collectors.toList());
        Assertions.assertThat((int)filesFound.size()).isEqualTo(1);
        Assertions.assertThat((long)ResourceHelper.internalGetResources((String)((String)filesFound.get(0)), (Pattern)Pattern.compile(".*\\.txt$")).count()).isEqualTo(0L);
    }
}

