/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.backend.expression.BaseExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorFactory;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorResult;
import org.drools.scenariosimulation.backend.runner.AbstractRunnerHelper;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.drools.scenariosimulation.backend.runner.model.ValueWrapper;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieContainer;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AbstractRunnerHelperTest {
    AbstractRunnerHelper abstractRunnerHelper = new AbstractRunnerHelper(){

        protected ScenarioResultMetadata extractResultMetadata(Map<String, Object> requestContext, ScenarioWithIndex scenarioWithIndex) {
            return null;
        }

        protected Map<String, Object> executeScenario(KieContainer kieContainer, ScenarioRunnerData scenarioRunnerData, ExpressionEvaluatorFactory expressionEvaluatorFactory, ScesimModelDescriptor scesimModelDescriptor, Settings settings) {
            return null;
        }

        protected void verifyConditions(ScesimModelDescriptor scesimModelDescriptor, ScenarioRunnerData scenarioRunnerData, ExpressionEvaluatorFactory expressionEvaluatorFactory, Map<String, Object> requestContext) {
        }

        protected Object createObject(ValueWrapper<Object> initialInstance, String className, Map<List<String>, Object> params, ClassLoader classLoader) {
            return null;
        }
    };

    @Test
    public void isFactMappingValueToSkip() {
        FactIdentifier factIdentifier = FactIdentifier.create((String)"MyInstance", (String)String.class.getCanonicalName());
        ExpressionIdentifier expressionIdentifier = ExpressionIdentifier.create((String)"MyProperty", (FactMappingType)FactMappingType.GIVEN);
        FactMappingValue factMappingValueWithValidValue = new FactMappingValue(factIdentifier, expressionIdentifier, (Object)"value");
        Assert.assertFalse((boolean)this.abstractRunnerHelper.isFactMappingValueToSkip(factMappingValueWithValidValue));
        FactMappingValue factMappingValueWithoutValue = new FactMappingValue(factIdentifier, expressionIdentifier, null);
        Assert.assertTrue((boolean)this.abstractRunnerHelper.isFactMappingValueToSkip(factMappingValueWithoutValue));
    }

    @Test
    public void fillResult() {
        FactIdentifier factIdentifier = FactIdentifier.create((String)"MyInstance", (String)String.class.getCanonicalName());
        ExpressionIdentifier expressionIdentifier = ExpressionIdentifier.create((String)"MyProperty", (FactMappingType)FactMappingType.GIVEN);
        FactMappingValue expectedResultSpy = (FactMappingValue)Mockito.spy((Object)new FactMappingValue(factIdentifier, expressionIdentifier, (Object)"value"));
        AtomicReference<ValueWrapper> resultWrapperAtomicReference = new AtomicReference<ValueWrapper>();
        Supplier<ValueWrapper> resultWrapperSupplier = resultWrapperAtomicReference::get;
        BaseExpressionEvaluator expressionEvaluator = new BaseExpressionEvaluator(AbstractRunnerHelper.class.getClassLoader());
        resultWrapperAtomicReference.set(ValueWrapper.of((Object)"value"));
        Assert.assertTrue((boolean)this.abstractRunnerHelper.fillResult(expectedResultSpy, resultWrapperSupplier, (ExpressionEvaluator)expressionEvaluator).getResult());
        ((FactMappingValue)Mockito.verify((Object)expectedResultSpy, (VerificationMode)Mockito.times((int)1))).resetStatus();
        Mockito.reset((Object[])new FactMappingValue[]{expectedResultSpy});
        resultWrapperAtomicReference.set(ValueWrapper.errorWithValidValue((Object)"value", (Object)"value1"));
        Assert.assertFalse((boolean)this.abstractRunnerHelper.fillResult(expectedResultSpy, resultWrapperSupplier, (ExpressionEvaluator)expressionEvaluator).getResult());
        ((FactMappingValue)Mockito.verify((Object)expectedResultSpy, (VerificationMode)Mockito.times((int)1))).setErrorValue((Object)"value");
        Mockito.reset((Object[])new FactMappingValue[]{expectedResultSpy});
        resultWrapperAtomicReference.set(ValueWrapper.errorWithValidValue((Object)"value", (Object)"value1"));
        ExpressionEvaluator expressionEvaluatorMock = (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class);
        Mockito.when((Object)expressionEvaluatorMock.fromObjectToExpression(ArgumentMatchers.any())).thenThrow(new Throwable[]{new IllegalArgumentException("Error")});
        Assert.assertFalse((boolean)this.abstractRunnerHelper.fillResult(expectedResultSpy, resultWrapperSupplier, expressionEvaluatorMock).getResult());
        ((FactMappingValue)Mockito.verify((Object)expectedResultSpy, (VerificationMode)Mockito.times((int)1))).setExceptionMessage("Error");
        Mockito.reset((Object[])new FactMappingValue[]{expectedResultSpy});
        List<String> pathToValue = Arrays.asList("field1", "fields2");
        resultWrapperAtomicReference.set(ValueWrapper.errorWithCollectionPathToValue((Object)"value", pathToValue));
        Assert.assertFalse((boolean)this.abstractRunnerHelper.fillResult(expectedResultSpy, resultWrapperSupplier, (ExpressionEvaluator)expressionEvaluator).getResult());
        ((FactMappingValue)Mockito.verify((Object)expectedResultSpy, (VerificationMode)Mockito.times((int)1))).setCollectionPathToValue(pathToValue);
        ((FactMappingValue)Mockito.verify((Object)expectedResultSpy, (VerificationMode)Mockito.times((int)1))).setErrorValue((Object)"value");
        resultWrapperAtomicReference.set(ValueWrapper.errorWithMessage((String)"detailedError"));
        Assert.assertFalse((boolean)this.abstractRunnerHelper.fillResult(expectedResultSpy, resultWrapperSupplier, (ExpressionEvaluator)expressionEvaluator).getResult());
        ((FactMappingValue)Mockito.verify((Object)expectedResultSpy, (VerificationMode)Mockito.times((int)1))).setExceptionMessage("detailedError");
    }

    @Test
    public void getResultWrapper() {
        ExpressionEvaluator expressionEvaluatorMock = (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class);
        String resultRaw = "test";
        String expectedResultRaw = "";
        String collectionWrongValue = "value";
        String collectionValuePath = "Item #: 1";
        String genericErrorMessage = "errorMessage";
        Mockito.when((Object)expressionEvaluatorMock.evaluateUnaryExpression((String)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)ExpressionEvaluatorResult.ofSuccessful());
        ValueWrapper valueWrapper = this.abstractRunnerHelper.getResultWrapper(String.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, String.class);
        Assert.assertTrue((boolean)valueWrapper.isValid());
        Assert.assertNull((Object)valueWrapper.getCollectionPathToValue());
        Mockito.when((Object)expressionEvaluatorMock.evaluateUnaryExpression((String)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)ExpressionEvaluatorResult.ofFailed());
        valueWrapper = this.abstractRunnerHelper.getResultWrapper(String.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, String.class);
        Assert.assertFalse((boolean)valueWrapper.isValid());
        Assert.assertEquals((Object)resultRaw, (Object)valueWrapper.getValue());
        Assert.assertNull((Object)valueWrapper.getCollectionPathToValue());
        valueWrapper = this.abstractRunnerHelper.getResultWrapper(List.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, List.class);
        Assert.assertFalse((boolean)valueWrapper.getErrorMessage().isPresent());
        Assert.assertTrue((boolean)valueWrapper.getCollectionPathToValue().isEmpty());
        Assert.assertNull((Object)valueWrapper.getValue());
        valueWrapper = this.abstractRunnerHelper.getResultWrapper(Map.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, Map.class);
        Assert.assertFalse((boolean)valueWrapper.getErrorMessage().isPresent());
        Assert.assertTrue((boolean)valueWrapper.getCollectionPathToValue().isEmpty());
        Assert.assertNull((Object)valueWrapper.getValue());
        ExpressionEvaluatorResult result = ExpressionEvaluatorResult.ofFailed((String)collectionWrongValue, (String)collectionValuePath);
        Mockito.when((Object)expressionEvaluatorMock.evaluateUnaryExpression((String)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)result);
        valueWrapper = this.abstractRunnerHelper.getResultWrapper(List.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, List.class);
        Assert.assertFalse((boolean)valueWrapper.getErrorMessage().isPresent());
        Assert.assertEquals((long)1L, (long)valueWrapper.getCollectionPathToValue().size());
        Assert.assertEquals((Object)collectionWrongValue, (Object)valueWrapper.getValue());
        valueWrapper = this.abstractRunnerHelper.getResultWrapper(Map.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, Map.class);
        Assert.assertFalse((boolean)valueWrapper.getErrorMessage().isPresent());
        Assert.assertEquals((long)1L, (long)valueWrapper.getCollectionPathToValue().size());
        Assert.assertEquals((Object)collectionWrongValue, (Object)valueWrapper.getValue());
        result = ExpressionEvaluatorResult.ofFailed(null, (String)collectionValuePath);
        Mockito.when((Object)expressionEvaluatorMock.evaluateUnaryExpression((String)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)result);
        valueWrapper = this.abstractRunnerHelper.getResultWrapper(List.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, List.class);
        Assert.assertFalse((boolean)valueWrapper.getErrorMessage().isPresent());
        Assert.assertEquals((long)1L, (long)valueWrapper.getCollectionPathToValue().size());
        Assert.assertNull((Object)valueWrapper.getValue());
        valueWrapper = this.abstractRunnerHelper.getResultWrapper(Map.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, Map.class);
        Assert.assertFalse((boolean)valueWrapper.getErrorMessage().isPresent());
        Assert.assertEquals((long)1L, (long)valueWrapper.getCollectionPathToValue().size());
        Assert.assertNull((Object)valueWrapper.getValue());
        Mockito.when((Object)expressionEvaluatorMock.evaluateUnaryExpression((String)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.any(Class.class))).thenThrow(new Throwable[]{new IllegalArgumentException(genericErrorMessage)});
        FactMappingValue expectedResult5 = new FactMappingValue();
        valueWrapper = this.abstractRunnerHelper.getResultWrapper(Map.class.getCanonicalName(), expectedResult5, expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, Map.class);
        Assert.assertEquals((Object)genericErrorMessage, valueWrapper.getErrorMessage().get());
        Assert.assertEquals((Object)genericErrorMessage, (Object)expectedResult5.getExceptionMessage());
    }
}

