/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.AuditLogLine;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.BackgroundData;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;
import org.drools.scenariosimulation.api.model.FactMappingValueType;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.backend.TestUtils;
import org.drools.scenariosimulation.backend.expression.BaseExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorFactory;
import org.drools.scenariosimulation.backend.fluent.AbstractRuleCoverageTest;
import org.drools.scenariosimulation.backend.fluent.CoverageAgendaListener;
import org.drools.scenariosimulation.backend.fluent.RuleScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.model.Dispute;
import org.drools.scenariosimulation.backend.model.Person;
import org.drools.scenariosimulation.backend.runner.RuleScenarioRunnerHelper;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.InstanceGiven;
import org.drools.scenariosimulation.backend.runner.model.ScenarioExpect;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.drools.scenariosimulation.backend.runner.model.ValueWrapper;
import org.drools.scenariosimulation.backend.util.ScenarioSimulationServerMessages;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.KieContainer;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class RuleScenarioRunnerHelperTest
extends AbstractRuleCoverageTest {
    @Mock
    protected RuleScenarioExecutableBuilder ruleScenarioExecutableBuilderMock;
    @Mock
    protected KieContainer kieContainerMock;
    private static final String NAME = "NAME";
    private static final String AMOUNT = "10";
    private static final String TEST_DESCRIPTION = "Test description";
    private static final ClassLoader classLoader = RuleScenarioRunnerHelperTest.class.getClassLoader();
    private static final ExpressionEvaluatorFactory expressionEvaluatorFactory = ExpressionEvaluatorFactory.create((ClassLoader)classLoader, (ScenarioSimulationModel.Type)ScenarioSimulationModel.Type.RULE);
    private static final ExpressionEvaluator expressionEvaluator = new BaseExpressionEvaluator(classLoader);
    private final RuleScenarioRunnerHelper runnerHelper = new RuleScenarioRunnerHelper(){

        protected RuleScenarioExecutableBuilder createBuilderWrapper(KieContainer kieContainer, Settings settings) {
            return RuleScenarioRunnerHelperTest.this.ruleScenarioExecutableBuilderMock;
        }
    };
    private Simulation simulation;
    private Background background;
    private Settings settings;
    private FactIdentifier personFactIdentifier;
    private ExpressionIdentifier firstNameGivenExpressionIdentifier;
    private FactMapping firstNameGivenFactMapping;
    private FactMapping backgroundFirstNameGivenFactMapping;
    private Scenario scenario1;
    private Scenario scenario2;
    private BackgroundData backgroundData1;
    private BackgroundData backgroundData2;
    private ExpressionIdentifier firstNameExpectedExpressionIdentifier;
    private FactMapping firstNameExpectedFactMapping;
    private FactIdentifier disputeFactIdentifier;
    private ExpressionIdentifier amountGivenExpressionIdentifier;
    private FactMapping amountNameGivenFactMapping;
    private FactMapping backgroundAmountNameGivenFactMapping;
    private ExpressionIdentifier amountExpectedExpressionIdentifier;
    private FactMapping amountNameExpectedFactMapping;
    private FactMappingValue amountNameExpectedFactMappingValue;
    private FactMapping disputeExpressionGivenFactMapping;
    private ExpressionIdentifier expressionGivenExpressionIdentifier;

    @Before
    public void setup() {
        Mockito.when((Object)this.kieContainerMock.getClassLoader()).thenReturn((Object)classLoader);
        this.simulation = new Simulation();
        this.background = new Background();
        this.settings = new Settings();
        this.settings.setType(ScenarioSimulationModel.Type.RULE);
        this.personFactIdentifier = FactIdentifier.create((String)"Fact 1", (String)Person.class.getCanonicalName());
        this.firstNameGivenExpressionIdentifier = ExpressionIdentifier.create((String)"First Name Given", (FactMappingType)FactMappingType.GIVEN);
        this.firstNameGivenFactMapping = this.simulation.getScesimModelDescriptor().addFactMapping(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier);
        this.firstNameGivenFactMapping.addExpressionElement("Fact 1", String.class.getCanonicalName());
        this.firstNameGivenFactMapping.addExpressionElement("firstName", String.class.getCanonicalName());
        this.disputeFactIdentifier = FactIdentifier.create((String)"Fact 2", (String)Dispute.class.getCanonicalName());
        this.amountGivenExpressionIdentifier = ExpressionIdentifier.create((String)"Amount Given", (FactMappingType)FactMappingType.GIVEN);
        this.amountNameGivenFactMapping = this.simulation.getScesimModelDescriptor().addFactMapping(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier);
        this.amountNameGivenFactMapping.addExpressionElement("Fact 2", Double.class.getCanonicalName());
        this.amountNameGivenFactMapping.addExpressionElement("amount", Double.class.getCanonicalName());
        this.firstNameExpectedExpressionIdentifier = ExpressionIdentifier.create((String)"First Name Expected", (FactMappingType)FactMappingType.EXPECT);
        this.firstNameExpectedFactMapping = this.simulation.getScesimModelDescriptor().addFactMapping(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier);
        this.firstNameExpectedFactMapping.addExpressionElement("Fact 1", String.class.getCanonicalName());
        this.firstNameExpectedFactMapping.addExpressionElement("firstName", String.class.getCanonicalName());
        this.amountExpectedExpressionIdentifier = ExpressionIdentifier.create((String)"Amount Expected", (FactMappingType)FactMappingType.EXPECT);
        this.amountNameExpectedFactMapping = this.simulation.getScesimModelDescriptor().addFactMapping(this.disputeFactIdentifier, this.amountExpectedExpressionIdentifier);
        this.amountNameExpectedFactMapping.addExpressionElement("Fact 2", Double.class.getCanonicalName());
        this.amountNameExpectedFactMapping.addExpressionElement("amount", Double.class.getCanonicalName());
        this.expressionGivenExpressionIdentifier = ExpressionIdentifier.create((String)"directMapping", (FactMappingType)FactMappingType.GIVEN);
        this.disputeExpressionGivenFactMapping = this.simulation.getScesimModelDescriptor().addFactMapping(this.disputeFactIdentifier, this.expressionGivenExpressionIdentifier);
        this.disputeExpressionGivenFactMapping.setFactMappingValueType(FactMappingValueType.EXPRESSION);
        this.disputeExpressionGivenFactMapping.addExpressionElement("Dispute", Dispute.class.getCanonicalName());
        this.scenario1 = (Scenario)this.simulation.addData();
        this.scenario1.setDescription(TEST_DESCRIPTION);
        this.scenario1.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)NAME);
        this.scenario1.addMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)NAME);
        this.scenario2 = (Scenario)this.simulation.addData();
        this.scenario2.setDescription(TEST_DESCRIPTION);
        this.scenario2.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)NAME);
        this.scenario2.addMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)NAME);
        this.scenario2.addMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)AMOUNT);
        this.amountNameExpectedFactMappingValue = this.scenario2.addMappingValue(this.disputeFactIdentifier, this.amountExpectedExpressionIdentifier, (Object)AMOUNT);
        this.backgroundFirstNameGivenFactMapping = this.background.getScesimModelDescriptor().addFactMapping(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier);
        this.backgroundFirstNameGivenFactMapping.addExpressionElement("Person", String.class.getCanonicalName());
        this.backgroundFirstNameGivenFactMapping.addExpressionElement("firstName", String.class.getCanonicalName());
        this.backgroundAmountNameGivenFactMapping = this.background.getScesimModelDescriptor().addFactMapping(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier);
        this.backgroundAmountNameGivenFactMapping.addExpressionElement("Dispute", Double.class.getCanonicalName());
        this.backgroundAmountNameGivenFactMapping.addExpressionElement("amount", Double.class.getCanonicalName());
        this.backgroundData1 = (BackgroundData)this.background.addData();
        this.backgroundData1.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)NAME);
        this.backgroundData1.addMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)AMOUNT);
        this.backgroundData2 = (BackgroundData)this.background.addData();
        this.backgroundData2.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)NAME);
    }

    @Test
    public void extractGivenValuesTest() {
        List scenario1Inputs = this.runnerHelper.extractGivenValues(this.simulation.getScesimModelDescriptor(), this.scenario1.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluatorFactory);
        Assert.assertEquals((long)1L, (long)scenario1Inputs.size());
        List scenario2Inputs = this.runnerHelper.extractGivenValues(this.simulation.getScesimModelDescriptor(), this.scenario2.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluatorFactory);
        Assert.assertEquals((long)2L, (long)scenario2Inputs.size());
        this.scenario2.addOrUpdateMappingValue(this.disputeFactIdentifier, this.expressionGivenExpressionIdentifier, (Object)"# new org.drools.scenariosimulation.backend.model.Dispute(\"dispute description\", 10)");
        scenario2Inputs = this.runnerHelper.extractGivenValues(this.simulation.getScesimModelDescriptor(), this.scenario2.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluatorFactory);
        Assert.assertEquals((long)2L, (long)scenario2Inputs.size());
        Optional<Dispute> disputeGivenOptional = scenario2Inputs.stream().filter(elem -> elem.getValue() instanceof Dispute).map(elem -> (Dispute)elem.getValue()).findFirst();
        Assert.assertTrue((boolean)disputeGivenOptional.isPresent());
        Assert.assertEquals((Object)"dispute description", (Object)disputeGivenOptional.get().getDescription());
        this.scenario2.addOrUpdateMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)"WrongValue");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runnerHelper.extractGivenValues(this.simulation.getScesimModelDescriptor(), this.scenario2.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluatorFactory)).isInstanceOf(ScenarioException.class)).hasMessage("Error in GIVEN data");
    }

    @Test
    public void extractExpectedValuesTest() {
        List scenario1Outputs = this.runnerHelper.extractExpectedValues(this.scenario1.getUnmodifiableFactMappingValues());
        Assert.assertEquals((long)1L, (long)scenario1Outputs.size());
        this.scenario2.addOrUpdateMappingValue(FactIdentifier.create((String)"TEST", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"TEST", (FactMappingType)FactMappingType.EXPECT), (Object)"TEST");
        List scenario2Outputs = this.runnerHelper.extractExpectedValues(this.scenario2.getUnmodifiableFactMappingValues());
        Assert.assertEquals((long)3L, (long)scenario2Outputs.size());
        Assert.assertEquals((long)1L, (long)scenario2Outputs.stream().filter(ScenarioExpect::isNewFact).count());
        this.scenario2.addOrUpdateMappingValue(FactIdentifier.create((String)"TEST", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"TEST", (FactMappingType)FactMappingType.GIVEN), null);
        List scenario2aOutputs = this.runnerHelper.extractExpectedValues(this.scenario2.getUnmodifiableFactMappingValues());
        Assert.assertEquals((long)3L, (long)scenario2aOutputs.size());
        Assert.assertEquals((long)1L, (long)scenario2aOutputs.stream().filter(ScenarioExpect::isNewFact).count());
    }

    @Test
    public void verifyConditionsTest() {
        List scenario1Inputs = this.runnerHelper.extractGivenValues(this.simulation.getScesimModelDescriptor(), this.scenario1.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluatorFactory);
        List scenario1Outputs = this.runnerHelper.extractExpectedValues(this.scenario1.getUnmodifiableFactMappingValues());
        ScenarioRunnerData scenarioRunnerData1 = new ScenarioRunnerData();
        scenario1Inputs.forEach(arg_0 -> ((ScenarioRunnerData)scenarioRunnerData1).addGiven(arg_0));
        scenario1Outputs.forEach(arg_0 -> ((ScenarioRunnerData)scenarioRunnerData1).addExpect(arg_0));
        this.runnerHelper.verifyConditions(this.simulation.getScesimModelDescriptor(), scenarioRunnerData1, expressionEvaluatorFactory, null);
        Assert.assertEquals((long)1L, (long)scenarioRunnerData1.getResults().size());
        List scenario2Inputs = this.runnerHelper.extractGivenValues(this.simulation.getScesimModelDescriptor(), this.scenario2.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluatorFactory);
        List scenario2Outputs = this.runnerHelper.extractExpectedValues(this.scenario2.getUnmodifiableFactMappingValues());
        ScenarioRunnerData scenarioRunnerData2 = new ScenarioRunnerData();
        scenario2Inputs.forEach(arg_0 -> ((ScenarioRunnerData)scenarioRunnerData2).addGiven(arg_0));
        scenario2Outputs.forEach(arg_0 -> ((ScenarioRunnerData)scenarioRunnerData2).addExpect(arg_0));
        this.runnerHelper.verifyConditions(this.simulation.getScesimModelDescriptor(), scenarioRunnerData2, expressionEvaluatorFactory, null);
        Assert.assertEquals((long)2L, (long)scenarioRunnerData2.getResults().size());
    }

    @Test
    public void getScenarioResultsTest() {
        List scenario1Inputs = this.runnerHelper.extractGivenValues(this.simulation.getScesimModelDescriptor(), this.scenario1.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluatorFactory);
        List scenario1Outputs = this.runnerHelper.extractExpectedValues(this.scenario1.getUnmodifiableFactMappingValues());
        Assert.assertTrue((scenario1Inputs.size() > 0 ? 1 : 0) != 0);
        InstanceGiven input1 = (InstanceGiven)scenario1Inputs.get(0);
        scenario1Outputs = scenario1Outputs.stream().filter(elem -> elem.getFactIdentifier().equals((Object)input1.getFactIdentifier())).collect(Collectors.toList());
        List scenario1Results = this.runnerHelper.getScenarioResultsFromGivenFacts(this.simulation.getScesimModelDescriptor(), scenario1Outputs, input1, expressionEvaluatorFactory);
        Assert.assertEquals((long)1L, (long)scenario1Results.size());
        Assert.assertEquals((Object)FactMappingValueStatus.SUCCESS, (Object)((FactMappingValue)((ScenarioExpect)scenario1Outputs.get(0)).getExpectedResult().get(0)).getStatus());
        List scenario2Inputs = this.runnerHelper.extractGivenValues(this.simulation.getScesimModelDescriptor(), this.scenario2.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluatorFactory);
        List scenario2Outputs = this.runnerHelper.extractExpectedValues(this.scenario2.getUnmodifiableFactMappingValues());
        Assert.assertTrue((scenario2Inputs.size() > 0 ? 1 : 0) != 0);
        InstanceGiven input2 = (InstanceGiven)scenario2Inputs.get(0);
        scenario2Outputs = scenario2Outputs.stream().filter(elem -> elem.getFactIdentifier().equals((Object)input2.getFactIdentifier())).collect(Collectors.toList());
        List scenario2Results = this.runnerHelper.getScenarioResultsFromGivenFacts(this.simulation.getScesimModelDescriptor(), scenario2Outputs, input2, expressionEvaluatorFactory);
        Assert.assertEquals((long)1L, (long)scenario2Results.size());
        Assert.assertEquals((Object)FactMappingValueStatus.SUCCESS, (Object)((FactMappingValue)((ScenarioExpect)scenario1Outputs.get(0)).getExpectedResult().get(0)).getStatus());
        List<ScenarioExpect> newFact = Collections.singletonList(new ScenarioExpect(this.personFactIdentifier, Collections.emptyList(), true));
        List scenario2NoResults = this.runnerHelper.getScenarioResultsFromGivenFacts(this.simulation.getScesimModelDescriptor(), newFact, input2, expressionEvaluatorFactory);
        Assert.assertEquals((long)0L, (long)scenario2NoResults.size());
        Person person = new Person();
        person.setFirstName("ANOTHER STRING");
        InstanceGiven newInput = new InstanceGiven(this.personFactIdentifier, (Object)person);
        List scenario3Results = this.runnerHelper.getScenarioResultsFromGivenFacts(this.simulation.getScesimModelDescriptor(), scenario1Outputs, newInput, expressionEvaluatorFactory);
        Assert.assertEquals((Object)FactMappingValueStatus.FAILED_WITH_ERROR, (Object)((FactMappingValue)((ScenarioExpect)scenario1Outputs.get(0)).getExpectedResult().get(0)).getStatus());
        Assert.assertEquals((long)1L, (long)scenario3Results.size());
        Assert.assertEquals((Object)person.getFirstName(), ((ScenarioResult)scenario3Results.get(0)).getResultValue().get());
        Assert.assertEquals((Object)NAME, (Object)((ScenarioResult)scenario3Results.get(0)).getFactMappingValue().getRawValue());
    }

    @Test
    public void validateAssertionTest() {
        ArrayList<ScenarioResult> scenarioFailResult = new ArrayList<ScenarioResult>();
        scenarioFailResult.add(new ScenarioResult(this.amountNameExpectedFactMappingValue, (Object)"SOMETHING_ELSE"));
        try {
            this.runnerHelper.validateAssertion(scenarioFailResult, this.simulation.getScesimModelDescriptor());
            Assert.fail();
        }
        catch (IllegalStateException exception) {
            Assert.assertEquals((Object)"Illegal FactMappingValue status", (Object)exception.getMessage());
        }
        this.amountNameExpectedFactMappingValue.resetStatus();
        this.amountNameExpectedFactMappingValue.setErrorValue((Object)"Error");
        scenarioFailResult.add(new ScenarioResult(this.amountNameExpectedFactMappingValue, (Object)"SOMETHING_ELSE"));
        try {
            this.runnerHelper.validateAssertion(scenarioFailResult, this.simulation.getScesimModelDescriptor());
            Assert.fail();
        }
        catch (ScenarioException exception) {
            Assert.assertTrue((boolean)exception.isFailedAssertion());
            Assert.assertEquals((Object)ScenarioSimulationServerMessages.getFactWithWrongValueExceptionMessage((String)"Fact 2.amount", (Object)this.amountNameExpectedFactMappingValue.getRawValue(), (Object)this.amountNameExpectedFactMappingValue.getErrorValue()), (Object)exception.getMessage());
        }
        String exceptionMessage = "Message";
        this.amountNameExpectedFactMappingValue.resetStatus();
        this.amountNameExpectedFactMappingValue.setExceptionMessage(exceptionMessage);
        scenarioFailResult.add(new ScenarioResult(this.amountNameExpectedFactMappingValue, (Object)"SOMETHING_ELSE"));
        try {
            this.runnerHelper.validateAssertion(scenarioFailResult, this.simulation.getScesimModelDescriptor());
            Assert.fail();
        }
        catch (ScenarioException exception) {
            Assert.assertFalse((boolean)exception.isFailedAssertion());
            Assert.assertEquals((Object)ScenarioSimulationServerMessages.getGenericScenarioExceptionMessage((String)exceptionMessage), (Object)exception.getMessage());
        }
        List<String> pathToValue = Arrays.asList("Item #2");
        this.amountNameExpectedFactMappingValue.resetStatus();
        this.amountNameExpectedFactMappingValue.setCollectionPathToValue(pathToValue);
        scenarioFailResult.add(new ScenarioResult(this.amountNameExpectedFactMappingValue, (Object)"SOMETHING_ELSE"));
        try {
            this.runnerHelper.validateAssertion(scenarioFailResult, this.simulation.getScesimModelDescriptor());
            Assert.fail();
        }
        catch (ScenarioException exception) {
            Assert.assertTrue((boolean)exception.isFailedAssertion());
            Assert.assertEquals((Object)ScenarioSimulationServerMessages.getCollectionFactExceptionMessage((String)"Fact 2.amount", pathToValue, (Object)this.amountNameExpectedFactMappingValue.getErrorValue()), (Object)exception.getMessage());
        }
        ArrayList<ScenarioResult> scenarioSuccessResult = new ArrayList<ScenarioResult>();
        scenarioSuccessResult.add(new ScenarioResult(this.amountNameExpectedFactMappingValue, this.amountNameExpectedFactMappingValue.getRawValue()).setResult(true));
        this.runnerHelper.validateAssertion(scenarioSuccessResult, this.simulation.getScesimModelDescriptor());
    }

    @Test
    public void groupByFactIdentifierAndFilterTest() {
        Map scenario1Given = this.runnerHelper.groupByFactIdentifierAndFilter(this.scenario1.getUnmodifiableFactMappingValues(), FactMappingType.GIVEN);
        Map scenario1Expected = this.runnerHelper.groupByFactIdentifierAndFilter(this.scenario1.getUnmodifiableFactMappingValues(), FactMappingType.EXPECT);
        Map scenario2Given = this.runnerHelper.groupByFactIdentifierAndFilter(this.scenario2.getUnmodifiableFactMappingValues(), FactMappingType.GIVEN);
        Map scenario2Expected = this.runnerHelper.groupByFactIdentifierAndFilter(this.scenario2.getUnmodifiableFactMappingValues(), FactMappingType.EXPECT);
        Assert.assertEquals((long)1L, (long)scenario1Given.keySet().size());
        Assert.assertEquals((long)1L, (long)scenario1Expected.keySet().size());
        Assert.assertEquals((long)2L, (long)scenario2Given.keySet().size());
        Assert.assertEquals((long)2L, (long)scenario2Expected.keySet().size());
        Assert.assertEquals((long)1L, (long)((List)scenario1Given.get(this.personFactIdentifier)).size());
        Assert.assertEquals((long)1L, (long)((List)scenario1Expected.get(this.personFactIdentifier)).size());
        Assert.assertEquals((long)1L, (long)((List)scenario2Given.get(this.disputeFactIdentifier)).size());
        Assert.assertEquals((long)1L, (long)((List)scenario2Expected.get(this.disputeFactIdentifier)).size());
        Scenario scenario = new Scenario();
        scenario.addMappingValue(FactIdentifier.EMPTY, ExpressionIdentifier.DESCRIPTION, null);
        Assert.assertEquals((long)0L, (long)this.runnerHelper.groupByFactIdentifierAndFilter(scenario.getUnmodifiableFactMappingValues(), FactMappingType.GIVEN).size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void groupByFactIdentifierAndFilterFailTest() {
        ArrayList<FactMappingValue> fail = new ArrayList<FactMappingValue>();
        FactMappingValue factMappingValue = new FactMappingValue();
        factMappingValue.setRawValue((Object)"TEST");
        fail.add(factMappingValue);
        this.runnerHelper.groupByFactIdentifierAndFilter(fail, FactMappingType.GIVEN);
    }

    @Test
    public void createExtractorFunctionTest() {
        String personName = "Test";
        FactMappingValue factMappingValue = new FactMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)personName);
        Function extractorFunction = this.runnerHelper.createExtractorFunction(expressionEvaluator, factMappingValue, this.simulation.getScesimModelDescriptor());
        Person person = new Person();
        person.setFirstName(personName);
        Assert.assertTrue((boolean)((ValueWrapper)extractorFunction.apply(person)).isValid());
        person.setFirstName("OtherString");
        Assert.assertFalse((boolean)((ValueWrapper)extractorFunction.apply(person)).isValid());
        Function extractorFunction1 = this.runnerHelper.createExtractorFunction(expressionEvaluator, new FactMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, null), this.simulation.getScesimModelDescriptor());
        ValueWrapper nullValue = (ValueWrapper)extractorFunction1.apply(new Person());
        Assert.assertTrue((boolean)nullValue.isValid());
        Assert.assertNull((Object)nullValue.getValue());
    }

    @Test
    public void getParamsForBeanTest() {
        ArrayList<FactMappingValue> factMappingValues = new ArrayList<FactMappingValue>();
        FactMappingValue factMappingValue1 = (FactMappingValue)Mockito.spy((Object)new FactMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)"NOT PARSABLE"));
        FactMappingValue factMappingValue2 = (FactMappingValue)Mockito.spy((Object)new FactMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)"NOT PARSABLE"));
        FactMappingValue factMappingValue3 = (FactMappingValue)Mockito.spy((Object)new FactMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)"1"));
        factMappingValues.add(factMappingValue1);
        factMappingValues.add(factMappingValue2);
        factMappingValues.add(factMappingValue3);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runnerHelper.getParamsForBean(this.simulation.getScesimModelDescriptor(), this.disputeFactIdentifier, factMappingValues, expressionEvaluatorFactory)).isInstanceOf(ScenarioException.class)).hasMessage("Error in one or more input values");
        factMappingValues.forEach(fmv -> ((FactMappingValue)Mockito.verify((Object)fmv, (VerificationMode)Mockito.times((int)2))).getRawValue());
        Assert.assertEquals((Object)FactMappingValueStatus.FAILED_WITH_EXCEPTION, (Object)factMappingValue1.getStatus());
        Assert.assertEquals((Object)FactMappingValueStatus.FAILED_WITH_EXCEPTION, (Object)factMappingValue2.getStatus());
        Assert.assertEquals((Object)FactMappingValueStatus.SUCCESS, (Object)factMappingValue3.getStatus());
    }

    @Test
    public void directMappingTest() {
        HashMap paramsToSet = new HashMap();
        paramsToSet.put(Collections.emptyList(), "Test");
        Assert.assertEquals((Object)"Test", (Object)this.runnerHelper.getDirectMapping(paramsToSet).getValue());
        paramsToSet.clear();
        paramsToSet.put(Collections.emptyList(), 1);
        Assert.assertEquals((Object)1, (Object)this.runnerHelper.getDirectMapping(paramsToSet).getValue());
        paramsToSet.clear();
        paramsToSet.put(Collections.emptyList(), null);
        Assert.assertNull((Object)this.runnerHelper.getDirectMapping(paramsToSet).getValue());
        paramsToSet.clear();
        ValueWrapper directMapping = this.runnerHelper.getDirectMapping(paramsToSet);
        Assert.assertFalse((boolean)directMapping.isValid());
        Assert.assertEquals((Object)"No direct mapping available", directMapping.getErrorMessage().get());
    }

    @Test
    public void createObject() {
        HashMap<List<String>, Object> params = new HashMap<List<String>, Object>();
        params.put(Collections.singletonList("firstName"), "TestName");
        params.put(Collections.singletonList("age"), 10);
        ValueWrapper initialInstance = this.runnerHelper.getDirectMapping(params);
        Object objectRaw = this.runnerHelper.createObject(initialInstance, Person.class.getCanonicalName(), params, this.getClass().getClassLoader());
        Assert.assertTrue((boolean)(objectRaw instanceof Person));
        Person object = (Person)objectRaw;
        Assert.assertEquals((long)10L, (long)object.getAge());
        Assert.assertEquals((Object)"TestName", (Object)object.getFirstName());
    }

    @Test
    public void createObjectDirectMappingSimpleType() {
        HashMap params = new HashMap();
        String directMappingSimpleTypeValue = "TestName";
        params.put(Collections.emptyList(), directMappingSimpleTypeValue);
        ValueWrapper initialInstance = this.runnerHelper.getDirectMapping(params);
        Object objectRaw = this.runnerHelper.createObject(initialInstance, String.class.getCanonicalName(), params, this.getClass().getClassLoader());
        Assert.assertTrue((boolean)(objectRaw instanceof String));
        Assert.assertEquals((Object)directMappingSimpleTypeValue, (Object)objectRaw);
    }

    @Test
    public void createObjectDirectMappingSimpleTypeNull() {
        HashMap params = new HashMap();
        params.put(Collections.emptyList(), null);
        ValueWrapper initialInstance = this.runnerHelper.getDirectMapping(params);
        Object objectRaw = this.runnerHelper.createObject(initialInstance, String.class.getCanonicalName(), params, this.getClass().getClassLoader());
        Assert.assertNull((Object)objectRaw);
    }

    @Test
    public void createObjectDirectMappingComplexType() {
        HashMap<List<Object>, Object> params = new HashMap<List<Object>, Object>();
        Person directMappingComplexTypeValue = new Person();
        directMappingComplexTypeValue.setFirstName("TestName");
        params.put(Collections.emptyList(), directMappingComplexTypeValue);
        params.put(Collections.singletonList("age"), 10);
        ValueWrapper initialInstance = this.runnerHelper.getDirectMapping(params);
        Object objectRaw = this.runnerHelper.createObject(initialInstance, Map.class.getCanonicalName(), params, this.getClass().getClassLoader());
        Assert.assertTrue((boolean)(objectRaw instanceof Person));
        Person object = (Person)objectRaw;
        Assert.assertEquals((long)10L, (long)object.getAge());
        Assert.assertEquals((Object)"TestName", (Object)object.getFirstName());
    }

    @Test
    public void extractResultMetadata() {
        LinkedHashMap<String, Integer> coverageData = new LinkedHashMap<String, Integer>();
        coverageData.put("rule1", 2);
        coverageData.put("rule2", 2);
        CoverageAgendaListener coverageAgendaListenerMock = this.createCoverageAgendaListenerWithData(coverageData);
        ScenarioWithIndex scenarioWithIndexMock = (ScenarioWithIndex)Mockito.mock(ScenarioWithIndex.class);
        Scenario scenarioMock = (Scenario)Mockito.mock(Scenario.class);
        Mockito.when((Object)scenarioMock.getDescription()).thenReturn((Object)"DESCRIPTION");
        Mockito.when((Object)((Scenario)scenarioWithIndexMock.getScesimData())).thenReturn((Object)scenarioMock);
        LinkedHashMap<String, Object> requestContext = new LinkedHashMap<String, Object>();
        requestContext.put("COVERAGE_LISTENER", coverageAgendaListenerMock);
        requestContext.put("RULES_AVAILABLE", coverageData.keySet());
        ScenarioResultMetadata scenarioResultMetadata = this.runnerHelper.extractResultMetadata(requestContext, scenarioWithIndexMock);
        Assert.assertEquals((Object)scenarioWithIndexMock, (Object)scenarioResultMetadata.getScenarioWithIndex());
        Assert.assertEquals((long)2L, (long)scenarioResultMetadata.getAvailable().size());
        Assert.assertEquals((long)2L, (long)scenarioResultMetadata.getExecuted().size());
        Assert.assertEquals((Object)2, scenarioResultMetadata.getExecutedWithCounter().get("rule1"));
        Assert.assertEquals((Object)2, scenarioResultMetadata.getExecutedWithCounter().get("rule2"));
        ArrayList<String> expectedMessages = new ArrayList<String>();
        this.commonAddMessageString(Arrays.asList("rule1", "rule2"), expectedMessages);
        List auditLogLines = scenarioResultMetadata.getAuditLogLines();
        Assert.assertEquals((long)expectedMessages.size(), (long)auditLogLines.size());
        for (int i = 0; i < expectedMessages.size(); ++i) {
            TestUtils.commonCheckAuditLogLine((AuditLogLine)auditLogLines.get(i), (String)expectedMessages.get(i), "EXECUTED", null);
        }
    }

    @Test
    public void extractBackgroundValues() {
        Background emptyBackground = new Background();
        List emptyBackgroundGivens = this.runnerHelper.extractBackgroundValues(emptyBackground, classLoader, expressionEvaluatorFactory);
        Assert.assertEquals((long)0L, (long)emptyBackgroundGivens.size());
        emptyBackground.addData();
        emptyBackgroundGivens = this.runnerHelper.extractBackgroundValues(emptyBackground, classLoader, expressionEvaluatorFactory);
        Assert.assertEquals((long)0L, (long)emptyBackgroundGivens.size());
        List backgroundGivens = this.runnerHelper.extractBackgroundValues(this.background, classLoader, expressionEvaluatorFactory);
        Assert.assertEquals((long)3L, (long)backgroundGivens.size());
        for (InstanceGiven backgroundGiven : backgroundGivens) {
            if (backgroundGiven.getFactIdentifier().equals((Object)this.personFactIdentifier)) {
                Assert.assertEquals((Object)this.personFactIdentifier, (Object)backgroundGiven.getFactIdentifier());
                Person person = (Person)backgroundGiven.getValue();
                Assert.assertEquals((Object)NAME, (Object)person.getFirstName());
                continue;
            }
            if (backgroundGiven.getFactIdentifier().equals((Object)this.disputeFactIdentifier)) {
                Assert.assertEquals((Object)this.disputeFactIdentifier, (Object)backgroundGiven.getFactIdentifier());
                Dispute dispute = (Dispute)backgroundGiven.getValue();
                double parsedAmount = Double.parseDouble(AMOUNT);
                Assert.assertEquals((double)parsedAmount, (double)dispute.getAmount(), (double)0.1);
                continue;
            }
            Assert.fail();
        }
        String notValid = "notValid";
        FactMappingValue notValid1 = this.backgroundData1.addOrUpdateMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)notValid);
        FactMappingValue notValid2 = this.backgroundData2.addOrUpdateMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)notValid);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runnerHelper.extractBackgroundValues(this.background, classLoader, expressionEvaluatorFactory)).isInstanceOf(ScenarioException.class)).hasMessage("Error in BACKGROUND data");
        Assert.assertEquals((Object)FactMappingValueStatus.FAILED_WITH_EXCEPTION, (Object)notValid1.getStatus());
        Assert.assertTrue((boolean)notValid1.getExceptionMessage().startsWith("Impossible to parse"));
        Assert.assertEquals((Object)FactMappingValueStatus.FAILED_WITH_EXCEPTION, (Object)notValid2.getStatus());
        Assert.assertTrue((boolean)notValid2.getExceptionMessage().startsWith("Impossible to parse"));
    }

    @Test
    public void executeScenario() {
        ArgumentCaptor insertCaptor = ArgumentCaptor.forClass(Object.class);
        ScenarioRunnerData scenarioRunnerData = new ScenarioRunnerData();
        scenarioRunnerData.addBackground(new InstanceGiven(this.personFactIdentifier, (Object)new Person()));
        scenarioRunnerData.addBackground(new InstanceGiven(this.disputeFactIdentifier, (Object)new Dispute()));
        scenarioRunnerData.addGiven(new InstanceGiven(this.personFactIdentifier, (Object)new Person()));
        FactMappingValue factMappingValue = new FactMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)NAME);
        scenarioRunnerData.addExpect(new ScenarioExpect(this.personFactIdentifier, Collections.singletonList(factMappingValue), false));
        scenarioRunnerData.addExpect(new ScenarioExpect(this.personFactIdentifier, Collections.singletonList(factMappingValue), true));
        int inputObjects = scenarioRunnerData.getBackgrounds().size() + scenarioRunnerData.getGivens().size();
        String ruleFlowGroup = "ruleFlowGroup";
        this.settings.setRuleFlowGroup(ruleFlowGroup);
        this.runnerHelper.executeScenario(this.kieContainerMock, scenarioRunnerData, expressionEvaluatorFactory, this.simulation.getScesimModelDescriptor(), this.settings);
        ((RuleScenarioExecutableBuilder)Mockito.verify((Object)this.ruleScenarioExecutableBuilderMock, (VerificationMode)Mockito.times((int)1))).setActiveRuleFlowGroup(ruleFlowGroup);
        ((RuleScenarioExecutableBuilder)Mockito.verify((Object)this.ruleScenarioExecutableBuilderMock, (VerificationMode)Mockito.times((int)inputObjects))).insert(insertCaptor.capture());
        for (Object value : insertCaptor.getAllValues()) {
            Assert.assertTrue((value instanceof Person || value instanceof Dispute ? 1 : 0) != 0);
        }
        ((RuleScenarioExecutableBuilder)Mockito.verify((Object)this.ruleScenarioExecutableBuilderMock, (VerificationMode)Mockito.times((int)1))).addInternalCondition((Class)ArgumentMatchers.eq(Person.class), (Function)ArgumentMatchers.any(), (ScenarioResult)ArgumentMatchers.any());
        ((RuleScenarioExecutableBuilder)Mockito.verify((Object)this.ruleScenarioExecutableBuilderMock, (VerificationMode)Mockito.times((int)1))).run();
        Assert.assertEquals((long)1L, (long)scenarioRunnerData.getResults().size());
        this.settings.setType(ScenarioSimulationModel.Type.DMN);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runnerHelper.executeScenario(this.kieContainerMock, scenarioRunnerData, expressionEvaluatorFactory, this.simulation.getScesimModelDescriptor(), this.settings)).isInstanceOf(ScenarioException.class)).hasMessageStartingWith("Impossible to run");
    }

    private void commonAddMessageString(List<String> ruleNames, List<String> expectedMessages) {
        ruleNames.forEach(ruleName -> IntStream.range(1, 3).forEach(index -> expectedMessages.add((String)ruleName)));
    }
}

