/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.backend.expression.AbstractExpressionEvaluator;
import org.junit.Test;

public class AbstractExpressionEvaluatorTest {
    private static final JsonNodeFactory factory = JsonNodeFactory.instance;
    private static final AbstractExpressionEvaluator expressionEvaluatorLocal = new AbstractExpressionEvaluator(){

        public String fromObjectToExpression(Object value) {
            throw new UnsupportedOperationException();
        }

        protected Object extractFieldValue(Object result, String fieldName) {
            return result;
        }

        protected boolean internalUnaryEvaluation(String rawExpression, Object resultValue, Class<?> resultClass, boolean skipEmptyString) {
            return true;
        }

        protected Object internalLiteralEvaluation(String raw, String className) {
            return raw;
        }

        protected Object createObject(String className, List<String> genericClasses) {
            return new HashMap();
        }

        protected void setField(Object toReturn, String fieldName, Object fieldValue) {
            ((Map)toReturn).put(fieldName, fieldValue);
        }

        protected Map.Entry<String, List<String>> getFieldClassNameAndGenerics(Object element, String fieldName, String className, List<String> genericClasses) {
            return new AbstractMap.SimpleEntry<String, List<String>>("", Collections.singletonList(""));
        }
    };

    @Test
    public void evaluateLiteralExpression() {
        Assertions.assertThat((Object)expressionEvaluatorLocal.evaluateLiteralExpression(null, String.class.getCanonicalName(), null)).isNull();
        Assertions.assertThat((Object)expressionEvaluatorLocal.evaluateLiteralExpression(null, List.class.getCanonicalName(), null)).isNull();
        Assertions.assertThat((Object)expressionEvaluatorLocal.evaluateLiteralExpression(null, Map.class.getCanonicalName(), null)).isNull();
    }

    @Test
    public void evaluateUnaryExpression() {
        Assertions.assertThat((boolean)expressionEvaluatorLocal.evaluateUnaryExpression(null, null, String.class).isSuccessful()).isTrue();
        Assertions.assertThat((boolean)expressionEvaluatorLocal.evaluateUnaryExpression(null, null, Map.class).isSuccessful()).isTrue();
        Assertions.assertThat((boolean)expressionEvaluatorLocal.evaluateUnaryExpression(null, null, List.class).isSuccessful()).isTrue();
    }

    @Test
    public void convertList() {
        ArrayNode jsonNodes = new ArrayNode(factory);
        ObjectNode objectNode = new ObjectNode(factory);
        objectNode.put("value", "data");
        jsonNodes.add((JsonNode)objectNode);
        List objects = expressionEvaluatorLocal.createAndFillList(jsonNodes, new ArrayList(), List.class.getCanonicalName(), Collections.singletonList(String.class.getCanonicalName()));
        Assertions.assertThat(objects.get(0)).isEqualTo((Object)"data");
    }

    @Test
    public void convertObject() {
        ObjectNode objectNode = new ObjectNode(factory);
        ObjectNode simpleValue = new ObjectNode(factory);
        ObjectNode simpleValue2 = new ObjectNode(factory);
        simpleValue.put("value", "Polissena");
        simpleValue2.put("value", "Antonia");
        objectNode.put("key1", (JsonNode)simpleValue);
        objectNode.put("key2", (JsonNode)simpleValue2);
        Object result = expressionEvaluatorLocal.createAndFillObject(objectNode, new HashMap(), Map.class.getCanonicalName(), Collections.singletonList(String.class.getCanonicalName()));
        Assertions.assertThat((boolean)(result instanceof Map)).isTrue();
        Map resultMap = (Map)result;
        Assertions.assertThat((int)resultMap.size()).isEqualTo(2);
        Assertions.assertThat(resultMap.get("key1")).isEqualTo((Object)"Polissena");
        Assertions.assertThat(resultMap.get("key2")).isEqualTo((Object)"Antonia");
        objectNode.removeAll();
        objectNode.put("age", "1");
        objectNode.put("name", "FS");
        result = expressionEvaluatorLocal.createAndFillObject(objectNode, new HashMap(), Map.class.getCanonicalName(), Collections.singletonList(String.class.getCanonicalName()));
        Assertions.assertThat((boolean)(result instanceof Map)).isTrue();
        resultMap = (Map)result;
        Assertions.assertThat(resultMap.get("age")).isEqualTo((Object)"1");
        Assertions.assertThat(resultMap.get("name")).isEqualTo((Object)"FS");
        Assertions.assertThat((int)resultMap.size()).isEqualTo(2);
        objectNode.removeAll();
        ObjectNode nestedObject = new ObjectNode(factory);
        objectNode.set("nested", (JsonNode)nestedObject);
        nestedObject.put("field", "fieldValue");
        result = expressionEvaluatorLocal.createAndFillObject(objectNode, new HashMap(), String.class.getCanonicalName(), Collections.emptyList());
        Assertions.assertThat((boolean)(result instanceof Map)).isTrue();
        resultMap = (Map)result;
        Assertions.assertThat((int)resultMap.size()).isEqualTo(1);
        Map nested = (Map)resultMap.get("nested");
        Assertions.assertThat((int)nested.size()).isEqualTo(1);
        Assertions.assertThat(nested.get("field")).isEqualTo((Object)"fieldValue");
        objectNode.removeAll();
        ArrayNode jsonNodes = new ArrayNode(factory);
        objectNode.set("listField", (JsonNode)jsonNodes);
        jsonNodes.add((JsonNode)nestedObject);
        result = expressionEvaluatorLocal.createAndFillObject(objectNode, new HashMap(), String.class.getCanonicalName(), Collections.emptyList());
        Assertions.assertThat((boolean)(result instanceof Map)).isTrue();
        resultMap = (Map)result;
        Assertions.assertThat((int)resultMap.size()).isEqualTo(1);
        List nestedList = (List)resultMap.get("listField");
        Assertions.assertThat((int)nestedList.size()).isEqualTo(1);
        Assertions.assertThat(((Map)nestedList.get(0)).get("field")).isEqualTo((Object)"fieldValue");
    }

    @Test
    public void isSimpleTypeNode() {
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isSimpleTypeNode((JsonNode)new ArrayNode(factory))).isFalse();
        ObjectNode jsonNode = new ObjectNode(factory);
        jsonNode.set("value", (JsonNode)new TextNode("test"));
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isSimpleTypeNode((JsonNode)jsonNode)).isTrue();
        jsonNode.set("otherField", (JsonNode)new TextNode("testValue"));
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isSimpleTypeNode((JsonNode)jsonNode)).isFalse();
    }

    @Test
    public void getSimpleTypeNodeTextValue() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> expressionEvaluatorLocal.getSimpleTypeNodeTextValue((JsonNode)new ArrayNode(factory))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter does not contains a simple type");
        ObjectNode jsonNode = new ObjectNode(factory);
        jsonNode.set("value", (JsonNode)new TextNode("testValue"));
        Assertions.assertThat((String)expressionEvaluatorLocal.getSimpleTypeNodeTextValue((JsonNode)jsonNode)).isEqualTo("testValue");
        jsonNode.set("value", (JsonNode)new IntNode(10));
        Assertions.assertThat((String)expressionEvaluatorLocal.getSimpleTypeNodeTextValue((JsonNode)jsonNode)).isNull();
    }

    @Test
    public void isNodeEmpty() {
        ObjectNode objectNode = new ObjectNode(factory);
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isNodeEmpty((JsonNode)objectNode)).isTrue();
        objectNode.set("empty array", (JsonNode)new ArrayNode(factory));
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isNodeEmpty((JsonNode)objectNode)).isTrue();
        objectNode.set("key", (JsonNode)new TextNode("value"));
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isNodeEmpty((JsonNode)objectNode)).isFalse();
        ArrayNode arrayNode = new ArrayNode(factory);
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isNodeEmpty((JsonNode)arrayNode)).isTrue();
        arrayNode.add((JsonNode)new TextNode("value"));
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isNodeEmpty((JsonNode)arrayNode)).isFalse();
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isNodeEmpty((JsonNode)new TextNode(""))).isTrue();
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isNodeEmpty((JsonNode)new TextNode(null))).isTrue();
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isNodeEmpty((JsonNode)new TextNode("value"))).isFalse();
    }

    @Test
    public void isListEmpty() {
        ArrayNode json = new ArrayNode(factory);
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isListEmpty(json)).isTrue();
        ObjectNode nestedNode = new ObjectNode(factory);
        json.add((JsonNode)nestedNode);
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isListEmpty(json)).isTrue();
        nestedNode.set("emptyField", (JsonNode)new TextNode(""));
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isListEmpty(json)).isTrue();
        nestedNode.set("notEmptyField", (JsonNode)new TextNode("text"));
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isListEmpty(json)).isFalse();
    }

    @Test
    public void isObjectEmpty() {
        ObjectNode json = new ObjectNode(factory);
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isObjectEmpty(json)).isTrue();
        ObjectNode nestedNode = new ObjectNode(factory);
        json.set("emptyField", (JsonNode)nestedNode);
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isObjectEmpty(json)).isTrue();
        nestedNode.set("notEmptyField", (JsonNode)new TextNode("text"));
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isObjectEmpty(json)).isFalse();
    }

    @Test
    public void isEmptyText() {
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isEmptyText((JsonNode)new TextNode(""))).isTrue();
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isEmptyText((JsonNode)new TextNode("value"))).isFalse();
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isEmptyText((JsonNode)new ObjectNode(factory))).isTrue();
    }

    @Test
    public void isStructuredInput() {
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isStructuredInput(List.class.getCanonicalName())).isTrue();
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isStructuredInput(ArrayList.class.getCanonicalName())).isTrue();
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isStructuredInput(LinkedList.class.getCanonicalName())).isTrue();
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isStructuredInput(Map.class.getCanonicalName())).isTrue();
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isStructuredInput(HashMap.class.getCanonicalName())).isTrue();
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isStructuredInput(LinkedHashMap.class.getCanonicalName())).isTrue();
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isStructuredInput(Set.class.getCanonicalName())).isFalse();
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isStructuredInput(Integer.class.getCanonicalName())).isFalse();
        Assertions.assertThat((boolean)expressionEvaluatorLocal.isStructuredInput(String.class.getCanonicalName())).isFalse();
    }
}

