/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.fluent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.drools.core.definitions.rule.impl.QueryImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.scenariosimulation.backend.fluent.RuleScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.fluent.RuleStatefulScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.fluent.RuleStatelessScenarioExecutableBuilder;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.mockito.Mockito;

public class RuleScenarioExecutableBuilderTest {
    @Test
    public void createBuilder() {
        RuleScenarioExecutableBuilder builder = RuleScenarioExecutableBuilder.createBuilder(null, null, (boolean)true);
        Assertions.assertThat((boolean)(builder instanceof RuleStatelessScenarioExecutableBuilder)).isTrue();
        builder = RuleScenarioExecutableBuilder.createBuilder(null, null, (boolean)false);
        Assertions.assertThat((boolean)(builder instanceof RuleStatefulScenarioExecutableBuilder)).isTrue();
        builder = RuleScenarioExecutableBuilder.createBuilder(null);
        Assertions.assertThat((boolean)(builder instanceof RuleStatefulScenarioExecutableBuilder)).isTrue();
    }

    @Test
    public void getAvailableRules() {
        HashMap<String, List<String>> packagesToRules = new HashMap<String, List<String>>();
        packagesToRules.put("package1", Arrays.asList("rule1", "rule2", "rule3"));
        packagesToRules.put("package2", Arrays.asList("rule4", "rule5", "rule6"));
        HashMap<String, List<String>> queryToRules = new HashMap<String, List<String>>();
        queryToRules.put("package1", Arrays.asList("query1", "query2"));
        queryToRules.put("package2", Collections.emptyList());
        HashMap<String, String> ruleToAgendaGroup = new HashMap<String, String>();
        ruleToAgendaGroup.put("rule1", "agenda1");
        ruleToAgendaGroup.put("rule2", "agenda1");
        ruleToAgendaGroup.put("rule3", "agenda1");
        ruleToAgendaGroup.put("rule4", "agenda2");
        RuleScenarioExecutableBuilder builder = RuleScenarioExecutableBuilder.createBuilder(null, null, (boolean)false);
        Set agenda1 = builder.getAvailableRules(this.createKieBaseMock(packagesToRules, ruleToAgendaGroup, queryToRules), "agenda1");
        Assertions.assertThat((int)agenda1.size()).isEqualTo(5);
        Set agenda2 = builder.getAvailableRules(this.createKieBaseMock(packagesToRules, ruleToAgendaGroup, queryToRules), "agenda2");
        Assertions.assertThat((int)agenda2.size()).isEqualTo(3);
        Set noAgenda = builder.getAvailableRules(this.createKieBaseMock(packagesToRules, ruleToAgendaGroup, queryToRules), null);
        Assertions.assertThat((int)noAgenda.size()).isEqualTo(2);
    }

    private KieBase createKieBaseMock(Map<String, List<String>> packagesToRules, Map<String, String> ruleToAgendaGroup, Map<String, List<String>> packagesToQueries) {
        KieBase kieBaseMock = (KieBase)Mockito.mock(KieBase.class);
        ArrayList<KiePackage> kiePackagesMock = new ArrayList<KiePackage>();
        Mockito.when((Object)kieBaseMock.getKiePackages()).thenReturn(kiePackagesMock);
        for (Map.Entry<String, List<String>> packageToRule : packagesToRules.entrySet()) {
            kiePackagesMock.add(this.createKiePackageMock(packageToRule.getKey(), packageToRule.getValue(), ruleToAgendaGroup, packagesToQueries.get(packageToRule.getKey())));
        }
        return kieBaseMock;
    }

    private KiePackage createKiePackageMock(String packageName, List<String> ruleNames, Map<String, String> ruleToAgendaGroup, List<String> queries) {
        KiePackage kiePackageMock = (KiePackage)Mockito.mock(KiePackage.class);
        Mockito.when((Object)kiePackageMock.getName()).thenReturn((Object)packageName);
        ArrayList<Object> ruleListMock = new ArrayList<Object>();
        Mockito.when((Object)kiePackageMock.getRules()).thenReturn(ruleListMock);
        for (String ruleName : ruleNames) {
            ruleListMock.add(this.createRuleMock(ruleName, ruleToAgendaGroup.get(ruleName)));
        }
        for (String queryName : queries) {
            ruleListMock.add(this.createQueryImplMock(queryName));
        }
        return kiePackageMock;
    }

    private RuleImpl createRuleMock(String fullName, String agendaGroup) {
        RuleImpl ruleMock = (RuleImpl)Mockito.mock(RuleImpl.class);
        Mockito.when((Object)ruleMock.getName()).thenReturn((Object)fullName);
        Mockito.when((Object)ruleMock.getPackageName()).thenReturn((Object)"");
        Mockito.when((Object)ruleMock.isMainAgendaGroup()).thenReturn((Object)(agendaGroup == null ? 1 : 0));
        Mockito.when((Object)ruleMock.getAgendaGroup()).thenReturn((Object)agendaGroup);
        Mockito.when((Object)ruleMock.getKnowledgeType()).thenCallRealMethod();
        return ruleMock;
    }

    private QueryImpl createQueryImplMock(String fullName) {
        QueryImpl queryImplMock = (QueryImpl)Mockito.mock(QueryImpl.class);
        Mockito.when((Object)queryImplMock.getName()).thenReturn((Object)fullName);
        Mockito.when((Object)queryImplMock.getPackageName()).thenReturn((Object)"");
        Mockito.when((Object)queryImplMock.getKnowledgeType()).thenCallRealMethod();
        return queryImplMock;
    }
}

