/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.backend.util.ScenarioSimulationServerMessages;
import org.junit.Test;

public class ScenarioSimulationServerMessagesTest {
    @Test
    public void getFactWithWrongValueExceptionMessage() {
        String factName = "Fact.name";
        String testResult = ScenarioSimulationServerMessages.getFactWithWrongValueExceptionMessage((String)factName, null, null);
        Assertions.assertThat((String)testResult).isEqualTo("Failed in \"Fact.name\": The expected value is \"null\" but the actual one is \"null\"");
        testResult = ScenarioSimulationServerMessages.getFactWithWrongValueExceptionMessage((String)factName, (Object)1, null);
        Assertions.assertThat((String)testResult).isEqualTo("Failed in \"Fact.name\": The expected value is \"1\" but the actual one is \"null\"");
        testResult = ScenarioSimulationServerMessages.getFactWithWrongValueExceptionMessage((String)factName, null, (Object)"value");
        Assertions.assertThat((String)testResult).isEqualTo("Failed in \"Fact.name\": The expected value is \"null\" but the actual one is \"value\"");
    }

    @Test
    public void getGenericScenarioExceptionMessage() {
        Assertions.assertThat((String)ScenarioSimulationServerMessages.getGenericScenarioExceptionMessage((String)"An exception message")).isEqualTo("Failure reason: An exception message");
    }

    @Test
    public void getCollectionFactExceptionMessage() {
        String factName = "Fact.name";
        String wrongValue = "value";
        String testResult = ScenarioSimulationServerMessages.getCollectionFactExceptionMessage((String)factName, Collections.emptyList(), (Object)wrongValue);
        Assertions.assertThat((String)testResult).isEqualTo("Failed in \"Fact.name\": Impossible to find elements in the collection to satisfy the conditions.");
        testResult = ScenarioSimulationServerMessages.getCollectionFactExceptionMessage((String)factName, Arrays.asList("Item #2"), (Object)wrongValue);
        Assertions.assertThat((String)testResult).isEqualTo("Failed in \"Fact.name\": Value \"value\" is wrong in \"Item #2\"");
        testResult = ScenarioSimulationServerMessages.getCollectionFactExceptionMessage((String)factName, Arrays.asList("Item #2"), null);
        Assertions.assertThat((String)testResult).isEqualTo("Failed in \"Fact.name\": Wrong in \"Item #2\"");
    }

    @Test
    public void getIndexedScenarioMessage() {
        String failureMessage = "Failure message";
        String scenarioDescription = "First Case";
        String fileName = "ScesimTest";
        String testResult = ScenarioSimulationServerMessages.getIndexedScenarioMessage((String)failureMessage, (int)1, (String)scenarioDescription, (String)fileName);
        Assertions.assertThat((String)testResult).isEqualTo("#1 First Case: Failure message (ScesimTest)");
        testResult = ScenarioSimulationServerMessages.getIndexedScenarioMessage((String)failureMessage, (int)1, (String)scenarioDescription, null);
        Assertions.assertThat((String)testResult).isEqualTo("#1 First Case: Failure message");
        testResult = ScenarioSimulationServerMessages.getIndexedScenarioMessage((String)failureMessage, (int)1, (String)"", (String)fileName);
        Assertions.assertThat((String)testResult).isEqualTo("#1: Failure message (ScesimTest)");
        testResult = ScenarioSimulationServerMessages.getIndexedScenarioMessage((String)failureMessage, (int)1, null, (String)fileName);
        Assertions.assertThat((String)testResult).isEqualTo("#1: Failure message (ScesimTest)");
    }
}

