/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.AuditLogLine;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.backend.TestUtils;
import org.drools.scenariosimulation.backend.expression.DMNFeelExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorFactory;
import org.drools.scenariosimulation.backend.fluent.DMNScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.runner.DMNScenarioRunnerHelper;
import org.drools.scenariosimulation.backend.runner.RuleScenarioRunnerHelperTest;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.InstanceGiven;
import org.drools.scenariosimulation.backend.runner.model.ScenarioExpect;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.drools.scenariosimulation.backend.runner.model.ValueWrapper;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.RequestContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.core.impl.DMNMessageImpl;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNScenarioRunnerHelperTest {
    private static final String NAME = "NAME";
    private static final String FEEL_EXPRESSION_NAME = "\"NAME\"";
    private static final BigDecimal AMOUNT = BigDecimal.valueOf(10L);
    private static final String DMN_FILE_PATH = "dmnFilePath";
    private static final String TEST_DESCRIPTION = "Test description";
    private static final ClassLoader classLoader = RuleScenarioRunnerHelperTest.class.getClassLoader();
    private static final ExpressionEvaluatorFactory expressionEvaluatorFactory = ExpressionEvaluatorFactory.create((ClassLoader)classLoader, (ScenarioSimulationModel.Type)ScenarioSimulationModel.Type.DMN);
    private static final ExpressionEvaluator expressionEvaluator = new DMNFeelExpressionEvaluator(classLoader);
    private final DMNScenarioRunnerHelper runnerHelper = new DMNScenarioRunnerHelper(){

        protected DMNScenarioExecutableBuilder createBuilderWrapper(KieContainer kieContainer) {
            return DMNScenarioRunnerHelperTest.this.dmnScenarioExecutableBuilderMock;
        }
    };
    @Mock
    protected Map<String, Object> requestContextMock;
    @Mock
    protected DMNResult dmnResultMock;
    @Mock
    protected DMNDecisionResult dmnDecisionResultMock;
    @Mock
    protected DMNModel dmnModelMock;
    @Mock
    protected DMNScenarioExecutableBuilder dmnScenarioExecutableBuilderMock;
    @Mock
    protected KieContainer kieContainerMock;
    @Captor
    private ArgumentCaptor<Object> valueCaptor;
    @Captor
    private ArgumentCaptor<String> keyCaptor;
    private Simulation simulation;
    private Settings settings;
    private FactIdentifier personFactIdentifier;
    private ExpressionIdentifier firstNameGivenExpressionIdentifier;
    private FactMapping firstNameGivenFactMapping;
    private Scenario scenario1;
    private Scenario scenario2;
    private ExpressionIdentifier firstNameExpectedExpressionIdentifier;
    private FactMapping firstNameExpectedFactMapping;
    private FactIdentifier disputeFactIdentifier;
    private ExpressionIdentifier amountGivenExpressionIdentifier;
    private FactMapping amountNameGivenFactMapping;
    private ExpressionIdentifier amountExpectedExpressionIdentifier;
    private FactMapping amountNameExpectedFactMapping;
    private FactMappingValue amountNameExpectedFactMappingValue;
    private FactMappingValue firstNameExpectedValue;

    @Before
    public void init() {
        Mockito.when((Object)this.dmnScenarioExecutableBuilderMock.run()).thenReturn((Object)((RequestContext)Mockito.mock(RequestContext.class)));
        this.simulation = new Simulation();
        this.settings = new Settings();
        this.settings.setType(ScenarioSimulationModel.Type.DMN);
        this.settings.setDmnFilePath(DMN_FILE_PATH);
        this.personFactIdentifier = FactIdentifier.create((String)"Fact 1", (String)"Fact 1");
        this.firstNameGivenExpressionIdentifier = ExpressionIdentifier.create((String)"First Name Given", (FactMappingType)FactMappingType.GIVEN);
        this.firstNameGivenFactMapping = this.simulation.getScesimModelDescriptor().addFactMapping(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier);
        this.firstNameGivenFactMapping.addExpressionElement("Fact 1", String.class.getCanonicalName());
        this.firstNameGivenFactMapping.addExpressionElement("firstName", String.class.getCanonicalName());
        this.disputeFactIdentifier = FactIdentifier.create((String)"Fact 2", (String)"Fact 2");
        this.amountGivenExpressionIdentifier = ExpressionIdentifier.create((String)"Amount Given", (FactMappingType)FactMappingType.GIVEN);
        this.amountNameGivenFactMapping = this.simulation.getScesimModelDescriptor().addFactMapping(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier);
        this.amountNameGivenFactMapping.addExpressionElement("Fact 2", BigDecimal.class.getCanonicalName());
        this.amountNameGivenFactMapping.addExpressionElement("amount", BigDecimal.class.getCanonicalName());
        this.firstNameExpectedExpressionIdentifier = ExpressionIdentifier.create((String)"First Name Expected", (FactMappingType)FactMappingType.EXPECT);
        this.firstNameExpectedFactMapping = this.simulation.getScesimModelDescriptor().addFactMapping(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier);
        this.firstNameExpectedFactMapping.addExpressionElement("Fact 1", String.class.getCanonicalName());
        this.firstNameExpectedFactMapping.addExpressionElement("firstName", String.class.getCanonicalName());
        this.amountExpectedExpressionIdentifier = ExpressionIdentifier.create((String)"Amount Expected", (FactMappingType)FactMappingType.EXPECT);
        this.amountNameExpectedFactMapping = this.simulation.getScesimModelDescriptor().addFactMapping(this.disputeFactIdentifier, this.amountExpectedExpressionIdentifier);
        this.amountNameExpectedFactMapping.addExpressionElement("Fact 2", Double.class.getCanonicalName());
        this.amountNameExpectedFactMapping.addExpressionElement("amount", Double.class.getCanonicalName());
        this.scenario1 = (Scenario)this.simulation.addData();
        this.scenario1.setDescription(TEST_DESCRIPTION);
        this.scenario1.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)FEEL_EXPRESSION_NAME);
        this.firstNameExpectedValue = this.scenario1.addMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)FEEL_EXPRESSION_NAME);
        this.scenario2 = (Scenario)this.simulation.addData();
        this.scenario2.setDescription(TEST_DESCRIPTION);
        this.scenario2.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)FEEL_EXPRESSION_NAME);
        this.scenario2.addMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)FEEL_EXPRESSION_NAME);
        this.scenario2.addMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)AMOUNT);
        this.amountNameExpectedFactMappingValue = this.scenario2.addMappingValue(this.disputeFactIdentifier, this.amountExpectedExpressionIdentifier, (Object)AMOUNT);
        Mockito.when((Object)this.requestContextMock.get("dmnResult")).thenReturn((Object)this.dmnResultMock);
        Mockito.when((Object)this.requestContextMock.get("dmnModel")).thenReturn((Object)this.dmnModelMock);
    }

    @Test
    public void verifyConditions() {
        ScenarioRunnerData scenarioRunnerData1 = new ScenarioRunnerData();
        scenarioRunnerData1.addExpect(new ScenarioExpect(this.personFactIdentifier, Collections.singletonList(this.firstNameExpectedValue)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runnerHelper.verifyConditions(this.simulation.getScesimModelDescriptor(), scenarioRunnerData1, expressionEvaluatorFactory, this.requestContextMock)).isInstanceOf(ScenarioException.class)).hasMessage("DMN execution has not generated a decision result with name Fact 1");
        Mockito.when((Object)this.dmnResultMock.getDecisionResultByName(ArgumentMatchers.anyString())).thenReturn((Object)this.dmnDecisionResultMock);
        Mockito.when((Object)this.dmnDecisionResultMock.getEvaluationStatus()).thenReturn((Object)DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
        this.runnerHelper.verifyConditions(this.simulation.getScesimModelDescriptor(), scenarioRunnerData1, expressionEvaluatorFactory, this.requestContextMock);
        Assertions.assertThat((int)scenarioRunnerData1.getResults().size()).isEqualTo(1);
        Assertions.assertThat((boolean)((ScenarioResult)scenarioRunnerData1.getResults().get(0)).getResult()).isFalse();
        Mockito.when((Object)this.dmnDecisionResultMock.getResult()).thenReturn((Object)"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runnerHelper.verifyConditions(this.simulation.getScesimModelDescriptor(), scenarioRunnerData1, expressionEvaluatorFactory, this.requestContextMock)).isInstanceOf(ScenarioException.class)).hasMessage("Wrong resultRaw structure because it is not a complex type as expected");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("firstName", "WrongValue");
        Mockito.when((Object)this.dmnDecisionResultMock.getResult()).thenReturn(resultMap);
        ScenarioRunnerData scenarioRunnerData2 = new ScenarioRunnerData();
        scenarioRunnerData2.addExpect(new ScenarioExpect(this.personFactIdentifier, Collections.singletonList(this.firstNameExpectedValue)));
        this.runnerHelper.verifyConditions(this.simulation.getScesimModelDescriptor(), scenarioRunnerData2, expressionEvaluatorFactory, this.requestContextMock);
        Assertions.assertThat((int)scenarioRunnerData2.getResults().size()).isEqualTo(1);
        Assertions.assertThat((boolean)((ScenarioResult)scenarioRunnerData2.getResults().get(0)).getResult()).isFalse();
        ScenarioRunnerData scenarioRunnerData3 = new ScenarioRunnerData();
        scenarioRunnerData3.addExpect(new ScenarioExpect(this.personFactIdentifier, Collections.singletonList(this.firstNameExpectedValue)));
        resultMap.put("firstName", NAME);
        this.runnerHelper.verifyConditions(this.simulation.getScesimModelDescriptor(), scenarioRunnerData3, expressionEvaluatorFactory, this.requestContextMock);
        Assertions.assertThat((int)scenarioRunnerData3.getResults().size()).isEqualTo(1);
        Assertions.assertThat((boolean)((ScenarioResult)scenarioRunnerData3.getResults().get(0)).getResult()).isTrue();
        ExpressionEvaluatorFactory expressionEvaluatorFactoryMock = (ExpressionEvaluatorFactory)Mockito.mock(ExpressionEvaluatorFactory.class);
        Mockito.when((Object)expressionEvaluatorFactoryMock.getOrCreate((FactMappingValue)ArgumentMatchers.any())).thenReturn((Object)((ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class)));
        this.runnerHelper.verifyConditions(this.simulation.getScesimModelDescriptor(), scenarioRunnerData3, expressionEvaluatorFactoryMock, this.requestContextMock);
        Assertions.assertThat((Comparable)((ScenarioResult)scenarioRunnerData3.getResults().get(0)).getFactMappingValue().getStatus()).isNotEqualTo((Object)FactMappingValueStatus.SUCCESS);
    }

    @Test
    public void createObject() {
        HashMap<List<String>, Object> params = new HashMap<List<String>, Object>();
        params.put(Arrays.asList("creator", "name"), "TestName");
        params.put(Arrays.asList("creator", "surname"), "TestSurname");
        params.put(Collections.singletonList("age"), BigDecimal.valueOf(10L));
        ValueWrapper initialInstance = this.runnerHelper.getDirectMapping(params);
        Object objectRaw = this.runnerHelper.createObject(initialInstance, String.class.getCanonicalName(), params, this.getClass().getClassLoader());
        Assertions.assertThat((boolean)(objectRaw instanceof Map)).isTrue();
        Map object = (Map)objectRaw;
        Assertions.assertThat(object.get("age")).isEqualTo((Object)BigDecimal.valueOf(10L));
        Assertions.assertThat((boolean)(object.get("creator") instanceof Map)).isTrue();
        Map creator = (Map)object.get("creator");
        Assertions.assertThat(creator.get("name")).isEqualTo((Object)"TestName");
        Assertions.assertThat(creator.get("surname")).isEqualTo((Object)"TestSurname");
    }

    @Test
    public void createObjectDirectMappingSimpleType() {
        HashMap params = new HashMap();
        String directMappingSimpleTypeValue = "TestName";
        params.put(Collections.emptyList(), directMappingSimpleTypeValue);
        ValueWrapper initialInstance = this.runnerHelper.getDirectMapping(params);
        Object objectRaw = this.runnerHelper.createObject(initialInstance, String.class.getCanonicalName(), params, this.getClass().getClassLoader());
        Assertions.assertThat((boolean)(objectRaw instanceof String)).isTrue();
        Assertions.assertThat((Object)objectRaw).isEqualTo((Object)directMappingSimpleTypeValue);
    }

    @Test
    public void createObjectDirectMappingSimpleTypeNull() {
        HashMap params = new HashMap();
        params.put(Collections.emptyList(), null);
        ValueWrapper initialInstance = this.runnerHelper.getDirectMapping(params);
        Object objectRaw = this.runnerHelper.createObject(initialInstance, String.class.getCanonicalName(), params, this.getClass().getClassLoader());
        Assertions.assertThat((Object)objectRaw).isNull();
    }

    @Test
    public void createObjectDirectMappingComplexType() {
        HashMap<List<Object>, Object> params = new HashMap<List<Object>, Object>();
        HashMap<String, String> directMappingComplexTypeValue = new HashMap<String, String>();
        directMappingComplexTypeValue.put("key1", "value1");
        params.put(Collections.emptyList(), directMappingComplexTypeValue);
        params.put(Collections.singletonList("key2"), "value2");
        ValueWrapper initialInstance = this.runnerHelper.getDirectMapping(params);
        Object objectRaw = this.runnerHelper.createObject(initialInstance, Map.class.getCanonicalName(), params, this.getClass().getClassLoader());
        Assertions.assertThat((boolean)(objectRaw instanceof Map)).isTrue();
        Map object = (Map)objectRaw;
        Assertions.assertThat(object.get("key1")).isEqualTo((Object)"value1");
        Assertions.assertThat(object.get("key2")).isEqualTo((Object)"value2");
    }

    @Test
    public void extractResultMetadataNoDecisionResultMessages() {
        this.commonExtractResultMetadata(null);
    }

    @Test
    public void extractResultMetadataDecisionResultMessages() {
        List<DMNMessage> messages = TestUtils.getRandomlyGeneratedDMNMessageList();
        this.commonExtractResultMetadata(messages);
    }

    @Test
    public void getSingleFactValueResultFailDecision() {
        DMNDecisionResult failedDecision = this.createDecisionResultMock("Test", false, new ArrayList<DMNMessage>());
        ValueWrapper failedResult = this.runnerHelper.getSingleFactValueResult(null, null, failedDecision, null, expressionEvaluator);
        Assertions.assertThat((boolean)failedResult.isValid()).isFalse();
        Assertions.assertThat((String)((String)failedResult.getErrorMessage().get())).isEqualTo("The decision \"" + failedDecision.getDecisionName() + "\" has not been successfully evaluated: " + failedDecision.getEvaluationStatus());
    }

    @Test
    public void getSingleFactValueResultFailDecisionWithMessages() {
        DMNMessageImpl errorMessage = new DMNMessageImpl(DMNMessage.Severity.ERROR, "DMN Internal Error", DMNMessageType.FEEL_EVALUATION_ERROR, null);
        DMNMessageImpl warnMessage = new DMNMessageImpl(DMNMessage.Severity.WARN, "DMN Internal Warn", DMNMessageType.FEEL_EVALUATION_ERROR, null);
        DMNDecisionResult failedDecision = this.createDecisionResultMock("Test", false, new ArrayList<DMNMessage>());
        ValueWrapper failedResult = this.runnerHelper.getSingleFactValueResult(null, null, failedDecision, Arrays.asList(warnMessage, errorMessage), expressionEvaluator);
        Assertions.assertThat((boolean)failedResult.isValid()).isFalse();
        Assertions.assertThat((String)((String)failedResult.getErrorMessage().get())).isEqualTo("The decision \"" + failedDecision.getDecisionName() + "\" has not been successfully evaluated: DMN Internal Error");
    }

    @Test
    public void executeScenario() {
        FactIdentifier bookFactIdentifier = FactIdentifier.create((String)"Book", (String)"Book");
        FactIdentifier importedPersonFactIdentifier = FactIdentifier.create((String)"imported.Person", (String)"imported.Person", (String)"imported");
        FactIdentifier importedDisputeFactIdentifier = FactIdentifier.create((String)"imported.Dispute", (String)"imported.Dispute", (String)"imported");
        FactIdentifier importedBookFactIdentifier = FactIdentifier.create((String)"imported.Book", (String)"imported.Book", (String)"imported");
        FactIdentifier importedWrBookFactIdentifier = FactIdentifier.create((String)"imported.wr.Book", (String)"imported.wr.Book", (String)"imported");
        AbstractMap.SimpleEntry<String, String> backgroundDisputeFactData = new AbstractMap.SimpleEntry<String, String>("description", "Nice");
        AbstractMap.SimpleEntry<String, String> backgroundPersonFactData = new AbstractMap.SimpleEntry<String, String>("name", "Carl");
        AbstractMap.SimpleEntry<String, Integer> backgroundPersonFactData2 = new AbstractMap.SimpleEntry<String, Integer>("age", 2);
        AbstractMap.SimpleEntry<String, String> backgroundImportedDisputeFactData = new AbstractMap.SimpleEntry<String, String>("description", "Bad");
        AbstractMap.SimpleEntry<String, String> backgroundImportedPersonFactData = new AbstractMap.SimpleEntry<String, String>("name", "Max");
        AbstractMap.SimpleEntry<String, Integer> backgroundImportedPersonFactData2 = new AbstractMap.SimpleEntry<String, Integer>("age", 34);
        AbstractMap.SimpleEntry<String, String> givenPersonFactData = new AbstractMap.SimpleEntry<String, String>("surname", "Brown");
        AbstractMap.SimpleEntry<String, Integer> givenPersonFactData2 = new AbstractMap.SimpleEntry<String, Integer>("age", 23);
        AbstractMap.SimpleEntry<String, String> givenBookFactData = new AbstractMap.SimpleEntry<String, String>("Author", "Resey Rema");
        AbstractMap.SimpleEntry<String, String> givenBookFactData2 = new AbstractMap.SimpleEntry<String, String>("Name", "The mighty Test Scenario!");
        AbstractMap.SimpleEntry<String, String> givenImportedBookFactData = new AbstractMap.SimpleEntry<String, String>("Author", "Mr Y");
        AbstractMap.SimpleEntry<String, String> givenImportedBookFactData2 = new AbstractMap.SimpleEntry<String, String>("Title", "The awesome Test Scenario!");
        AbstractMap.SimpleEntry<String, String> givenImportedPersonFactData = new AbstractMap.SimpleEntry<String, String>("surname", "White");
        AbstractMap.SimpleEntry<String, Integer> givenImportedPersonFactData2 = new AbstractMap.SimpleEntry<String, Integer>("age", 67);
        AbstractMap.SimpleEntry<String, String> givenImportedWrBookFactData = new AbstractMap.SimpleEntry<String, String>("Title", "I hate name with multi dots");
        ScenarioRunnerData scenarioRunnerData = new ScenarioRunnerData();
        scenarioRunnerData.addBackground(new InstanceGiven(this.disputeFactIdentifier, this.instantiateMap(backgroundDisputeFactData)));
        scenarioRunnerData.addBackground(new InstanceGiven(this.personFactIdentifier, this.instantiateMap(backgroundPersonFactData, backgroundPersonFactData2)));
        scenarioRunnerData.addBackground(new InstanceGiven(importedPersonFactIdentifier, this.instantiateMap(backgroundImportedPersonFactData, backgroundImportedPersonFactData2)));
        scenarioRunnerData.addBackground(new InstanceGiven(importedDisputeFactIdentifier, this.instantiateMap(backgroundImportedDisputeFactData)));
        scenarioRunnerData.addGiven(new InstanceGiven(this.personFactIdentifier, this.instantiateMap(givenPersonFactData, givenPersonFactData2)));
        scenarioRunnerData.addGiven(new InstanceGiven(importedPersonFactIdentifier, this.instantiateMap(givenImportedPersonFactData, givenImportedPersonFactData2)));
        scenarioRunnerData.addGiven(new InstanceGiven(bookFactIdentifier, this.instantiateMap(givenBookFactData, givenBookFactData2)));
        scenarioRunnerData.addGiven(new InstanceGiven(importedBookFactIdentifier, this.instantiateMap(givenImportedBookFactData, givenImportedBookFactData2)));
        scenarioRunnerData.addGiven(new InstanceGiven(importedWrBookFactIdentifier, this.instantiateMap(givenImportedWrBookFactData)));
        FactMappingValue factMappingValue = new FactMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)NAME);
        scenarioRunnerData.addExpect(new ScenarioExpect(this.personFactIdentifier, Collections.singletonList(factMappingValue), false));
        scenarioRunnerData.addExpect(new ScenarioExpect(this.personFactIdentifier, Collections.singletonList(factMappingValue), true));
        List<String> expectedInputDataToLoad = Arrays.asList(this.personFactIdentifier.getName(), this.disputeFactIdentifier.getName(), bookFactIdentifier.getName(), "imported");
        int inputObjects = expectedInputDataToLoad.size();
        this.runnerHelper.executeScenario(this.kieContainerMock, scenarioRunnerData, expressionEvaluatorFactory, this.simulation.getScesimModelDescriptor(), this.settings);
        ((DMNScenarioExecutableBuilder)Mockito.verify((Object)this.dmnScenarioExecutableBuilderMock, (VerificationMode)Mockito.times((int)1))).setActiveModel(DMN_FILE_PATH);
        ((DMNScenarioExecutableBuilder)Mockito.verify((Object)this.dmnScenarioExecutableBuilderMock, (VerificationMode)Mockito.times((int)inputObjects))).setValue((String)this.keyCaptor.capture(), this.valueCaptor.capture());
        Assertions.assertThat((boolean)this.keyCaptor.getAllValues().containsAll(expectedInputDataToLoad)).isTrue();
        for (int i = 0; i < inputObjects; ++i) {
            String key = (String)this.keyCaptor.getAllValues().get(i);
            Map value = (Map)this.valueCaptor.getAllValues().get(i);
            if (this.personFactIdentifier.getName().equals(key)) {
                Assertions.assertThat(value.get(backgroundPersonFactData.getKey())).isEqualTo((Object)backgroundPersonFactData.getValue());
                Assertions.assertThat(value.get(backgroundPersonFactData2.getKey())).isNotEqualTo((Object)backgroundPersonFactData2.getValue());
                Assertions.assertThat(value.get(givenPersonFactData.getKey())).isEqualTo((Object)givenPersonFactData.getValue());
                Assertions.assertThat(value.get(givenPersonFactData2.getKey())).isEqualTo((Object)givenPersonFactData2.getValue());
                Assertions.assertThat((int)value.size()).isEqualTo(3);
                continue;
            }
            if (this.disputeFactIdentifier.getName().equals(key)) {
                Assertions.assertThat(value.get(backgroundDisputeFactData.getKey())).isEqualTo((Object)backgroundDisputeFactData.getValue());
                Assertions.assertThat((int)value.size()).isEqualTo(1);
                continue;
            }
            if (bookFactIdentifier.getName().equals(key)) {
                Assertions.assertThat(value.get(givenBookFactData.getKey())).isEqualTo((Object)givenBookFactData.getValue());
                Assertions.assertThat(value.get(givenBookFactData2.getKey())).isEqualTo((Object)givenBookFactData2.getValue());
                Assertions.assertThat((int)value.size()).isEqualTo(2);
                continue;
            }
            if ("imported".equals(key)) {
                Map subValueDispute = (Map)value.get("Dispute");
                Assertions.assertThat(subValueDispute.get(backgroundImportedDisputeFactData.getKey())).isEqualTo((Object)backgroundImportedDisputeFactData.getValue());
                Assertions.assertThat((int)subValueDispute.size()).isEqualTo(1);
                Map subValueBook = (Map)value.get("Book");
                Assertions.assertThat(subValueBook.get(givenImportedBookFactData.getKey())).isEqualTo((Object)givenImportedBookFactData.getValue());
                Assertions.assertThat(subValueBook.get(givenImportedBookFactData2.getKey())).isEqualTo((Object)givenImportedBookFactData2.getValue());
                Assertions.assertThat((int)subValueBook.size()).isEqualTo(2);
                Map subValuePerson = (Map)value.get("Person");
                Assertions.assertThat(subValuePerson.get(backgroundImportedPersonFactData.getKey())).isEqualTo((Object)backgroundImportedPersonFactData.getValue());
                Assertions.assertThat(subValuePerson.get(backgroundImportedPersonFactData2.getKey())).isNotEqualTo((Object)backgroundImportedPersonFactData2.getValue());
                Assertions.assertThat(subValuePerson.get(givenImportedPersonFactData.getKey())).isEqualTo((Object)givenImportedPersonFactData.getValue());
                Assertions.assertThat(subValuePerson.get(givenImportedPersonFactData2.getKey())).isEqualTo((Object)givenImportedPersonFactData2.getValue());
                Assertions.assertThat((int)subValuePerson.size()).isEqualTo(3);
                Map subValueWrBook = (Map)value.get("wr.Book");
                Assertions.assertThat(subValueWrBook.get(givenImportedWrBookFactData.getKey())).isEqualTo((Object)givenImportedWrBookFactData.getValue());
                Assertions.assertThat((int)subValueWrBook.size()).isEqualTo(1);
                Assertions.assertThat((int)value.size()).isEqualTo(4);
                continue;
            }
            Assertions.fail((String)("Unexpected key: " + key));
        }
        ((DMNScenarioExecutableBuilder)Mockito.verify((Object)this.dmnScenarioExecutableBuilderMock, (VerificationMode)Mockito.times((int)1))).run();
        this.settings.setType(ScenarioSimulationModel.Type.RULE);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runnerHelper.executeScenario(this.kieContainerMock, scenarioRunnerData, expressionEvaluatorFactory, this.simulation.getScesimModelDescriptor(), this.settings)).isInstanceOf(ScenarioException.class)).hasMessageStartingWith("Impossible to run");
    }

    @Test
    public void validateWrongImportPrefix() {
        String wrongPrefix = "WrongPrefix";
        FactIdentifier importedPersonFactIdentifier = FactIdentifier.create((String)"imported.Person", (String)"imported.Person", (String)wrongPrefix);
        ScenarioRunnerData scenarioRunnerData = new ScenarioRunnerData();
        AbstractMap.SimpleEntry<String, String> givenImportedPersonFactData = new AbstractMap.SimpleEntry<String, String>("surname", "White");
        AbstractMap.SimpleEntry<String, Integer> givenImportedPersonFactData2 = new AbstractMap.SimpleEntry<String, Integer>("age", 67);
        scenarioRunnerData.addGiven(new InstanceGiven(importedPersonFactIdentifier, this.instantiateMap(givenImportedPersonFactData, givenImportedPersonFactData2)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runnerHelper.executeScenario(this.kieContainerMock, scenarioRunnerData, expressionEvaluatorFactory, this.simulation.getScesimModelDescriptor(), this.settings)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Fact name: imported.Person has defined an invalid import prefix: " + wrongPrefix);
    }

    @Test
    public void validateUnSecureImportPrefix() {
        String injectedPrefix = "/.(a+)+$/";
        FactIdentifier importedPersonFactIdentifier = FactIdentifier.create((String)(injectedPrefix + ".Person"), (String)(injectedPrefix + ".Person"), (String)injectedPrefix);
        ScenarioRunnerData scenarioRunnerData = new ScenarioRunnerData();
        AbstractMap.SimpleEntry<String, String> givenImportedPersonFactData = new AbstractMap.SimpleEntry<String, String>("surname", "White");
        AbstractMap.SimpleEntry<String, Integer> givenImportedPersonFactData2 = new AbstractMap.SimpleEntry<String, Integer>("age", 67);
        scenarioRunnerData.addGiven(new InstanceGiven(importedPersonFactIdentifier, this.instantiateMap(givenImportedPersonFactData, givenImportedPersonFactData2)));
        List<String> expectedInputDataToLoad = List.of(injectedPrefix);
        int inputObjects = expectedInputDataToLoad.size();
        this.runnerHelper.executeScenario(this.kieContainerMock, scenarioRunnerData, expressionEvaluatorFactory, this.simulation.getScesimModelDescriptor(), this.settings);
        ((DMNScenarioExecutableBuilder)Mockito.verify((Object)this.dmnScenarioExecutableBuilderMock, (VerificationMode)Mockito.times((int)inputObjects))).setValue((String)this.keyCaptor.capture(), this.valueCaptor.capture());
        Assertions.assertThat((boolean)this.keyCaptor.getAllValues().containsAll(expectedInputDataToLoad)).isTrue();
        String key = (String)this.keyCaptor.getAllValues().get(0);
        Map value = (Map)this.valueCaptor.getAllValues().get(0);
        Assertions.assertThat((String)key).isEqualTo(injectedPrefix);
        Map subValuePerson = (Map)value.get("Person");
        Assertions.assertThat(subValuePerson.get(givenImportedPersonFactData.getKey())).isEqualTo((Object)givenImportedPersonFactData.getValue());
        Assertions.assertThat(subValuePerson.get(givenImportedPersonFactData2.getKey())).isEqualTo((Object)givenImportedPersonFactData2.getValue());
        Assertions.assertThat((int)subValuePerson.size()).isEqualTo(2);
    }

    private Map<String, Object> instantiateMap(AbstractMap.SimpleEntry<String, Object> ... entries) {
        return Arrays.asList(entries).stream().collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    public void commonExtractResultMetadata(List<DMNMessage> messages) {
        HashSet decisions = new HashSet();
        IntStream.range(0, 5).forEach(index -> decisions.add(this.createDecisionMock("decision" + index)));
        Mockito.when((Object)this.dmnModelMock.getDecisions()).thenReturn(decisions);
        ArrayList<DMNDecisionResult> decisionResults = new ArrayList<DMNDecisionResult>();
        decisionResults.add(this.createDecisionResultMock("decision2", true, messages));
        decisionResults.add(this.createDecisionResultMock("decision3", false, messages));
        Mockito.when((Object)this.dmnResultMock.getDecisionResults()).thenReturn(decisionResults);
        ScenarioWithIndex scenarioWithIndex = new ScenarioWithIndex(1, this.scenario1);
        ScenarioResultMetadata scenarioResultMetadata = this.runnerHelper.extractResultMetadata(this.requestContextMock, scenarioWithIndex);
        Assertions.assertThat((Object)scenarioResultMetadata.getScenarioWithIndex()).isEqualTo((Object)scenarioWithIndex);
        Assertions.assertThat((int)scenarioResultMetadata.getAvailable().size()).isEqualTo(5);
        Assertions.assertThat((boolean)scenarioResultMetadata.getAvailable().contains("decision1")).isTrue();
        Assertions.assertThat((int)scenarioResultMetadata.getExecuted().size()).isEqualTo(1);
        Assertions.assertThat((boolean)scenarioResultMetadata.getExecuted().contains("decision2")).isTrue();
        Assertions.assertThat((boolean)scenarioResultMetadata.getExecuted().contains("decision3")).isFalse();
        List auditLogLines = scenarioResultMetadata.getAuditLogLines();
        Assertions.assertThat((List)auditLogLines).isNotNull();
        if (messages == null) {
            Assertions.assertThat((int)auditLogLines.size()).isEqualTo(decisionResults.size());
            for (int i = 0; i < decisionResults.size(); ++i) {
                TestUtils.commonCheckAuditLogLine((AuditLogLine)auditLogLines.get(i), ((DMNDecisionResult)decisionResults.get(i)).getDecisionName(), ((DMNDecisionResult)decisionResults.get(i)).getEvaluationStatus().name(), null);
            }
        } else {
            List<String> expectedDecisions = Arrays.asList("decision2", "decision3");
            List<String> expectedResults = Arrays.asList(DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED.toString(), DMNDecisionResult.DecisionEvaluationStatus.FAILED.toString());
            int expectedLines = messages.size() * expectedDecisions.size();
            Assertions.assertThat((int)auditLogLines.size()).isEqualTo(expectedLines);
            for (int i = 0; i < auditLogLines.size(); ++i) {
                int messagesIndex = i < messages.size() ? i : i - messages.size();
                String decisionName = i < messages.size() ? expectedDecisions.get(0) : expectedDecisions.get(1);
                String expectedResultName = i < messages.size() ? expectedResults.get(0) : expectedResults.get(1);
                TestUtils.commonCheckAuditLogLine((AuditLogLine)auditLogLines.get(i), decisionName, expectedResultName, messages.get(messagesIndex).getLevel().name() + ": " + messages.get(messagesIndex).getText());
            }
        }
    }

    private DecisionNode createDecisionMock(String decisionName) {
        DecisionNode decisionMock = (DecisionNode)Mockito.mock(DecisionNode.class);
        Mockito.when((Object)decisionMock.getName()).thenReturn((Object)decisionName);
        return decisionMock;
    }

    private DMNDecisionResult createDecisionResultMock(String decisionName, boolean success, List<DMNMessage> messages) {
        DMNDecisionResult decisionResultMock = (DMNDecisionResult)Mockito.mock(DMNDecisionResult.class);
        Mockito.when((Object)decisionResultMock.getDecisionName()).thenReturn((Object)decisionName);
        Mockito.when((Object)decisionResultMock.getEvaluationStatus()).thenReturn((Object)(success ? DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED : DMNDecisionResult.DecisionEvaluationStatus.FAILED));
        if (messages != null) {
            Mockito.when((Object)decisionResultMock.getMessages()).thenReturn(messages);
        }
        return decisionResultMock;
    }
}

