/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.drools.scenariosimulation.api.model.AuditLogLine;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.backend.TestUtils;
import org.drools.scenariosimulation.backend.expression.DMNFeelExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorFactory;
import org.drools.scenariosimulation.backend.fluent.DMNScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.runner.DMNScenarioRunnerHelper;
import org.drools.scenariosimulation.backend.runner.RuleScenarioRunnerHelperTest;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.InstanceGiven;
import org.drools.scenariosimulation.backend.runner.model.ScenarioExpect;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.drools.scenariosimulation.backend.runner.model.ValueWrapper;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.RequestContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.core.impl.DMNMessageImpl;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNScenarioRunnerHelperTest {
    private static final String NAME = "NAME";
    private static final String FEEL_EXPRESSION_NAME = "\"NAME\"";
    private static final BigDecimal AMOUNT = BigDecimal.valueOf(10L);
    private static final String DMN_FILE_PATH = "dmnFilePath";
    private static final String TEST_DESCRIPTION = "Test description";
    private static final ClassLoader classLoader = RuleScenarioRunnerHelperTest.class.getClassLoader();
    private static final ExpressionEvaluatorFactory expressionEvaluatorFactory = ExpressionEvaluatorFactory.create((ClassLoader)classLoader, (ScenarioSimulationModel.Type)ScenarioSimulationModel.Type.DMN);
    private static final ExpressionEvaluator expressionEvaluator = new DMNFeelExpressionEvaluator(classLoader);
    private final DMNScenarioRunnerHelper runnerHelper = new DMNScenarioRunnerHelper(){

        protected DMNScenarioExecutableBuilder createBuilderWrapper(KieContainer kieContainer) {
            return DMNScenarioRunnerHelperTest.this.dmnScenarioExecutableBuilderMock;
        }
    };
    @Mock
    protected Map<String, Object> requestContextMock;
    @Mock
    protected DMNResult dmnResultMock;
    @Mock
    protected DMNDecisionResult dmnDecisionResultMock;
    @Mock
    protected DMNModel dmnModelMock;
    @Mock
    protected DMNScenarioExecutableBuilder dmnScenarioExecutableBuilderMock;
    @Mock
    protected KieContainer kieContainerMock;
    @Captor
    private ArgumentCaptor<Object> valueCaptor;
    @Captor
    private ArgumentCaptor<String> keyCaptor;
    private Simulation simulation;
    private Settings settings;
    private FactIdentifier personFactIdentifier;
    private ExpressionIdentifier firstNameGivenExpressionIdentifier;
    private FactMapping firstNameGivenFactMapping;
    private Scenario scenario1;
    private Scenario scenario2;
    private ExpressionIdentifier firstNameExpectedExpressionIdentifier;
    private FactMapping firstNameExpectedFactMapping;
    private FactIdentifier disputeFactIdentifier;
    private ExpressionIdentifier amountGivenExpressionIdentifier;
    private FactMapping amountNameGivenFactMapping;
    private ExpressionIdentifier amountExpectedExpressionIdentifier;
    private FactMapping amountNameExpectedFactMapping;
    private FactMappingValue amountNameExpectedFactMappingValue;
    private FactMappingValue firstNameExpectedValue;

    @Before
    public void init() {
        Mockito.when((Object)this.dmnScenarioExecutableBuilderMock.run()).thenReturn((Object)((RequestContext)Mockito.mock(RequestContext.class)));
        this.simulation = new Simulation();
        this.settings = new Settings();
        this.settings.setType(ScenarioSimulationModel.Type.DMN);
        this.settings.setDmnFilePath(DMN_FILE_PATH);
        this.personFactIdentifier = FactIdentifier.create((String)"Fact 1", (String)"Fact 1");
        this.firstNameGivenExpressionIdentifier = ExpressionIdentifier.create((String)"First Name Given", (FactMappingType)FactMappingType.GIVEN);
        this.firstNameGivenFactMapping = this.simulation.getScesimModelDescriptor().addFactMapping(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier);
        this.firstNameGivenFactMapping.addExpressionElement("Fact 1", String.class.getCanonicalName());
        this.firstNameGivenFactMapping.addExpressionElement("firstName", String.class.getCanonicalName());
        this.disputeFactIdentifier = FactIdentifier.create((String)"Fact 2", (String)"Fact 2");
        this.amountGivenExpressionIdentifier = ExpressionIdentifier.create((String)"Amount Given", (FactMappingType)FactMappingType.GIVEN);
        this.amountNameGivenFactMapping = this.simulation.getScesimModelDescriptor().addFactMapping(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier);
        this.amountNameGivenFactMapping.addExpressionElement("Fact 2", BigDecimal.class.getCanonicalName());
        this.amountNameGivenFactMapping.addExpressionElement("amount", BigDecimal.class.getCanonicalName());
        this.firstNameExpectedExpressionIdentifier = ExpressionIdentifier.create((String)"First Name Expected", (FactMappingType)FactMappingType.EXPECT);
        this.firstNameExpectedFactMapping = this.simulation.getScesimModelDescriptor().addFactMapping(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier);
        this.firstNameExpectedFactMapping.addExpressionElement("Fact 1", String.class.getCanonicalName());
        this.firstNameExpectedFactMapping.addExpressionElement("firstName", String.class.getCanonicalName());
        this.amountExpectedExpressionIdentifier = ExpressionIdentifier.create((String)"Amount Expected", (FactMappingType)FactMappingType.EXPECT);
        this.amountNameExpectedFactMapping = this.simulation.getScesimModelDescriptor().addFactMapping(this.disputeFactIdentifier, this.amountExpectedExpressionIdentifier);
        this.amountNameExpectedFactMapping.addExpressionElement("Fact 2", Double.class.getCanonicalName());
        this.amountNameExpectedFactMapping.addExpressionElement("amount", Double.class.getCanonicalName());
        this.scenario1 = (Scenario)this.simulation.addData();
        this.scenario1.setDescription(TEST_DESCRIPTION);
        this.scenario1.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)FEEL_EXPRESSION_NAME);
        this.firstNameExpectedValue = this.scenario1.addMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)FEEL_EXPRESSION_NAME);
        this.scenario2 = (Scenario)this.simulation.addData();
        this.scenario2.setDescription(TEST_DESCRIPTION);
        this.scenario2.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)FEEL_EXPRESSION_NAME);
        this.scenario2.addMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)FEEL_EXPRESSION_NAME);
        this.scenario2.addMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)AMOUNT);
        this.amountNameExpectedFactMappingValue = this.scenario2.addMappingValue(this.disputeFactIdentifier, this.amountExpectedExpressionIdentifier, (Object)AMOUNT);
        Mockito.when((Object)this.requestContextMock.get("dmnResult")).thenReturn((Object)this.dmnResultMock);
        Mockito.when((Object)this.requestContextMock.get("dmnModel")).thenReturn((Object)this.dmnModelMock);
    }

    @Test
    public void verifyConditions_noDecisionGeneratedForSpecificName() {
        ScenarioRunnerData scenarioRunnerData = new ScenarioRunnerData();
        scenarioRunnerData.addExpect(new ScenarioExpect(this.personFactIdentifier, List.of(this.firstNameExpectedValue)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runnerHelper.verifyConditions(this.simulation.getScesimModelDescriptor(), scenarioRunnerData, expressionEvaluatorFactory, this.requestContextMock)).isInstanceOf(ScenarioException.class)).hasMessage("DMN execution has not generated a decision result with name Fact 1");
    }

    @Test
    public void verifyConditions_decisionResultContainsANull() {
        ScenarioRunnerData scenarioRunnerData = new ScenarioRunnerData();
        scenarioRunnerData.addExpect(new ScenarioExpect(this.personFactIdentifier, List.of(this.firstNameExpectedValue)));
        Mockito.when((Object)this.dmnResultMock.getDecisionResultByName(ArgumentMatchers.anyString())).thenReturn((Object)this.dmnDecisionResultMock);
        Mockito.when((Object)this.dmnDecisionResultMock.getEvaluationStatus()).thenReturn((Object)DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
        this.runnerHelper.verifyConditions(this.simulation.getScesimModelDescriptor(), scenarioRunnerData, expressionEvaluatorFactory, this.requestContextMock);
        Assertions.assertThat((List)scenarioRunnerData.getResults()).hasSize(1);
        Assertions.assertThat((boolean)((ScenarioResult)scenarioRunnerData.getResults().get(0)).getResult()).isFalse();
    }

    @Test
    public void verifyConditions_decisionResultIsNotNullButMalformed() {
        ScenarioRunnerData scenarioRunnerData = new ScenarioRunnerData();
        scenarioRunnerData.addExpect(new ScenarioExpect(this.personFactIdentifier, List.of(this.firstNameExpectedValue)));
        Mockito.when((Object)this.dmnResultMock.getDecisionResultByName(ArgumentMatchers.anyString())).thenReturn((Object)this.dmnDecisionResultMock);
        Mockito.when((Object)this.dmnDecisionResultMock.getEvaluationStatus()).thenReturn((Object)DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
        Mockito.when((Object)this.dmnDecisionResultMock.getResult()).thenReturn((Object)"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runnerHelper.verifyConditions(this.simulation.getScesimModelDescriptor(), scenarioRunnerData, expressionEvaluatorFactory, this.requestContextMock)).isInstanceOf(ScenarioException.class)).hasMessage("Wrong resultRaw structure because it is not a complex type as expected");
    }

    @Test
    public void verifyConditions_checksArePerformed_fail() {
        ScenarioRunnerData scenarioRunnerData = new ScenarioRunnerData();
        scenarioRunnerData.addExpect(new ScenarioExpect(this.personFactIdentifier, List.of(this.firstNameExpectedValue)));
        Mockito.when((Object)this.dmnResultMock.getDecisionResultByName(ArgumentMatchers.anyString())).thenReturn((Object)this.dmnDecisionResultMock);
        Mockito.when((Object)this.dmnDecisionResultMock.getEvaluationStatus()).thenReturn((Object)DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("firstName", "WrongValue");
        Mockito.when((Object)this.dmnDecisionResultMock.getResult()).thenReturn(resultMap);
        this.runnerHelper.verifyConditions(this.simulation.getScesimModelDescriptor(), scenarioRunnerData, expressionEvaluatorFactory, this.requestContextMock);
        Assertions.assertThat((List)scenarioRunnerData.getResults()).hasSize(1);
        Assertions.assertThat((boolean)((ScenarioResult)scenarioRunnerData.getResults().get(0)).getResult()).isFalse();
    }

    @Test
    public void verifyConditions_checksArePerformed_success() {
        ScenarioRunnerData scenarioRunnerData = new ScenarioRunnerData();
        scenarioRunnerData.addExpect(new ScenarioExpect(this.personFactIdentifier, List.of(this.firstNameExpectedValue)));
        Mockito.when((Object)this.dmnResultMock.getDecisionResultByName(ArgumentMatchers.anyString())).thenReturn((Object)this.dmnDecisionResultMock);
        Mockito.when((Object)this.dmnDecisionResultMock.getEvaluationStatus()).thenReturn((Object)DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("firstName", NAME);
        Mockito.when((Object)this.dmnDecisionResultMock.getResult()).thenReturn(resultMap);
        this.runnerHelper.verifyConditions(this.simulation.getScesimModelDescriptor(), scenarioRunnerData, expressionEvaluatorFactory, this.requestContextMock);
        Assertions.assertThat((List)scenarioRunnerData.getResults()).hasSize(1);
        Assertions.assertThat((boolean)((ScenarioResult)scenarioRunnerData.getResults().get(0)).getResult()).isTrue();
    }

    @Test
    public void verifyConditions_errorsAreReported() {
        ScenarioRunnerData scenarioRunnerData = new ScenarioRunnerData();
        scenarioRunnerData.addExpect(new ScenarioExpect(this.personFactIdentifier, List.of(this.firstNameExpectedValue)));
        Mockito.when((Object)this.dmnResultMock.getDecisionResultByName(ArgumentMatchers.anyString())).thenReturn((Object)this.dmnDecisionResultMock);
        Mockito.when((Object)this.dmnDecisionResultMock.getEvaluationStatus()).thenReturn((Object)DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("firstName", NAME);
        Mockito.when((Object)this.dmnDecisionResultMock.getResult()).thenReturn(resultMap);
        ExpressionEvaluatorFactory expressionEvaluatorFactoryMock = (ExpressionEvaluatorFactory)Mockito.mock(ExpressionEvaluatorFactory.class);
        Mockito.when((Object)expressionEvaluatorFactoryMock.getOrCreate((FactMappingValue)ArgumentMatchers.any())).thenReturn((Object)((ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class)));
        this.runnerHelper.verifyConditions(this.simulation.getScesimModelDescriptor(), scenarioRunnerData, expressionEvaluatorFactoryMock, this.requestContextMock);
        Assertions.assertThat((Comparable)((ScenarioResult)scenarioRunnerData.getResults().get(0)).getFactMappingValue().getStatus()).isNotEqualTo((Object)FactMappingValueStatus.SUCCESS);
    }

    @Test
    public void createObject() {
        HashMap<List<String>, Object> params = new HashMap<List<String>, Object>();
        params.put(List.of("creator", "name"), "TestName");
        params.put(List.of("creator", "surname"), "TestSurname");
        params.put(List.of("age"), BigDecimal.valueOf(10L));
        ValueWrapper initialInstance = this.runnerHelper.getDirectMapping(params);
        Object objectRaw = this.runnerHelper.createObject(initialInstance, String.class.getCanonicalName(), params, this.getClass().getClassLoader());
        Assertions.assertThat((Object)objectRaw).isInstanceOf(Map.class);
        Map object = (Map)objectRaw;
        Assertions.assertThat((Map)object).containsEntry((Object)"age", (Object)BigDecimal.valueOf(10L));
        Assertions.assertThat(object.get("creator")).isInstanceOf(Map.class);
        Map creator = (Map)object.get("creator");
        ((MapAssert)Assertions.assertThat((Map)creator).containsEntry((Object)"name", (Object)"TestName")).containsEntry((Object)"surname", (Object)"TestSurname");
    }

    @Test
    public void createObject_directMappingSimpleType() {
        HashMap params = new HashMap();
        String directMappingSimpleTypeValue = "TestName";
        params.put(List.of(), directMappingSimpleTypeValue);
        ValueWrapper initialInstance = this.runnerHelper.getDirectMapping(params);
        Object objectRaw = this.runnerHelper.createObject(initialInstance, String.class.getCanonicalName(), params, this.getClass().getClassLoader());
        ((ObjectAssert)Assertions.assertThat((Object)objectRaw).isInstanceOf(String.class)).isEqualTo((Object)directMappingSimpleTypeValue);
    }

    @Test
    public void createObject_directMappingSimpleTypeNull() {
        HashMap params = new HashMap();
        params.put(List.of(), null);
        ValueWrapper initialInstance = this.runnerHelper.getDirectMapping(params);
        Object objectRaw = this.runnerHelper.createObject(initialInstance, String.class.getCanonicalName(), params, this.getClass().getClassLoader());
        Assertions.assertThat((Object)objectRaw).isNull();
    }

    @Test
    public void createObject_directMappingComplexType() {
        HashMap params = new HashMap();
        HashMap<String, String> directMappingComplexTypeValue = new HashMap<String, String>();
        directMappingComplexTypeValue.put("key1", "value1");
        params.put(List.of(), directMappingComplexTypeValue);
        params.put(List.of("key2"), "value2");
        ValueWrapper initialInstance = this.runnerHelper.getDirectMapping(params);
        Object objectRaw = this.runnerHelper.createObject(initialInstance, Map.class.getCanonicalName(), params, this.getClass().getClassLoader());
        Assertions.assertThat((Object)objectRaw).isInstanceOf(Map.class);
        Map object = (Map)objectRaw;
        ((MapAssert)Assertions.assertThat((Map)object).containsEntry((Object)"key1", (Object)"value1")).containsEntry((Object)"key2", (Object)"value2");
    }

    @Test
    public void extractResultMetadata_noDecisionResultMessages() {
        this.commonExtractResultMetadata();
    }

    @Test
    public void extractResultMetadata_decisionResultMessages() {
        List<DMNMessage> messages = TestUtils.getRandomlyGeneratedDMNMessageList();
        this.commonExtractResultMetadata(messages);
    }

    @Test
    public void getSingleFactValueResult_failDecision() {
        DMNDecisionResult failedDecision = this.createDecisionResultMock("Test", false, new ArrayList<DMNMessage>());
        ValueWrapper failedResult = this.runnerHelper.getSingleFactValueResult(null, null, failedDecision, null, expressionEvaluator);
        Assertions.assertThat((boolean)failedResult.isValid()).isFalse();
        Assertions.assertThat((String)((String)failedResult.getErrorMessage().get())).isEqualTo("The decision \"" + failedDecision.getDecisionName() + "\" has not been successfully evaluated: " + failedDecision.getEvaluationStatus());
    }

    @Test
    public void getSingleFactValueResult_failDecisionWithMessages() {
        DMNMessageImpl errorMessage = new DMNMessageImpl(DMNMessage.Severity.ERROR, "DMN Internal Error", DMNMessageType.FEEL_EVALUATION_ERROR, null);
        DMNMessageImpl warnMessage = new DMNMessageImpl(DMNMessage.Severity.WARN, "DMN Internal Warn", DMNMessageType.FEEL_EVALUATION_ERROR, null);
        DMNDecisionResult failedDecision = this.createDecisionResultMock("Test", false, new ArrayList<DMNMessage>());
        ValueWrapper failedResult = this.runnerHelper.getSingleFactValueResult(null, null, failedDecision, List.of(warnMessage, errorMessage), expressionEvaluator);
        Assertions.assertThat((boolean)failedResult.isValid()).isFalse();
        Assertions.assertThat((String)((String)failedResult.getErrorMessage().get())).isEqualTo("The decision \"" + failedDecision.getDecisionName() + "\" has not been successfully evaluated: DMN Internal Error");
    }

    @Test
    public void executeScenario() {
        FactIdentifier bookFactIdentifier = FactIdentifier.create((String)"Book", (String)"Book");
        FactIdentifier importedPersonFactIdentifier = FactIdentifier.create((String)"imported.Person", (String)"imported.Person", (String)"imported");
        FactIdentifier importedDisputeFactIdentifier = FactIdentifier.create((String)"imported.Dispute", (String)"imported.Dispute", (String)"imported");
        FactIdentifier importedBookFactIdentifier = FactIdentifier.create((String)"imported.Book", (String)"imported.Book", (String)"imported");
        FactIdentifier importedWrBookFactIdentifier = FactIdentifier.create((String)"imported.wr.Book", (String)"imported.wr.Book", (String)"imported");
        AbstractMap.SimpleEntry<String, String> backgroundDisputeFactData = new AbstractMap.SimpleEntry<String, String>("description", "Nice");
        AbstractMap.SimpleEntry<String, String> backgroundPersonFactData = new AbstractMap.SimpleEntry<String, String>("name", "Carl");
        AbstractMap.SimpleEntry<String, Integer> backgroundPersonFactData2 = new AbstractMap.SimpleEntry<String, Integer>("age", 2);
        AbstractMap.SimpleEntry<String, String> backgroundImportedDisputeFactData = new AbstractMap.SimpleEntry<String, String>("description", "Bad");
        AbstractMap.SimpleEntry<String, String> backgroundImportedPersonFactData = new AbstractMap.SimpleEntry<String, String>("name", "Max");
        AbstractMap.SimpleEntry<String, Integer> backgroundImportedPersonFactData2 = new AbstractMap.SimpleEntry<String, Integer>("age", 34);
        AbstractMap.SimpleEntry<String, String> givenPersonFactData = new AbstractMap.SimpleEntry<String, String>("surname", "Brown");
        AbstractMap.SimpleEntry<String, Integer> givenPersonFactData2 = new AbstractMap.SimpleEntry<String, Integer>("age", 23);
        AbstractMap.SimpleEntry<String, String> givenBookFactData = new AbstractMap.SimpleEntry<String, String>("Author", "Resey Rema");
        AbstractMap.SimpleEntry<String, String> givenBookFactData2 = new AbstractMap.SimpleEntry<String, String>("Name", "The mighty Test Scenario!");
        AbstractMap.SimpleEntry<String, String> givenImportedBookFactData = new AbstractMap.SimpleEntry<String, String>("Author", "Mr Y");
        AbstractMap.SimpleEntry<String, String> givenImportedBookFactData2 = new AbstractMap.SimpleEntry<String, String>("Title", "The awesome Test Scenario!");
        AbstractMap.SimpleEntry<String, String> givenImportedPersonFactData = new AbstractMap.SimpleEntry<String, String>("surname", "White");
        AbstractMap.SimpleEntry<String, Integer> givenImportedPersonFactData2 = new AbstractMap.SimpleEntry<String, Integer>("age", 67);
        AbstractMap.SimpleEntry<String, String> givenImportedWrBookFactData = new AbstractMap.SimpleEntry<String, String>("Title", "I hate name with multi dots");
        ScenarioRunnerData scenarioRunnerData = new ScenarioRunnerData();
        scenarioRunnerData.addBackground(new InstanceGiven(this.disputeFactIdentifier, Map.ofEntries(backgroundDisputeFactData)));
        scenarioRunnerData.addBackground(new InstanceGiven(this.personFactIdentifier, Map.ofEntries(backgroundPersonFactData, backgroundPersonFactData2)));
        scenarioRunnerData.addBackground(new InstanceGiven(importedPersonFactIdentifier, Map.ofEntries(backgroundImportedPersonFactData, backgroundImportedPersonFactData2)));
        scenarioRunnerData.addBackground(new InstanceGiven(importedDisputeFactIdentifier, Map.ofEntries(backgroundImportedDisputeFactData)));
        scenarioRunnerData.addGiven(new InstanceGiven(this.personFactIdentifier, Map.ofEntries(givenPersonFactData, givenPersonFactData2)));
        scenarioRunnerData.addGiven(new InstanceGiven(importedPersonFactIdentifier, Map.ofEntries(givenImportedPersonFactData, givenImportedPersonFactData2)));
        scenarioRunnerData.addGiven(new InstanceGiven(bookFactIdentifier, Map.ofEntries(givenBookFactData, givenBookFactData2)));
        scenarioRunnerData.addGiven(new InstanceGiven(importedBookFactIdentifier, Map.ofEntries(givenImportedBookFactData, givenImportedBookFactData2)));
        scenarioRunnerData.addGiven(new InstanceGiven(importedWrBookFactIdentifier, Map.ofEntries(givenImportedWrBookFactData)));
        FactMappingValue factMappingValue = new FactMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)NAME);
        scenarioRunnerData.addExpect(new ScenarioExpect(this.personFactIdentifier, List.of(factMappingValue), false));
        scenarioRunnerData.addExpect(new ScenarioExpect(this.personFactIdentifier, List.of(factMappingValue), true));
        List<String> expectedInputDataToLoad = List.of(this.personFactIdentifier.getName(), this.disputeFactIdentifier.getName(), bookFactIdentifier.getName(), "imported");
        int inputObjects = expectedInputDataToLoad.size();
        this.runnerHelper.executeScenario(this.kieContainerMock, scenarioRunnerData, expressionEvaluatorFactory, this.simulation.getScesimModelDescriptor(), this.settings);
        ((DMNScenarioExecutableBuilder)Mockito.verify((Object)this.dmnScenarioExecutableBuilderMock, (VerificationMode)Mockito.times((int)1))).setActiveModel(DMN_FILE_PATH);
        ((DMNScenarioExecutableBuilder)Mockito.verify((Object)this.dmnScenarioExecutableBuilderMock, (VerificationMode)Mockito.times((int)inputObjects))).setValue((String)this.keyCaptor.capture(), this.valueCaptor.capture());
        Assertions.assertThat((List)this.keyCaptor.getAllValues()).containsAll(expectedInputDataToLoad);
        for (int i = 0; i < inputObjects; ++i) {
            String key = (String)this.keyCaptor.getAllValues().get(i);
            Map value = (Map)this.valueCaptor.getAllValues().get(i);
            if (this.personFactIdentifier.getName().equals(key)) {
                ((MapAssert)Assertions.assertThat((Map)value).hasSize(3)).contains(new Map.Entry[]{backgroundPersonFactData, givenPersonFactData, givenPersonFactData2});
                continue;
            }
            if (this.disputeFactIdentifier.getName().equals(key)) {
                ((MapAssert)Assertions.assertThat((Map)value).hasSize(1)).contains(new Map.Entry[]{backgroundDisputeFactData});
                continue;
            }
            if (bookFactIdentifier.getName().equals(key)) {
                ((MapAssert)Assertions.assertThat((Map)value).hasSize(2)).contains(new Map.Entry[]{givenBookFactData, givenBookFactData2});
                continue;
            }
            if ("imported".equals(key)) {
                Assertions.assertThat((Map)value).hasSize(4);
                Map subValueDispute = (Map)value.get("Dispute");
                ((MapAssert)Assertions.assertThat((Map)subValueDispute).hasSize(1)).contains(new Map.Entry[]{backgroundImportedDisputeFactData});
                Map subValueBook = (Map)value.get("Book");
                ((MapAssert)Assertions.assertThat((Map)subValueBook).hasSize(2)).contains(new Map.Entry[]{givenImportedBookFactData, givenImportedBookFactData2});
                Map subValuePerson = (Map)value.get("Person");
                ((MapAssert)Assertions.assertThat((Map)subValuePerson).hasSize(3)).contains(new Map.Entry[]{backgroundImportedPersonFactData, givenImportedPersonFactData, givenImportedPersonFactData2});
                Map subValueWrBook = (Map)value.get("wr.Book");
                ((MapAssert)Assertions.assertThat((Map)subValueWrBook).hasSize(1)).contains(new Map.Entry[]{givenImportedWrBookFactData});
                continue;
            }
            Assertions.fail((String)("Unexpected key: " + key));
        }
        ((DMNScenarioExecutableBuilder)Mockito.verify((Object)this.dmnScenarioExecutableBuilderMock, (VerificationMode)Mockito.times((int)1))).run();
        this.settings.setType(ScenarioSimulationModel.Type.RULE);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runnerHelper.executeScenario(this.kieContainerMock, scenarioRunnerData, expressionEvaluatorFactory, this.simulation.getScesimModelDescriptor(), this.settings)).isInstanceOf(ScenarioException.class)).hasMessageStartingWith("Impossible to run");
    }

    @Test
    public void validateScenario_wrongImportPrefix() {
        String wrongPrefix = "WrongPrefix";
        FactIdentifier importedPersonFactIdentifier = FactIdentifier.create((String)"imported.Person", (String)"imported.Person", (String)wrongPrefix);
        ScenarioRunnerData scenarioRunnerData = new ScenarioRunnerData();
        AbstractMap.SimpleEntry<String, String> givenImportedPersonFactData = new AbstractMap.SimpleEntry<String, String>("surname", "White");
        AbstractMap.SimpleEntry<String, Integer> givenImportedPersonFactData2 = new AbstractMap.SimpleEntry<String, Integer>("age", 67);
        scenarioRunnerData.addGiven(new InstanceGiven(importedPersonFactIdentifier, Map.ofEntries(givenImportedPersonFactData, givenImportedPersonFactData2)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runnerHelper.executeScenario(this.kieContainerMock, scenarioRunnerData, expressionEvaluatorFactory, this.simulation.getScesimModelDescriptor(), this.settings)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Fact name: imported.Person has defined an invalid import prefix: " + wrongPrefix);
    }

    @Test
    public void validateUnSecureImportPrefix() {
        String injectedPrefix = "/.(a+)+$/";
        FactIdentifier importedPersonFactIdentifier = FactIdentifier.create((String)(injectedPrefix + ".Person"), (String)(injectedPrefix + ".Person"), (String)injectedPrefix);
        ScenarioRunnerData scenarioRunnerData = new ScenarioRunnerData();
        AbstractMap.SimpleEntry<String, String> givenImportedPersonFactData = new AbstractMap.SimpleEntry<String, String>("surname", "White");
        AbstractMap.SimpleEntry<String, Integer> givenImportedPersonFactData2 = new AbstractMap.SimpleEntry<String, Integer>("age", 67);
        scenarioRunnerData.addGiven(new InstanceGiven(importedPersonFactIdentifier, Map.ofEntries(givenImportedPersonFactData, givenImportedPersonFactData2)));
        List<String> expectedInputDataToLoad = List.of(injectedPrefix);
        int inputObjects = expectedInputDataToLoad.size();
        this.runnerHelper.executeScenario(this.kieContainerMock, scenarioRunnerData, expressionEvaluatorFactory, this.simulation.getScesimModelDescriptor(), this.settings);
        ((DMNScenarioExecutableBuilder)Mockito.verify((Object)this.dmnScenarioExecutableBuilderMock, (VerificationMode)Mockito.times((int)inputObjects))).setValue((String)this.keyCaptor.capture(), this.valueCaptor.capture());
        Assertions.assertThat((List)this.keyCaptor.getAllValues()).containsAll(expectedInputDataToLoad);
        String key = (String)this.keyCaptor.getAllValues().get(0);
        Map value = (Map)this.valueCaptor.getAllValues().get(0);
        Assertions.assertThat((String)key).isEqualTo(injectedPrefix);
        Map subValuePerson = (Map)value.get("Person");
        ((MapAssert)Assertions.assertThat((Map)subValuePerson).hasSize(2)).contains(new Map.Entry[]{givenImportedPersonFactData, givenImportedPersonFactData2});
    }

    public void commonExtractResultMetadata(List<DMNMessage> messages) {
        HashSet decisions = new HashSet();
        IntStream.range(0, 5).forEach(index -> decisions.add(this.createDecisionMock("decision" + index)));
        Mockito.when((Object)this.dmnModelMock.getDecisions()).thenReturn(decisions);
        ArrayList<DMNDecisionResult> decisionResults = new ArrayList<DMNDecisionResult>();
        decisionResults.add(this.createDecisionResultMock("decision2", true, messages));
        decisionResults.add(this.createDecisionResultMock("decision3", false, messages));
        Mockito.when((Object)this.dmnResultMock.getDecisionResults()).thenReturn(decisionResults);
        ScenarioWithIndex scenarioWithIndex = new ScenarioWithIndex(1, this.scenario1);
        ScenarioResultMetadata scenarioResultMetadata = this.runnerHelper.extractResultMetadata(this.requestContextMock, scenarioWithIndex);
        Assertions.assertThat((Object)scenarioResultMetadata.getScenarioWithIndex()).isEqualTo((Object)scenarioWithIndex);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)scenarioResultMetadata.getAvailable()).hasSize(5)).contains((Object[])new String[]{"decision1"});
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)scenarioResultMetadata.getExecuted()).hasSize(1)).contains((Object[])new String[]{"decision2"})).doesNotContain((Object[])new String[]{"decision3"});
        List auditLogLines = scenarioResultMetadata.getAuditLogLines();
        Assertions.assertThat((List)auditLogLines).isNotNull();
        List<String> expectedDecisions = List.of("decision2", "decision3");
        List<String> expectedResults = List.of(DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED.toString(), DMNDecisionResult.DecisionEvaluationStatus.FAILED.toString());
        int expectedLines = messages.size() * expectedDecisions.size();
        Assertions.assertThat((List)auditLogLines).hasSize(expectedLines);
        for (int i = 0; i < auditLogLines.size(); ++i) {
            int messagesIndex = i < messages.size() ? i : i - messages.size();
            String decisionName = i < messages.size() ? expectedDecisions.get(0) : expectedDecisions.get(1);
            String expectedResultName = i < messages.size() ? expectedResults.get(0) : expectedResults.get(1);
            TestUtils.commonCheckAuditLogLine((AuditLogLine)auditLogLines.get(i), decisionName, expectedResultName, messages.get(messagesIndex).getLevel().name() + ": " + messages.get(messagesIndex).getText());
        }
    }

    public void commonExtractResultMetadata() {
        HashSet decisions = new HashSet();
        IntStream.range(0, 5).forEach(index -> decisions.add(this.createDecisionMock("decision" + index)));
        Mockito.when((Object)this.dmnModelMock.getDecisions()).thenReturn(decisions);
        ArrayList<DMNDecisionResult> decisionResults = new ArrayList<DMNDecisionResult>();
        decisionResults.add(this.createDecisionResultMock("decision2", true, null));
        decisionResults.add(this.createDecisionResultMock("decision3", false, null));
        Mockito.when((Object)this.dmnResultMock.getDecisionResults()).thenReturn(decisionResults);
        ScenarioWithIndex scenarioWithIndex = new ScenarioWithIndex(1, this.scenario1);
        ScenarioResultMetadata scenarioResultMetadata = this.runnerHelper.extractResultMetadata(this.requestContextMock, scenarioWithIndex);
        Assertions.assertThat((Object)scenarioResultMetadata.getScenarioWithIndex()).isEqualTo((Object)scenarioWithIndex);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)scenarioResultMetadata.getAvailable()).hasSize(5)).contains((Object[])new String[]{"decision1"});
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)scenarioResultMetadata.getExecuted()).hasSize(1)).contains((Object[])new String[]{"decision2"})).doesNotContain((Object[])new String[]{"decision3"});
        List auditLogLines = scenarioResultMetadata.getAuditLogLines();
        ((ListAssert)Assertions.assertThat((List)auditLogLines).isNotNull()).hasSameSizeAs(decisionResults);
        for (int i = 0; i < decisionResults.size(); ++i) {
            TestUtils.commonCheckAuditLogLine((AuditLogLine)auditLogLines.get(i), ((DMNDecisionResult)decisionResults.get(i)).getDecisionName(), ((DMNDecisionResult)decisionResults.get(i)).getEvaluationStatus().name());
        }
    }

    private DecisionNode createDecisionMock(String decisionName) {
        DecisionNode decisionMock = (DecisionNode)Mockito.mock(DecisionNode.class);
        Mockito.when((Object)decisionMock.getName()).thenReturn((Object)decisionName);
        return decisionMock;
    }

    private DMNDecisionResult createDecisionResultMock(String decisionName, boolean success, List<DMNMessage> messages) {
        DMNDecisionResult decisionResultMock = (DMNDecisionResult)Mockito.mock(DMNDecisionResult.class);
        Mockito.when((Object)decisionResultMock.getDecisionName()).thenReturn((Object)decisionName);
        Mockito.when((Object)decisionResultMock.getEvaluationStatus()).thenReturn((Object)(success ? DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED : DMNDecisionResult.DecisionEvaluationStatus.FAILED));
        if (messages != null) {
            Mockito.when((Object)decisionResultMock.getMessages()).thenReturn(messages);
        }
        return decisionResultMock;
    }
}

