/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.AuditLogLine;
import org.drools.util.ResourceHelper;
import org.kie.api.builder.Message;
import org.kie.dmn.api.core.DMNMessage;
import org.mockito.Mockito;

public class TestUtils {
    public static String getFileContent(String fileName) throws IOException {
        String extension = fileName.substring(fileName.lastIndexOf(".") + 1);
        String filePath = ResourceHelper.getResourcesByExtension((String)extension).stream().filter(path -> path.endsWith(fileName)).findFirst().orElse(null);
        Assertions.assertThat((String)filePath).isNotNull();
        File sourceFile = new File(filePath);
        Assertions.assertThat((File)sourceFile).exists();
        return new String(Files.readAllBytes(sourceFile.toPath()));
    }

    public static List<DMNMessage> getRandomlyGeneratedDMNMessageList() {
        return IntStream.range(0, 5).mapToObj(index -> {
            Message.Level level = Message.Level.values()[new Random().nextInt(Message.Level.values().length)];
            return TestUtils.createDMNMessageMock("dmnMessage-" + index, level);
        }).collect(Collectors.toList());
    }

    public static void commonCheckAuditLogLine(AuditLogLine toCheck, String expectedDecisionOrRuleName, String expectedResult, String expectedMessage) {
        Assertions.assertThat((Object)toCheck).isNotNull();
        Assertions.assertThat((String)toCheck.getDecisionOrRuleName()).isEqualTo(expectedDecisionOrRuleName);
        Assertions.assertThat((String)toCheck.getResult()).isEqualTo(expectedResult);
        Assertions.assertThat((String)((String)toCheck.getMessage().get())).isEqualTo(expectedMessage);
    }

    public static void commonCheckAuditLogLine(AuditLogLine toCheck, String expectedDecisionOrRuleName, String expectedResult) {
        Assertions.assertThat((Object)toCheck).isNotNull();
        Assertions.assertThat((String)toCheck.getDecisionOrRuleName()).isEqualTo(expectedDecisionOrRuleName);
        Assertions.assertThat((String)toCheck.getResult()).isEqualTo(expectedResult);
        Assertions.assertThat((Optional)toCheck.getMessage()).isNotPresent();
    }

    private static DMNMessage createDMNMessageMock(String text, Message.Level level) {
        DMNMessage dmnMessageMock = (DMNMessage)Mockito.mock(DMNMessage.class);
        Mockito.when((Object)dmnMessageMock.getText()).thenReturn((Object)text);
        Mockito.when((Object)dmnMessageMock.getLevel()).thenReturn((Object)level);
        return dmnMessageMock;
    }
}

