/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import com.fasterxml.jackson.databind.node.TextNode;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.drools.scenariosimulation.backend.expression.AbstractExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.BaseExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorResult;
import org.drools.scenariosimulation.backend.model.ListMapClass;
import org.junit.Before;
import org.junit.Test;

public class BaseExpressionEvaluatorTest {
    private Condition<ExpressionEvaluatorResult> successful = new Condition(x -> x.isSuccessful(), "isSuccessful", new Object[0]);
    private Condition<ExpressionEvaluatorResult> notSuccessful = new Condition(x -> !x.isSuccessful(), "isNotSuccessful", new Object[0]);
    private static final ClassLoader classLoader = BaseExpressionEvaluatorTest.class.getClassLoader();
    private AbstractExpressionEvaluator expressionEvaluator;

    @Before
    public void setUp() {
        this.expressionEvaluator = new BaseExpressionEvaluator(classLoader);
    }

    @Test
    public void evaluateLiteralExpression() {
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateLiteralExpression("", Object.class.getCanonicalName(), List.of())).isEqualTo((Object)"");
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateLiteralExpression("SimpleString", String.class.getCanonicalName(), List.of())).isEqualTo((Object)"SimpleString");
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateLiteralExpression("= SimpleString", String.class.getCanonicalName(), List.of())).isEqualTo((Object)"SimpleString");
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateLiteralExpression(null, String.class.getCanonicalName(), List.of())).isNull();
    }

    @Test
    public void createObject() {
        Assertions.assertThat((Object)this.expressionEvaluator.createObject(String.class.getCanonicalName(), List.of())).isNotNull();
        Assertions.assertThat((Object)this.expressionEvaluator.createObject(Map.class.getCanonicalName(), List.of(String.class.getCanonicalName(), String.class.getCanonicalName()))).isInstanceOf(Map.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.expressionEvaluator.createObject("com.invalid.class.Name", List.of())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Impossible to instantiate com.invalid.class.Name");
    }

    @Test
    public void verifyNullTest() {
        Assertions.assertThat((Object)this.expressionEvaluator.verifyResult("[]", null, null)).is(this.successful);
        Assertions.assertThat((Object)this.expressionEvaluator.verifyResult("[{\"value\" : \"result\"}]", null, null)).is(this.notSuccessful);
    }

    @Test
    public void nullResultTest() {
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression("> 1", null, null)).is(this.notSuccessful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression("", null, null)).is(this.successful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(null, null, null)).is(this.successful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression("{}", null, Map.class)).is(this.successful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression("[]", null, List.class)).is(this.successful);
        String mapOfListJson = "{\"key1\" : [{\"value\" : \"value1\"}, {\"value\" : \"value2\"}]}";
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(mapOfListJson, Map.of(), Map.class)).is(this.notSuccessful);
    }

    public void convertResult_list() {
        String listJsonString = "[{\"value\" : \"10\"}, {\"value\" : \"12\"}]";
        List result = (List)this.expressionEvaluator.convertResult(listJsonString, List.class.getCanonicalName(), List.of(Integer.class.getCanonicalName()));
        Assertions.assertThat((List)result).hasSize(2);
        Assertions.assertThat((List)result).containsExactly((Object[])new Integer[]{10, 12});
    }

    @Test
    public void convertResult_mapOfStringToString() {
        List<String> genericClasses = List.of(String.class.getCanonicalName(), String.class.getCanonicalName());
        String givenWorkbenchMapString = "{ \"Home\": { \"value\": \"123 Any Street\" } }";
        Map parsedWorkbench = (Map)this.expressionEvaluator.convertResult(givenWorkbenchMapString, Map.class.getCanonicalName(), genericClasses);
        ((MapAssert)Assertions.assertThat((Map)parsedWorkbench).hasSize(1)).containsEntry((Object)"Home", (Object)"123 Any Street");
    }

    @Test
    public void evaluateUnaryExpression_mapOfStringToString() {
        String stringToString = "{\"key1\" : {\"value\" : \"value1\"}, \"key2\" : {\"value\" : \"value2\"}}";
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(stringToString, Map.of("key1", "value1"), Map.class)).is(this.notSuccessful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(stringToString, Map.of("key1", "value1", "key2", "value2"), Map.class)).is(this.successful);
    }

    @Test
    public void evaluateUnaryExpression_mapOfStringToString_empty() {
        String mapOfStringJson1 = "{\"key1\" : {\"value\" : \"\"}}";
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(mapOfStringJson1, Map.of(), Map.class)).is(this.successful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(mapOfStringJson1, Map.of("key1", "value1"), Map.class)).is(this.successful);
    }

    @Test
    public void convertResult_mapOfStringToInteger() {
        List<String> genericClasses = List.of(String.class.getCanonicalName(), Integer.class.getCanonicalName());
        String givenWorkbenchMapInteger = "{ \"Home\": { \"value\": \"100\" } }";
        Map parsedMap = (Map)this.expressionEvaluator.convertResult(givenWorkbenchMapInteger, Map.class.getCanonicalName(), genericClasses);
        ((MapAssert)Assertions.assertThat((Map)parsedMap).hasSize(1)).containsEntry((Object)"Home", (Object)100);
    }

    @Test
    public void convertResult_listMapToString() {
        String mapJsonString = "{\"first\": {\"name\": \"John\"}}";
        Map parsedMap = (Map)this.expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), List.of(ListMapClass.class.getCanonicalName()));
        Assertions.assertThat((Map)parsedMap).hasSize(1);
        Assertions.assertThat((String)((ListMapClass)parsedMap.get("first")).getName()).isEqualTo("John");
    }

    @Test
    public void convertResult_listMapToList() {
        String mapJsonString = "{\"first\": {\"siblings\": [{\"name\" : \"John\"}]}}";
        Map parsedMap = (Map)this.expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), List.of(ListMapClass.class.getCanonicalName()));
        Assertions.assertThat((Map)parsedMap).hasSize(1);
        Assertions.assertThat((String)((ListMapClass)parsedMap.get("first")).getSiblings().get(0).getName()).isEqualTo("John");
    }

    @Test
    public void convertResult_listMapToListMap() {
        String mapJsonString = "{\"first\": {\"phones\": {\"number\" : \"1\"}}}";
        Map parsedMap = (Map)this.expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), List.of(ListMapClass.class.getCanonicalName()));
        Assertions.assertThat((Map)parsedMap).hasSize(1);
        Assertions.assertThat((Integer)((ListMapClass)parsedMap.get("first")).getPhones().get("number")).isEqualTo((Object)1);
    }

    @Test
    public void convertResult_listOfComplexTypes() {
        String listJsonString = "[{\"name\": \"John\"}, {\"name\": \"John\", \"names\" : [{\"value\": \"Anna\"}, {\"value\": \"Mario\"}]}]";
        List parsedValue = (List)this.expressionEvaluator.convertResult(listJsonString, List.class.getCanonicalName(), List.of(ListMapClass.class.getCanonicalName()));
        Assertions.assertThat((List)parsedValue).hasSize(2);
        ((ListAssert)Assertions.assertThat(((ListMapClass)parsedValue.get(1)).getNames()).hasSize(2)).containsExactly((Object[])new String[]{"Anna", "Mario"});
    }

    @Test
    public void verifyResult_mapOfMapsofMaps_successful() {
        String mapJsonString = "{\"first\": {\"phones\": {\"number\" : \"> 1\"}}}";
        HashMap<String, ListMapClass> toCheck = new HashMap<String, ListMapClass>();
        ListMapClass element = new ListMapClass();
        HashMap<String, Integer> phones = new HashMap<String, Integer>();
        phones.put("number", 10);
        element.setPhones(phones);
        toCheck.put("first", element);
        Assertions.assertThat((Object)this.expressionEvaluator.verifyResult(mapJsonString, toCheck, null)).is(this.successful);
    }

    @Test
    public void verifyResult_mapOfMapsofMaps_notSuccessful() {
        String mapJsonString = "{\"first\": {\"phones\": {\"number\" : \"> 1\"}}}";
        HashMap toCheck = new HashMap();
        ListMapClass element = new ListMapClass();
        HashMap<String, Integer> phones = new HashMap<String, Integer>();
        phones.put("number", 10);
        element.setPhones(phones);
        phones.put("number", -1);
        Assertions.assertThat((Object)this.expressionEvaluator.verifyResult(mapJsonString, toCheck, null)).is(this.notSuccessful);
    }

    @Test
    public void verifyResult_listOfComplexTypeTest_success() {
        String listJsonString = "[{\"name\": \"John\"}, {\"name\": \"John\", \"names\" : [{\"value\": \"Anna\"}, {\"value\": \"Mario\"}]}]";
        List parsedValue = (List)this.expressionEvaluator.convertResult(listJsonString, List.class.getCanonicalName(), List.of(ListMapClass.class.getCanonicalName()));
        Assertions.assertThat((Object)this.expressionEvaluator.verifyResult(listJsonString, (Object)parsedValue, null)).is(this.successful);
    }

    @Test
    public void verifyResult_listOfComplexTypeTest_failure() {
        String listJsonString = "[{\"name\": \"John\"}, {\"name\": \"John\", \"names\" : [{\"value\": \"Anna\"}, {\"value\": \"Mario\"}]}]";
        List parsedValue = (List)this.expressionEvaluator.convertResult(listJsonString, List.class.getCanonicalName(), List.of(ListMapClass.class.getCanonicalName()));
        ((ListMapClass)parsedValue.get(1)).setNames(new ArrayList<String>());
        Assertions.assertThat((Object)this.expressionEvaluator.verifyResult(listJsonString, (Object)parsedValue, null)).is(this.notSuccessful);
    }

    @Test
    public void verifyResult_mapOfStringToInteger() {
        String expectWorkbenchMapInteger = "{ \"Home\": { \"value\": \"> 100\" } }";
        Assertions.assertThat((Object)this.expressionEvaluator.verifyResult(expectWorkbenchMapInteger, Map.of("Home", 120), null)).is(this.successful);
        Assertions.assertThat((Object)this.expressionEvaluator.verifyResult(expectWorkbenchMapInteger, Map.of("Home", 10), null)).is(this.notSuccessful);
    }

    @Test
    public void listOfSimpleTypeTest() {
        Assertions.assertThat((Object)this.expressionEvaluator.verifyResult("[{\"value\" : \"> 10\"}]", List.of(Integer.valueOf(13)), null)).is(this.successful);
        Assertions.assertThat((Object)this.expressionEvaluator.verifyResult("[{\"value\" : \"> 100\"}]", List.of(Integer.valueOf(13)), null)).is(this.notSuccessful);
        Assertions.assertThat((Object)this.expressionEvaluator.verifyResult("[{\"value\" : \"\"}]", List.of(Integer.valueOf(13)), null)).is(this.successful);
    }

    @Test
    public void expressionListVerifyResultTest() {
        String expressionCollectionJsonString = new TextNode("10").toString();
        List<BigDecimal> contextValue = List.of(BigDecimal.valueOf(10L));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.expressionEvaluator.verifyResult(expressionCollectionJsonString, (Object)contextValue, List.class));
    }

    @Test
    public void expressionMapVerifyResultTest() {
        String expressionCollectionJsonString = new TextNode("{key_a : 1}").toString();
        Map<String, BigDecimal> contextValue = Map.of("key_a", BigDecimal.valueOf(1L));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.expressionEvaluator.verifyResult(expressionCollectionJsonString, (Object)contextValue, Map.class));
    }
}

