/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.drltext.backend.server.indexing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.Version;
import org.drools.workbench.screens.drltext.backend.server.indexing.TestDrlFileIndexer;
import org.drools.workbench.screens.drltext.type.DRLResourceTypeDefinition;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.RuleAttributeNameAnalyzer;
import org.kie.workbench.common.services.refactoring.backend.server.query.QueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueRuleAttributeIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueRuleAttributeValueIndexTerm;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndex;
import org.uberfire.ext.metadata.engine.Index;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class IndexRuleAttributeNameAndValueCompositionTest
extends BaseIndexingTest<DRLResourceTypeDefinition> {
    @Test
    public void testIndexDrlRuleAttributeNameAndValueComposition() throws IOException, InterruptedException {
        Path path = this.basePath.resolve("drl5.drl");
        String drl = this.loadText("drl5.drl");
        this.ioService().write(path, drl, new OpenOption[0]);
        Thread.sleep(5000L);
        Index index = IndexRuleAttributeNameAndValueCompositionTest.getConfig().getIndexManager().get(KObjectUtil.toKCluster((FileSystem)this.basePath.getFileSystem()));
        IndexSearcher searcher = ((LuceneIndex)index).nrtSearcher();
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)10, (boolean)true);
        Query query = new QueryBuilder().addTerm((ValueIndexTerm)new ValueRuleAttributeIndexTerm("ruleflow-group")).addTerm((ValueIndexTerm)new ValueRuleAttributeValueIndexTerm("myRuleFlowGroup")).build();
        searcher.search(query, (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits.length);
        ArrayList<KObject> results = new ArrayList<KObject>();
        for (int i = 0; i < hits.length; ++i) {
            results.add(org.uberfire.ext.metadata.backend.lucene.util.KObjectUtil.toKObject((Document)searcher.doc(hits[i].doc)));
        }
        this.assertContains(results, path);
        ((LuceneIndex)index).nrtRelease(searcher);
        searcher = ((LuceneIndex)index).nrtSearcher();
        collector = TopScoreDocCollector.create((int)10, (boolean)true);
        query = new QueryBuilder().addTerm((ValueIndexTerm)new ValueRuleAttributeIndexTerm("ruleflow-group")).addTerm((ValueIndexTerm)new ValueRuleAttributeValueIndexTerm("myAgendaGroup")).build();
        searcher.search(query, (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)0L, (long)hits.length);
        ((LuceneIndex)index).nrtRelease(searcher);
    }

    protected TestIndexer getIndexer() {
        return new TestDrlFileIndexer();
    }

    public Map<String, Analyzer> getAnalyzers() {
        return new HashMap<String, Analyzer>(){
            {
                this.put("rule_attribute", new RuleAttributeNameAnalyzer(Version.LUCENE_40));
            }
        };
    }

    protected DRLResourceTypeDefinition getResourceTypeDefinition() {
        return new DRLResourceTypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

