/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dsltext.backend.server;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.screens.dsltext.service.DSLTextEditorService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.options.CommentedOption;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.kie.workbench.common.services.datamodel.events.InvalidateDMOPackageCacheEvent;
import org.kie.workbench.common.services.shared.file.CopyService;
import org.kie.workbench.common.services.shared.file.DeleteService;
import org.kie.workbench.common.services.shared.file.RenameService;
import org.kie.workbench.common.services.shared.metadata.MetadataService;
import org.kie.workbench.common.services.shared.metadata.model.Metadata;
import org.kie.workbench.common.services.shared.validation.model.BuilderResult;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.security.Identity;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceOpenedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@Service
@ApplicationScoped
public class DSLTextEditorServiceImpl
implements DSLTextEditorService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private MetadataService metadataService;
    @Inject
    private CopyService copyService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private Event<InvalidateDMOPackageCacheEvent> invalidateDMOPackageCache;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    private Event<ResourceAddedEvent> resourceAddedEvent;
    @Inject
    private Event<ResourceUpdatedEvent> resourceUpdatedEvent;
    @Inject
    private Paths paths;
    @Inject
    private Identity identity;

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, String content, String comment) {
        Path nioPath = this.paths.convert(context).resolve(fileName);
        org.uberfire.backend.vfs.Path newPath = this.paths.convert(nioPath, false);
        this.ioService.createFile(nioPath, new FileAttribute[0]);
        this.ioService.write(nioPath, content, new OpenOption[]{this.makeCommentedOption(comment)});
        this.resourceAddedEvent.fire((Object)new ResourceAddedEvent(newPath));
        return newPath;
    }

    public String load(org.uberfire.backend.vfs.Path path) {
        String content = this.ioService.readAllString(this.paths.convert(path));
        this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path));
        return content;
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, String content, Metadata metadata, String comment) {
        this.ioService.write(this.paths.convert(resource), content, this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.makeCommentedOption(comment)});
        this.invalidateDMOPackageCache.fire((Object)new InvalidateDMOPackageCacheEvent(resource));
        this.resourceUpdatedEvent.fire((Object)new ResourceUpdatedEvent(resource));
        return resource;
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        this.deleteService.delete(path, comment);
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        return this.renameService.rename(path, newName, comment);
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        return this.copyService.copy(path, newName, comment);
    }

    public BuilderResult validate(org.uberfire.backend.vfs.Path path, String content) {
        return new BuilderResult();
    }

    public boolean isValid(org.uberfire.backend.vfs.Path path, String content) {
        return !this.validate(path, content).hasLines();
    }

    private CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getName();
        Date when = new Date();
        CommentedOption co = new CommentedOption(name, null, commitMessage, when);
        return co;
    }
}

