/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dsltext.backend.server.indexing;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.drools.workbench.screens.dsltext.backend.server.indexing.TestDslFileIndexer;
import org.drools.workbench.screens.dsltext.type.DSLResourceTypeDefinition;
import org.hamcrest.Matcher;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.RuleAttributeNameAnalyzer;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.BasicQueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueTypeIndexTerm;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.metadata.engine.Index;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class IndexDslInvalidDrlTest
extends BaseIndexingTest<DSLResourceTypeDefinition> {
    @Test
    public void testIndexDslInvalidDrl() throws IOException, InterruptedException {
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        Appender mockAppender = (Appender)Mockito.mock(Appender.class);
        Mockito.when((Object)mockAppender.getName()).thenReturn((Object)"MOCK");
        root.addAppender(mockAppender);
        Path path = this.basePath.resolve("bz1269366.dsl");
        String dsl = this.loadText("bz1269366.dsl");
        this.ioService().write(path, dsl, new OpenOption[0]);
        Thread.sleep(5000L);
        Index index = IndexDslInvalidDrlTest.getConfig().getIndexManager().get(KObjectUtil.toKCluster((FileSystem)this.basePath.getFileSystem()));
        Query query = new BasicQueryBuilder().addTerm((ValueIndexTerm)new ValueTypeIndexTerm("org.drools.workbench.screens.dsltext.backend.server.indexing.classes.Applicant")).build();
        this.searchFor(index, query, 0, new Path[0]);
        ((Appender)Mockito.verify((Object)mockAppender)).doAppend(Matchers.argThat((Matcher)new ArgumentMatcher<ILoggingEvent>(){

            public boolean matches(Object argument) {
                return ((ILoggingEvent)argument).getMessage().startsWith("Unable to parse DRL");
            }
        }));
    }

    protected TestIndexer getIndexer() {
        return new TestDslFileIndexer();
    }

    public Map<String, Analyzer> getAnalyzers() {
        return new HashMap<String, Analyzer>(){
            {
                this.put("ruleAttribute", new RuleAttributeNameAnalyzer());
            }
        };
    }

    protected DSLResourceTypeDefinition getResourceTypeDefinition() {
        return new DSLResourceTypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

