/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.client.handlers;

import com.google.gwt.user.client.Command;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.drools.workbench.screens.dtablexls.client.handlers.FileExtensionSelector;
import org.drools.workbench.screens.dtablexls.client.handlers.NewDecisionTableXLSHandler;
import org.drools.workbench.screens.dtablexls.client.type.DecisionTableXLSResourceType;
import org.drools.workbench.screens.dtablexls.client.type.DecisionTableXLSXResourceType;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.bus.client.api.ClientMessageBus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.widget.AttachmentFileWidget;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class NewDecisionTableXLSHandlerTest {
    private NewDecisionTableXLSHandler handler;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private BusyIndicatorView busyIndicatorView;
    @Mock
    private NewResourcePresenter newResourcePresenter;
    @Mock
    private ClientMessageBus clientMessageBus;
    @GwtMock
    private FileExtensionSelector fileExtensionSelector;
    @GwtMock
    private AttachmentFileWidget uploadWidget;
    @Captor
    private ArgumentCaptor<Command> successCmdCaptor;
    @Captor
    private ArgumentCaptor<Command> failureCmdCaptor;
    @Captor
    private ArgumentCaptor<Path> newPathCaptor;
    private DecisionTableXLSResourceType decisionTableXLSResourceType = new DecisionTableXLSResourceType();
    private DecisionTableXLSXResourceType decisionTableXLSXResourceType = new DecisionTableXLSXResourceType();
    @Mock
    private EventSourceMock<NotificationEvent> mockNotificationEvent;

    @Before
    public void setup() {
        this.handler = new NewDecisionTableXLSHandler(this.placeManager, this.decisionTableXLSResourceType, this.decisionTableXLSXResourceType, this.busyIndicatorView, this.clientMessageBus){
            {
                this.notificationEvent = NewDecisionTableXLSHandlerTest.this.mockNotificationEvent;
            }

            protected String encode(String fileName) {
                return NewDecisionTableXLSHandlerTest.this.encode(fileName);
            }

            protected String getClientId() {
                return "123";
            }
        };
        this.handler.setFileExtensionSelector(this.fileExtensionSelector);
        this.handler.setUploadWidget(this.uploadWidget);
        Mockito.when((Object)this.fileExtensionSelector.getResourceType()).thenReturn((Object)this.decisionTableXLSResourceType);
    }

    @Test
    public void testSuccess() {
        String fileName = "fileName";
        Package pkg = (Package)Mockito.mock(Package.class);
        Path resourcesPath = PathFactory.newPath((String)"resources", (String)"default://project/src/main/resources");
        Mockito.when((Object)pkg.getPackageMainResourcesPath()).thenReturn((Object)resourcesPath);
        this.handler.create(pkg, "fileName", this.newResourcePresenter);
        ((AttachmentFileWidget)Mockito.verify((Object)this.uploadWidget, (VerificationMode)Mockito.times((int)1))).submit((Path)Mockito.eq((Object)resourcesPath), (String)Mockito.eq((Object)("fileName." + this.decisionTableXLSResourceType.getSuffix())), (String)Mockito.any(String.class), (Command)this.successCmdCaptor.capture(), (Command)this.failureCmdCaptor.capture());
        ((Command)this.successCmdCaptor.getValue()).execute();
        ((BusyIndicatorView)Mockito.verify((Object)this.busyIndicatorView, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((NewResourcePresenter)Mockito.verify((Object)this.newResourcePresenter, (VerificationMode)Mockito.times((int)1))).complete();
        ((EventSourceMock)Mockito.verify(this.mockNotificationEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(NotificationEvent.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo((Path)this.newPathCaptor.capture());
        Assert.assertEquals((Object)"default://project/src/main/resources/fileName.xls", (Object)((Path)this.newPathCaptor.getValue()).toURI());
    }

    @Test
    public void testSuccessMultiByteProjectName() {
        String fileName = "fileName";
        Package pkg = (Package)Mockito.mock(Package.class);
        Path resourcesPath = PathFactory.newPath((String)"resources", (String)"default://\u3042\u3042\u3042/src/main/resources");
        Mockito.when((Object)pkg.getPackageMainResourcesPath()).thenReturn((Object)resourcesPath);
        this.handler.create(pkg, "fileName", this.newResourcePresenter);
        ((AttachmentFileWidget)Mockito.verify((Object)this.uploadWidget, (VerificationMode)Mockito.times((int)1))).submit((Path)Mockito.eq((Object)resourcesPath), (String)Mockito.eq((Object)("fileName." + this.decisionTableXLSResourceType.getSuffix())), (String)Mockito.any(String.class), (Command)this.successCmdCaptor.capture(), (Command)this.failureCmdCaptor.capture());
        ((Command)this.successCmdCaptor.getValue()).execute();
        ((BusyIndicatorView)Mockito.verify((Object)this.busyIndicatorView, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((NewResourcePresenter)Mockito.verify((Object)this.newResourcePresenter, (VerificationMode)Mockito.times((int)1))).complete();
        ((EventSourceMock)Mockito.verify(this.mockNotificationEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(NotificationEvent.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo((Path)this.newPathCaptor.capture());
        Assert.assertEquals((Object)"default://\u3042\u3042\u3042/src/main/resources/fileName.xls", (Object)((Path)this.newPathCaptor.getValue()).toURI());
    }

    @Test
    public void testSuccessMultiByteFileName() {
        String fileName = "\u3042\u3042\u3042";
        Package pkg = (Package)Mockito.mock(Package.class);
        Path resourcesPath = PathFactory.newPath((String)"resources", (String)"default://project/src/main/resources");
        Mockito.when((Object)pkg.getPackageMainResourcesPath()).thenReturn((Object)resourcesPath);
        this.handler.create(pkg, "\u3042\u3042\u3042", this.newResourcePresenter);
        ((AttachmentFileWidget)Mockito.verify((Object)this.uploadWidget, (VerificationMode)Mockito.times((int)1))).submit((Path)Mockito.eq((Object)resourcesPath), (String)Mockito.eq((Object)("\u3042\u3042\u3042." + this.decisionTableXLSResourceType.getSuffix())), (String)Mockito.any(String.class), (Command)this.successCmdCaptor.capture(), (Command)this.failureCmdCaptor.capture());
        ((Command)this.successCmdCaptor.getValue()).execute();
        ((BusyIndicatorView)Mockito.verify((Object)this.busyIndicatorView, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((NewResourcePresenter)Mockito.verify((Object)this.newResourcePresenter, (VerificationMode)Mockito.times((int)1))).complete();
        ((EventSourceMock)Mockito.verify(this.mockNotificationEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(NotificationEvent.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo((Path)this.newPathCaptor.capture());
        Assert.assertEquals((Object)"default://project/src/main/resources/%E3%81%82%E3%81%82%E3%81%82.xls", (Object)((Path)this.newPathCaptor.getValue()).toURI());
    }

    @Test
    public void testSuccessMultiByteProjectNameAndFileName() {
        String fileName = "\u3042\u3042\u3042";
        Package pkg = (Package)Mockito.mock(Package.class);
        Path resourcesPath = PathFactory.newPath((String)"resources", (String)("default://" + this.encode("\u3042\u3042") + "/src/main/resources"));
        Mockito.when((Object)pkg.getPackageMainResourcesPath()).thenReturn((Object)resourcesPath);
        this.handler.create(pkg, "\u3042\u3042\u3042", this.newResourcePresenter);
        ((AttachmentFileWidget)Mockito.verify((Object)this.uploadWidget, (VerificationMode)Mockito.times((int)1))).submit((Path)Mockito.eq((Object)resourcesPath), (String)Mockito.eq((Object)("\u3042\u3042\u3042." + this.decisionTableXLSResourceType.getSuffix())), (String)Mockito.any(String.class), (Command)this.successCmdCaptor.capture(), (Command)this.failureCmdCaptor.capture());
        ((Command)this.successCmdCaptor.getValue()).execute();
        ((BusyIndicatorView)Mockito.verify((Object)this.busyIndicatorView, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((NewResourcePresenter)Mockito.verify((Object)this.newResourcePresenter, (VerificationMode)Mockito.times((int)1))).complete();
        ((EventSourceMock)Mockito.verify(this.mockNotificationEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(NotificationEvent.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo((Path)this.newPathCaptor.capture());
        Assert.assertEquals((Object)"default://%E3%81%82%E3%81%82/src/main/resources/%E3%81%82%E3%81%82%E3%81%82.xls", (Object)((Path)this.newPathCaptor.getValue()).toURI());
    }

    @Test
    public void testGetServletUrl() {
        Assert.assertEquals((Object)"dtablexls/file?clientId=123", (Object)this.handler.getServletUrl());
    }

    private String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            Assert.fail((String)uee.getMessage());
            return "";
        }
    }
}

