/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.client.editor;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.dtablexls.client.editor.DecisionTableXLSEditorPresenter;
import org.drools.workbench.screens.dtablexls.client.editor.DecisionTableXLSEditorView;
import org.drools.workbench.screens.dtablexls.client.editor.DecisionTableXLSEditorViewImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.widget.AttachmentFileWidget;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.workbench.type.ClientResourceType;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableXLSEditorViewImplTest {
    private static final String SERVLET_URL = "dtablexls/file?clientId=123";
    private DecisionTableXLSEditorViewImpl view;
    @Mock
    AttachmentFileWidget attachmentFileWidget;
    @Mock
    ClientResourceType type;
    @Mock
    DecisionTableXLSEditorPresenter presenter;
    @Captor
    ArgumentCaptor<ClickHandler> clickCaptor;

    @Before
    public void setup() {
        this.view = new DecisionTableXLSEditorViewImpl(){

            String getClientId() {
                return "123";
            }

            protected AttachmentFileWidget constructUploadWidget(ClientResourceType resourceTypeDefinition) {
                return DecisionTableXLSEditorViewImplTest.this.attachmentFileWidget;
            }
        };
        this.view.init((DecisionTableXLSEditorView.Presenter)this.presenter);
    }

    @Test
    public void testGetDownloadUrl() throws Exception {
        Assert.assertEquals((Object)"dtablexls/file?clientId=123&attachmentPath=", (Object)this.view.getDownloadUrl(this.path()));
    }

    @Test
    public void getServletUrl() throws Exception {
        Assert.assertEquals((Object)SERVLET_URL, (Object)this.view.getServletUrl());
    }

    @Test
    public void testUploadWidgetClickHandler() throws Exception {
        ((DecisionTableXLSEditorPresenter)Mockito.doCallRealMethod().when((Object)this.presenter)).onUpload();
        this.view.setupUploadWidget(this.type);
        ((AttachmentFileWidget)Mockito.verify((Object)this.attachmentFileWidget)).addClickHandler((ClickHandler)this.clickCaptor.capture());
        ((ClickHandler)this.clickCaptor.getValue()).onClick(null);
        ((DecisionTableXLSEditorPresenter)Mockito.verify((Object)this.presenter)).submit();
    }

    @Test
    public void testSubmit() throws Exception {
        Path path = (Path)Mockito.mock(Path.class);
        this.view.setupUploadWidget(this.type);
        this.view.submit(path);
        ((AttachmentFileWidget)Mockito.verify((Object)this.attachmentFileWidget)).submit((Path)Matchers.eq((Object)path), (String)Matchers.eq((Object)SERVLET_URL), (Command)Matchers.any(Command.class), (Command)Matchers.any(Command.class));
    }

    private Path path() {
        return new Path(){

            public String getFileName() {
                return "";
            }

            public String toURI() {
                return "";
            }

            public int compareTo(Path o) {
                return 0;
            }
        };
    }
}

