/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.client.editor;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.List;
import java.util.Optional;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionResult;
import org.drools.workbench.screens.dtablexls.client.editor.DecisionTableXLSEditorPresenter;
import org.drools.workbench.screens.dtablexls.client.editor.DecisionTableXLSEditorView;
import org.drools.workbench.screens.dtablexls.client.resources.DecisionTableXLSResources;
import org.drools.workbench.screens.dtablexls.client.resources.i18n.DecisionTableXLSEditorConstants;
import org.drools.workbench.screens.dtablexls.client.resources.images.DecisionTableXLSImageResources;
import org.drools.workbench.screens.dtablexls.client.type.DecisionTableXLSResourceType;
import org.drools.workbench.screens.dtablexls.client.type.DecisionTableXLSXResourceType;
import org.drools.workbench.screens.dtablexls.service.DecisionTableXLSContent;
import org.drools.workbench.screens.dtablexls.service.DecisionTableXLSService;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.guvnor.messageconsole.client.console.widget.button.AlertsButtonMenuItemBuilder;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilderImpl;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.metadata.client.KieEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.validation.AssetUpdateValidator;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.promise.Promises;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.ConcurrentChangePopup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.promise.SyncPromises;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={ConcurrentChangePopup.class})
public class DecisionTableXLSEditorPresenterTest {
    @GwtMock
    DecisionTableXLSImageResources decisionTableXLSImageResources;
    @GwtMock
    DecisionTableXLSResources decisionTableXLSResources;
    @GwtMock
    DecisionTableXLSEditorConstants decisionTableXLSEditorConstants;
    @Mock
    DecisionTableXLSResourceType decisionTableXLSResourceType;
    @Mock
    DecisionTableXLSXResourceType decisionTableXLSXResourceType;
    @Mock
    ObservablePath XLSPath;
    @Mock
    ObservablePath XLSXPath;
    @Mock
    DecisionTableXLSEditorView view;
    @Mock
    BusyIndicatorView busyIndicatorView;
    @Mock
    KieEditorWrapperView kieView;
    @Mock
    ValidationPopup validationPopup;
    @Mock
    BasicFileMenuBuilder menuBuilder;
    @Mock
    VersionRecordManager versionRecordManager;
    @Spy
    @InjectMocks
    FileMenuBuilderImpl fileMenuBuilder;
    @Mock
    ProjectController projectController;
    @Mock
    WorkspaceProjectContext workbenchContext;
    @Mock
    AlertsButtonMenuItemBuilder alertsButtonMenuItemBuilder;
    Promises promises;
    @Mock
    MenuItem alertsButtonMenuItem;
    DecisionTableXLSEditorPresenter presenter;

    @Before
    public void setUp() throws Exception {
        this.promises = new SyncPromises();
        Mockito.when((Object)this.decisionTableXLSResourceType.getSuffix()).thenReturn((Object)"XLS");
        Mockito.when((Object)this.decisionTableXLSResourceType.accept((Path)this.XLSPath)).thenReturn((Object)true);
        Mockito.when((Object)this.decisionTableXLSResourceType.accept((Path)this.XLSXPath)).thenReturn((Object)false);
        Mockito.when((Object)this.decisionTableXLSXResourceType.getSuffix()).thenReturn((Object)"XLSX");
        Mockito.when((Object)this.decisionTableXLSXResourceType.accept((Path)this.XLSPath)).thenReturn((Object)false);
        Mockito.when((Object)this.decisionTableXLSXResourceType.accept((Path)this.XLSXPath)).thenReturn((Object)true);
        Mockito.when((Object)this.alertsButtonMenuItemBuilder.build()).thenReturn((Object)this.alertsButtonMenuItem);
        this.presenter = (DecisionTableXLSEditorPresenter)Mockito.spy((Object)new DecisionTableXLSEditorPresenter(this.view, this.decisionTableXLSResourceType, this.decisionTableXLSXResourceType, this.busyIndicatorView, this.validationPopup, new ServiceMock()){
            {
                this.kieView = (KieEditorWrapperView)Mockito.mock(KieEditorWrapperView.class);
                this.overviewWidget = (OverviewWidgetPresenter)Mockito.mock(OverviewWidgetPresenter.class);
                this.concurrentUpdateSessionInfo = null;
                this.fileMenuBuilder = DecisionTableXLSEditorPresenterTest.this.fileMenuBuilder;
                this.projectController = DecisionTableXLSEditorPresenterTest.this.projectController;
                this.workbenchContext = DecisionTableXLSEditorPresenterTest.this.workbenchContext;
                this.versionRecordManager = DecisionTableXLSEditorPresenterTest.this.versionRecordManager;
                this.alertsButtonMenuItemBuilder = DecisionTableXLSEditorPresenterTest.this.alertsButtonMenuItemBuilder;
                this.promises = DecisionTableXLSEditorPresenterTest.this.promises;
            }

            protected void addSourcePage() {
            }
        });
        ((DecisionTableXLSEditorPresenter)Mockito.doNothing().when((Object)this.presenter)).addDownloadMenuItem((FileMenuBuilder)Matchers.any());
        ((DecisionTableXLSEditorPresenter)Mockito.doReturn((Object)Mockito.mock(MenuItem.class)).when((Object)this.presenter)).getConvertMenu();
        Mockito.when((Object)this.workbenchContext.getActiveOrganizationalUnit()).thenReturn(Optional.empty());
        Mockito.when((Object)this.workbenchContext.getActiveWorkspaceProject()).thenReturn(Optional.empty());
    }

    @Test
    public void testXLSSetup() throws Exception {
        this.presenter.onStartup(this.XLSPath, (PlaceRequest)Mockito.mock(PlaceRequest.class));
        ((DecisionTableXLSEditorView)Mockito.verify((Object)this.view)).init((Object)this.presenter);
        ((DecisionTableXLSEditorView)Mockito.verify((Object)this.view)).setupUploadWidget((ClientResourceType)this.decisionTableXLSResourceType);
        ((DecisionTableXLSEditorView)Mockito.verify((Object)this.view)).setPath((Path)Matchers.any(Path.class));
        ((DecisionTableXLSEditorView)Mockito.verify((Object)this.view)).setReadOnly(false);
    }

    @Test
    public void testXLSXSetup() throws Exception {
        this.presenter.onStartup(this.XLSXPath, (PlaceRequest)Mockito.mock(PlaceRequest.class));
        ((DecisionTableXLSEditorView)Mockito.verify((Object)this.view)).init((Object)this.presenter);
        ((DecisionTableXLSEditorView)Mockito.verify((Object)this.view)).setupUploadWidget((ClientResourceType)this.decisionTableXLSXResourceType);
        ((DecisionTableXLSEditorView)Mockito.verify((Object)this.view)).setPath((Path)Matchers.any(Path.class));
        ((DecisionTableXLSEditorView)Mockito.verify((Object)this.view)).setReadOnly(false);
    }

    @Test
    public void testOnUploadWhenConcurrentUpdateSessionInfoIsNull() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        ((VersionRecordManager)Mockito.doReturn((Object)path).when((Object)this.versionRecordManager)).getCurrentPath();
        this.presenter.onUpload();
        ((DecisionTableXLSEditorView)Mockito.verify((Object)this.view)).submit((Path)path);
        Assert.assertNull((Object)this.presenter.getConcurrentUpdateSessionInfo());
    }

    @Test
    public void testOnUploadWhenConcurrentUpdateSessionInfoIsNotNull() {
        this.presenter = (DecisionTableXLSEditorPresenter)Mockito.spy((Object)new DecisionTableXLSEditorPresenter(null, null, null, this.busyIndicatorView, null, null){
            {
                this.concurrentUpdateSessionInfo = (ObservablePath.OnConcurrentUpdateEvent)Mockito.mock(ObservablePath.OnConcurrentUpdateEvent.class);
            }
        });
        this.presenter.onUpload();
        ((BusyIndicatorView)Mockito.verify((Object)this.busyIndicatorView)).hideBusyIndicator();
        ((DecisionTableXLSEditorPresenter)Mockito.verify((Object)this.presenter)).showConcurrentUpdateError();
        ((VersionRecordManager)Mockito.verify((Object)this.versionRecordManager, (VerificationMode)Mockito.never())).reloadVersions((Path)this.versionRecordManager.getCurrentPath());
    }

    @Test
    public void testOnUploadSuccess() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        ((VersionRecordManager)Mockito.doReturn(null).when((Object)this.versionRecordManager)).getCurrentPath();
        ((VersionRecordManager)Mockito.doReturn((Object)path).when((Object)this.versionRecordManager)).getPathToLatest();
        this.presenter.onUploadSuccess();
        ((VersionRecordManager)Mockito.verify((Object)this.versionRecordManager)).getPathToLatest();
        ((VersionRecordManager)Mockito.verify((Object)this.versionRecordManager, (VerificationMode)Mockito.never())).getCurrentPath();
        ((VersionRecordManager)Mockito.verify((Object)this.versionRecordManager)).reloadVersions((Path)path);
    }

    @Test
    public void testMakeMenuBar() {
        ((WorkspaceProjectContext)Mockito.doReturn(Optional.of(Mockito.mock(WorkspaceProject.class))).when((Object)this.workbenchContext)).getActiveWorkspaceProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve((Object)true)).when((Object)this.projectController)).canUpdateProject((WorkspaceProject)Matchers.any());
        this.presenter.makeMenuBar();
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addCopy((Path)Matchers.any(Path.class), (Validator)Matchers.any(AssetUpdateValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addRename((Path)Matchers.any(Path.class), (Validator)Matchers.any(AssetUpdateValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addDelete((Path)Matchers.any(Path.class), (Validator)Matchers.any(AssetUpdateValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addNewTopLevelMenu(this.alertsButtonMenuItem);
        ((DecisionTableXLSEditorPresenter)Mockito.verify((Object)this.presenter)).addDownloadMenuItem((FileMenuBuilder)this.fileMenuBuilder);
    }

    @Test
    public void testMakeMenuBarWithoutUpdateProjectPermission() {
        ((WorkspaceProjectContext)Mockito.doReturn(Optional.of(Mockito.mock(WorkspaceProject.class))).when((Object)this.workbenchContext)).getActiveWorkspaceProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve((Object)false)).when((Object)this.projectController)).canUpdateProject((WorkspaceProject)Matchers.any());
        this.presenter.makeMenuBar();
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addCopy((Path)Matchers.any(Path.class), (Validator)Matchers.any(AssetUpdateValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addRename((Path)Matchers.any(Path.class), (Validator)Matchers.any(AssetUpdateValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addDelete((Path)Matchers.any(Path.class), (Validator)Matchers.any(AssetUpdateValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addNewTopLevelMenu(this.alertsButtonMenuItem);
    }

    private class ServiceMock
    implements Caller<DecisionTableXLSService> {
        private DecisionTableXLSService decisionTableXLSService = new DecisionTableXLSServiceMock();
        RemoteCallback remoteCallback;

        private ServiceMock() {
        }

        public DecisionTableXLSService call() {
            return this.decisionTableXLSService;
        }

        public DecisionTableXLSService call(RemoteCallback<?> remoteCallback) {
            return this.call(remoteCallback, (ErrorCallback<?>)null);
        }

        public DecisionTableXLSService call(RemoteCallback<?> remoteCallback, ErrorCallback<?> errorCallback) {
            this.remoteCallback = remoteCallback;
            return this.decisionTableXLSService;
        }

        private class DecisionTableXLSServiceMock
        implements DecisionTableXLSService {
            private DecisionTableXLSServiceMock() {
            }

            public ConversionResult convert(Path path) {
                return null;
            }

            public DecisionTableXLSContent loadContent(Path path) {
                DecisionTableXLSContent content = new DecisionTableXLSContent();
                content.setOverview(new Overview(){
                    {
                        this.setMetadata((Metadata)Mockito.mock(Metadata.class));
                    }
                });
                ServiceMock.this.remoteCallback.callback((Object)content);
                return null;
            }

            public String getSource(Path path) {
                return null;
            }

            public Path copy(Path path, String newName, String comment) {
                return null;
            }

            public Path copy(Path path, String newName, Path targetDirectory, String comment) {
                return null;
            }

            public void delete(Path path, String comment) {
            }

            public Path rename(Path path, String newName, String comment) {
                return null;
            }

            public List<ValidationMessage> validate(Path path, Path content) {
                return null;
            }
        }
    }
}

