/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.client.handlers;

import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.screens.dtablexls.client.editor.URLHelper;
import org.drools.workbench.screens.dtablexls.client.resources.DecisionTableXLSResources;
import org.drools.workbench.screens.dtablexls.client.resources.i18n.DecisionTableXLSEditorConstants;
import org.drools.workbench.screens.dtablexls.client.type.DecisionTableXLSResourceType;
import org.drools.workbench.screens.dtablexls.client.type.DecisionTableXLSXResourceType;
import org.guvnor.common.services.project.model.Package;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.jboss.errai.bus.client.api.ClientMessageBus;
import org.kie.workbench.common.widgets.client.handlers.DefaultNewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.handlers.NewResourceSuccessEvent;
import org.kie.workbench.common.widgets.client.widget.AttachmentFileWidget;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class NewDecisionTableXLSHandler
extends DefaultNewResourceHandler {
    private ClientMessageBus clientMessageBus;
    private PlaceManager placeManager;
    private DecisionTableXLSResourceType decisionTableXLSResourceType;
    private DecisionTableXLSXResourceType decisionTableXLSXResourceType;
    private BusyIndicatorView busyIndicatorView;
    private AttachmentFileWidget uploadWidget;

    public NewDecisionTableXLSHandler() {
    }

    @Inject
    public NewDecisionTableXLSHandler(PlaceManager placeManager, DecisionTableXLSResourceType decisionTableXLSResourceType, DecisionTableXLSXResourceType decisionTableXLSXResourceType, BusyIndicatorView busyIndicatorView, ClientMessageBus clientMessageBus) {
        this.placeManager = placeManager;
        this.decisionTableXLSResourceType = decisionTableXLSResourceType;
        this.decisionTableXLSXResourceType = decisionTableXLSXResourceType;
        this.busyIndicatorView = busyIndicatorView;
        this.clientMessageBus = clientMessageBus;
    }

    void setUploadWidget(AttachmentFileWidget uploadWidget) {
        this.uploadWidget = uploadWidget;
    }

    @PostConstruct
    private void setupExtensions() {
        this.uploadWidget = new AttachmentFileWidget(new String[]{this.decisionTableXLSResourceType.getSuffix(), this.decisionTableXLSXResourceType.getSuffix()});
        this.extensions.add(Pair.newPair((Object)DecisionTableXLSEditorConstants.INSTANCE.Upload(), (Object)this.uploadWidget));
    }

    public List<Pair<String, ? extends IsWidget>> getExtensions() {
        this.uploadWidget.reset();
        return super.getExtensions();
    }

    public String getDescription() {
        return DecisionTableXLSEditorConstants.INSTANCE.NewDecisionTableDescription();
    }

    public IsWidget getIcon() {
        return new Image(DecisionTableXLSResources.INSTANCE.images().typeXLSDecisionTable());
    }

    public ResourceTypeDefinition getResourceType() {
        return this.decisionTableXLSResourceType;
    }

    public void validate(String baseFileName, ValidatorWithReasonCallback callback) {
        if (this.uploadWidget.getFilenameSelectedToUpload() == null || this.uploadWidget.getFilenameSelectedToUpload().isEmpty()) {
            this.uploadWidget.addStyleName(ValidationState.ERROR.getCssName());
        } else {
            super.validate(baseFileName, callback);
        }
    }

    public void create(Package pkg, String baseFileName, final NewResourcePresenter presenter) {
        this.busyIndicatorView.showBusyIndicator(DecisionTableXLSEditorConstants.INSTANCE.Uploading());
        ClientResourceType type = this.uploadWidget.getFilenameSelectedToUpload().endsWith(this.decisionTableXLSResourceType.getSuffix()) ? this.decisionTableXLSResourceType : this.decisionTableXLSXResourceType;
        Path path = pkg.getPackageMainResourcesPath();
        String fileName = this.buildFileName(baseFileName, (ResourceTypeDefinition)type);
        final Path newPath = PathFactory.newPathBasedOn((String)fileName, (String)(path.toURI() + "/" + this.encode(fileName)), (Path)path);
        this.uploadWidget.submit(path, fileName, this.getServletUrl(), new Command(){

            public void execute() {
                NewDecisionTableXLSHandler.this.busyIndicatorView.hideBusyIndicator();
                presenter.complete();
                NewDecisionTableXLSHandler.this.notifySuccess();
                NewDecisionTableXLSHandler.this.newResourceSuccessEvent.fire((Object)new NewResourceSuccessEvent(newPath));
                NewDecisionTableXLSHandler.this.placeManager.goTo(newPath);
            }
        }, new Command(){

            public void execute() {
                NewDecisionTableXLSHandler.this.busyIndicatorView.hideBusyIndicator();
            }
        });
    }

    protected String getServletUrl() {
        return URLHelper.getServletUrl(this.getClientId());
    }

    protected String getClientId() {
        return this.clientMessageBus.getClientId();
    }

    protected String encode(String fileName) {
        return URL.encode((String)fileName);
    }
}

