/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.enums.backend.server.indexing;

import java.util.Map;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.DataEnumLoader;
import org.kie.workbench.common.services.refactoring.ResourceReference;
import org.kie.workbench.common.services.refactoring.backend.server.impact.ResourceReferenceCollector;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.Path;

public class EnumIndexVisitor
extends ResourceReferenceCollector {
    private static final Logger logger = LoggerFactory.getLogger(EnumIndexVisitor.class);
    private final ModuleDataModelOracle dmo;
    private final Path resourcePath;
    private final DataEnumLoader enumLoader;

    public EnumIndexVisitor(ModuleDataModelOracle dmo, Path resourcePath, DataEnumLoader enumLoader) {
        this.dmo = (ModuleDataModelOracle)PortablePreconditions.checkNotNull((String)"dmo", (Object)dmo);
        this.resourcePath = (Path)PortablePreconditions.checkNotNull((String)"resourcePath", (Object)resourcePath);
        this.enumLoader = (DataEnumLoader)PortablePreconditions.checkNotNull((String)"enumLoader", (Object)enumLoader);
    }

    public void visit() {
        if (this.enumLoader.hasErrors()) {
            logger.error("Errors when indexing " + this.resourcePath.toAbsolutePath().toFile().getAbsolutePath());
            return;
        }
        for (Map.Entry e : this.enumLoader.getData().entrySet()) {
            String typeName = this.getTypeName((String)e.getKey());
            String fullyQualifiedClassName = this.getFullyQualifiedClassName(typeName);
            String fieldName = this.getFieldName((String)e.getKey());
            String fieldFullyQualifiedClassName = this.getFieldFullyQualifiedClassName(fullyQualifiedClassName, fieldName);
            if (fullyQualifiedClassName == null) {
                logger.warn("Index entry will not be created for '" + (String)e.getKey() + "'. Unable to determine FQCN for '" + typeName + "'. ");
                continue;
            }
            ResourceReference resRef = this.addResourceReference(fullyQualifiedClassName, ResourceType.JAVA);
            if (fieldFullyQualifiedClassName == null) {
                logger.warn("Index entry will not be created for '" + (String)e.getKey() + "'. Unable to determine FQCN for '" + typeName + "." + fieldName + "'. ");
                continue;
            }
            resRef.addPartReference(fieldName, PartType.FIELD);
            this.addResourceReference(fieldFullyQualifiedClassName, ResourceType.JAVA);
        }
    }

    private String getTypeName(String key) {
        int hashIndex = key.indexOf("#");
        return key.substring(0, hashIndex);
    }

    private String getFieldName(String key) {
        int hashIndex = key.indexOf("#");
        return key.substring(hashIndex + 1);
    }

    private String getFullyQualifiedClassName(String typeName) {
        if (typeName.contains(".")) {
            return typeName;
        }
        for (Map.Entry e : this.dmo.getModuleModelFields().entrySet()) {
            String fqcn = (String)e.getKey();
            if (((String)e.getKey()).contains(".")) {
                fqcn = fqcn.substring(fqcn.lastIndexOf(".") + 1);
            }
            if (!fqcn.equals(typeName)) continue;
            return (String)e.getKey();
        }
        return null;
    }

    private String getFieldFullyQualifiedClassName(String fullyQualifiedClassName, String fieldName) {
        ModelField[] mfs = (ModelField[])this.dmo.getModuleModelFields().get(fullyQualifiedClassName);
        if (mfs != null) {
            for (ModelField mf : mfs) {
                if (!mf.getName().equals(fieldName)) continue;
                return mf.getClassName();
            }
        }
        return null;
    }
}

