/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.client.widget.palette;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.widget.LienzoPanel;
import com.ait.lienzo.shared.core.types.Color;
import com.ait.lienzo.shared.core.types.TextBaseLine;
import org.drools.workbench.screens.guided.dtree.client.widget.factories.ConstraintFactoryHelper;
import org.drools.workbench.screens.guided.dtree.client.widget.factories.TypeFactoryHelper;
import org.drools.workbench.screens.guided.dtree.client.widget.palette.GuidedDecisionTree;
import org.uberfire.ext.wires.core.api.factories.FactoryHelper;
import org.uberfire.ext.wires.core.api.factories.ShapeFactory;
import org.uberfire.ext.wires.core.api.factories.ShapeGlyph;
import org.uberfire.ext.wires.core.client.palette.PaletteShape;
import org.uberfire.ext.wires.core.client.palette.StencilPaletteBuilder;
import org.uberfire.ext.wires.core.client.util.ShapeFactoryUtil;

@GuidedDecisionTree
public class GuidedDecisionTreeStencilPaletteBuilder
extends StencilPaletteBuilder {
    private static final double GLYPH_WIDTH = 30.0;
    private static final double GLYPH_HEIGHT = 30.0;
    private static final int STENCIL_CORNER_RADIUS = 5;
    public static final int STENCIL_HEIGHT = 35;
    public static final int STENCIL_WIDTH = 275;

    public PaletteShape build(LienzoPanel dragProxyParentPanel, FactoryHelper helper, ShapeFactory factory, boolean isReadOnly) {
        if (!isReadOnly) {
            return super.build(dragProxyParentPanel, helper, factory);
        }
        PaletteShape paletteShape = new PaletteShape();
        ShapeGlyph glyph = this.drawGlyph(factory, helper);
        Text description = this.drawDescription(factory, helper);
        Rectangle bounding = this.drawBoundingBox(factory, helper);
        paletteShape.setBounding(bounding);
        paletteShape.setGroup(this.scaleGlyph(glyph));
        paletteShape.setDescription(description);
        return paletteShape;
    }

    protected Group scaleGlyph(ShapeGlyph glyph) {
        double sx = 30.0 / glyph.getWidth();
        double sy = 30.0 / glyph.getHeight();
        Group group = glyph.getGroup();
        return (Group)((Group)((Group)group.setX(17.0)).setY(17.0)).setScale(sx, sy);
    }

    protected Text drawDescription(ShapeFactory factory, FactoryHelper helper) {
        String description = factory.getShapeDescription();
        if (helper instanceof TypeFactoryHelper) {
            description = ((TypeFactoryHelper)helper).getContext().getClassName();
        } else if (helper instanceof ConstraintFactoryHelper) {
            description = ((ConstraintFactoryHelper)helper).getContext().getFieldName();
        }
        Text text = new Text(description, "oblique normal", 10.0);
        text.setFillColor(Color.rgbToBrowserHexColor((int)100, (int)100, (int)100));
        text.setTextBaseLine(TextBaseLine.MIDDLE);
        text.setX(35.0);
        text.setY(17.0);
        return text;
    }

    protected Rectangle drawBoundingBox(ShapeFactory factory, FactoryHelper helper) {
        Rectangle boundingBox = new Rectangle(275.0, 35.0, 5.0);
        ((Rectangle)((Rectangle)((Rectangle)boundingBox.setStrokeColor(ShapeFactoryUtil.RGB_STROKE_BOUNDING)).setStrokeWidth(1.0)).setFillColor(ShapeFactoryUtil.RGB_FILL_BOUNDING)).setDraggable(false);
        return boundingBox;
    }
}

