/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.client.widget.shapes;

import com.ait.lienzo.client.core.shape.Circle;
import com.ait.lienzo.shared.core.types.Color;
import com.google.gwt.i18n.client.DateTimeFormat;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.ConstraintNode;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.TypeNode;
import org.drools.workbench.models.guided.dtree.shared.model.values.Value;
import org.drools.workbench.models.guided.dtree.shared.model.values.impl.DateValue;
import org.drools.workbench.models.guided.dtree.shared.model.values.impl.StringValue;
import org.drools.workbench.screens.guided.dtree.client.widget.shapes.ActionRetractShape;
import org.drools.workbench.screens.guided.dtree.client.widget.shapes.ActionUpdateShape;
import org.drools.workbench.screens.guided.dtree.client.widget.shapes.BaseGuidedDecisionTreeShape;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.uberfire.ext.wires.core.trees.client.shapes.WiresBaseTreeNode;

public class ConstraintShape
extends BaseGuidedDecisionTreeShape<ConstraintNode> {
    private static final String DROOLS_DATE_FORMAT = ApplicationPreferences.getDroolsDateFormat();
    private static final DateTimeFormat DATE_FORMAT = DateTimeFormat.getFormat((String)DROOLS_DATE_FORMAT);

    public ConstraintShape(Circle shape, ConstraintNode node, boolean isReadOnly) {
        super(shape, node, isReadOnly);
        this.setNodeLabel(this.getNodeLabel());
        this.plus.setFillColor(Color.rgbToBrowserHexColor((int)0, (int)200, (int)0));
        this.plus.setStrokeColor(Color.rgbToBrowserHexColor((int)0, (int)150, (int)0));
    }

    @Override
    public String getNodeLabel() {
        StringBuilder sb = new StringBuilder();
        if (((ConstraintNode)this.node).isBound()) {
            sb.append(((ConstraintNode)this.node).getBinding()).append(" : ");
        }
        String fieldName = ((ConstraintNode)this.node).getFieldName();
        String operator = ((ConstraintNode)this.node).getOperator();
        Value value = ((ConstraintNode)this.node).getValue();
        if (fieldName != null) {
            sb.append(fieldName);
            if (operator != null) {
                sb.append(" ").append(operator);
                if (value != null) {
                    sb.append(" ").append(this.toString(value));
                }
            }
        }
        return sb.toString();
    }

    public boolean acceptChildNode(WiresBaseTreeNode child) {
        if (!(child instanceof BaseGuidedDecisionTreeShape)) {
            return false;
        }
        if (child instanceof ConstraintShape) {
            ConstraintShape cs = (ConstraintShape)child;
            if (!((ConstraintNode)this.node).getClassName().equals(((ConstraintNode)cs.getModelNode()).getClassName())) {
                return false;
            }
        }
        if (child instanceof ActionRetractShape || child instanceof ActionUpdateShape) {
            for (Object node = this.getModelNode(); node != null; node = node.getParent()) {
                if (!(node instanceof TypeNode) || !((TypeNode)node).isBound()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private String toString(Value value) {
        StringBuilder sb = new StringBuilder();
        if (value instanceof StringValue) {
            StringValue sv = (StringValue)value;
            return sb.append("\"").append(sv.getValue()).append("\"").toString();
        }
        if (value instanceof DateValue) {
            DateValue dv = (DateValue)value;
            return sb.append("\"").append(DATE_FORMAT.format(dv.getValue())).append("\"").toString();
        }
        return sb.append(value.getValue()).toString();
    }
}

