/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.models.guided.dtree.shared.model.GuidedDecisionTree;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.ActionInsertNode;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.ActionRetractNode;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.ActionUpdateNode;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.ConstraintNode;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.Node;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.TypeNode;
import org.drools.workbench.screens.guided.dtree.client.editor.GuidedDecisionTreeEditorView;
import org.drools.workbench.screens.guided.dtree.client.type.GuidedDTreeResourceType;
import org.drools.workbench.screens.guided.dtree.client.widget.popups.EditActionInsertPopup;
import org.drools.workbench.screens.guided.dtree.client.widget.popups.EditActionRetractPopup;
import org.drools.workbench.screens.guided.dtree.client.widget.popups.EditActionUpdatePopup;
import org.drools.workbench.screens.guided.dtree.client.widget.popups.EditConstraintPopup;
import org.drools.workbench.screens.guided.dtree.client.widget.popups.EditTypePopup;
import org.drools.workbench.screens.guided.dtree.client.widget.popups.ParserMessagesPopup;
import org.drools.workbench.screens.guided.dtree.model.GuidedDecisionTreeEditorContent;
import org.drools.workbench.screens.guided.dtree.service.GuidedDecisionTreeEditorService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.soup.project.datamodel.imports.HasImports;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.kie.workbench.common.widgets.client.datamodel.ImportAddedEvent;
import org.kie.workbench.common.widgets.client.datamodel.ImportRemovedEvent;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.configresource.client.widget.bound.ImportsWidgetPresenter;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.ext.widgets.common.client.callbacks.CommandErrorCallback;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@WorkbenchEditor(identifier="GuidedDecisionTreeEditorPresenter", supportedTypes={GuidedDTreeResourceType.class}, priority=101)
public class GuidedDecisionTreeEditorPresenter
extends KieEditor<GuidedDecisionTree> {
    @Inject
    private ImportsWidgetPresenter importsWidget;
    @Inject
    protected Caller<GuidedDecisionTreeEditorService> service;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    protected ValidationPopup validationPopup;
    @Inject
    private GuidedDTreeResourceType type;
    @Inject
    private AsyncPackageDataModelOracleFactory oracleFactory;
    private GuidedDecisionTree model;
    private AsyncPackageDataModelOracle oracle;
    private GuidedDecisionTreeEditorContent content;
    private GuidedDecisionTreeEditorView view;

    public GuidedDecisionTreeEditorPresenter() {
    }

    @Inject
    public GuidedDecisionTreeEditorPresenter(GuidedDecisionTreeEditorView baseView) {
        super((KieEditorView)baseView);
        this.view = baseView;
    }

    @PostConstruct
    public void init() {
        this.view.init((Object)this);
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.init(path, place, (ClientResourceType)this.type);
    }

    protected void loadContent() {
        this.view.showLoading();
        ((GuidedDecisionTreeEditorService)this.service.call(this.getModelSuccessCallback(), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)this.versionRecordManager.getCurrentPath());
    }

    protected Supplier<GuidedDecisionTree> getContentSupplier() {
        return () -> this.view.getModel();
    }

    protected Caller<? extends SupportsSaveAndRename<GuidedDecisionTree, Metadata>> getSaveAndRenameServiceCaller() {
        return this.service;
    }

    private RemoteCallback<GuidedDecisionTreeEditorContent> getModelSuccessCallback() {
        return new RemoteCallback<GuidedDecisionTreeEditorContent>(){

            public void callback(GuidedDecisionTreeEditorContent content) {
                if (GuidedDecisionTreeEditorPresenter.this.versionRecordManager.getCurrentPath() == null) {
                    return;
                }
                GuidedDecisionTreeEditorPresenter.this.content = content;
                GuidedDecisionTreeEditorPresenter.this.model = content.getModel();
                GuidedDecisionTreeEditorPresenter.this.metadata = content.getOverview().getMetadata();
                PackageDataModelOracleBaselinePayload dataModel = content.getDataModel();
                GuidedDecisionTreeEditorPresenter.this.oracle = GuidedDecisionTreeEditorPresenter.this.oracleFactory.makeAsyncPackageDataModelOracle((Path)GuidedDecisionTreeEditorPresenter.this.versionRecordManager.getCurrentPath(), (HasImports)GuidedDecisionTreeEditorPresenter.this.model, dataModel);
                GuidedDecisionTreeEditorPresenter.this.resetEditorPages(content.getOverview());
                GuidedDecisionTreeEditorPresenter.this.addSourcePage();
                GuidedDecisionTreeEditorPresenter.this.addImportsTab((IsWidget)GuidedDecisionTreeEditorPresenter.this.importsWidget);
                GuidedDecisionTreeEditorPresenter.this.importsWidget.setContent(GuidedDecisionTreeEditorPresenter.this.oracle, GuidedDecisionTreeEditorPresenter.this.model.getImports(), GuidedDecisionTreeEditorPresenter.this.isReadOnly);
                GuidedDecisionTreeEditorPresenter.this.view.setModel(GuidedDecisionTreeEditorPresenter.this.model, GuidedDecisionTreeEditorPresenter.this.isReadOnly);
                GuidedDecisionTreeEditorPresenter.this.view.setDataModel(GuidedDecisionTreeEditorPresenter.this.oracle, GuidedDecisionTreeEditorPresenter.this.isReadOnly);
                GuidedDecisionTreeEditorPresenter.this.view.hideBusyIndicator();
                if (!GuidedDecisionTreeEditorPresenter.this.model.getParserErrors().isEmpty()) {
                    ParserMessagesPopup popup = new ParserMessagesPopup(GuidedDecisionTreeEditorPresenter.this.model);
                    popup.show();
                }
                GuidedDecisionTreeEditorPresenter.this.createOriginalHash(GuidedDecisionTreeEditorPresenter.this.model);
            }
        };
    }

    public void onSourceTabSelected() {
        ((GuidedDecisionTreeEditorService)this.service.call((RemoteCallback)new RemoteCallback<String>(){

            public void callback(String source) {
                GuidedDecisionTreeEditorPresenter.this.updateSource(source);
            }
        })).toSource((Path)this.versionRecordManager.getCurrentPath(), (Object)this.model);
    }

    protected void onValidate(Command finished) {
        ((GuidedDecisionTreeEditorService)this.service.call((RemoteCallback)this.validationPopup.getValidationCallback(finished), (ErrorCallback)new CommandErrorCallback(finished))).validate((Path)this.versionRecordManager.getCurrentPath(), (Object)this.model);
    }

    protected void save(String commitMessage) {
        ((GuidedDecisionTreeEditorService)this.service.call(this.getSaveSuccessCallback(this.model.hashCode()), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).save((Path)this.versionRecordManager.getCurrentPath(), (Object)this.model, (Object)this.metadata, commitMessage);
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @OnClose
    public void onClose() {
        this.versionRecordManager.clear();
    }

    @OnMayClose
    public boolean mayClose() {
        return super.mayClose((Object)this.model);
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }

    public void handleImportAddedEvent(@Observes ImportAddedEvent event) {
        if (!event.getDataModelOracle().equals(this.oracle)) {
            return;
        }
        this.view.setDataModel(this.oracle, this.isReadOnly);
    }

    public void handleImportRemovedEvent(@Observes ImportRemovedEvent event) {
        if (!event.getDataModelOracle().equals(this.oracle)) {
            return;
        }
        this.view.setDataModel(this.oracle, this.isReadOnly);
    }

    public void editModelNode(Node node, final Command callback) {
        if (node instanceof TypeNode) {
            EditTypePopup popup = new EditTypePopup((TypeNode)node, new com.google.gwt.user.client.Command(){

                public void execute() {
                    callback.execute();
                }
            });
            popup.show();
        } else if (node instanceof ConstraintNode) {
            EditConstraintPopup popup = new EditConstraintPopup((ConstraintNode)node, this.oracle, new com.google.gwt.user.client.Command(){

                public void execute() {
                    callback.execute();
                }
            });
            popup.show();
        } else if (node instanceof ActionInsertNode) {
            EditActionInsertPopup popup = new EditActionInsertPopup((ActionInsertNode)node, this.oracle, new com.google.gwt.user.client.Command(){

                public void execute() {
                    callback.execute();
                }
            });
            popup.show();
        } else if (node instanceof ActionUpdateNode) {
            EditActionUpdatePopup popup = new EditActionUpdatePopup((ActionUpdateNode)node, this.oracle, new com.google.gwt.user.client.Command(){

                public void execute() {
                    callback.execute();
                }
            });
            popup.show();
        } else if (node instanceof ActionRetractNode) {
            EditActionRetractPopup popup = new EditActionRetractPopup((ActionRetractNode)node, new com.google.gwt.user.client.Command(){

                public void execute() {
                    callback.execute();
                }
            });
            popup.show();
        }
    }
}

