/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.client.widget.popups;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.ActionRetractNode;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.ActionUpdateNode;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.Node;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.TypeNode;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.impl.TypeNodeImpl;
import org.drools.workbench.screens.guided.dtree.client.resources.i18n.GuidedDecisionTreeConstants;
import org.drools.workbench.screens.guided.dtree.client.widget.utils.BindingUtilities;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.kie.workbench.common.widgets.client.widget.BindingTextBox;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class EditTypePopup
extends BaseModal {
    private static EditTypeBinder uiBinder = (EditTypeBinder)GWT.create(EditTypeBinder.class);
    private final TypeNode node;
    private final TypeNode clone;
    private final Command callback;
    private final Command okCommand = new Command(){

        public void execute() {
            EditTypePopup.this.onOKButtonClick();
        }
    };
    private final Command cancelCommand = new Command(){

        public void execute() {
            EditTypePopup.this.hide();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.okCommand, this.cancelCommand);
    @UiField
    Label classNameLabel;
    @UiField
    FormGroup bindingGroup;
    @UiField
    HelpBlock bindingHelpInline;
    @UiField
    BindingTextBox bindingTextBox;

    public EditTypePopup(TypeNode node, Command callback) {
        this.setTitle(GuidedDecisionTreeConstants.INSTANCE.popupTitleEditType());
        this.setBody((Widget)uiBinder.createAndBindUi((Object)this));
        this.add((Widget)this.footer);
        this.bindingTextBox.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                EditTypePopup.this.bindingGroup.setValidationState(ValidationState.NONE);
                EditTypePopup.this.bindingHelpInline.setText("");
            }
        });
        this.bindingTextBox.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                EditTypePopup.this.clone.setBinding(EditTypePopup.this.bindingTextBox.getText());
            }
        });
        this.node = node;
        this.clone = this.cloneNode(node);
        this.callback = callback;
        this.classNameLabel.setText(this.clone.getClassName());
        this.bindingTextBox.setText(this.clone.getBinding());
    }

    private TypeNode cloneNode(TypeNode node) {
        TypeNodeImpl clone = new TypeNodeImpl(node.getClassName());
        clone.setParent(node.getParent());
        clone.setBinding(node.getBinding());
        return clone;
    }

    private void onOKButtonClick() {
        boolean hasError = false;
        String binding = this.clone.getBinding();
        if (binding != null && !binding.isEmpty()) {
            if (!BindingUtilities.isUniqueInPath(binding, (Node)this.clone)) {
                this.bindingGroup.setValidationState(ValidationState.ERROR);
                this.bindingHelpInline.setText(GuidedDecisionTreeConstants.INSTANCE.bindingIsNotUnique());
                hasError = true;
            }
        } else if (this.hasBoundChildren((Node)this.node)) {
            this.bindingGroup.setValidationState(ValidationState.ERROR);
            this.bindingHelpInline.setText(GuidedDecisionTreeConstants.INSTANCE.bindingIsUsed());
            hasError = true;
        } else {
            this.bindingGroup.setValidationState(ValidationState.NONE);
        }
        if (hasError) {
            return;
        }
        this.node.setBinding(this.clone.getBinding());
        if (this.callback != null) {
            this.callback.execute();
        }
        this.hide();
    }

    private boolean hasBoundChildren(Node node) {
        for (Node n : node.getChildren()) {
            ActionUpdateNode aun;
            ActionRetractNode arn;
            if (n instanceof ActionRetractNode ? (arn = (ActionRetractNode)n).getBoundNode().equals(node) : n instanceof ActionUpdateNode && (aun = (ActionUpdateNode)n).getBoundNode().equals(node)) {
                return true;
            }
            if (!this.hasBoundChildren(n)) continue;
            return true;
        }
        return false;
    }

    static interface EditTypeBinder
    extends UiBinder<Widget, EditTypePopup> {
    }
}

