/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.client.widget.popups;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Widget;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.drools.workbench.models.datamodel.oracle.DropDownData;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.HasValue;
import org.drools.workbench.models.guided.dtree.shared.model.values.Value;
import org.drools.workbench.screens.guided.dtree.client.resources.i18n.GuidedDecisionTreeConstants;
import org.drools.workbench.screens.guided.dtree.client.widget.utils.ValueUtilities;
import org.gwtbootstrap3.client.ui.ListBox;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.widget.EnumDropDownUtilities;
import org.kie.workbench.common.widgets.client.widget.TextBoxFactory;
import org.uberfire.ext.widgets.common.client.common.DatePicker;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;

public abstract class ValueEditorFactory {
    private static final String DATE_FORMAT = ApplicationPreferences.getDroolsDateFormat();

    public Widget getValueEditor(String className, String fieldName, final HasValue hasValue, AsyncPackageDataModelOracle oracle, boolean isMultipleSelect) {
        DatePicker valueEditor;
        String dataType = oracle.getFieldType(className, fieldName);
        if (isMultipleSelect) {
            dataType = "String";
        }
        DropDownData dd = null;
        if (oracle.hasEnums(className, fieldName)) {
            Map<String, String> currentValueMap = this.getCurrentValueMap();
            dd = oracle.getEnums(className, fieldName, currentValueMap);
        }
        if (hasValue.getValue() == null) {
            Value value = ValueUtilities.makeEmptyValue(dataType);
            if (value == null) {
                ErrorPopup.showMessage((String)GuidedDecisionTreeConstants.INSTANCE.dataTypeNotSupported0(dataType));
                return null;
            }
            hasValue.setValue(value);
        }
        if (dataType.equals("Date")) {
            valueEditor = new DatePicker(false);
            valueEditor.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Date>(){

                public void onValueChange(ValueChangeEvent<Date> event) {
                    hasValue.getValue().setValue((Serializable)valueEditor.getValue());
                }
            });
            valueEditor.setFormat(DATE_FORMAT);
            valueEditor.setValue((Date)hasValue.getValue().getValue());
            return valueEditor;
        }
        if (dataType.equals("Boolean")) {
            valueEditor = new ListBox();
            valueEditor.addItem("true");
            valueEditor.addItem("false");
            valueEditor.addClickHandler(new ClickHandler((ListBox)valueEditor, hasValue){
                final /* synthetic */ ListBox val$valueEditor;
                final /* synthetic */ HasValue val$hasValue;
                {
                    this.val$valueEditor = listBox;
                    this.val$hasValue = hasValue;
                }

                public void onClick(ClickEvent event) {
                    String txtValue = this.val$valueEditor.getValue(this.val$valueEditor.getSelectedIndex());
                    Boolean value = Boolean.valueOf(txtValue);
                    this.val$hasValue.getValue().setValue((Serializable)value);
                }
            });
            valueEditor.setSelectedIndex(hasValue.getValue().getValue().equals(Boolean.TRUE) ? 0 : 1);
            return valueEditor;
        }
        if (dd != null) {
            valueEditor = this.makeListBox(dd, hasValue, oracle, isMultipleSelect);
            return valueEditor;
        }
        valueEditor = TextBoxFactory.getTextBox((String)dataType);
        valueEditor.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                hasValue.getValue().setValue((String)event.getValue());
            }
        });
        valueEditor.setText(ValueUtilities.convertNodeValue(hasValue.getValue()));
        return valueEditor;
    }

    protected abstract Map<String, String> getCurrentValueMap();

    private ListBox makeListBox(DropDownData dd, final HasValue hasValue, AsyncPackageDataModelOracle oracle, boolean isMultipleSelect) {
        final ListBox lb = new ListBox(isMultipleSelect);
        EnumDropDownUtilities utilities = new EnumDropDownUtilities(){

            protected int addItems(ListBox listBox) {
                return 0;
            }

            protected void selectItem(ListBox listBox) {
                int itemCount = listBox.getItemCount();
                listBox.setEnabled(itemCount > 0);
                if (itemCount > 0) {
                    listBox.setSelectedIndex(0);
                    hasValue.getValue().setValue(listBox.getValue(0));
                } else {
                    hasValue.getValue().setValue("");
                }
            }
        };
        String value = hasValue.getValue().getValue().toString();
        utilities.setDropDownData(value, dd, isMultipleSelect, oracle.getResourcePath(), lb);
        lb.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String value = null;
                if (lb.isMultipleSelect()) {
                    for (int i = 0; i < lb.getItemCount(); ++i) {
                        if (!lb.isItemSelected(i)) continue;
                        value = value == null ? lb.getValue(i) : value + "," + lb.getValue(i);
                    }
                } else {
                    int index = lb.getSelectedIndex();
                    if (index > -1) {
                        value = lb.getValue(index);
                    }
                }
                hasValue.getValue().setValue(value);
            }
        });
        return lb;
    }
}

