/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.client.widget.popups;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.ActionFieldValue;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.HasValue;
import org.drools.workbench.screens.guided.dtree.client.resources.i18n.GuidedDecisionTreeConstants;
import org.drools.workbench.screens.guided.dtree.client.widget.popups.ValueEditorFactory;
import org.drools.workbench.screens.guided.dtree.client.widget.utils.ValueUtilities;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.ListBox;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.uberfire.mvp.ParameterizedCommand;

public class ActionFieldValueEditor
extends Composite {
    private static ActionFieldValueEditorBinder uiBinder = (ActionFieldValueEditorBinder)GWT.create(ActionFieldValueEditorBinder.class);
    private final String className;
    private final ActionFieldValue afv;
    private final List<ActionFieldValue> afvs;
    private final AsyncPackageDataModelOracle oracle;
    private final ParameterizedCommand<ActionFieldValue> onDeleteCallback;
    private final ValueEditorFactory valueEditorFactory = new ValueEditorFactory(){

        @Override
        protected Map<String, String> getCurrentValueMap() {
            if (ActionFieldValueEditor.this.afvs == null) {
                return Collections.emptyMap();
            }
            HashMap<String, String> currentValueMap = new HashMap<String, String>();
            for (ActionFieldValue afv : ActionFieldValueEditor.this.afvs) {
                currentValueMap.put(afv.getFieldName(), ValueUtilities.convertNodeValue(afv.getValue()));
            }
            return currentValueMap;
        }
    };
    @UiField
    ListBox fieldListBox;
    @UiField
    FormGroup valueHolder;
    @UiField
    Button removeFieldValueButton;

    public ActionFieldValueEditor(String className, ActionFieldValue afv, List<ActionFieldValue> afvs, AsyncPackageDataModelOracle oracle, ParameterizedCommand<ActionFieldValue> onDeleteCallback) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.className = className;
        this.afv = afv;
        this.afvs = afvs;
        this.oracle = oracle;
        this.onDeleteCallback = onDeleteCallback;
        this.initializeFieldNames(afv);
    }

    private void initializeFieldNames(ActionFieldValue afv) {
        this.fieldListBox.clear();
        this.fieldListBox.setEnabled(false);
        this.oracle.getFieldCompletions(this.className, modelFields -> {
            this.fieldListBox.setEnabled(((ModelField[])modelFields).length > 0);
            if (((ModelField[])modelFields).length == 0) {
                this.fieldListBox.addItem(GuidedDecisionTreeConstants.INSTANCE.noFields());
                return;
            }
            int selectedIndex = -1;
            for (ModelField modelField : modelFields) {
                String fieldName = modelField.getName();
                if (fieldName.equals("this")) continue;
                this.fieldListBox.addItem(fieldName);
                if (!fieldName.equals(afv.getFieldName())) continue;
                selectedIndex = this.fieldListBox.getItemCount() - 1;
            }
            this.fieldListBox.addChangeHandler(event -> {
                String fieldName = this.fieldListBox.getItemText(this.fieldListBox.getSelectedIndex());
                afv.setFieldName(fieldName);
                afv.setValue(null);
                this.initialiseValue();
            });
            this.fieldListBox.setSelectedIndex(selectedIndex);
            if (selectedIndex == -1) {
                this.fieldListBox.setSelectedIndex(0);
                String fieldName = this.fieldListBox.getItemText(0);
                afv.setFieldName(fieldName);
            }
            this.initialiseValue();
        });
    }

    private void initialiseValue() {
        Widget editor = this.valueEditorFactory().getValueEditor(this.className, this.afv.getFieldName(), (HasValue)this.afv, this.oracle, false);
        this.valueHolder.clear();
        if (editor != null) {
            this.valueHolder.add(editor);
        }
    }

    ValueEditorFactory valueEditorFactory() {
        return this.valueEditorFactory;
    }

    @UiHandler(value={"removeFieldValueButton"})
    void onRemoveFieldValueButtonClick(ClickEvent event) {
        this.onDeleteCallback.execute((Object)this.afv);
    }

    static interface ActionFieldValueEditorBinder
    extends UiBinder<Widget, ActionFieldValueEditor> {
    }
}

