/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.client.widget.popups;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.ConstraintNode;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.HasValue;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.Node;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.impl.ConstraintNodeImpl;
import org.drools.workbench.screens.guided.dtree.client.resources.i18n.GuidedDecisionTreeConstants;
import org.drools.workbench.screens.guided.dtree.client.widget.popups.ValueEditorFactory;
import org.drools.workbench.screens.guided.dtree.client.widget.utils.BindingUtilities;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.kie.soup.project.datamodel.oracle.OperatorsOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.resources.HumanReadable;
import org.kie.workbench.common.widgets.client.widget.BindingTextBox;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class EditConstraintPopup
extends BaseModal {
    private static EditConstraintBinder uiBinder = (EditConstraintBinder)GWT.create(EditConstraintBinder.class);
    private final ConstraintNode node;
    private final ConstraintNode clone;
    private final Command callback;
    private final AsyncPackageDataModelOracle oracle;
    private final ValueEditorFactory valueEditorFactory = new ValueEditorFactory(){

        @Override
        protected Map<String, String> getCurrentValueMap() {
            HashMap<String, String> currentValueMap = new HashMap<String, String>();
            Node parent = EditConstraintPopup.this.node.getParent();
            while (parent != null) {
                if (parent instanceof ConstraintNode) {
                    ConstraintNode cn = (ConstraintNode)parent;
                    currentValueMap.put(cn.getFieldName(), cn.getValue().toString());
                    parent = parent.getParent();
                    continue;
                }
                parent = null;
            }
            return currentValueMap;
        }
    };
    private final Command okCommand = new Command(){

        public void execute() {
            EditConstraintPopup.this.onOKButtonClick();
        }
    };
    private final Command cancelCommand = new Command(){

        public void execute() {
            EditConstraintPopup.this.hide();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.okCommand, this.cancelCommand);
    @UiField
    Label classNameLabel;
    @UiField
    Label fieldNameLabel;
    @UiField
    FormGroup bindingGroup;
    @UiField
    HelpBlock bindingHelpInline;
    @UiField
    BindingTextBox bindingTextBox;
    @UiField
    ListBox operatorListBox;
    @UiField
    FormGroup valueGroup;
    @UiField
    SimplePanel valueHolder;

    public EditConstraintPopup(ConstraintNode node, AsyncPackageDataModelOracle oracle, Command callback) {
        this.setTitle(GuidedDecisionTreeConstants.INSTANCE.popupTitleEditConstraint());
        this.setBody((Widget)uiBinder.createAndBindUi((Object)this));
        this.add((Widget)this.footer);
        this.bindingTextBox.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                EditConstraintPopup.this.bindingGroup.setValidationState(ValidationState.NONE);
                EditConstraintPopup.this.bindingHelpInline.setText("");
            }
        });
        this.bindingTextBox.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                EditConstraintPopup.this.clone.setBinding(EditConstraintPopup.this.bindingTextBox.getText());
            }
        });
        this.node = node;
        this.clone = this.cloneNode(node);
        this.oracle = oracle;
        this.callback = callback;
        this.classNameLabel.setText(this.clone.getClassName());
        this.fieldNameLabel.setText(this.clone.getFieldName());
        this.bindingTextBox.setText(this.clone.getBinding());
        this.initialiseOperators();
    }

    private ConstraintNode cloneNode(ConstraintNode node) {
        ConstraintNodeImpl clone = new ConstraintNodeImpl(node.getClassName(), node.getFieldName());
        if (node.getOperator() != null) {
            clone.setOperator(node.getOperator());
        }
        if (node.getValue() != null) {
            clone.setValue(node.getValue());
        }
        clone.setParent(node.getParent());
        clone.setBinding(node.getBinding());
        return clone;
    }

    private void initialiseOperators() {
        this.oracle.getOperatorCompletions(this.clone.getClassName(), this.clone.getFieldName(), (Callback)new Callback<String[]>(){

            public void callback(String[] operators) {
                EditConstraintPopup.this.operatorListBox.clear();
                EditConstraintPopup.this.operatorListBox.setEnabled(false);
                if (operators == null) {
                    return;
                }
                int selectedIndex = 0;
                EditConstraintPopup.this.operatorListBox.setEnabled(true);
                EditConstraintPopup.this.operatorListBox.addItem(GuidedDecisionTreeConstants.INSTANCE.noOperator());
                for (int index = 0; index < operators.length; ++index) {
                    String operator = operators[index];
                    if (operator.equals(EditConstraintPopup.this.clone.getOperator())) {
                        selectedIndex = index + 1;
                    }
                    EditConstraintPopup.this.operatorListBox.addItem(HumanReadable.getOperatorDisplayName((String)operator), operator);
                }
                EditConstraintPopup.this.operatorListBox.setSelectedIndex(selectedIndex);
                EditConstraintPopup.this.initialiseValue();
            }
        });
        this.operatorListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                int selectedIndex = EditConstraintPopup.this.operatorListBox.getSelectedIndex();
                if (selectedIndex == 0) {
                    EditConstraintPopup.this.clone.setOperator(null);
                } else {
                    EditConstraintPopup.this.clone.setOperator(EditConstraintPopup.this.operatorListBox.getValue(selectedIndex));
                }
                EditConstraintPopup.this.initialiseValue();
            }
        });
    }

    private void initialiseValue() {
        if (this.operatorListBox.getSelectedIndex() == 0) {
            this.clone.setValue(null);
            this.valueGroup.setVisible(false);
            this.valueHolder.clear();
            return;
        }
        String operator = this.operatorListBox.getValue(this.operatorListBox.getSelectedIndex());
        if (!OperatorsOracle.isValueRequired((String)operator)) {
            this.clone.setValue(null);
            this.valueGroup.setVisible(false);
            this.valueHolder.clear();
            return;
        }
        Widget editor = this.valueEditorFactory.getValueEditor(this.clone.getClassName(), this.clone.getFieldName(), (HasValue)this.clone, this.oracle, OperatorsOracle.operatorRequiresList((String)operator));
        this.valueHolder.clear();
        if (editor != null) {
            this.valueGroup.setVisible(true);
            this.valueHolder.setWidget(editor);
        }
    }

    private void onOKButtonClick() {
        boolean hasError = false;
        String binding = this.clone.getBinding();
        if (binding != null && !binding.isEmpty()) {
            if (!BindingUtilities.isUniqueInPath(binding, (Node)this.clone)) {
                this.bindingGroup.setValidationState(ValidationState.ERROR);
                this.bindingHelpInline.setText(GuidedDecisionTreeConstants.INSTANCE.bindingIsNotUnique());
                hasError = true;
            }
        } else {
            this.bindingGroup.setValidationState(ValidationState.NONE);
        }
        if (hasError) {
            return;
        }
        this.node.setBinding(this.clone.getBinding());
        this.node.setOperator(this.clone.getOperator());
        this.node.setValue(this.clone.getValue());
        if (this.callback != null) {
            this.callback.execute();
        }
        this.hide();
    }

    static interface EditConstraintBinder
    extends UiBinder<Widget, EditConstraintPopup> {
    }
}

