/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.backend.server;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.services.backend.enums.EnumDropdownServiceImpl;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;

public class EnumDropDownServiceTest {
    @Test
    public void testLoadDropDown() throws Exception {
        final ClassLoader cl = Thread.currentThread().getContextClassLoader();
        EnumDropdownServiceImpl service = new EnumDropdownServiceImpl(){

            public String[] loadDropDownExpression(Path resource, String[] valuePairs, String expression) {
                return super.loadDropDownExpression(cl, valuePairs, expression);
            }
        };
        String[] pairs = new String[]{"f1=x", "f2=2"};
        String expression = "['@{f1}', '@{f2}']";
        String[] r = service.loadDropDownExpression((Path)Mockito.mock(Path.class), pairs, "['@{f1}', '@{f2}']");
        Assert.assertEquals((long)2L, (long)r.length);
        Assert.assertEquals((Object)"x", (Object)r[0]);
        Assert.assertEquals((Object)"2", (Object)r[1]);
    }

    @Test
    public void testLoadDropDownNoValuePairs() throws Exception {
        final ClassLoader cl = Thread.currentThread().getContextClassLoader();
        EnumDropdownServiceImpl service = new EnumDropdownServiceImpl(){

            public String[] loadDropDownExpression(Path resource, String[] valuePairs, String expression) {
                return super.loadDropDownExpression(cl, valuePairs, expression);
            }
        };
        String[] pairs = new String[]{null};
        String expression = "['@{f1}', '@{f2}']";
        String[] r = service.loadDropDownExpression((Path)Mockito.mock(Path.class), pairs, "['@{f1}', '@{f2}']");
        Assert.assertEquals((long)0L, (long)r.length);
    }
}

