/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.backend.server.indexing;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.Version;
import org.drools.workbench.screens.guided.rule.backend.server.indexing.TestGuidedRuleDrlFileIndexer;
import org.drools.workbench.screens.guided.rule.type.GuidedRuleDRLResourceTypeDefinition;
import org.junit.Assert;
import org.junit.Test;
import org.kie.uberfire.metadata.backend.lucene.index.LuceneIndex;
import org.kie.uberfire.metadata.engine.Index;
import org.kie.uberfire.metadata.io.KObjectUtil;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.RuleAttributeNameAnalyzer;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class IndexRuleAttributeNameAndValueTest
extends BaseIndexingTest<GuidedRuleDRLResourceTypeDefinition> {
    @Test
    public void testIndexDrlRuleAttributeNameAndValues() throws IOException, InterruptedException {
        Path path = this.basePath.resolve("drl1.rdrl");
        String drl = this.loadText("drl1.rdrl");
        this.ioService().write(path, drl, new OpenOption[0]);
        Thread.sleep(5000L);
        Index index = IndexRuleAttributeNameAndValueTest.getConfig().getIndexManager().get(KObjectUtil.toKCluster((FileSystem)this.basePath.getFileSystem()));
        IndexSearcher searcher = ((LuceneIndex)index).nrtSearcher();
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)10, (boolean)true);
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term("rule_attribute", "ruleflow-group")), BooleanClause.Occur.MUST);
        query.add((Query)new TermQuery(new Term("rule_attribute_value", "nonexistent")), BooleanClause.Occur.MUST);
        searcher.search((Query)query, (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)0L, (long)hits.length);
        ((LuceneIndex)index).nrtRelease(searcher);
        searcher = ((LuceneIndex)index).nrtSearcher();
        collector = TopScoreDocCollector.create((int)10, (boolean)true);
        query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term("rule_attribute", "ruleflow-group")), BooleanClause.Occur.MUST);
        query.add((Query)new TermQuery(new Term("rule_attribute_value", "myruleflowgroup")), BooleanClause.Occur.MUST);
        searcher.search((Query)query, (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits.length);
        ((LuceneIndex)index).nrtRelease(searcher);
    }

    protected TestIndexer getIndexer() {
        return new TestGuidedRuleDrlFileIndexer();
    }

    public Map<String, Analyzer> getAnalyzers() {
        return new HashMap<String, Analyzer>(){
            {
                this.put("rule_attribute", new RuleAttributeNameAnalyzer(Version.LUCENE_40));
            }
        };
    }

    protected GuidedRuleDRLResourceTypeDefinition getResourceTypeDefinition() {
        return new GuidedRuleDRLResourceTypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

