/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.util;

import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.rule.ActionFieldList;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.screens.guided.rule.client.util.ModelFieldUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ModelFieldUtilTest {
    @Mock
    private ModelField field1;
    @Mock
    private ModelField field2;

    @Test
    public void nullModelFields() {
        Assert.assertNull((Object)ModelFieldUtil.getAvailableFieldCompletions(null, null));
    }

    @Test
    public void emptyModelFields() {
        Assert.assertEquals((long)0L, (long)ModelFieldUtil.getAvailableFieldCompletions((ModelField[])new ModelField[0], null).length);
    }

    @Test
    public void nullActionFieldList() {
        ModelField[] result = ModelFieldUtil.getAvailableFieldCompletions((ModelField[])new ModelField[]{this.field1}, null);
        Assert.assertEquals((long)1L, (long)result.length);
        Assert.assertEquals((Object)this.field1, (Object)result[0]);
    }

    @Test
    public void emptyActionFieldList() {
        ModelField[] result = ModelFieldUtil.getAvailableFieldCompletions((ModelField[])new ModelField[]{this.field1}, (ActionFieldList)new ActionInsertFact());
        Assert.assertEquals((long)1L, (long)result.length);
        Assert.assertEquals((Object)this.field1, (Object)result[0]);
    }

    @Test
    public void filtering() {
        Mockito.when((Object)this.field1.getName()).thenReturn((Object)"field1");
        Mockito.when((Object)this.field2.getName()).thenReturn((Object)"field2");
        ActionInsertFact afl = new ActionInsertFact();
        ActionFieldValue afv = new ActionFieldValue();
        afv.setField("field1");
        afl.addFieldValue(afv);
        ModelField[] result = ModelFieldUtil.getAvailableFieldCompletions((ModelField[])new ModelField[]{this.field1, this.field2}, (ActionFieldList)afl);
        Assert.assertEquals((long)1L, (long)result.length);
        Assert.assertEquals((Object)this.field2, (Object)result[0]);
    }
}

