/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import java.util.HashMap;
import java.util.Iterator;
import org.drools.workbench.models.datamodel.rule.ActionFieldFunction;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.editor.util.SuperTypeMatcher;
import org.gwtbootstrap3.client.ui.ListBox;
import org.uberfire.client.callbacks.Callback;

public class BoundListBox
extends ListBox {
    private RuleModeller model;
    private ActionFieldFunction methodParameter;
    private SuperTypeMatcher matcher;
    private HashMap<String, String> factTypesByVariables = new HashMap();

    public BoundListBox(RuleModeller model, ActionFieldFunction methodParameter, SuperTypeMatcher matcher) {
        this.model = model;
        this.methodParameter = methodParameter;
        this.matcher = matcher;
        this.addItem("...");
        this.addBoundFacts();
    }

    private void addBoundFacts() {
        this.getRHSFacTypes();
        this.getLHSFacTypes();
        this.addVariables(this.factTypesByVariables.keySet().iterator());
    }

    private void getRHSFacTypes() {
        for (String variable : this.model.getModel().getAllRHSVariables()) {
            this.factTypesByVariables.put(variable, this.model.getModel().getRHSBoundFact(variable).getFactType());
        }
    }

    private void getLHSFacTypes() {
        for (String variable : this.model.getModel().getAllLHSVariables()) {
            this.factTypesByVariables.put(variable, this.model.getModel().getLHSBindingType(variable));
        }
    }

    private void setSelectedIndex() {
        if (this.methodParameter.getValue().equals("=")) {
            this.setSelectedIndex(0);
        } else {
            for (int i = 0; i < this.getItemCount(); ++i) {
                if (!this.getItemText(i).equals(this.methodParameter.getValue())) continue;
                this.setSelectedIndex(i);
            }
        }
    }

    private void addVariables(final Iterator<String> variables) {
        if (variables.hasNext()) {
            final String variable = variables.next();
            String factType = this.factTypesByVariables.get(variable);
            if (factType.equals(this.methodParameter.getType())) {
                this.addItem(variable);
                this.addVariables(variables);
            } else {
                this.matcher.isThereAMatchingSuperType(factType, this.methodParameter.getType(), new Callback<Boolean>(){

                    public void callback(Boolean result) {
                        if (result.booleanValue()) {
                            BoundListBox.this.addItem(variable);
                        }
                        BoundListBox.this.addVariables(variables);
                    }
                });
            }
        } else {
            this.setSelectedIndex();
        }
    }
}

