/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Composite;
import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.widget.FactTypeKnownValueChangeEvent;
import org.drools.workbench.screens.guided.rule.client.widget.FactTypeKnownValueChangeHandler;

public abstract class RuleModellerWidget
extends Composite {
    protected RuleModeller modeller;
    private EventBus eventBus;
    private boolean modified;
    private List<Command> onModifiedCommands = new ArrayList<Command>();

    public RuleModellerWidget(RuleModeller modeller, EventBus eventBus) {
        this.modeller = modeller;
        this.eventBus = eventBus;
    }

    public abstract boolean isReadOnly();

    public abstract boolean isFactTypeKnown();

    public HandlerRegistration addFactTypeKnownValueChangeHandler(FactTypeKnownValueChangeHandler changeHandler) {
        return this.addHandler(changeHandler, FactTypeKnownValueChangeEvent.getType());
    }

    public RuleModeller getModeller() {
        return this.modeller;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void setModified(boolean modified) {
        if (modified) {
            this.executeOnModifiedCommands();
        }
        this.modified = modified;
    }

    protected boolean isModified() {
        return this.modified;
    }

    public void addOnModifiedCommand(Command command) {
        this.onModifiedCommands.add(command);
    }

    private void executeOnModifiedCommands() {
        for (Command command : this.onModifiedCommands) {
            command.execute();
        }
    }
}

