/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.List;
import org.drools.workbench.models.datamodel.rule.ActionCallMethod;
import org.drools.workbench.models.datamodel.rule.ActionGlobalCollectionAdd;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.datamodel.rule.ActionInsertLogicalFact;
import org.drools.workbench.models.datamodel.rule.ActionRetractFact;
import org.drools.workbench.models.datamodel.rule.ActionSetField;
import org.drools.workbench.models.datamodel.rule.ActionUpdateField;
import org.drools.workbench.models.datamodel.rule.DSLSentence;
import org.drools.workbench.models.datamodel.rule.FreeFormLine;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.client.editor.AbstractRuleModellerSelectorPopup;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.editor.plugin.RuleModellerActionPlugin;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.uberfire.ext.widgets.common.client.common.InfoPopup;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class RuleModellerActionSelectorPopup
extends AbstractRuleModellerSelectorPopup {
    private Collection<RuleModellerActionPlugin> actionPlugins;
    private final Command okCommand = new Command(){

        public void execute() {
            RuleModellerActionSelectorPopup.this.selectSomething();
        }
    };
    private final Command cancelCommand = new Command(){

        public void execute() {
            RuleModellerActionSelectorPopup.this.hide();
        }
    };

    public RuleModellerActionSelectorPopup(RuleModel model, RuleModeller ruleModeller, Collection<RuleModellerActionPlugin> actionPlugins, Integer position, AsyncPackageDataModelOracle oracle) {
        super(model, ruleModeller, position, oracle);
        this.actionPlugins = actionPlugins;
        this.add((Widget)new ModalBody(){
            {
                this.add(RuleModellerActionSelectorPopup.this.getContent());
            }
        });
        this.add((Widget)new ModalFooterOKCancelButtons(this.okCommand, this.cancelCommand));
    }

    @Override
    protected String getPopupTitle() {
        return GuidedRuleEditorResources.CONSTANTS.AddANewAction();
    }

    @Override
    public Widget getContent() {
        if (this.position == null) {
            this.positionCbo.addItem(GuidedRuleEditorResources.CONSTANTS.Bottom(), String.valueOf(this.model.rhs.length));
            this.positionCbo.addItem(GuidedRuleEditorResources.CONSTANTS.Top(), "0");
            for (int i = 1; i < this.model.rhs.length; ++i) {
                this.positionCbo.addItem(GuidedRuleEditorResources.CONSTANTS.Line0(i), String.valueOf(i));
            }
        } else {
            this.positionCbo.addItem(String.valueOf(this.position));
            this.positionCbo.setSelectedIndex(0);
        }
        if (this.oracle.getDSLConditions().size() == 0 && this.oracle.getFactTypes().length == 0) {
            this.layoutPanel.addRow((IsWidget)new HTML("<div class='highlight'>" + GuidedRuleEditorResources.CONSTANTS.NoModelTip() + "</div>"));
        }
        if (this.position == null) {
            HorizontalPanel hp0 = new HorizontalPanel();
            hp0.add((Widget)new HTML(GuidedRuleEditorResources.CONSTANTS.PositionColon()));
            hp0.add((Widget)this.positionCbo);
            hp0.add((IsWidget)new InfoPopup(GuidedRuleEditorResources.CONSTANTS.PositionColon(), GuidedRuleEditorResources.CONSTANTS.ActionPositionExplanation()));
            this.layoutPanel.addRow((IsWidget)hp0);
            this.layoutPanel.addRow((IsWidget)new HTML("<hr/>"));
        }
        this.choices = this.makeChoicesListBox();
        this.choicesPanel.add((Widget)this.choices);
        this.layoutPanel.addRow((IsWidget)this.choicesPanel);
        if (this.ruleModeller.isDSLEnabled()) {
            CheckBox chkOnlyDisplayDSLConditions = new CheckBox();
            chkOnlyDisplayDSLConditions.setText(GuidedRuleEditorResources.CONSTANTS.OnlyDisplayDSLActions());
            chkOnlyDisplayDSLConditions.setValue(Boolean.valueOf(this.onlyShowDSLStatements));
            chkOnlyDisplayDSLConditions.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    RuleModellerActionSelectorPopup.this.onlyShowDSLStatements = (Boolean)event.getValue();
                    RuleModellerActionSelectorPopup.this.choicesPanel.setWidget((Widget)RuleModellerActionSelectorPopup.this.makeChoicesListBox());
                }
            });
            this.layoutPanel.addRow((IsWidget)chkOnlyDisplayDSLConditions);
        }
        return this.layoutPanel;
    }

    public void show() {
        super.show();
        this.choices.setFocus(true);
    }

    private ListBox makeChoicesListBox() {
        this.choices = new ListBox(true);
        this.choices.setPixelSize(this.getChoicesWidth(), this.getChoicesHeight());
        this.choices.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 13) {
                    RuleModellerActionSelectorPopup.this.selectSomething();
                }
            }
        });
        this.addDSLSentences();
        if (!this.onlyShowDSLStatements) {
            this.addUpdateNotModify();
            this.addGlobals();
            this.addRetractions();
            this.addModifies();
            this.addInsertions();
            this.addLogicalInsertions();
            this.addGlobalCollections();
            this.addFreeFormDRL();
            this.addCustomActionPlugins();
        }
        return this.choices;
    }

    private void addDSLSentences() {
        if (!this.ruleModeller.isDSLEnabled()) {
            return;
        }
        for (final DSLSentence sen : this.oracle.getDSLActions()) {
            String sentence = sen.toString();
            String key = "DSL" + sentence;
            this.choices.addItem(sentence, key);
            this.cmds.put(key, new Command(){

                public void execute() {
                    RuleModellerActionSelectorPopup.this.addNewDSLRhs(sen, Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                    RuleModellerActionSelectorPopup.this.hide();
                }
            });
        }
    }

    private void addUpdateNotModify() {
        List vars = this.model.getAllLHSVariables();
        if (vars.size() == 0) {
            return;
        }
        this.choices.addItem("..................");
        for (final String v : vars) {
            this.choices.addItem(GuidedRuleEditorResources.CONSTANTS.ChangeFieldValuesOf0(v), "VAR" + v);
            this.cmds.put("VAR" + v, new Command(){

                public void execute() {
                    RuleModellerActionSelectorPopup.this.addActionSetField(v, Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                    RuleModellerActionSelectorPopup.this.hide();
                }
            });
        }
    }

    private void addGlobals() {
        String[] globals = this.oracle.getGlobalVariables();
        if (globals.length == 0) {
            return;
        }
        this.choices.addItem("..................");
        for (int i = 0; i < globals.length; ++i) {
            final String v = globals[i];
            this.choices.addItem(GuidedRuleEditorResources.CONSTANTS.ChangeFieldValuesOf0(v), "GLOBVAR" + v);
            this.cmds.put("GLOBVAR" + v, new Command(){

                public void execute() {
                    RuleModellerActionSelectorPopup.this.addActionSetField(v, Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                    RuleModellerActionSelectorPopup.this.hide();
                }
            });
        }
    }

    private void addRetractions() {
        List vars = this.model.getLHSBoundFacts();
        if (vars.size() == 0) {
            return;
        }
        this.choices.addItem("..................");
        for (final String v : vars) {
            this.choices.addItem(GuidedRuleEditorResources.CONSTANTS.Delete0(v), "RET" + v);
            this.cmds.put("RET" + v, new Command(){

                public void execute() {
                    RuleModellerActionSelectorPopup.this.addRetract(v, Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                    RuleModellerActionSelectorPopup.this.hide();
                }
            });
        }
    }

    private void addModifies() {
        List vars = this.model.getAllLHSVariables();
        if (vars.size() == 0) {
            return;
        }
        this.choices.addItem("..................");
        for (final String v : vars) {
            this.choices.addItem(GuidedRuleEditorResources.CONSTANTS.Modify0(v), "MOD" + v);
            this.cmds.put("MOD" + v, new Command(){

                public void execute() {
                    RuleModellerActionSelectorPopup.this.addModify(v, Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                    RuleModellerActionSelectorPopup.this.hide();
                }
            });
        }
    }

    private void addInsertions() {
        if (this.oracle.getFactTypes().length == 0) {
            return;
        }
        this.choices.addItem("..................");
        for (int i = 0; i < this.oracle.getFactTypes().length; ++i) {
            final String item = this.oracle.getFactTypes()[i];
            this.choices.addItem(GuidedRuleEditorResources.CONSTANTS.InsertFact0(item), "INS" + item);
            this.cmds.put("INS" + item, new Command(){

                public void execute() {
                    RuleModellerActionSelectorPopup.this.model.addRhsItem((IAction)new ActionInsertFact(item), Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                    RuleModellerActionSelectorPopup.this.hide();
                }
            });
        }
    }

    private void addLogicalInsertions() {
        if (this.oracle.getFactTypes().length == 0) {
            return;
        }
        this.choices.addItem("..................");
        for (int i = 0; i < this.oracle.getFactTypes().length; ++i) {
            final String item = this.oracle.getFactTypes()[i];
            this.choices.addItem(GuidedRuleEditorResources.CONSTANTS.LogicallyInsertFact0(item), "LINS" + item);
            this.cmds.put("LINS" + item, new Command(){

                public void execute() {
                    RuleModellerActionSelectorPopup.this.model.addRhsItem((IAction)new ActionInsertLogicalFact(item), Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                    RuleModellerActionSelectorPopup.this.hide();
                }
            });
        }
    }

    private void addGlobalCollections() {
        List vars = this.model.getLHSBoundFacts();
        if (vars.size() == 0) {
            return;
        }
        if (this.oracle.getGlobalCollections().length == 0) {
            return;
        }
        this.choices.addItem("..................");
        for (String bf : vars) {
            for (int i = 0; i < this.oracle.getGlobalCollections().length; ++i) {
                final String glob = this.oracle.getGlobalCollections()[i];
                final String var = bf;
                this.choices.addItem(GuidedRuleEditorResources.CONSTANTS.Append0ToList1(var, glob), "GLOBCOL" + glob + var);
                this.cmds.put("GLOBCOL" + glob + var, new Command(){

                    public void execute() {
                        ActionGlobalCollectionAdd gca = new ActionGlobalCollectionAdd();
                        gca.setGlobalName(glob);
                        gca.setFactName(var);
                        RuleModellerActionSelectorPopup.this.model.addRhsItem((IAction)gca, Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                        RuleModellerActionSelectorPopup.this.hide();
                    }
                });
            }
        }
    }

    private void addFreeFormDRL() {
        List lhsVars = this.model.getAllLHSVariables();
        List rhsVars = this.model.getRHSBoundFacts();
        String[] globals = this.oracle.getGlobalVariables();
        this.choices.addItem("..................");
        this.choices.addItem(GuidedRuleEditorResources.CONSTANTS.AddFreeFormDrl(), "FF");
        this.cmds.put("FF", new Command(){

            public void execute() {
                RuleModellerActionSelectorPopup.this.model.addRhsItem((IAction)new FreeFormLine(), Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                RuleModellerActionSelectorPopup.this.hide();
            }
        });
        if (globals.length > 0) {
            this.choices.addItem("..................");
        }
        for (int i = 0; i < globals.length; ++i) {
            final String v = globals[i];
            this.choices.addItem(GuidedRuleEditorResources.CONSTANTS.CallMethodOn0(v), "GLOBCALL" + v);
            this.cmds.put("GLOBCALL" + v, new Command(){

                public void execute() {
                    RuleModellerActionSelectorPopup.this.addCallMethod(v, Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                    RuleModellerActionSelectorPopup.this.hide();
                }
            });
        }
        if (lhsVars.size() > 0) {
            this.choices.addItem("..................");
        }
        for (final String v : lhsVars) {
            this.choices.addItem(GuidedRuleEditorResources.CONSTANTS.CallMethodOn0(v), "CALL" + v);
            this.cmds.put("CALL" + v, new Command(){

                public void execute() {
                    RuleModellerActionSelectorPopup.this.addCallMethod(v, Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                    RuleModellerActionSelectorPopup.this.hide();
                }
            });
        }
        if (rhsVars.size() > 0) {
            this.choices.addItem("..................");
        }
        for (final String v : rhsVars) {
            this.choices.addItem(GuidedRuleEditorResources.CONSTANTS.CallMethodOn0(v), "CALL" + v);
            this.cmds.put("CALL" + v, new Command(){

                public void execute() {
                    RuleModellerActionSelectorPopup.this.addCallMethod(v, Integer.parseInt(RuleModellerActionSelectorPopup.this.positionCbo.getValue(RuleModellerActionSelectorPopup.this.positionCbo.getSelectedIndex())));
                    RuleModellerActionSelectorPopup.this.hide();
                }
            });
        }
    }

    private void addCustomActionPlugins() {
        if (this.actionPlugins != null) {
            for (RuleModellerActionPlugin actionPlugin : this.actionPlugins) {
                IAction iAction = actionPlugin.createIAction(this.ruleModeller);
                actionPlugin.addPluginToActionList(this.ruleModeller, () -> {
                    this.choices.addItem(actionPlugin.getActionAddDescription(), actionPlugin.getId());
                    this.cmds.put(actionPlugin.getId(), () -> {
                        this.model.addRhsItem(iAction, Integer.parseInt(this.positionCbo.getValue(this.positionCbo.getSelectedIndex())));
                        this.hide();
                    });
                });
            }
        }
    }

    private void addNewDSLRhs(DSLSentence sentence, int position) {
        this.model.addRhsItem((IAction)sentence.copy(), position);
    }

    private void addRetract(String var, int position) {
        this.model.addRhsItem((IAction)new ActionRetractFact(var), position);
    }

    private void addActionSetField(String itemText, int position) {
        this.model.addRhsItem((IAction)new ActionSetField(itemText), position);
    }

    private void addCallMethod(String itemText, int position) {
        this.model.addRhsItem((IAction)new ActionCallMethod(itemText), position);
    }

    private void addModify(String itemText, int position) {
        this.model.addRhsItem((IAction)new ActionUpdateField(itemText), position);
    }
}

