/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.rule.ActionFieldList;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.datamodel.rule.ActionSetField;
import org.drools.workbench.models.datamodel.rule.ActionUpdateField;
import org.drools.workbench.screens.guided.rule.client.editor.ActionValueEditor;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.editor.events.TemplateVariablesChangedEvent;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.resources.images.GuidedRuleEditorImages508;
import org.drools.workbench.screens.guided.rule.client.util.ModelFieldUtil;
import org.drools.workbench.screens.guided.rule.client.widget.RuleModellerWidget;
import org.gwtbootstrap3.client.ui.ListBox;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.resources.HumanReadable;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.common.ClickableLabel;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;

public class ActionSetFieldWidget
extends RuleModellerWidget {
    private final ActionSetField model;
    private final FlexTable layout;
    private boolean isBoundFact = false;
    private ModelField[] fieldCompletions;
    private String variableClass;
    private boolean readOnly;
    private boolean isFactTypeKnown;
    private final Map<ActionFieldValue, ActionValueEditor> actionValueEditors = new HashMap<ActionFieldValue, ActionValueEditor>();

    public ActionSetFieldWidget(RuleModeller mod, EventBus eventBus, ActionSetField set, Boolean readOnly) {
        super(mod, eventBus);
        this.model = set;
        this.layout = new FlexTable();
        AsyncPackageDataModelOracle oracle = this.getModeller().getDataModelOracle();
        if (oracle.isGlobalVariable(set.getVariable())) {
            oracle.getFieldCompletionsForGlobalVariable(set.getVariable(), (Callback)new Callback<ModelField[]>(){

                public void callback(ModelField[] fieldCompletions) {
                    ActionSetFieldWidget.access$002(ActionSetFieldWidget.this, fieldCompletions);
                }
            });
            this.variableClass = oracle.getGlobalVariable(set.getVariable());
        } else {
            String type = mod.getModel().getLHSBindingType(set.getVariable());
            if (type != null) {
                oracle.getFieldCompletions(type, FieldAccessorsAndMutators.MUTATOR, (Callback)new Callback<ModelField[]>(){

                    public void callback(ModelField[] fields) {
                        ActionSetFieldWidget.access$002(ActionSetFieldWidget.this, fields);
                    }
                });
                this.variableClass = type;
                this.isBoundFact = true;
            } else {
                ActionInsertFact patternRhs = mod.getModel().getRHSBoundFact(set.getVariable());
                if (patternRhs != null) {
                    oracle.getFieldCompletions(patternRhs.getFactType(), FieldAccessorsAndMutators.MUTATOR, (Callback)new Callback<ModelField[]>(){

                        public void callback(ModelField[] fields) {
                            ActionSetFieldWidget.access$002(ActionSetFieldWidget.this, fields);
                        }
                    });
                    this.variableClass = patternRhs.getFactType();
                    this.isBoundFact = true;
                }
            }
        }
        if (this.variableClass == null) {
            readOnly = true;
            ErrorPopup.showMessage((String)GuidedRuleEditorResources.CONSTANTS.CouldNotFindTheTypeForVariable0(set.getVariable()));
        }
        this.isFactTypeKnown = oracle.isFactTypeRecognized(this.variableClass);
        this.readOnly = readOnly == null ? !this.isFactTypeKnown : readOnly;
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        this.doLayout();
        this.initWidget((Widget)this.layout);
    }

    private void doLayout() {
        this.layout.clear();
        for (int i = 0; i < this.model.getFieldValues().length; ++i) {
            ActionFieldValue val = this.model.getFieldValues()[i];
            this.layout.setWidget(i, 0, this.getSetterLabel());
            this.layout.setWidget(i, 1, this.fieldSelector(val));
            this.layout.setWidget(i, 2, this.valueEditor(val));
            final int idx = i;
            Image remove = GuidedRuleEditorImages508.INSTANCE.DeleteItemSmall();
            remove.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (Window.confirm((String)GuidedRuleEditorResources.CONSTANTS.RemoveThisItem())) {
                        ActionSetFieldWidget.this.model.removeField(idx);
                        ActionSetFieldWidget.this.setModified(true);
                        ActionSetFieldWidget.this.getModeller().refreshWidget();
                        TemplateVariablesChangedEvent tvce = new TemplateVariablesChangedEvent(ActionSetFieldWidget.this.getModeller().getModel());
                        ActionSetFieldWidget.this.getEventBus().fireEventFromSource((GwtEvent)tvce, (Object)ActionSetFieldWidget.this.getModeller().getModel());
                    }
                }
            });
            if (this.readOnly) continue;
            this.layout.setWidget(i, 3, (Widget)remove);
        }
        if (this.model.getFieldValues().length == 0) {
            HorizontalPanel h = new HorizontalPanel();
            h.add(this.getSetterLabel());
            if (!this.readOnly) {
                Image image = GuidedRuleEditorImages508.INSTANCE.Edit();
                image.setAltText(GuidedRuleEditorResources.CONSTANTS.AddFirstNewField());
                image.setTitle(GuidedRuleEditorResources.CONSTANTS.AddFirstNewField());
                image.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent sender) {
                        ActionSetFieldWidget.this.showAddFieldPopup(sender);
                    }
                });
                h.add((Widget)image);
            }
            this.layout.setWidget(0, 0, (Widget)h);
        }
    }

    private Widget getSetterLabel() {
        String type;
        ClickHandler clk = new ClickHandler(){

            public void onClick(ClickEvent event) {
                ActionSetFieldWidget.this.showAddFieldPopup(event);
            }
        };
        String modifyType = "set";
        if (this.model instanceof ActionUpdateField) {
            modifyType = "modify";
        }
        String descFact = (type = this.getModeller().getModel().getLHSBindingType(this.model.getVariable())) != null ? type + " <b>[" + this.model.getVariable() + "]</b>" : this.model.getVariable();
        String sl = GuidedRuleEditorResources.CONSTANTS.setterLabel(HumanReadable.getActionDisplayName((String)modifyType), descFact);
        return new ClickableLabel(sl, clk, !this.readOnly);
    }

    protected void showAddFieldPopup(ClickEvent w) {
        boolean isEnabled;
        final AsyncPackageDataModelOracle oracle = this.getModeller().getDataModelOracle();
        final FormStylePopup popup = new FormStylePopup(GuidedRuleEditorImages508.INSTANCE.Wizard(), GuidedRuleEditorResources.CONSTANTS.AddAField());
        final ListBox box = new ListBox();
        box.addItem("...");
        ModelField[] availableFieldCompletions = ModelFieldUtil.getAvailableFieldCompletions(this.fieldCompletions, (ActionFieldList)this.model);
        boolean bl = isEnabled = !this.isReadOnly() && availableFieldCompletions.length > 0;
        if (availableFieldCompletions.length > 0) {
            for (int i = 0; i < availableFieldCompletions.length; ++i) {
                box.addItem(availableFieldCompletions[i].getName());
            }
        }
        box.setSelectedIndex(0);
        popup.addAttribute(GuidedRuleEditorResources.CONSTANTS.AddField(), (IsWidget)box);
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String fieldName = box.getItemText(box.getSelectedIndex());
                String fieldType = oracle.getFieldType(ActionSetFieldWidget.this.variableClass, fieldName);
                ActionSetFieldWidget.this.model.addFieldValue(new ActionFieldValue(fieldName, "", fieldType));
                ActionSetFieldWidget.this.setModified(true);
                ActionSetFieldWidget.this.getModeller().refreshWidget();
                popup.hide();
            }
        });
        box.setEnabled(isEnabled);
        popup.show();
    }

    private Widget valueEditor(final ActionFieldValue val) {
        AsyncPackageDataModelOracle oracle = this.getModeller().getDataModelOracle();
        String type = "";
        if (oracle.isGlobalVariable(this.model.getVariable())) {
            type = oracle.getGlobalVariable(this.model.getVariable());
        } else {
            type = this.getModeller().getModel().getLHSBindingType(this.model.getVariable());
            if (type == null && !this.readOnly) {
                type = this.getModeller().getModel().getRHSBoundFact(this.model.getVariable()).getFactType();
            }
        }
        ActionValueEditor actionValueEditor = new ActionValueEditor(type, val, this.model.getFieldValues(), this.getModeller(), this.getEventBus(), val.getType(), this.readOnly);
        actionValueEditor.setOnChangeCommand(new Command(){

            public void execute() {
                ActionSetFieldWidget.this.refreshActionValueEditorsDropDownData(val);
                ActionSetFieldWidget.this.setModified(true);
            }
        });
        this.actionValueEditors.put(val, actionValueEditor);
        return actionValueEditor;
    }

    private void refreshActionValueEditorsDropDownData(ActionFieldValue modifiedField) {
        for (Map.Entry<ActionFieldValue, ActionValueEditor> e : this.actionValueEditors.entrySet()) {
            ActionFieldValue afv = e.getKey();
            if (afv.getNature() != 1 && afv.getNature() != 4 || afv.equals((Object)modifiedField)) continue;
            e.getValue().refresh();
        }
    }

    private Widget fieldSelector(ActionFieldValue val) {
        return new SmallLabel(val.getField());
    }

    public boolean isBoundFact() {
        return this.isBoundFact;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isFactTypeKnown() {
        return this.isFactTypeKnown;
    }

    static /* synthetic */ ModelField[] access$002(ActionSetFieldWidget x0, ModelField[] x1) {
        x0.fieldCompletions = x1;
        return x1;
    }
}

