/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.validator;

import org.drools.workbench.models.datamodel.rule.CompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.ExpressionFormLine;
import org.drools.workbench.models.datamodel.rule.ExpressionPart;
import org.drools.workbench.models.datamodel.rule.ExpressionVariable;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.FromAccumulateCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromCollectCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromEntryPointFactPattern;
import org.drools.workbench.models.datamodel.rule.IFactPattern;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.screens.guided.rule.client.editor.validator.GuidedRuleEditorValidator;
import org.drools.workbench.screens.guided.rule.client.resources.i18n.Constants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class GuidedRuleEditorValidatorTest {
    private static final String MISSING_FACT_PATTERN = "Missing fact pattern";
    private static final String MISSING_VALUE_WHEN_OPERATOR_IS_SET = "Missing value when operator is set";
    private static final String MISSING_RHS_FROM = "Missing RHS from";
    private static final String MISSING_ENTRY_POINT = "Missing Entry Point";
    private RuleModel model;
    private GuidedRuleEditorValidator validator;
    private Constants constants;

    @Before
    public void setUp() throws Exception {
        this.model = new RuleModel();
        this.constants = (Constants)Mockito.mock(Constants.class);
        Mockito.when((Object)this.constants.AreasMarkedWithRedAreMandatoryPleaseSetAValueBeforeSaving()).thenReturn((Object)MISSING_FACT_PATTERN);
        Mockito.when((Object)this.constants.FactType0HasAField1ThatHasAnOperatorSetButNoValuePleaseAddAValueOrRemoveTheOperator(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)MISSING_VALUE_WHEN_OPERATOR_IS_SET);
        Mockito.when((Object)this.constants.WhenUsingFromTheSourceNeedsToBeSet()).thenReturn((Object)MISSING_RHS_FROM);
        Mockito.when((Object)this.constants.PleaseSetTheEntryPoint()).thenReturn((Object)MISSING_ENTRY_POINT);
        this.validator = new GuidedRuleEditorValidator(this.model, this.constants);
    }

    @Test
    public void testEmpty() throws Exception {
        Assert.assertTrue((boolean)this.validator.isValid());
        Assert.assertTrue((boolean)this.validator.getErrors().isEmpty());
    }

    @Test
    public void testValidateFactPattern() throws Exception {
        this.model.addLhsItem((IPattern)new FactPattern());
        Assert.assertTrue((boolean)this.validator.isValid());
        Assert.assertTrue((boolean)this.validator.getErrors().isEmpty());
    }

    @Test
    public void testValidateCompositeFactPatternFalse() throws Exception {
        CompositeFactPattern not = new CompositeFactPattern();
        not.setType("not");
        this.model.addLhsItem((IPattern)not);
        Assert.assertFalse((boolean)this.validator.isValid());
        Assert.assertTrue((boolean)((String)this.validator.getErrors().get(0)).equals(MISSING_FACT_PATTERN));
    }

    @Test
    public void testValidateCompositeFactPatternTrue() throws Exception {
        CompositeFactPattern not = new CompositeFactPattern();
        not.setType("not");
        not.addFactPattern((IFactPattern)new FactPattern());
        this.model.addLhsItem((IPattern)not);
        Assert.assertTrue((boolean)this.validator.isValid());
        Assert.assertTrue((boolean)this.validator.getErrors().isEmpty());
    }

    @Test
    public void testMissingValueWhenOperatorExists() throws Exception {
        FactPattern pattern = new FactPattern("Person");
        SingleFieldConstraint constraint = new SingleFieldConstraint("age");
        constraint.setOperator("==");
        pattern.addConstraint((FieldConstraint)constraint);
        this.model.lhs = new IPattern[]{pattern};
        Assert.assertFalse((boolean)this.validator.isValid());
        Assert.assertEquals((long)1L, (long)this.validator.getErrors().size());
        Assert.assertEquals((Object)MISSING_VALUE_WHEN_OPERATOR_IS_SET, this.validator.getErrors().get(0));
        ((Constants)Mockito.verify((Object)this.constants)).FactType0HasAField1ThatHasAnOperatorSetButNoValuePleaseAddAValueOrRemoveTheOperator("Person", "age");
    }

    @Test
    public void testMissingValueWhenOperatorExistsInCompositePattern() throws Exception {
        FactPattern pattern = new FactPattern("Person");
        SingleFieldConstraint constraint = new SingleFieldConstraint("age");
        constraint.setOperator("==");
        pattern.addConstraint((FieldConstraint)constraint);
        CompositeFactPattern not = new CompositeFactPattern();
        not.setType("not");
        not.addFactPattern((IFactPattern)pattern);
        this.model.lhs = new IPattern[]{not};
        Assert.assertFalse((boolean)this.validator.isValid());
        Assert.assertEquals((long)1L, (long)this.validator.getErrors().size());
        Assert.assertEquals((Object)MISSING_VALUE_WHEN_OPERATOR_IS_SET, this.validator.getErrors().get(0));
        ((Constants)Mockito.verify((Object)this.constants)).FactType0HasAField1ThatHasAnOperatorSetButNoValuePleaseAddAValueOrRemoveTheOperator("Person", "age");
    }

    @Test
    public void testMissingValueWhenOperatorExistsIsNull() throws Exception {
        FactPattern pattern = new FactPattern("Person");
        SingleFieldConstraint constraint = new SingleFieldConstraint("age");
        constraint.setOperator("== null");
        pattern.addConstraint((FieldConstraint)constraint);
        CompositeFactPattern not = new CompositeFactPattern();
        not.setType("not");
        not.addFactPattern((IFactPattern)pattern);
        this.model.lhs = new IPattern[]{not};
        Assert.assertTrue((boolean)this.validator.isValid());
        Assert.assertTrue((boolean)this.validator.getErrors().isEmpty());
    }

    @Test
    public void testMissingValueWhenOperatorExistsIsNotNull() throws Exception {
        FactPattern pattern = new FactPattern("Person");
        SingleFieldConstraint constraint = new SingleFieldConstraint("age");
        constraint.setOperator("!= null");
        pattern.addConstraint((FieldConstraint)constraint);
        CompositeFactPattern not = new CompositeFactPattern();
        not.setType("not");
        not.addFactPattern((IFactPattern)pattern);
        this.model.lhs = new IPattern[]{not};
        Assert.assertTrue((boolean)this.validator.isValid());
        Assert.assertTrue((boolean)this.validator.getErrors().isEmpty());
    }

    @Test
    public void testMissingValueInFrom() throws Exception {
        FactPattern boundPattern = new FactPattern("Person");
        boundPattern.setBoundName("person");
        boundPattern.addConstraint((FieldConstraint)new SingleFieldConstraint("addresses"));
        FactPattern pattern = new FactPattern("Address");
        SingleFieldConstraint constraint = new SingleFieldConstraint("street");
        constraint.setOperator("!=");
        pattern.addConstraint((FieldConstraint)constraint);
        FromCompositeFactPattern fromCompositeFactPattern = new FromCompositeFactPattern();
        fromCompositeFactPattern.setFactPattern(pattern);
        ExpressionFormLine expression = new ExpressionFormLine();
        expression.setBinding("person.addresses");
        fromCompositeFactPattern.setExpression(expression);
        this.model.lhs = new IPattern[]{boundPattern, fromCompositeFactPattern};
        Assert.assertFalse((boolean)this.validator.isValid());
        Assert.assertEquals((long)1L, (long)this.validator.getErrors().size());
        Assert.assertEquals((Object)MISSING_VALUE_WHEN_OPERATOR_IS_SET, this.validator.getErrors().get(0));
        ((Constants)Mockito.verify((Object)this.constants)).FactType0HasAField1ThatHasAnOperatorSetButNoValuePleaseAddAValueOrRemoveTheOperator("Address", "street");
    }

    @Test
    public void testWorkingFrom() throws Exception {
        FactPattern boundPattern = new FactPattern("Person");
        boundPattern.setBoundName("person");
        boundPattern.addConstraint((FieldConstraint)new SingleFieldConstraint("addresses"));
        FactPattern pattern = new FactPattern("Address");
        SingleFieldConstraint constraint = new SingleFieldConstraint("street");
        pattern.addConstraint((FieldConstraint)constraint);
        FromCompositeFactPattern fromCompositeFactPattern = new FromCompositeFactPattern();
        fromCompositeFactPattern.setFactPattern(pattern);
        ExpressionFormLine expression = new ExpressionFormLine();
        expression.setBinding("person.addresses");
        fromCompositeFactPattern.setExpression(expression);
        this.model.lhs = new IPattern[]{boundPattern, fromCompositeFactPattern};
        Assert.assertTrue((boolean)this.validator.isValid());
    }

    @Test
    public void testEmptyFrom() throws Exception {
        this.model.lhs = new IPattern[]{new FromCompositeFactPattern()};
        Assert.assertFalse((boolean)this.validator.isValid());
        Assert.assertEquals((long)2L, (long)this.validator.getErrors().size());
        Assert.assertEquals((Object)MISSING_FACT_PATTERN, this.validator.getErrors().get(0));
        Assert.assertEquals((Object)MISSING_RHS_FROM, this.validator.getErrors().get(1));
        ((Constants)Mockito.verify((Object)this.constants)).AreasMarkedWithRedAreMandatoryPleaseSetAValueBeforeSaving();
        ((Constants)Mockito.verify((Object)this.constants)).WhenUsingFromTheSourceNeedsToBeSet();
    }

    @Test
    public void testValidFromCompositeFactPattern() throws Exception {
        FactPattern factPattern = new FactPattern("SomeList");
        factPattern.setBoundName("list");
        FromCompositeFactPattern fromCompositeFactPattern = new FromCompositeFactPattern();
        fromCompositeFactPattern.setFactPattern(new FactPattern("Person"));
        ExpressionFormLine expression = new ExpressionFormLine();
        expression.appendPart((ExpressionPart)new ExpressionVariable("list", "SomeList", "SomeList"));
        fromCompositeFactPattern.setExpression(expression);
        this.model.lhs = new IPattern[]{fromCompositeFactPattern};
        Assert.assertTrue((boolean)this.validator.isValid());
    }

    @Test
    public void testMissingRHSPartInFrom() throws Exception {
        FactPattern pattern = new FactPattern("Address");
        SingleFieldConstraint constraint = new SingleFieldConstraint("street");
        pattern.addConstraint((FieldConstraint)constraint);
        FromCompositeFactPattern fromCompositeFactPattern = new FromCompositeFactPattern();
        fromCompositeFactPattern.setFactPattern(pattern);
        ExpressionFormLine expression = new ExpressionFormLine();
        fromCompositeFactPattern.setExpression(expression);
        this.model.lhs = new IPattern[]{fromCompositeFactPattern};
        Assert.assertFalse((boolean)this.validator.isValid());
        Assert.assertEquals((long)1L, (long)this.validator.getErrors().size());
        Assert.assertEquals((Object)MISSING_RHS_FROM, this.validator.getErrors().get(0));
        ((Constants)Mockito.verify((Object)this.constants)).WhenUsingFromTheSourceNeedsToBeSet();
    }

    @Test
    public void testFromAccumulateCompositePattern() throws Exception {
        FactPattern pattern1 = new FactPattern("Person");
        SingleFieldConstraint constraint1 = new SingleFieldConstraint("name");
        constraint1.setOperator("==");
        constraint1.setValue("Toni");
        pattern1.addConstraint((FieldConstraint)constraint1);
        FactPattern pattern2 = new FactPattern("Address");
        SingleFieldConstraint constraint2 = new SingleFieldConstraint("street");
        constraint2.setOperator("!=");
        constraint2.setValue("some street");
        pattern2.addConstraint((FieldConstraint)constraint2);
        FromAccumulateCompositeFactPattern fromAccumulateCompositeFactPattern = new FromAccumulateCompositeFactPattern();
        fromAccumulateCompositeFactPattern.setSourcePattern((IPattern)pattern1);
        fromAccumulateCompositeFactPattern.setFactPattern(pattern2);
        ExpressionFormLine expression = new ExpressionFormLine();
        expression.setBinding("person.addresses");
        fromAccumulateCompositeFactPattern.setExpression(expression);
        this.model.lhs = new IPattern[]{fromAccumulateCompositeFactPattern};
        Assert.assertTrue((boolean)this.validator.isValid());
    }

    @Test
    public void testFromAccumulateCompositePatternMissingValues() throws Exception {
        FactPattern pattern1 = new FactPattern("Person");
        SingleFieldConstraint constraint1 = new SingleFieldConstraint("name");
        constraint1.setOperator("==");
        pattern1.addConstraint((FieldConstraint)constraint1);
        FactPattern pattern2 = new FactPattern("Address");
        SingleFieldConstraint constraint2 = new SingleFieldConstraint("street");
        constraint2.setOperator("!=");
        pattern2.addConstraint((FieldConstraint)constraint2);
        FromAccumulateCompositeFactPattern fromAccumulateCompositeFactPattern = new FromAccumulateCompositeFactPattern();
        fromAccumulateCompositeFactPattern.setSourcePattern((IPattern)pattern1);
        fromAccumulateCompositeFactPattern.setFactPattern(pattern2);
        fromAccumulateCompositeFactPattern.setFunction("test()");
        this.model.lhs = new IPattern[]{fromAccumulateCompositeFactPattern};
        Assert.assertFalse((boolean)this.validator.isValid());
        Assert.assertEquals((long)2L, (long)this.validator.getErrors().size());
        ((Constants)Mockito.verify((Object)this.constants, (VerificationMode)Mockito.never())).WhenUsingFromTheSourceNeedsToBeSet();
        ((Constants)Mockito.verify((Object)this.constants)).FactType0HasAField1ThatHasAnOperatorSetButNoValuePleaseAddAValueOrRemoveTheOperator("Person", "name");
        ((Constants)Mockito.verify((Object)this.constants)).FactType0HasAField1ThatHasAnOperatorSetButNoValuePleaseAddAValueOrRemoveTheOperator("Address", "street");
    }

    @Test
    public void testFromAccumulateCompositePatternMissingValues2() throws Exception {
        FactPattern pattern1 = new FactPattern("Person");
        FactPattern pattern2 = new FactPattern("Address");
        FromAccumulateCompositeFactPattern fromAccumulateCompositeFactPattern = new FromAccumulateCompositeFactPattern();
        fromAccumulateCompositeFactPattern.setSourcePattern((IPattern)pattern1);
        fromAccumulateCompositeFactPattern.setFactPattern(pattern2);
        fromAccumulateCompositeFactPattern.setFunction("");
        fromAccumulateCompositeFactPattern.setReverseCode("");
        fromAccumulateCompositeFactPattern.setInitCode("");
        fromAccumulateCompositeFactPattern.setActionCode("");
        fromAccumulateCompositeFactPattern.setResultCode("");
        this.model.lhs = new IPattern[]{fromAccumulateCompositeFactPattern};
        Assert.assertFalse((boolean)this.validator.isValid());
        Assert.assertEquals((long)1L, (long)this.validator.getErrors().size());
        ((Constants)Mockito.verify((Object)this.constants)).WhenUsingFromTheSourceNeedsToBeSet();
    }

    @Test
    public void testFromAccumulateCompositePatternMissingValuesWithExistingFrom() throws Exception {
        FactPattern pattern1 = new FactPattern("Person");
        SingleFieldConstraint constraint1 = new SingleFieldConstraint("name");
        constraint1.setOperator("==");
        pattern1.addConstraint((FieldConstraint)constraint1);
        FactPattern pattern2 = new FactPattern("Address");
        SingleFieldConstraint constraint2 = new SingleFieldConstraint("street");
        constraint2.setOperator("!=");
        pattern2.addConstraint((FieldConstraint)constraint2);
        FromAccumulateCompositeFactPattern fromAccumulateCompositeFactPattern = new FromAccumulateCompositeFactPattern();
        fromAccumulateCompositeFactPattern.setSourcePattern((IPattern)pattern1);
        fromAccumulateCompositeFactPattern.setFactPattern(pattern2);
        fromAccumulateCompositeFactPattern.setInitCode("int i = 0");
        fromAccumulateCompositeFactPattern.setActionCode(" i++;");
        fromAccumulateCompositeFactPattern.setReverseCode("i--;");
        fromAccumulateCompositeFactPattern.setResultCode("return i");
        this.model.lhs = new IPattern[]{fromAccumulateCompositeFactPattern};
        Assert.assertFalse((boolean)this.validator.isValid());
        Assert.assertEquals((long)2L, (long)this.validator.getErrors().size());
        ((Constants)Mockito.verify((Object)this.constants, (VerificationMode)Mockito.never())).WhenUsingFromTheSourceNeedsToBeSet();
        ((Constants)Mockito.verify((Object)this.constants)).FactType0HasAField1ThatHasAnOperatorSetButNoValuePleaseAddAValueOrRemoveTheOperator("Person", "name");
        ((Constants)Mockito.verify((Object)this.constants)).FactType0HasAField1ThatHasAnOperatorSetButNoValuePleaseAddAValueOrRemoveTheOperator("Address", "street");
    }

    @Test
    public void testEmptyFromEntryPointFactPattern() throws Exception {
        this.model.lhs = new IPattern[]{new FromEntryPointFactPattern()};
        Assert.assertFalse((boolean)this.validator.isValid());
        Assert.assertEquals((long)2L, (long)this.validator.getErrors().size());
        Assert.assertEquals((Object)MISSING_FACT_PATTERN, this.validator.getErrors().get(0));
        Assert.assertEquals((Object)MISSING_ENTRY_POINT, this.validator.getErrors().get(1));
        ((Constants)Mockito.verify((Object)this.constants)).AreasMarkedWithRedAreMandatoryPleaseSetAValueBeforeSaving();
        ((Constants)Mockito.verify((Object)this.constants)).PleaseSetTheEntryPoint();
    }

    @Test
    public void testValidFromEntryPointFactPattern() throws Exception {
        FromEntryPointFactPattern fromEntryPointFactPattern = new FromEntryPointFactPattern();
        fromEntryPointFactPattern.setFactPattern(new FactPattern("Person"));
        fromEntryPointFactPattern.setEntryPointName("entryPoint");
        this.model.lhs = new IPattern[]{fromEntryPointFactPattern};
        Assert.assertTrue((boolean)this.validator.isValid());
    }

    @Test
    public void testComparingFieldToExpression() throws Exception {
        FactPattern f1 = new FactPattern();
        f1.setBoundName("f1");
        FactPattern f2 = new FactPattern();
        SingleFieldConstraint constraint = new SingleFieldConstraint();
        constraint.setOperator("==");
        constraint.getExpressionValue().appendPart((ExpressionPart)new ExpressionVariable("field", "java.lang.Number", "Number"));
        f2.addConstraint((FieldConstraint)constraint);
        this.model.lhs = new IPattern[]{f1, f2};
        Assert.assertTrue((boolean)this.validator.isValid());
    }

    @Test
    public void testEmptyLiteralStringFieldConstraints() throws Exception {
        FactPattern f1 = new FactPattern("Applicant");
        f1.setBoundName("$a");
        SingleFieldConstraint constraint = new SingleFieldConstraint();
        constraint.setConstraintValueType(1);
        constraint.setFieldType("String");
        constraint.setFactType("Applicant");
        constraint.setOperator("==");
        constraint.setFieldName("name");
        f1.addConstraint((FieldConstraint)constraint);
        this.model.lhs = new IPattern[]{f1};
        Assert.assertTrue((boolean)this.validator.isValid());
    }

    @Test
    public void testEmptyLiteralNonStringFieldConstraints() throws Exception {
        FactPattern f1 = new FactPattern("Applicant");
        f1.setBoundName("$a");
        SingleFieldConstraint constraint = new SingleFieldConstraint();
        constraint.setConstraintValueType(1);
        constraint.setFieldType("Integer");
        constraint.setFactType("Applicant");
        constraint.setOperator("==");
        constraint.setFieldName("age");
        f1.addConstraint((FieldConstraint)constraint);
        this.model.lhs = new IPattern[]{f1};
        Assert.assertFalse((boolean)this.validator.isValid());
    }

    @Test
    public void testMissingValueInFromCollect() throws Exception {
        FactPattern pattern = new FactPattern("Person");
        pattern.setBoundName("person");
        FromCollectCompositeFactPattern fromCompositeFactPattern = new FromCollectCompositeFactPattern();
        fromCompositeFactPattern.setFactPattern(pattern);
        this.model.lhs = new IPattern[]{fromCompositeFactPattern};
        Assert.assertFalse((boolean)this.validator.isValid());
        Assert.assertEquals((long)1L, (long)this.validator.getErrors().size());
        Assert.assertEquals((Object)MISSING_FACT_PATTERN, this.validator.getErrors().get(0));
        ((Constants)Mockito.verify((Object)this.constants)).AreasMarkedWithRedAreMandatoryPleaseSetAValueBeforeSaving();
    }

    @Test
    public void testMissingFactTypeInFromCollect() throws Exception {
        FromCollectCompositeFactPattern fromCompositeFactPattern = new FromCollectCompositeFactPattern();
        fromCompositeFactPattern.setRightPattern((IPattern)new FactPattern("Person"));
        this.model.lhs = new IPattern[]{fromCompositeFactPattern};
        Assert.assertFalse((boolean)this.validator.isValid());
        Assert.assertEquals((long)1L, (long)this.validator.getErrors().size());
        Assert.assertEquals((Object)MISSING_FACT_PATTERN, this.validator.getErrors().get(0));
        ((Constants)Mockito.verify((Object)this.constants)).AreasMarkedWithRedAreMandatoryPleaseSetAValueBeforeSaving();
    }
}

