/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.models.datamodel.rule.HasParameterizedOperator;
import org.drools.workbench.screens.guided.rule.client.editor.CEPOperatorsDropdown;
import org.gwtbootstrap3.client.ui.ListBox;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class CEPOperatorsDropdownTest {
    @Mock
    HasParameterizedOperator hasParameterizedOperator;
    @Mock
    ListBox box;
    @Mock
    CEPOperatorsDropdown dropdown;

    @Before
    public void setUp() throws Exception {
        this.dropdown.hop = this.hasParameterizedOperator;
        Mockito.when((Object)this.dropdown.getBox()).thenReturn((Object)this.box);
        ((CEPOperatorsDropdown)Mockito.doCallRealMethod().when((Object)this.dropdown)).addPlaceholder(Matchers.anyString(), Matchers.anyString());
        ((CEPOperatorsDropdown)Mockito.doCallRealMethod().when((Object)this.dropdown)).insertItem(Matchers.anyString(), Matchers.anyString(), Matchers.anyInt());
    }

    @Test
    public void testSetPlaceHolderNullOperator() throws Exception {
        this.testSetPlaceholder(null, "text", "value", 1);
    }

    @Test
    public void testSetPlaceHolderEmptyOperator() throws Exception {
        this.testSetPlaceholder("", "text", "value", 1);
    }

    @Test
    public void testSetPlaceHolderEqualToOperator() throws Exception {
        this.testSetPlaceholder("equal to", "text", "value", 0);
    }

    private void testSetPlaceholder(String operator, String placeholderText, String placeholderValue, int setSelectedIndexCount) {
        Mockito.when((Object)this.hasParameterizedOperator.getOperator()).thenReturn((Object)operator);
        this.dropdown.addPlaceholder(placeholderText, placeholderValue);
        ((ListBox)Mockito.verify((Object)this.box)).insertItem(placeholderText, placeholderValue, 0);
        ((ListBox)Mockito.verify((Object)this.box, (VerificationMode)Mockito.times((int)setSelectedIndexCount))).setSelectedIndex(0);
    }
}

