/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget.attribute;

import com.google.gwt.dom.client.InputElement;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockito;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import org.drools.workbench.models.datamodel.rule.RuleAttribute;
import org.drools.workbench.models.datamodel.rule.RuleMetadata;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.widget.attribute.RuleAttributeWidget;
import org.gwtbootstrap3.client.ui.TextBox;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.widget.LiteralTextBox;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.common.DatePicker;
import org.uberfire.ext.widgets.common.client.common.DirtyableHorizontalPane;
import org.uberfire.ext.widgets.common.client.common.FormStyleLayout;
import org.uberfire.ext.widgets.common.client.common.NumericIntegerTextBox;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={DateTimeFormat.class, DatePicker.class})
public class RuleAttributeWidgetTest {
    @Mock
    private FormStyleLayout layout;
    @Mock
    private DirtyableHorizontalPane dirtyableHorizontalPane;
    @Mock
    private TextBox textBox;
    @Mock
    private Element textBoxElement;
    @Mock
    private InputElement textBoxInputElement;
    @Mock
    private RuleModeller ruleModeller;
    private RuleModel ruleModel;
    private boolean isReadOnly = false;
    private RuleAttributeWidget ruleAttributeWidget;

    @Before
    public void setUp() throws Exception {
        GwtMockito.useProviderForType(FormStyleLayout.class, aClass -> this.layout);
        GwtMockito.useProviderForType(DirtyableHorizontalPane.class, aClass -> this.dirtyableHorizontalPane);
        GwtMockito.useProviderForType(TextBox.class, aClass -> this.textBox);
        ((TextBox)Mockito.doReturn((Object)this.textBoxElement).when((Object)this.textBox)).getElement();
        ((Element)Mockito.doReturn((Object)this.textBoxInputElement).when((Object)this.textBoxElement)).cast();
        this.ruleModel = new RuleModel();
    }

    @Test
    public void testNoAttribute() {
        this.ruleAttributeWidget = new RuleAttributeWidget(this.ruleModeller, this.ruleModel, this.isReadOnly);
        ((FormStyleLayout)Mockito.verify((Object)this.layout, (VerificationMode)Mockito.never())).addAttribute(Matchers.anyString(), (IsWidget)Matchers.any(IsWidget.class));
    }

    @Test
    public void testCalendarAttribute() {
        this.ruleModel.addAttribute(new RuleAttribute("calendars", ""));
        this.ruleAttributeWidget = new RuleAttributeWidget(this.ruleModeller, this.ruleModel, this.isReadOnly);
        ((FormStyleLayout)Mockito.verify((Object)this.layout)).addAttribute((String)Matchers.eq((Object)"calendars"), (IsWidget)Matchers.eq((Object)this.dirtyableHorizontalPane));
        ((DirtyableHorizontalPane)Mockito.verify((Object)this.dirtyableHorizontalPane)).add((Widget)Matchers.isA(LiteralTextBox.class));
    }

    @Test
    public void testTimerAttribute() {
        this.ruleModel.addAttribute(new RuleAttribute("timer", ""));
        this.ruleAttributeWidget = new RuleAttributeWidget(this.ruleModeller, this.ruleModel, this.isReadOnly);
        ((FormStyleLayout)Mockito.verify((Object)this.layout)).addAttribute((String)Matchers.eq((Object)"timer"), (IsWidget)Matchers.eq((Object)this.dirtyableHorizontalPane));
        ((DirtyableHorizontalPane)Mockito.verify((Object)this.dirtyableHorizontalPane)).add((Widget)Matchers.isA(LiteralTextBox.class));
    }

    @Test
    public void testSalienceAttribute() {
        this.ruleModel.addAttribute(new RuleAttribute("salience", ""));
        this.ruleAttributeWidget = new RuleAttributeWidget(this.ruleModeller, this.ruleModel, this.isReadOnly);
        ((FormStyleLayout)Mockito.verify((Object)this.layout)).addAttribute((String)Matchers.eq((Object)"salience"), (IsWidget)Matchers.eq((Object)this.dirtyableHorizontalPane));
        ((DirtyableHorizontalPane)Mockito.verify((Object)this.dirtyableHorizontalPane)).add((Widget)Matchers.isA(NumericIntegerTextBox.class));
    }

    @Test
    public void testDateEffectiveAttribute() {
        this.ruleModel.addAttribute(new RuleAttribute("date-effective", ""));
        this.ruleAttributeWidget = new RuleAttributeWidget(this.ruleModeller, this.ruleModel, this.isReadOnly);
        ((FormStyleLayout)Mockito.verify((Object)this.layout)).addAttribute((String)Matchers.eq((Object)"date-effective"), (IsWidget)Matchers.eq((Object)this.dirtyableHorizontalPane));
        ((DirtyableHorizontalPane)Mockito.verify((Object)this.dirtyableHorizontalPane)).add((Widget)Matchers.isA(DatePicker.class));
    }

    @Test
    public void testDateExpiresAttribute() {
        this.ruleModel.addAttribute(new RuleAttribute("date-expires", ""));
        this.ruleAttributeWidget = new RuleAttributeWidget(this.ruleModeller, this.ruleModel, this.isReadOnly);
        ((FormStyleLayout)Mockito.verify((Object)this.layout)).addAttribute((String)Matchers.eq((Object)"date-expires"), (IsWidget)Matchers.eq((Object)this.dirtyableHorizontalPane));
        ((DirtyableHorizontalPane)Mockito.verify((Object)this.dirtyableHorizontalPane)).add((Widget)Matchers.isA(DatePicker.class));
    }

    @Test
    public void testMetadataFrozenConditionsTranslated() {
        this.ruleModel.addMetadata(new RuleMetadata("freeze_conditions", "true"));
        this.ruleAttributeWidget = new RuleAttributeWidget(this.ruleModeller, this.ruleModel, this.isReadOnly);
        ((FormStyleLayout)Mockito.verify((Object)this.layout)).addAttribute((String)Matchers.eq((Object)GuidedRuleEditorResources.CONSTANTS.FrozenConditions()), (IsWidget)Matchers.eq((Object)this.dirtyableHorizontalPane));
    }

    @Test
    public void testMetadataFrozenActionsTranslated() {
        this.ruleModel.addMetadata(new RuleMetadata("freeze_actions", "true"));
        this.ruleAttributeWidget = new RuleAttributeWidget(this.ruleModeller, this.ruleModel, this.isReadOnly);
        ((FormStyleLayout)Mockito.verify((Object)this.layout)).addAttribute((String)Matchers.eq((Object)GuidedRuleEditorResources.CONSTANTS.FrozenActions()), (IsWidget)Matchers.eq((Object)this.dirtyableHorizontalPane));
    }

    @Test
    public void testMetadataUnknownNotTranslated() {
        String metadata = "unknown-metadata";
        this.ruleModel.addMetadata(new RuleMetadata("unknown-metadata", "true"));
        this.ruleAttributeWidget = new RuleAttributeWidget(this.ruleModeller, this.ruleModel, this.isReadOnly);
        ((FormStyleLayout)Mockito.verify((Object)this.layout)).addAttribute((String)Matchers.eq((Object)"unknown-metadata"), (IsWidget)Matchers.eq((Object)this.dirtyableHorizontalPane));
    }
}

