/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.Collections;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModellerActionSelectorPopup;
import org.gwtbootstrap3.client.ui.Heading;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Mock;
import org.mockito.Mockito;

@WithClassesToStub(value={Heading.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class RuleModellerActionSelectorPopupTest {
    @Mock
    private RuleModeller ruleModeller;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    private RuleModel model;
    private RuleModellerActionSelectorPopup popup;

    @Before
    public void setUp() {
        this.model = (RuleModel)Mockito.spy((Object)new RuleModel());
        Mockito.when((Object)this.oracle.getDSLConditions()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.oracle.getFactTypes()).thenReturn((Object)new String[0]);
        Mockito.when((Object)this.oracle.getGlobalVariables()).thenReturn((Object)new String[0]);
        this.popup = new RuleModellerActionSelectorPopup(this.model, this.ruleModeller, Collections.emptyList(), null, this.oracle);
        Mockito.reset((Object[])new RuleModel[]{this.model});
    }

    @Test
    public void checkAddUpdateNotModifyGetsPatternBindings() {
        this.popup.addUpdateNotModify();
        ((RuleModel)Mockito.verify((Object)this.model)).getLHSPatternVariables();
    }

    @Test
    public void checkAddRetractionsGetsPatternBindings() {
        this.popup.addRetractions();
        ((RuleModel)Mockito.verify((Object)this.model)).getLHSPatternVariables();
    }

    @Test
    public void checkAddModifiesGetsLhsBindings() {
        this.popup.addModifies();
        ((RuleModel)Mockito.verify((Object)this.model)).getAllLHSVariables();
    }

    @Test
    public void checkAddCallMethodOnGetsAllBindings() {
        this.popup.addCallMethodOn();
        ((RuleModel)Mockito.verify((Object)this.model)).getAllLHSVariables();
        ((RuleModel)Mockito.verify((Object)this.model)).getRHSBoundFacts();
    }
}

