/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.drools.workbench.models.datamodel.rule.ActionFieldFunction;
import org.drools.workbench.screens.guided.rule.client.editor.BoundListBox;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.editor.util.SuperTypeMatcher;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.resources.images.GuidedRuleEditorImages508;
import org.drools.workbench.screens.guided.rule.client.widget.EnumDropDown;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.kie.soup.project.datamodel.oracle.DropDownData;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.widget.TextBoxFactory;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.common.DropDownValueChanged;
import org.uberfire.ext.widgets.common.client.common.InfoPopup;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;

public class MethodParameterValueEditor
extends Composite {
    private AsyncPackageDataModelOracle oracle;
    private ActionFieldFunction methodParameter;
    private DropDownData enums;
    private SimplePanel root = new SimplePanel();
    private RuleModeller modeller = null;
    private String parameterType = null;
    private Command onValueChangeCommand = null;

    public MethodParameterValueEditor(AsyncPackageDataModelOracle oracle, ActionFieldFunction val, DropDownData enums, RuleModeller modeller, Command onValueChangeCommand) {
        this.oracle = oracle;
        this.methodParameter = val;
        this.modeller = modeller;
        this.parameterType = val.getType();
        this.onValueChangeCommand = onValueChangeCommand;
        this.setEnums(enums);
        this.refresh();
        this.initWidget((Widget)this.root);
    }

    private void setEnums(DropDownData enums) {
        this.enums = this.methodParameter.getType().equals("Boolean") ? DropDownData.create((String[])new String[]{"true", "false"}) : enums;
    }

    private void refresh() {
        this.root.clear();
        if (this.enums != null && (this.enums.getFixedList() != null || this.enums.getQueryExpression() != null)) {
            this.root.add((Widget)new EnumDropDown(this.methodParameter.getValue(), new DropDownValueChanged(){

                public void valueChanged(String newText, String newValue) {
                    MethodParameterValueEditor.this.setMethodParameterValue(newValue);
                }
            }, this.enums, this.modeller.getPath()));
        } else if (this.methodParameter.getNature() == 0 && this.methodParameter.getValue() == null) {
            this.root.add(this.choice());
        } else if (this.methodParameter.getNature() == 2) {
            this.root.add((Widget)this.boundVariable());
        } else if (this.methodParameter.getNature() == 3) {
            this.root.add((Widget)this.boundFormulaTextBox());
        } else {
            this.root.add((Widget)this.boundLiteralTextBox());
        }
    }

    private ListBox boundVariable() {
        BoundListBox boundListBox = new BoundListBox(this.modeller, this.methodParameter, new SuperTypeMatcher(this.oracle));
        boundListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ListBox w = (ListBox)event.getSource();
                MethodParameterValueEditor.this.setMethodParameterValue(w.getValue(w.getSelectedIndex()));
                MethodParameterValueEditor.this.refresh();
            }
        });
        return boundListBox;
    }

    private TextBox boundLiteralTextBox() {
        final TextBox box = TextBoxFactory.getTextBox((String)this.methodParameter.getType());
        box.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                MethodParameterValueEditor.this.setMethodParameterValue(box.getValue());
            }
        });
        box.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                MethodParameterValueEditor.this.setMethodParameterValue(box.getValue());
            }
        });
        box.setStyleName("constraint-value-Editor");
        if (this.methodParameter.getValue() != null || this.methodParameter.getValue().isEmpty()) {
            box.setValue((Object)this.methodParameter.getValue());
        }
        this.setMethodParameterValue(box.getValue());
        return box;
    }

    private TextBox boundFormulaTextBox() {
        final TextBox box = new TextBox();
        box.setStyleName("constraint-value-Editor");
        if (this.methodParameter.getValue() == null) {
            box.setValue((Object)"");
        } else {
            box.setValue((Object)this.methodParameter.getValue());
        }
        box.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                MethodParameterValueEditor.this.setMethodParameterValue(box.getValue());
            }
        });
        return box;
    }

    private void setMethodParameterValue(String value) {
        this.methodParameter.setValue(value);
        if (this.onValueChangeCommand != null) {
            this.onValueChangeCommand.execute();
        }
    }

    private Widget choice() {
        Image clickme = GuidedRuleEditorImages508.INSTANCE.Edit();
        clickme.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MethodParameterValueEditor.this.showTypeChoice();
            }
        });
        return clickme;
    }

    protected void showTypeChoice() {
        final FormStylePopup form = new FormStylePopup(GuidedRuleEditorImages508.INSTANCE.Wizard(), GuidedRuleEditorResources.CONSTANTS.FieldValue());
        Button lit = new Button(GuidedRuleEditorResources.CONSTANTS.LiteralValue());
        lit.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MethodParameterValueEditor.this.methodParameter.setNature(1);
                MethodParameterValueEditor.this.methodParameter.setValue("");
                MethodParameterValueEditor.this.refresh();
                form.hide();
            }
        });
        form.addAttribute(GuidedRuleEditorResources.CONSTANTS.LiteralValue() + ":", (IsWidget)this.widgets(lit, new InfoPopup(GuidedRuleEditorResources.CONSTANTS.Literal(), GuidedRuleEditorResources.CONSTANTS.LiteralValTip())));
        this.canTheVariableButtonBeShown(new Callback<Boolean>(){

            public void callback(Boolean result) {
                if (result.booleanValue()) {
                    MethodParameterValueEditor.this.addBoundVariableButton(form);
                    form.addRow((IsWidget)new HTML("<hr/>"));
                    form.addRow((IsWidget)new SmallLabel(GuidedRuleEditorResources.CONSTANTS.AdvancedSection()));
                }
                Button formula = new Button(GuidedRuleEditorResources.CONSTANTS.NewFormula());
                formula.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        MethodParameterValueEditor.this.methodParameter.setNature(3);
                        MethodParameterValueEditor.this.refresh();
                        form.hide();
                    }
                });
                form.addAttribute(GuidedRuleEditorResources.CONSTANTS.AFormula() + ":", (IsWidget)MethodParameterValueEditor.this.widgets(formula, new InfoPopup(GuidedRuleEditorResources.CONSTANTS.AFormula(), GuidedRuleEditorResources.CONSTANTS.FormulaExpressionTip())));
                form.show();
            }
        });
    }

    private void addBoundVariableButton(final FormStylePopup form) {
        form.addRow((IsWidget)new HTML("<hr/>"));
        form.addRow((IsWidget)new SmallLabel(GuidedRuleEditorResources.CONSTANTS.AdvancedSection()));
        Button variableButton = new Button(GuidedRuleEditorResources.CONSTANTS.BoundVariable());
        form.addAttribute(GuidedRuleEditorResources.CONSTANTS.BoundVariable() + ":", (IsWidget)variableButton);
        variableButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MethodParameterValueEditor.this.methodParameter.setNature(2);
                MethodParameterValueEditor.this.methodParameter.setValue("=");
                MethodParameterValueEditor.this.refresh();
                form.hide();
            }
        });
    }

    private void canTheVariableButtonBeShown(Callback<Boolean> callback) {
        ArrayList<String> factTypes = new ArrayList<String>();
        for (String variable : this.modeller.getModel().getAllVariables()) {
            String factType = this.getFactType(variable);
            factTypes.add(factType);
            if (!factType.equals(this.parameterType)) continue;
            callback.callback((Object)true);
            return;
        }
        new SuperTypeMatcher(this.oracle).isThereAMatchingSuperType(factTypes, this.parameterType, callback);
    }

    private String getFactType(String variable) {
        if (!this.modeller.getModel().getRHSBoundFacts().contains(variable)) {
            return this.modeller.getModel().getLHSBindingType(variable);
        }
        return this.modeller.getModel().getRHSBoundFact(variable).getFactType();
    }

    private Widget widgets(Button lit, InfoPopup popup) {
        HorizontalPanel h = new HorizontalPanel();
        h.add((Widget)lit);
        h.add((IsWidget)popup);
        return h;
    }
}

