/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget;

import com.google.gwt.dom.client.InputElement;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.drools.workbench.models.datamodel.rule.DSLComplexVariableValue;
import org.drools.workbench.models.datamodel.rule.DSLSentence;
import org.drools.workbench.models.datamodel.rule.DSLVariableValue;
import org.drools.workbench.screens.guided.rule.client.editor.CustomFormPopUp;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.resources.images.GuidedRuleEditorImages508;
import org.drools.workbench.screens.guided.rule.client.widget.DSLDropDown;
import org.drools.workbench.screens.guided.rule.client.widget.RuleModellerWidget;
import org.guvnor.common.services.workingset.client.WorkingSetManager;
import org.guvnor.common.services.workingset.client.factconstraints.customform.CustomFormConfiguration;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.jboss.errai.ioc.client.container.IOC;
import org.kie.soup.project.datamodel.oracle.OperatorsOracle;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.common.DatePicker;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;

public class DSLSentenceWidget
extends RuleModellerWidget {
    private WorkingSetManager workingSetManager = null;
    private final List<Widget> widgets = new ArrayList<Widget>();
    private final List<DSLDropDown> dropDownWidgets = new ArrayList<DSLDropDown>();
    private final DSLSentence sentence;
    private final VerticalPanel layout;
    private HorizontalPanel currentRow;
    private boolean readOnly;

    public DSLSentenceWidget(RuleModeller modeller, EventBus eventBus, DSLSentence sentence, Boolean readOnly) {
        super(modeller, eventBus);
        this.sentence = sentence;
        this.readOnly = readOnly == null ? false : readOnly;
        this.layout = new VerticalPanel();
        this.currentRow = new HorizontalPanel();
        this.layout.add((Widget)this.currentRow);
        this.layout.setCellWidth((Widget)this.currentRow, "100%");
        this.layout.setWidth("100%");
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        this.init();
    }

    private void init() {
        this.makeWidgets(this.sentence);
        this.initWidget((Widget)this.layout);
    }

    public void makeWidgets(DSLSentence sentence) {
        String dslDefinition = sentence.getDefinition();
        List dslValues = sentence.getValues();
        int index = 0;
        int startVariable = dslDefinition.indexOf("{");
        ArrayList<Widget> lineWidgets = new ArrayList<Widget>();
        boolean firstOneIsBracket = dslDefinition.indexOf("{") == 0;
        String startLabel = "";
        if (startVariable > 0) {
            startLabel = dslDefinition.substring(0, startVariable);
        } else if (!firstOneIsBracket) {
            startLabel = dslDefinition;
        }
        Widget label = this.getLabel(startLabel);
        lineWidgets.add(label);
        while (startVariable > 0 || firstOneIsBracket) {
            firstOneIsBracket = false;
            int endVariable = this.getIndexForEndOfVariable(dslDefinition, startVariable);
            String currVariable = dslDefinition.substring(startVariable + 1, endVariable);
            DSLVariableValue value = (DSLVariableValue)dslValues.get(index);
            Widget varWidget = this.processVariable(currVariable, sentence, value);
            lineWidgets.add(varWidget);
            ++index;
            startVariable = dslDefinition.indexOf("{", endVariable);
            String lbl = startVariable > 0 ? dslDefinition.substring(endVariable + 1, startVariable) : dslDefinition.substring(endVariable + 1, dslDefinition.length());
            if (lbl.indexOf("\\n") > -1) {
                String[] lines = lbl.split("\\\\n");
                for (int i = 0; i < lines.length; ++i) {
                    lineWidgets.add(new NewLine());
                    lineWidgets.add(this.getLabel(lines[i]));
                }
                continue;
            }
            Widget currLabel = this.getLabel(lbl);
            lineWidgets.add(currLabel);
        }
        for (Widget widg : lineWidgets) {
            this.addWidget(widg);
        }
        this.updateSentence();
    }

    private int getIndexForEndOfVariable(String dsl, int start) {
        int end = -1;
        int bracketCount = 0;
        if (start > dsl.length()) {
            return end;
        }
        for (int i = start; i < dsl.length(); ++i) {
            char c = dsl.charAt(i);
            if (c == '{') {
                ++bracketCount;
            }
            if (c != '}' || --bracketCount != 0) continue;
            end = i;
            return end;
        }
        return -1;
    }

    public Widget processVariable(String currVariable, DSLSentence sentence, DSLVariableValue value) {
        Widget result = null;
        if (currVariable.contains(":")) {
            if (currVariable.contains(":ENUM:")) {
                result = this.getEnumDropdown(currVariable, sentence, value);
            } else if (currVariable.contains(":DATE:")) {
                result = this.getDateSelector(value);
            } else if (currVariable.contains(":BOOLEAN:")) {
                result = this.getCheckbox(currVariable, value);
            } else if (currVariable.contains(":CF:")) {
                result = this.getCustomFormEditor(currVariable, value);
            } else {
                String regex = currVariable.substring(currVariable.indexOf(":") + 1, currVariable.length());
                result = this.getBox(value, regex);
            }
        } else {
            result = this.getBox(value, "");
        }
        return result;
    }

    private Widget getEnumDropdown(String variableDef, DSLSentence sentence, DSLVariableValue value) {
        boolean multipleSelect = this.isMultipleSelect(variableDef, sentence);
        DSLDropDown resultWidget = new DSLDropDown(this.modeller, variableDef, sentence, value, multipleSelect, (Callback<DSLDropDown>)((Callback)dslDropDown -> this.updateEnumDropDowns((DSLDropDown)dslDropDown)));
        this.dropDownWidgets.add(resultWidget);
        return resultWidget;
    }

    private boolean isMultipleSelect(String variableDef, DSLSentence sentence) {
        String variableName = variableDef.substring(0, variableDef.indexOf(":"));
        String variableNameMarker = "{" + variableName + "}";
        String drl = sentence.getDrl();
        String normalizedDrl = drl.trim().replaceAll("\"", "").replaceAll(" +", " ");
        String normalizedDrlFragment = normalizedDrl.substring(0, normalizedDrl.indexOf(variableNameMarker));
        for (String listOperator : OperatorsOracle.EXPLICIT_LIST_OPERATORS) {
            String listOperatorMarker = " " + listOperator + " ";
            if (normalizedDrlFragment.indexOf(listOperatorMarker) != normalizedDrlFragment.length() - listOperatorMarker.length()) continue;
            return true;
        }
        return false;
    }

    private Widget getBox(DSLVariableValue variableDef, String regex) {
        return this.getBox(variableDef, regex, false);
    }

    private Widget getBox(DSLVariableValue variableDef, String regex, boolean readonly) {
        FieldEditor currentBox = new FieldEditor();
        currentBox.setVisibleLength(variableDef.getValue().length() + 1);
        currentBox.setValue(variableDef);
        currentBox.setRestriction(regex);
        currentBox.box.setEnabled(!readonly);
        return currentBox;
    }

    private Widget getCheckbox(String variableDef, DSLVariableValue value) {
        return new DSLCheckBox(variableDef, value);
    }

    private Widget getCustomFormEditor(String variableDef, DSLVariableValue value) {
        int lastIndex = variableDef.lastIndexOf(":");
        String factAndField = variableDef.substring(lastIndex + 1, variableDef.length());
        int dotIndex = factAndField.indexOf(".");
        String factType = factAndField.substring(0, dotIndex);
        String field = factAndField.substring(dotIndex + 1, factAndField.length());
        CustomFormConfiguration customFormConfiguration = this.getWorkingSetManager().getCustomFormConfiguration(this.getModeller().getPath(), factType, field);
        boolean editorReadOnly = this.readOnly;
        if (!editorReadOnly) {
            boolean bl = editorReadOnly = !this.getModeller().getDataModelOracle().isFactTypeRecognized(factType);
        }
        if (customFormConfiguration != null) {
            return new DSLCustomFormButton(variableDef, value, customFormConfiguration, editorReadOnly);
        }
        return this.getBox(value, "", editorReadOnly);
    }

    public Widget getDateSelector(DSLVariableValue value) {
        return new DSLDateSelector(value);
    }

    public Widget getLabel(String labelDef) {
        SmallLabel label = new SmallLabel();
        label.setText(labelDef.trim());
        return label;
    }

    private void addWidget(Widget currentBox) {
        if (currentBox instanceof NewLine) {
            this.currentRow = new HorizontalPanel();
            this.layout.add((Widget)this.currentRow);
            this.layout.setCellWidth((Widget)this.currentRow, "100%");
        } else {
            this.currentRow.add(currentBox);
        }
        this.widgets.add(currentBox);
    }

    protected void updateSentence() {
        int iVariable = 0;
        for (Widget wid : this.widgets) {
            if (!(wid instanceof DSLVariableEditor)) continue;
            this.sentence.getValues().set(iVariable++, ((DSLVariableEditor)wid).getSelectedValue());
        }
        this.setModified(true);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isFactTypeKnown() {
        return true;
    }

    private void updateEnumDropDowns(DSLDropDown source) {
        this.updateSentence();
        int sourceIndex = this.dropDownWidgets.indexOf(source);
        for (DSLDropDown dd : this.dropDownWidgets) {
            if (this.dropDownWidgets.indexOf(dd) <= sourceIndex) continue;
            dd.refreshDropDownData();
        }
        this.updateSentence();
    }

    private WorkingSetManager getWorkingSetManager() {
        if (this.workingSetManager == null) {
            this.workingSetManager = (WorkingSetManager)IOC.getBeanManager().lookupBean(WorkingSetManager.class, new Annotation[0]).getInstance();
        }
        return this.workingSetManager;
    }

    class DSLDateSelector
    extends Composite
    implements DSLVariableEditor {
        private final String DATE_FORMAT = ApplicationPreferences.getDroolsDateFormat();
        private final DateTimeFormat DATE_FORMATTER = DateTimeFormat.getFormat((String)this.DATE_FORMAT);
        private final DatePicker datePicker = new DatePicker(false);

        public DSLDateSelector(DSLVariableValue selectedDate) {
            this.datePicker.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Date>(){

                public void onValueChange(ValueChangeEvent<Date> event) {
                    DSLSentenceWidget.this.updateSentence();
                }
            });
            this.datePicker.setFormat(this.DATE_FORMAT);
            this.datePicker.setValue(this.assertDateValue(selectedDate));
            HorizontalPanel hp = new HorizontalPanel();
            hp.add((Widget)new HTML("&nbsp;"));
            hp.add((Widget)this.datePicker);
            hp.add((Widget)new HTML("&nbsp;"));
            this.initWidget((Widget)hp);
        }

        @Override
        public DSLVariableValue getSelectedValue() {
            Date date = this.datePicker.getValue();
            String sDate = date == null ? null : this.DATE_FORMATTER.format(this.datePicker.getValue());
            return new DSLVariableValue(sDate);
        }

        private Date assertDateValue(DSLVariableValue dslVariableValue) {
            if (dslVariableValue.getValue() == null) {
                return null;
            }
            try {
                return this.DATE_FORMATTER.parse(dslVariableValue.getValue());
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
    }

    class DSLCheckBox
    extends Composite
    implements DSLVariableEditor {
        ListBox resultWidget = new ListBox();

        public DSLCheckBox(String variableDef, DSLVariableValue value) {
            this.resultWidget.addItem("true");
            this.resultWidget.addItem("false");
            if (value.getValue().equalsIgnoreCase("true")) {
                this.resultWidget.setSelectedIndex(0);
            } else {
                this.resultWidget.setSelectedIndex(1);
            }
            this.resultWidget.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    DSLSentenceWidget.this.updateSentence();
                }
            });
            this.resultWidget.setVisible(true);
            HorizontalPanel hp = new HorizontalPanel();
            hp.add((Widget)new HTML("&nbsp;"));
            hp.add((Widget)this.resultWidget);
            hp.add((Widget)new HTML("&nbsp;"));
            this.initWidget((Widget)hp);
        }

        @Override
        public DSLVariableValue getSelectedValue() {
            String value = this.resultWidget.getSelectedIndex() == 0 ? "true" : "false";
            return new DSLVariableValue(value);
        }
    }

    class DSLCustomFormButton
    extends Composite
    implements DSLVariableEditor {
        private DSLVariableValue selectedValue;
        private CustomFormConfiguration customFormConfiguration;
        private Button btnCustomForm;

        public DSLCustomFormButton(String variableDef, DSLVariableValue value, CustomFormConfiguration customFormConfiguration, boolean readonly) {
            this.customFormConfiguration = customFormConfiguration;
            this.selectedValue = value;
            this.btnCustomForm = new Button(this.selectedValue.getValue());
            this.btnCustomForm.setEnabled(!readonly);
            if (!readonly) {
                this.btnCustomForm.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        final CustomFormPopUp customFormPopUp = new CustomFormPopUp(GuidedRuleEditorImages508.INSTANCE.Wizard(), GuidedRuleEditorResources.CONSTANTS.FieldValue(), DSLCustomFormButton.this.customFormConfiguration);
                        customFormPopUp.addOkButtonHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                String id = customFormPopUp.getFormId();
                                String value = customFormPopUp.getFormValue();
                                DSLCustomFormButton.this.btnCustomForm.setText(value);
                                DSLCustomFormButton.this.selectedValue = (DSLVariableValue)new DSLComplexVariableValue(id, value);
                                DSLSentenceWidget.this.updateSentence();
                                customFormPopUp.hide();
                            }
                        });
                        if (DSLCustomFormButton.this.selectedValue instanceof DSLComplexVariableValue) {
                            DSLComplexVariableValue complexSelectedValue = (DSLComplexVariableValue)DSLCustomFormButton.this.selectedValue;
                            customFormPopUp.show(complexSelectedValue.getId(), complexSelectedValue.getValue());
                        } else {
                            customFormPopUp.show("", DSLCustomFormButton.this.selectedValue.getValue());
                        }
                    }
                });
            }
            HorizontalPanel hp = new HorizontalPanel();
            hp.add((Widget)new HTML("&nbsp;"));
            hp.add((Widget)this.btnCustomForm);
            hp.add((Widget)new HTML("&nbsp;"));
            this.initWidget((Widget)hp);
        }

        @Override
        public DSLVariableValue getSelectedValue() {
            return this.selectedValue;
        }
    }

    class FieldEditor
    extends Composite
    implements DSLVariableEditor {
        private TextBox box = new TextBox();
        private String oldValue = "";
        private DSLVariableValue oldVariableValue;
        private String regex = "";

        public FieldEditor() {
            this.box.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    TextBox otherBox = (TextBox)event.getSource();
                    if (!FieldEditor.this.regex.equals("") && !otherBox.getText().matches(FieldEditor.this.regex)) {
                        Window.alert((String)GuidedRuleEditorResources.CONSTANTS.TheValue0IsNotValidForThisField(otherBox.getText()));
                        FieldEditor.this.box.setText(FieldEditor.this.oldValue);
                    } else {
                        FieldEditor.this.oldValue = otherBox.getText();
                        DSLSentenceWidget.this.updateSentence();
                    }
                }
            });
            HorizontalPanel hp = new HorizontalPanel();
            hp.add((Widget)new HTML("&nbsp;"));
            hp.add((Widget)this.box);
            hp.add((Widget)new HTML("&nbsp;"));
            this.initWidget((Widget)hp);
        }

        public void setRestriction(String regex) {
            this.regex = regex;
        }

        public void setValue(DSLVariableValue value) {
            this.oldVariableValue = value;
            this.box.setText(value.getValue());
        }

        public void setVisibleLength(int l) {
            ((InputElement)this.box.getElement().cast()).setSize(l);
        }

        @Override
        public DSLVariableValue getSelectedValue() {
            if (this.oldVariableValue instanceof DSLComplexVariableValue) {
                return new DSLComplexVariableValue(((DSLComplexVariableValue)this.oldVariableValue).getId(), this.box.getText());
            }
            return new DSLVariableValue(this.box.getText());
        }
    }

    static interface DSLVariableEditor {
        public DSLVariableValue getSelectedValue();
    }

    static class NewLine
    extends Widget {
        NewLine() {
        }
    }
}

