/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwtmockito.GwtMockito;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Instance;
import org.drools.workbench.models.datamodel.rule.FromAccumulateCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.util.ModelFieldUtil;
import org.drools.workbench.screens.guided.rule.client.widget.FromAccumulateCompositeFactPatternWidget;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.html.Text;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jboss.errai.validation.client.dynamic.DynamicValidator;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.imports.HasImports;
import org.kie.soup.project.datamodel.imports.Import;
import org.kie.soup.project.datamodel.imports.Imports;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.services.datamodel.service.IncrementalDataModelService;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleImpl;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.MockInstanceImpl;

@WithClassesToStub(value={RootPanel.class, Text.class, AnchorElement.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class FromAccumulateCompositeFactPatternWidgetTest {
    private static final String REDHAT_PACKAGE = "com.redhat";
    private static final String REDHAT_SUBPACKAGE = "com.redhat.rule";
    private static final String FACT_TYPE_CAR = "Car";
    private static final String FACT_TYPE_PERSON = "Person";
    private PackageDataModelOracleBaselinePayload dataModelPayload;
    @Mock
    private Path resourcePath;
    @Mock
    private SyncBeanDef syncBeanDef;
    @Mock
    private SyncBeanManager syncBeanManager;
    @Spy
    @InjectMocks
    private AsyncPackageDataModelOracleFactory asyncPackageDataModelOracleFactory;
    @Mock
    private RuleModeller ruleModeller;
    @Mock
    private IncrementalDataModelService incrementalDataModelService;
    private Instance<DynamicValidator> validatorInstance;
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private EventBus eventBus;
    @Mock
    private FromAccumulateCompositeFactPattern pattern;
    @Mock
    private ListBox listBox;
    private RuleModel ruleModelWithImportedNumber;
    private FromAccumulateCompositeFactPatternWidget fromAccumulateWidget;

    @Before
    public void setUp() throws Exception {
        GwtMockito.useProviderForType(ListBox.class, aClass -> this.listBox);
        this.validatorInstance = new MockInstanceImpl((Object[])new DynamicValidator[0]);
        this.oracle = (AsyncPackageDataModelOracle)Mockito.spy((Object)new AsyncPackageDataModelOracleImpl((Caller)new CallerMock((Object)this.incrementalDataModelService), this.validatorInstance));
        ((SyncBeanManager)Mockito.doReturn((Object)this.syncBeanDef).when((Object)this.syncBeanManager)).lookupBean(AsyncPackageDataModelOracle.class, new Annotation[0]);
        ((SyncBeanDef)Mockito.doReturn((Object)this.oracle).when((Object)this.syncBeanDef)).getInstance();
        ((RuleModeller)Mockito.doReturn((Object)this.oracle).when((Object)this.ruleModeller)).getDataModelOracle();
        this.dataModelPayload = new PackageDataModelOracleBaselinePayload();
        this.dataModelPayload.setModelFields((Map)new HashMap<String, ModelField[]>(){
            {
                String fqnPerson = "com.redhat.Person";
                String fqnCar = "com.redhat.Car";
                String fqnNumber = Number.class.getName();
                this.put("com.redhat.Person", new ModelField[]{ModelFieldUtil.modelField((String)"this", (String)"com.redhat.Person")});
                this.put("com.redhat.Car", new ModelField[]{ModelFieldUtil.modelField((String)"this", (String)"com.redhat.Car")});
                this.put(fqnNumber, new ModelField[]{ModelFieldUtil.modelField((String)"this", (String)fqnNumber)});
            }
        });
        Mockito.when((Object)this.pattern.useFunctionOrCode()).thenReturn((Object)"use_function");
        this.fromAccumulateWidget = new FromAccumulateCompositeFactPatternWidget(this.ruleModeller, this.eventBus, this.pattern);
        this.ruleModelWithImportedNumber = new RuleModel(){
            {
                this.setImports(new Imports(){
                    {
                        this.addImport(new Import(Number.class));
                    }
                });
            }
        };
    }

    @Test
    public void testShowFactTypeSelectorFactsInSamePackage() throws Exception {
        this.dataModelPayload.setPackageName(REDHAT_PACKAGE);
        this.asyncPackageDataModelOracleFactory.makeAsyncPackageDataModelOracle(this.resourcePath, this.dataModelPayload);
        this.fromAccumulateWidget.showFactTypeSelector();
        ((ListBox)Mockito.verify((Object)this.listBox)).addItem(GuidedRuleEditorResources.CONSTANTS.Choose());
        ((ListBox)Mockito.verify((Object)this.listBox)).addItem(FACT_TYPE_PERSON);
        ((ListBox)Mockito.verify((Object)this.listBox)).addItem(FACT_TYPE_CAR);
        ((ListBox)Mockito.verify((Object)this.listBox, (VerificationMode)Mockito.times((int)3))).addItem(Matchers.anyString());
    }

    @Test
    public void testShowFactTypeSelectorFactsNotInSamePackage() throws Exception {
        this.dataModelPayload.setPackageName(REDHAT_SUBPACKAGE);
        this.asyncPackageDataModelOracleFactory.makeAsyncPackageDataModelOracle(this.resourcePath, this.dataModelPayload);
        this.fromAccumulateWidget.showFactTypeSelector();
        ((ListBox)Mockito.verify((Object)this.listBox)).addItem(GuidedRuleEditorResources.CONSTANTS.Choose());
        ((ListBox)Mockito.verify((Object)this.listBox, (VerificationMode)Mockito.times((int)1))).addItem(Matchers.anyString());
    }

    @Test
    public void testShowFactTypeSelectorFactsInSamePackageAndImportedNumber() throws Exception {
        this.dataModelPayload.setPackageName(REDHAT_PACKAGE);
        this.asyncPackageDataModelOracleFactory.makeAsyncPackageDataModelOracle(this.resourcePath, (HasImports)this.ruleModelWithImportedNumber, this.dataModelPayload);
        this.fromAccumulateWidget.showFactTypeSelector();
        ((ListBox)Mockito.verify((Object)this.listBox)).addItem(GuidedRuleEditorResources.CONSTANTS.Choose());
        ((ListBox)Mockito.verify((Object)this.listBox)).addItem(FACT_TYPE_PERSON);
        ((ListBox)Mockito.verify((Object)this.listBox)).addItem(FACT_TYPE_CAR);
        ((ListBox)Mockito.verify((Object)this.listBox)).addItem(Number.class.getSimpleName());
        ((ListBox)Mockito.verify((Object)this.listBox, (VerificationMode)Mockito.times((int)4))).addItem(Matchers.anyString());
    }

    @Test
    public void testShowFactTypeSelectorFactsNotInSamePackageAndImportedNumber() throws Exception {
        this.dataModelPayload.setPackageName(REDHAT_SUBPACKAGE);
        this.asyncPackageDataModelOracleFactory.makeAsyncPackageDataModelOracle(this.resourcePath, (HasImports)this.ruleModelWithImportedNumber, this.dataModelPayload);
        this.fromAccumulateWidget.showFactTypeSelector();
        ((ListBox)Mockito.verify((Object)this.listBox)).addItem(GuidedRuleEditorResources.CONSTANTS.Choose());
        ((ListBox)Mockito.verify((Object)this.listBox)).addItem(Number.class.getSimpleName());
        ((ListBox)Mockito.verify((Object)this.listBox, (VerificationMode)Mockito.times((int)2))).addItem(Matchers.anyString());
    }
}

